/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.regnosys.rosetta.common.util.UrlUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class JsonProcessor {
    private final String baseNodeName;
    private final ObjectMapper mapper;

    public JsonProcessor(String baseNode, ObjectMapper mapper) {
        this.baseNodeName = baseNode;
        this.mapper = mapper;
    }

    public Reader process(URL input) throws IOException {
        return this.process(UrlUtils.openURL((URL)input));
    }

    public Reader process(Reader input) throws IOException {
        Map jsonMap = (Map)this.mapper.readValue(input, (TypeReference)new TypeReference<Map<String, Object>>(){});
        if (!this.isMap(jsonMap.get(this.baseNodeName))) {
            throw new IllegalArgumentException("Invalid base node name (should be a map)" + this.baseNodeName);
        }
        Map baseNode = (Map)jsonMap.get(this.baseNodeName);
        for (String childNodeName : baseNode.keySet()) {
            if (!this.isMap(baseNode.get(childNodeName))) {
                throw new IllegalArgumentException("JSON contains unexpected data");
            }
            Map childNode = (Map)baseNode.get(childNodeName);
            Map<String, Object> symmetricalSorted = this.makePartiesSymmetrical(childNode);
            baseNode.put(childNodeName, symmetricalSorted);
        }
        return new StringReader(this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonMap));
    }

    private Map<String, Object> makePartiesSymmetrical(Map<String, Object> map) {
        TreeMap<String, Object> sortedMap = new TreeMap<String, Object>();
        Set<Map.Entry<String, Object>> entries = map.entrySet();
        boolean mustSort = entries.stream().anyMatch(k -> ((String)k.getKey()).startsWith("partyA") | ((String)k.getKey()).startsWith("partyB"));
        for (Map.Entry<String, Object> entry : entries) {
            if (entry.getKey().startsWith("partyA") || entry.getKey().startsWith("partyB")) {
                sortedMap.put(entry.getKey(), entry.getValue());
                this.ensureSymmetry(entry, "partyA", "partyB", map, sortedMap);
                this.ensureSymmetry(entry, "partyB", "partyA", map, sortedMap);
                continue;
            }
            if (!mustSort) continue;
            sortedMap.put(entry.getKey(), entry.getValue());
        }
        if (mustSort) {
            return sortedMap;
        }
        return map;
    }

    private void ensureSymmetry(Map.Entry<String, Object> entry, String one, String other, Map<String, Object> originMap, SortedMap<String, Object> sortedMap) {
        if (entry.getKey().startsWith(one)) {
            String key = entry.getKey().replace(one, other);
            if (originMap.containsKey(key)) {
                sortedMap.put(key, originMap.get(key));
            } else {
                sortedMap.put(key, "");
            }
        }
    }

    private boolean isMap(Object obj) {
        return obj instanceof Map;
    }
}

