/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate.synonymmap;

import com.codahale.metrics.Timer;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.regnosys.rosetta.common.util.StreamUtils;
import com.regnosys.rosetta.generator.java.RosettaJavaPackages;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.types.JavaTypeUtil;
import com.regnosys.rosetta.generator.object.ExpandedAttribute;
import com.regnosys.rosetta.generator.object.ExpandedSynonym;
import com.regnosys.rosetta.generator.object.ExpandedSynonymValue;
import com.regnosys.rosetta.generator.object.ExpandedType;
import com.regnosys.rosetta.generator.util.RosettaAttributeExtensions;
import com.regnosys.rosetta.rosetta.ExternalAnnotationSource;
import com.regnosys.rosetta.rosetta.ExternalValueOperator;
import com.regnosys.rosetta.rosetta.RosettaClassSynonym;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaExternalClassSynonym;
import com.regnosys.rosetta.rosetta.RosettaExternalEnumValue;
import com.regnosys.rosetta.rosetta.RosettaExternalRegularAttribute;
import com.regnosys.rosetta.rosetta.RosettaExternalSynonymSource;
import com.regnosys.rosetta.rosetta.RosettaFactory;
import com.regnosys.rosetta.rosetta.RosettaMappingInstance;
import com.regnosys.rosetta.rosetta.RosettaMergeSynonymValue;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaNamed;
import com.regnosys.rosetta.rosetta.RosettaRootElement;
import com.regnosys.rosetta.rosetta.RosettaType;
import com.regnosys.rosetta.rosetta.RosettaTypeAlias;
import com.regnosys.rosetta.rosetta.TypeCall;
import com.regnosys.rosetta.rosetta.simple.AnnotationRef;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.SimpleFactory;
import com.regnosys.rosetta.translate.IngesterGenerator;
import com.regnosys.rosetta.translate.datamodel.NamespaceName;
import com.regnosys.rosetta.translate.synonymmap.AttributeGroup;
import com.regnosys.rosetta.translate.synonymmap.Element;
import com.regnosys.rosetta.translate.synonymmap.SynonymCondition;
import com.regnosys.rosetta.translate.synonymmap.SynonymGroup;
import com.regnosys.rosetta.translate.synonymmap.SynonymMap;
import com.regnosys.rosetta.translate.synonymmap.SynonymTest;
import com.regnosys.rosetta.translate.synonymmap.SynonymValue;
import com.regnosys.rosetta.types.TypeSystem;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaReferenceType;
import com.rosetta.util.types.generated.GeneratedJavaClass;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.util.Strings;

public class SynonymMapBuilder {
    private static final Logger LOGGER = Logger.getLogger(SynonymMapBuilder.class);
    private final List<RosettaExternalSynonymSource> externalSynonyms;
    private final Collection<String> synonymSourceNames;
    private final JavaTypeTranslator typeTranslator;
    private final RosettaJavaPackages packages;
    private final JavaTypeUtil typeUtil;
    private final TypeSystem typeSystem;
    private final RBuiltinTypeService builtins;
    private Map<NamespaceName, RosettaType> typeCache;
    static TypeCall META_TYPE = null;

    public SynonymMapBuilder(String synonymSourceName, JavaTypeTranslator typeTranslator) {
        this(Collections.singletonList(synonymSourceName), Collections.emptyList(), typeTranslator);
    }

    public SynonymMapBuilder(Collection<String> synonymSourceNames, List<RosettaExternalSynonymSource> externalSynonyms, JavaTypeTranslator typeTranslator) {
        this(synonymSourceNames, externalSynonyms, null, typeTranslator);
    }

    public SynonymMapBuilder(Collection<String> synonymSourceNames, List<RosettaExternalSynonymSource> externalSynonyms, Map<NamespaceName, RosettaType> typeCache, JavaTypeTranslator typeTranslator) {
        Data res = SimpleFactory.eINSTANCE.createData();
        res.setName("MetaFields");
        TypeCall typeCall = RosettaFactory.eINSTANCE.createTypeCall();
        typeCall.setType((RosettaType)res);
        META_TYPE = typeCall;
        this.synonymSourceNames = synonymSourceNames;
        this.externalSynonyms = externalSynonyms;
        this.typeCache = typeCache;
        this.typeTranslator = typeTranslator;
        this.packages = (RosettaJavaPackages)this.getPrivateField(typeTranslator, "packages");
        this.typeUtil = (JavaTypeUtil)this.getPrivateField(typeTranslator, "typeUtil");
        this.typeSystem = (TypeSystem)this.getPrivateField(typeTranslator, "typeSystem");
        this.builtins = (RBuiltinTypeService)this.getPrivateField(typeTranslator, "builtins");
    }

    private <T> T getPrivateField(Object owner, String field) {
        Field f;
        try {
            f = owner.getClass().getDeclaredField(field);
        }
        catch (IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            try {
                f = owner.getClass().getSuperclass().getDeclaredField(field);
            }
            catch (NoSuchFieldException | SecurityException e1) {
                throw new RuntimeException(e);
            }
        }
        f.setAccessible(true);
        try {
            return (T)f.get(owner);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    public SynonymMap buildMap(RosettaType topClass) {
        Timer timer = IngesterGenerator.GENERATOR_METRICS.timer("Building synoym map");
        Timer.Context time = timer.time();
        if (topClass == null) {
            return null;
        }
        HashMap<RosettaType, SynonymMap> maps = new HashMap<RosettaType, SynonymMap>();
        HashMap<RosettaEnumeration, SynonymMap> enumMaps = new HashMap<RosettaEnumeration, SynonymMap>();
        SynonymMap buildMap = this.buildMap(topClass, maps, enumMaps);
        time.stop();
        return buildMap;
    }

    public SynonymMap buildMap(RosettaType topType, Map<RosettaType, SynonymMap> classMaps, Map<RosettaEnumeration, SynonymMap> enumMaps) {
        if (topType == null) {
            return null;
        }
        if (classMaps.containsKey(topType = this.resolveType(topType))) {
            return classMaps.get(topType);
        }
        if (enumMaps.containsKey(topType)) {
            return enumMaps.get(topType);
        }
        if (topType instanceof Data) {
            LOGGER.trace((Object)("building map for " + topType.getName()));
            Data topClass = (Data)topType;
            Data superType = topClass.getSuperType();
            SynonymMap result = classMaps.get(topType);
            if (result == null) {
                result = new SynonymMap((RosettaType)topClass, this.buildMap((RosettaType)superType, classMaps, enumMaps));
                classMaps.put((RosettaType)topClass, result);
            }
            Map<AttributeGroup, SynonymMap> mappings = this.buildMappings((RosettaType)topClass, Collections.emptyList(), classMaps, enumMaps, false, Collections.emptySet(), (Multimap<ExpandedAttribute, RosettaMergeSynonymValue>)HashMultimap.create());
            result.addMappings(mappings);
            Multimap<SynonymValue, SynonymCondition> conditionCaptures = this.findCaptures(mappings);
            result.getConditionalCaptures().putAll(conditionCaptures);
            return result;
        }
        if (topType instanceof RosettaEnumeration) {
            LOGGER.trace((Object)("building enum map for " + topType.getName()));
            RosettaEnumeration rEnum = (RosettaEnumeration)topType;
            SynonymMap result = enumMaps.get(topType);
            if (result == null) {
                result = new SynonymMap((RosettaType)rEnum, this.buildMap((RosettaType)rEnum.getParent(), classMaps, enumMaps));
                enumMaps.put(rEnum, result);
            }
            Map<AttributeGroup, SynonymMap> buildMappings = this.buildEnumMappings(rEnum, Collections.emptyList());
            result.addMappings(buildMappings);
            return result;
        }
        if (topType instanceof RosettaTypeAlias) {
            return this.buildMap(((RosettaTypeAlias)topType).getTypeCall().getType(), classMaps, enumMaps);
        }
        return new SynonymMap();
    }

    private Multimap<SynonymValue, SynonymCondition> findCaptures(Map<AttributeGroup, SynonymMap> mappings) {
        ArrayListMultimap res = ArrayListMultimap.create();
        for (AttributeGroup pp : mappings.keySet()) {
            for (SynonymGroup sg : pp.getSynonymGroups()) {
                for (SynonymCondition cond : sg.getConditions()) {
                    for (SynonymTest test : cond.getCondition()) {
                        for (SynonymValue val : test.getPaths()) {
                            res.put((Object)val, (Object)cond);
                        }
                    }
                }
            }
        }
        return res;
    }

    private Map<AttributeGroup, SynonymMap> buildEnumMappings(RosettaEnumeration rEnum, List<ExpandedAttribute> attPath) {
        HashMap<AttributeGroup, SynonymMap> result = new HashMap<AttributeGroup, SynonymMap>();
        for (ExpandedAttribute enumVal : this.getAllEnumValue(rEnum)) {
            ArrayList<ExpandedAttribute> enumPath = new ArrayList<ExpandedAttribute>(attPath);
            enumPath.add(enumVal);
            List<ExpandedSynonym> enumSyns = this.getEnumSynonyms(enumVal);
            List<SynonymGroup> groups = enumSyns.stream().map(s -> this.toGroup((ExpandedSynonym)s, rEnum.getModel().getName())).collect(Collectors.toList());
            result.put(new AttributeGroup(groups, enumPath), new SynonymMap(null));
        }
        return result;
    }

    public List<ExpandedSynonym> getEnumSynonyms(ExpandedAttribute enumVal) {
        List<ExpandedSynonym> enumSyns = enumVal.getSynonyms().stream().filter(s -> this.sourcesMatch((ExpandedSynonym)s)).collect(Collectors.toList());
        ArrayList<RosettaExternalSynonymSource> copy = new ArrayList<RosettaExternalSynonymSource>(this.externalSynonyms);
        Collections.reverse(copy);
        copy.forEach(extSynSrc -> {
            LOGGER.trace((Object)("External Synonym src: " + extSynSrc.getName()));
            List<RosettaExternalEnumValue> externalAttributes = this.getRosettaExternalEnums(enumVal.getEnclosingType(), enumVal, (RosettaExternalSynonymSource)extSynSrc);
            List<RosettaExternalEnumValue> additions = externalAttributes.stream().filter(x -> x.getOperator().equals((Object)ExternalValueOperator.PLUS)).collect(Collectors.toList());
            List removals = externalAttributes.stream().filter(x -> x.getOperator().equals((Object)ExternalValueOperator.MINUS)).collect(Collectors.toList());
            enumSyns.removeIf(s -> removals.stream().map(c -> c.getEnumRef()).map(c -> c.getName()).anyMatch(n -> n.equals(enumVal.getName())));
            enumSyns.addAll(this.addExternalEnumSynonyms(additions));
        });
        return enumSyns;
    }

    private Map<AttributeGroup, SynonymMap> buildMappings(RosettaType clazz, List<ExpandedAttribute> attPath, Map<RosettaType, SynonymMap> maps, Map<RosettaEnumeration, SynonymMap> enumMaps, boolean includeSupers, Collection<RosettaType> alreadySearched, Multimap<ExpandedAttribute, RosettaMergeSynonymValue> attMergeSyns) {
        HashMap<AttributeGroup, SynonymMap> result = new HashMap<AttributeGroup, SynonymMap>();
        ArrayList<ExpandedAttribute> searchAttributes = new ArrayList();
        ArrayList<RosettaExternalSynonymSource> copy = new ArrayList<RosettaExternalSynonymSource>(this.externalSynonyms);
        Collections.reverse(copy);
        if (clazz instanceof Data) {
            searchAttributes = this.getAllAttributes((Data)clazz, includeSupers);
            Data data = (Data)clazz;
            if (data.getAnnotations() != null && data.getAnnotations().stream().map(AnnotationRef::getAttribute).filter(Objects::nonNull).map(RosettaNamed::getName).filter(Objects::nonNull).anyMatch(a -> a.equals("key"))) {
                this.addKeySynonyms(data.getSynonyms().stream().filter(s -> this.sourcesMatch((RosettaClassSynonym)s)).collect(Collectors.toList()), this.getRosettaExternalClassSynonyms(clazz.getName()), attPath, result);
            }
            if (data.getSuperType() != null && !includeSupers) {
                searchAttributes.addAll(this.addsSynonyms(copy, searchAttributes, (Data)clazz));
            }
        }
        for (ExpandedAttribute att : searchAttributes) {
            ArrayList<ExpandedAttribute> newPath = new ArrayList<ExpandedAttribute>(attPath);
            if (att.hasMetas()) {
                if (att.refIndex() >= 0) {
                    newPath.add(this.referenceTo(att));
                    newPath.add(SynonymMapBuilder.metadFieldValue(att));
                } else {
                    newPath.add(SynonymMapBuilder.metadField(att));
                    newPath.add(SynonymMapBuilder.metadFieldValue(att));
                }
            } else {
                newPath.add(att);
            }
            List<ExpandedSynonym> allAttSyns = att.getSynonyms().stream().filter(s -> this.sourcesMatch((ExpandedSynonym)s)).collect(Collectors.toList());
            List<RosettaExternalRegularAttribute> delta = this.getSynonymDeltas(att, allAttSyns, copy, clazz);
            List attSyns = allAttSyns.stream().filter(s -> s.getMerge() == null).collect(Collectors.toList());
            List mergeSyns = allAttSyns.stream().map(s -> s.getMerge()).filter(Objects::nonNull).collect(Collectors.toList());
            if (!mergeSyns.isEmpty()) {
                attMergeSyns.putAll((Object)att, mergeSyns);
            }
            TypeCall tc = att.getRosettaType();
            RosettaType type = null;
            if (tc != null) {
                type = tc.getType();
            }
            if (!attSyns.isEmpty()) {
                List<String> hints;
                List<SynonymGroup> groups = attSyns.stream().map(s -> this.toGroup((ExpandedSynonym)s, clazz.getModel().getName())).collect(Collectors.toList());
                if (!groups.isEmpty()) {
                    SynonymMap map = this.buildMap(type, maps, enumMaps);
                    if (!attMergeSyns.isEmpty()) {
                        List attMergeSynValues = attMergeSyns.values().stream().map(RosettaMergeSynonymValue::getName).collect(Collectors.toList());
                        boolean matchesSyn = groups.stream().flatMap(group -> group.getSynonymValues().stream()).flatMap(synValue -> synValue.getSynonymPath().stream()).map(Element::getName).anyMatch(attMergeSynValues::contains);
                        if (matchesSyn) {
                            map.getMergeSynonyms().putAll(attMergeSyns);
                        }
                    }
                    result.put(new AttributeGroup(groups, newPath), map);
                }
                if (att.hasMetas()) {
                    Map<AttributeGroup, SynonymMap> metaSynonyms = this.metaSynonyms(att, newPath.subList(0, newPath.size() - 1), delta, clazz.getModel().getName());
                    result.putAll(metaSynonyms);
                }
                if ((hints = attSyns.stream().flatMap(s -> s.getHints().stream()).collect(Collectors.toList())).isEmpty() || !(type instanceof Data) || alreadySearched.contains(type)) continue;
                HashSet<RosettaType> searched = new HashSet<RosettaType>(alreadySearched);
                RosettaType attClazz = type;
                searched.add(attClazz);
                Map<AttributeGroup, SynonymMap> hintMappings = this.buildMappings(attClazz, newPath, maps, enumMaps, true, searched, attMergeSyns);
                hintMappings = this.filtertoHinted(hintMappings, hints);
                result.putAll(hintMappings);
                continue;
            }
            if (!(type instanceof Data) || att.refIndex() >= 0 || alreadySearched.contains(type)) continue;
            HashSet<RosettaType> searched = new HashSet<RosettaType>(alreadySearched);
            RosettaType attClazz = type;
            searched.add(attClazz);
            result.putAll(this.buildMappings(attClazz, newPath, maps, enumMaps, true, searched, attMergeSyns));
        }
        return result;
    }

    private Collection<? extends ExpandedAttribute> addsSynonyms(List<RosettaExternalSynonymSource> copy, Collection<ExpandedAttribute> searchAttributes, Data clazz) {
        Collection<ExpandedAttribute> allSuperAttributes = this.getAllAttributes(clazz.getSuperType(), true);
        return copy.stream().flatMap(extSynSrc -> allSuperAttributes.stream().filter(a -> this.addsASynonym((ExpandedAttribute)a, (RosettaExternalSynonymSource)extSynSrc, clazz))).collect(Collectors.toSet());
    }

    private boolean addsASynonym(ExpandedAttribute att, RosettaExternalSynonymSource extSynSrc, Data clazz) {
        List<RosettaExternalRegularAttribute> externalSynonymsForType = this.getRosettaExternalRegularAttributes((RosettaType)clazz, att, extSynSrc, false);
        boolean additions = externalSynonymsForType.stream().anyMatch(x -> x.getOperator().equals((Object)ExternalValueOperator.PLUS));
        return additions;
    }

    public List<RosettaExternalRegularAttribute> getSynonymDeltas(ExpandedAttribute att, List<ExpandedSynonym> attSyns, List<RosettaExternalSynonymSource> copy, RosettaType clazz) {
        ArrayList<RosettaExternalRegularAttribute> delta = new ArrayList<RosettaExternalRegularAttribute>();
        copy.forEach(extSynSrc -> {
            LOGGER.trace((Object)("External Synonym src: " + extSynSrc.getName()));
            List<RosettaExternalRegularAttribute> externalAttributes = this.getRosettaExternalRegularAttributes(clazz, att, (RosettaExternalSynonymSource)extSynSrc, true);
            List<RosettaExternalRegularAttribute> additions = externalAttributes.stream().filter(x -> x.getOperator().equals((Object)ExternalValueOperator.PLUS)).collect(Collectors.toList());
            List removals = externalAttributes.stream().filter(x -> x.getOperator().equals((Object)ExternalValueOperator.MINUS)).collect(Collectors.toList());
            delta.removeIf(s -> removals.stream().map(c -> c.getAttributeRef()).map(c -> c.getName()).anyMatch(n -> n.equals(att.getName())));
            delta.addAll(additions);
            attSyns.removeIf(s -> removals.stream().map(c -> c.getAttributeRef()).map(c -> c.getName()).anyMatch(n -> n.equals(att.getName())));
            attSyns.addAll(this.addExternalSynonyms(additions));
        });
        return delta;
    }

    private void addKeySynonyms(List<RosettaClassSynonym> synonyms, List<RosettaExternalClassSynonym> externalSynonyms, List<ExpandedAttribute> attPath, Map<AttributeGroup, SynonymMap> result) {
        ArrayList<SynonymGroup> synonymGroups = new ArrayList<SynonymGroup>();
        List expandedSynonyms = synonyms.stream().filter(syn -> syn.getMetaValue() != null).map(RosettaAttributeExtensions::toRosettaExpandedSynonym).collect(Collectors.toList());
        expandedSynonyms.addAll(externalSynonyms.stream().filter(syn -> syn.getMetaValue() != null).map(RosettaAttributeExtensions::toRosettaExpandedSynonym).collect(Collectors.toList()));
        for (ExpandedSynonym rosettaExpandedSynonym : expandedSynonyms) {
            List<SynonymValue> synonymValues = Collections.singletonList(this.toList((ExpandedSynonymValue)rosettaExpandedSynonym.getMetaValues().get(0)));
            SynonymGroup synGroup = new SynonymGroup(synonymValues, Collections.emptyList(), null, null, null, null, false);
            synonymGroups.add(synGroup);
        }
        if (!synonymGroups.isEmpty()) {
            ArrayList<ExpandedAttribute> newPath = new ArrayList<ExpandedAttribute>(attPath);
            newPath.add(SynonymMapBuilder.metaAtt());
            newPath.add(SynonymMapBuilder.externalKeyAtt());
            AttributeGroup attgroup = new AttributeGroup(synonymGroups, newPath);
            result.put(attgroup, new SynonymMap());
        }
    }

    private Map<AttributeGroup, SynonymMap> filtertoHinted(Map<AttributeGroup, SynonymMap> hintMappings, List<String> hints) {
        HashMap<AttributeGroup, SynonymMap> result = new HashMap<AttributeGroup, SynonymMap>();
        for (Map.Entry<AttributeGroup, SynonymMap> entry : hintMappings.entrySet()) {
            ArrayList<SynonymGroup> filteredGroups = new ArrayList<SynonymGroup>();
            for (SynonymGroup group : entry.getKey().getSynonymGroups()) {
                List<SynonymCondition> filteredConditions;
                List<SynonymValue> filteredValues = group.getSynonymValues().stream().filter(v -> hints.contains(v.getSynonymPath().get(0).getName())).collect(Collectors.toList());
                if (!filteredValues.isEmpty()) {
                    SynonymGroup filteredGroup = new SynonymGroup(filteredValues, group.getConditions(), group.getMapperName(), group.getFormatString(), group.getPatternMatcher(), group.getPatternReplace(), group.isRemoveHtml());
                    filteredGroups.add(filteredGroup);
                }
                if ((filteredConditions = group.getConditions().stream().map(c -> this.filteredCondition((SynonymCondition)c, hints)).filter(c -> !c.getCondition().isEmpty()).collect(Collectors.toList())).isEmpty()) continue;
                SynonymGroup filteredGroup = new SynonymGroup(Collections.emptyList(), filteredConditions, group.getMapperName(), group.getFormatString(), group.getPatternMatcher(), group.getPatternReplace(), group.isRemoveHtml());
                filteredGroups.add(filteredGroup);
            }
            if (filteredGroups.isEmpty()) continue;
            AttributeGroup fillteredAtt = new AttributeGroup(filteredGroups, entry.getKey().getAttributePath());
            result.put(fillteredAtt, entry.getValue());
        }
        return result;
    }

    private SynonymCondition filteredCondition(SynonymCondition condition, List<String> hints) {
        List<SynonymTest> conditions = condition.getCondition().stream().filter(t -> this.filterTest((SynonymTest)t, hints)).collect(Collectors.toList());
        return new SynonymCondition(condition.getSetToValue(), conditions);
    }

    private boolean filterTest(SynonymTest test, List<String> hints) {
        return test.getPaths().stream().anyMatch(v -> hints.contains(v.getSynonymPath().get(0).getName()));
    }

    private Map<AttributeGroup, SynonymMap> metaSynonyms(ExpandedAttribute att, List<ExpandedAttribute> newPath, List<RosettaExternalRegularAttribute> externalRegularAttributes, String enclosingPackageName) {
        HashMap<AttributeGroup, SynonymMap> metaSynonyms = new HashMap<AttributeGroup, SynonymMap>();
        List metas = att.getMetas();
        for (int metaIndex = 0; metaIndex < metas.size(); ++metaIndex) {
            ExpandedAttribute metaAtt = (ExpandedAttribute)metas.get(metaIndex);
            String name = metaAtt.getName();
            List sourceSyns = metaAtt.getSynonyms().stream().filter(s -> this.sourcesMatch((ExpandedSynonym)s)).collect(Collectors.toList());
            List<ExpandedSynonym> addExternalMetaSynonyms = this.findExternalMetaSynonyms(externalRegularAttributes, metaIndex);
            sourceSyns.addAll(addExternalMetaSynonyms);
            ArrayList<ExpandedAttribute> metaPath = new ArrayList<ExpandedAttribute>(newPath);
            if (name.equals("reference")) {
                metaPath.add(SynonymMapBuilder.refField());
            } else if (name.equals("address")) {
                metaPath.add(SynonymMapBuilder.addressField());
            } else {
                metaPath.add(SynonymMapBuilder.metaAtt());
                metaPath.add(SynonymMapBuilder.metaDataField(metaAtt));
            }
            List<SynonymGroup> groups = sourceSyns.stream().map(s -> this.toGroup((ExpandedSynonym)s, enclosingPackageName)).collect(Collectors.toList());
            SynonymMap map = new SynonymMap(null);
            if (groups.isEmpty()) continue;
            metaSynonyms.put(new AttributeGroup(groups, metaPath), map);
        }
        return metaSynonyms;
    }

    private List<ExpandedSynonym> findExternalMetaSynonyms(List<RosettaExternalRegularAttribute> externalRegularAttributes, int metaIndex) {
        ArrayList<ExpandedSynonym> expandedSynonyms = new ArrayList<ExpandedSynonym>();
        IntStream.range(0, externalRegularAttributes.size()).forEach(i -> {
            RosettaExternalRegularAttribute rosettaExternalRegularAttribute = (RosettaExternalRegularAttribute)externalRegularAttributes.get(i);
            List rosettaExpandedSynonym = RosettaAttributeExtensions.toRosettaExpandedSynonym(null, (List)rosettaExternalRegularAttribute.getExternalSynonyms(), (int)metaIndex);
            expandedSynonyms.addAll(rosettaExpandedSynonym);
        });
        return expandedSynonyms;
    }

    private List<ExpandedSynonym> addExternalEnumSynonyms(List<RosettaExternalEnumValue> externalAttributes) {
        return externalAttributes.stream().map(a -> a.getExternalEnumSynonyms()).flatMap(Collection::stream).map(RosettaAttributeExtensions::toExpandedSynonym).collect(Collectors.toList());
    }

    private List<RosettaExternalEnumValue> getRosettaExternalEnums(String enclosingTypeName, ExpandedAttribute att, RosettaExternalSynonymSource extSynSrc) {
        return extSynSrc.getExternalEnums().stream().filter(c -> c.getTypeRef().getName().equals(enclosingTypeName)).map(c -> c.getRegularValues()).flatMap(Collection::stream).filter(c -> c.getEnumRef().getName().equals(att.getName())).collect(Collectors.toList());
    }

    private List<ExpandedSynonym> addExternalSynonyms(List<RosettaExternalRegularAttribute> externalAttributes) {
        return externalAttributes.stream().map(a -> a.getExternalSynonyms()).flatMap(Collection::stream).map(RosettaAttributeExtensions::toRosettaExpandedSynonym).collect(Collectors.toList());
    }

    private List<RosettaExternalRegularAttribute> getRosettaExternalRegularAttributes(RosettaType enclosingType, ExpandedAttribute att, RosettaExternalSynonymSource extSynSrc, boolean includeSupers) {
        Set enclosingTypeNames = this.getEnclosingTypes(enclosingType, includeSupers).map(RosettaNamed::getName).collect(Collectors.toSet());
        return extSynSrc.getExternalClasses().stream().filter(c -> enclosingTypeNames.contains(c.getTypeRef().getName())).map(c -> c.getRegularAttributes()).flatMap(Collection::stream).filter(c -> c.getAttributeRef().getName().equals(att.getName())).collect(Collectors.toList());
    }

    private Stream<? extends RosettaType> getEnclosingTypes(RosettaType enclosingType, boolean includeSupers) {
        if (!includeSupers) {
            return Stream.of(enclosingType);
        }
        if (enclosingType instanceof Data) {
            return StreamUtils.recurse((Object)((Data)enclosingType), Data::getSuperType);
        }
        if (enclosingType instanceof RosettaEnumeration) {
            return StreamUtils.recurse((Object)((RosettaEnumeration)enclosingType), e -> e.getParent());
        }
        return Stream.of(enclosingType);
    }

    private List<RosettaExternalClassSynonym> getRosettaExternalClassSynonyms(String enclosingTypeName) {
        return this.externalSynonyms.stream().map(ExternalAnnotationSource::getExternalClasses).flatMap(Collection::stream).filter(c -> c.getTypeRef().getName().equals(enclosingTypeName)).map(c -> c.getExternalClassSynonyms()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private Collection<ExpandedAttribute> getAllAttributes(Data clazz, boolean includeSupers) {
        ArrayList<ExpandedAttribute> result = new ArrayList<ExpandedAttribute>(RosettaAttributeExtensions.getExpandedAttributes((Data)clazz));
        if (clazz.getSuperType() != null && includeSupers) {
            result.addAll(this.getAllAttributes(clazz.getSuperType(), includeSupers));
        }
        return result;
    }

    public Collection<ExpandedAttribute> getAllEnumValue(RosettaEnumeration rEnum) {
        if (rEnum.getParent() == null) {
            return RosettaAttributeExtensions.getExpandedAttributes((RosettaEnumeration)rEnum);
        }
        ArrayList<ExpandedAttribute> result = new ArrayList<ExpandedAttribute>(RosettaAttributeExtensions.getExpandedAttributes((RosettaEnumeration)rEnum));
        result.addAll(this.getAllEnumValue(rEnum.getParent()));
        return result;
    }

    private SynonymGroup toGroup(ExpandedSynonym synonym, String enclosingPackageName) {
        String mapperName;
        String string = mapperName = synonym.getMapperName() == null ? null : enclosingPackageName + ".processor." + synonym.getMapperName();
        if (synonym.getValues() != null && synonym.getMetaValues() != null) {
            return new SynonymGroup(synonym.getValues().stream().map(this::toList).collect(Collectors.toList()), this.toConditions(synonym), mapperName, synonym.getFormat(), synonym.getPatternMatcher(), synonym.getPatternReplace(), synonym.isRemoveHtml());
        }
        return new SynonymGroup(this.toConditions(synonym));
    }

    private List<SynonymCondition> toConditions(ExpandedSynonym synonym) {
        if (synonym.getMappingLogic() == null) {
            return Collections.emptyList();
        }
        EList instances = synonym.getMappingLogic().getInstances();
        return instances.stream().map(i -> this.toCondition((RosettaMappingInstance)i)).collect(Collectors.toList());
    }

    private SynonymCondition toCondition(RosettaMappingInstance instance) {
        return SynonymCondition.create(instance.getSet(), instance.getWhen() == null ? Collections.emptyList() : instance.getWhen().getTests());
    }

    private SynonymValue toList(ExpandedSynonymValue value) {
        if (value.getPath() == null || value.getPath().isEmpty()) {
            return new SynonymValue((List<Element>)ImmutableList.of((Object)new Element(value.getName())), value.getMaps(), value.isMeta());
        }
        List<Element> r = Element.toElementList(value.getPath());
        r.add(new Element(value.getName()));
        return new SynonymValue(r, value.getMaps(), value.isMeta());
    }

    private boolean sourcesMatch(ExpandedSynonym s) {
        return s.getSources().stream().anyMatch(ss -> this.synonymSourceNames.contains(ss.getName()));
    }

    private boolean sourcesMatch(RosettaClassSynonym s) {
        return s.getSources().stream().anyMatch(ss -> this.synonymSourceNames.contains(ss.getName()));
    }

    private <T extends RosettaRootElement & RosettaNamed> T resolveType(T typeReference) {
        NamespaceName name;
        RosettaNamed rosettaNamed;
        RosettaRootElement result;
        if (this.typeCache != null && (result = (RosettaRootElement)(rosettaNamed = (RosettaNamed)this.typeCache.get(name = new NamespaceName(typeReference.getModel().getName(), ((RosettaNamed)typeReference).getName())))) != null) {
            return (T)result;
        }
        return typeReference;
    }

    private ExpandedAttribute referenceTo(ExpandedAttribute att) {
        return new ExpandedAttribute(att.getName(), att.getEnclosingType(), RosettaAttributeExtensions.toExpandedType((RosettaType)this.referenceType(att).getType()), this.referenceType(att), true, att.getInf(), att.getSup(), att.isUnbound(), Collections.emptyList(), null, Collections.emptyList(), false, Collections.emptyList());
    }

    private static String toFirstUpper(String name) {
        return Strings.toFirstUpper((String)name);
    }

    private static ExpandedAttribute refField() {
        return new ExpandedAttribute("externalReference", null, SynonymMapBuilder.provideStringType(), null, false, 1, 1, false, Collections.emptyList(), null, Collections.emptyList(), false, Collections.emptyList());
    }

    private static ExpandedAttribute addressField() {
        return new ExpandedAttribute("reference", null, new ExpandedType(null, "ReferenceBuilder", false, false, false), null, false, 1, 1, false, Collections.emptyList(), null, Collections.emptyList(), false, Collections.emptyList());
    }

    private static ExpandedAttribute metadField(ExpandedAttribute att) {
        return new ExpandedAttribute(att.getName(), att.getEnclosingType(), RosettaAttributeExtensions.toExpandedType((RosettaType)SynonymMapBuilder.metadType(att.getType()).getType()), SynonymMapBuilder.metadType(att.getType()), true, att.getInf(), att.getSup(), att.isUnbound(), Collections.emptyList(), null, Collections.emptyList(), false, Collections.emptyList());
    }

    private static ExpandedAttribute metadFieldValue(ExpandedAttribute att) {
        return new ExpandedAttribute("value", att.getEnclosingType(), att.getType(), att.getRosettaType(), false, 1, 1, false, Collections.emptyList(), null, Collections.emptyList(), false, Collections.emptyList());
    }

    static ExpandedAttribute metaDataField(ExpandedAttribute att) {
        String name = att.getName();
        if ("id".equals(name)) {
            name = "externalKey";
        }
        return new ExpandedAttribute(name, att.getEnclosingType(), att.getType(), null, false, 1, 1, false, Collections.emptyList(), null, Collections.emptyList(), false, Collections.emptyList());
    }

    private static ExpandedAttribute metaAtt() {
        return new ExpandedAttribute("meta", null, RosettaAttributeExtensions.toExpandedType((RosettaType)META_TYPE.getType()), META_TYPE, false, 1, 1, false, Collections.emptyList(), null, Collections.emptyList(), false, Collections.emptyList());
    }

    private static ExpandedAttribute externalKeyAtt() {
        return new ExpandedAttribute("externalKey", null, SynonymMapBuilder.provideStringType(), null, false, 1, 1, false, Collections.emptyList(), null, Collections.emptyList(), false, Collections.emptyList());
    }

    private static ExpandedType provideStringType() {
        return new ExpandedType(null, "string", false, false, false);
    }

    private TypeCall referenceType(ExpandedAttribute genAttr) {
        JavaClass<?> metaJavaType = this.toMetaJavaType(genAttr);
        Data res = SimpleFactory.eINSTANCE.createData();
        res.setName(metaJavaType.getSimpleName());
        res.setDefinition(genAttr.getName());
        RosettaModel model = RosettaFactory.eINSTANCE.createRosettaModel();
        model.setName(metaJavaType.getPackageName().withDots());
        res.setModel(model);
        TypeCall typeCall = RosettaFactory.eINSTANCE.createTypeCall();
        typeCall.setType((RosettaType)res);
        return typeCall;
    }

    private JavaClass<?> toMetaJavaType(ExpandedAttribute expAttr) {
        Object attrType = expAttr.getRosettaType() != null ? this.typeTranslator.toJavaReferenceType(this.typeSystem.typeCallToRType(expAttr.getRosettaType())) : this.expandedTypeToJavaType(expAttr.getType());
        DottedPath namespace = this.getModelPackage((RosettaNamed)expAttr.getRosettaType().getType());
        return this.toMetaJavaType((JavaReferenceType)attrType, expAttr.refIndex() < 0, namespace);
    }

    private JavaClass<?> toMetaJavaType(JavaReferenceType base, boolean hasMetaFieldAnnotations, DottedPath namespace) {
        String attributeTypeName = base.getSimpleName();
        String name = hasMetaFieldAnnotations ? "FieldWithMeta" + attributeTypeName : "ReferenceWithMeta" + attributeTypeName;
        DottedPath pkg = this.metaField(namespace);
        return new GeneratedJavaClass(pkg, name, Object.class);
    }

    private DottedPath metaField(DottedPath p) {
        return p.child("metafields");
    }

    private DottedPath getModelPackage(RosettaNamed object) {
        RosettaRootElement rootElement = (RosettaRootElement)EcoreUtil2.getContainerOfType((EObject)object, RosettaRootElement.class);
        RosettaModel model = rootElement.getModel();
        if (model == null) {
            throw new IllegalArgumentException("Can not compute package name for " + object.eClass().getName() + " " + object.getName() + ". Element is not attached to a RosettaModel.");
        }
        return this.modelPackage(model);
    }

    private DottedPath modelPackage(RosettaModel model) {
        return DottedPath.splitOnDots((String)model.getName());
    }

    private JavaReferenceType expandedTypeToJavaType(ExpandedType type) {
        if (type.getName().equals("MetaFields") || type.getName().equals("MetaAndTemplateFields")) {
            return new GeneratedJavaClass(this.packages.basicMetafields(), type.getName(), Object.class);
        }
        if (type.isMetaType()) {
            return this.typeUtil.STRING;
        }
        if (type.isBuiltInType()) {
            return this.typeTranslator.toJavaReferenceType(this.builtins.getType(type.getName(), Collections.emptyMap()));
        }
        return new GeneratedJavaClass(this.modelPackage(type.getModel()), type.getName(), Object.class);
    }

    private static TypeCall metadType(ExpandedType genType) {
        Data res = SimpleFactory.eINSTANCE.createData();
        res.setName("FieldWithMeta" + SynonymMapBuilder.toFirstUpper(genType.getName()));
        res.setDefinition(genType.getName());
        RosettaModel model = RosettaFactory.eINSTANCE.createRosettaModel();
        model.setName(genType.getModel().getName() + ".metafields");
        res.setModel(model);
        TypeCall typeCall = RosettaFactory.eINSTANCE.createTypeCall();
        typeCall.setType((RosettaType)res);
        return typeCall;
    }
}

