/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate.synonymmap;

import com.codahale.metrics.Timer;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.regnosys.rosetta.common.util.StreamUtils;
import com.regnosys.rosetta.generator.object.ExpandedAttribute;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.translate.IngesterGenerator;
import com.regnosys.rosetta.translate.MappingError;
import com.regnosys.rosetta.translate.datamodel.Attribute;
import com.regnosys.rosetta.translate.datamodel.Cardinality;
import com.regnosys.rosetta.translate.datamodel.Entity;
import com.regnosys.rosetta.translate.datamodel.EntityImpl;
import com.regnosys.rosetta.translate.datamodel.NamespaceName;
import com.regnosys.rosetta.translate.datamodel.Schema;
import com.regnosys.rosetta.translate.synonymmap.AttributeGroup;
import com.regnosys.rosetta.translate.synonymmap.AttributeGroupMapping;
import com.regnosys.rosetta.translate.synonymmap.Element;
import com.regnosys.rosetta.translate.synonymmap.SynonymCondition;
import com.regnosys.rosetta.translate.synonymmap.SynonymGroup;
import com.regnosys.rosetta.translate.synonymmap.SynonymMap;
import com.regnosys.rosetta.translate.synonymmap.SynonymTest;
import com.regnosys.rosetta.translate.synonymmap.SynonymValue;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelCombiner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelCombiner.class);
    private static final String BASIC_ERROR_STRING = "Type Mismatch: The rosettaPath %s.%s is of type %s while the schema path %s.%s is a basic type";
    private final Map<Entity, Set<Attribute>> entityAttributeCache = new HashMap<Entity, Set<Attribute>>();

    public List<SynonymMap> combineModels(Schema model, List<SynonymMap> synonyms, List<MappingError> errors, Collection<String> topEntityNames) {
        Timer timer = IngesterGenerator.GENERATOR_METRICS.timer("combining models");
        Timer.Context time = timer.time();
        List<Object> topEntities = null;
        if (topEntityNames.isEmpty()) {
            EntityImpl topEnt = new EntityImpl(new NamespaceName("top", "top"), false);
            topEnt.getAttributes().addAll(model.getAttributes());
            topEntities = Collections.singletonList(topEnt);
        } else {
            topEntities = model.getAttributes().stream().filter(a -> topEntityNames.contains(a.getName())).map(a -> a.getType()).collect(Collectors.toList());
        }
        Collection<Entity> globals = model.getGlobalTypes();
        for (Entity topEntity : topEntities) {
            for (SynonymMap sm : synonyms) {
                this.combine(sm, topEntity, true, globals, errors);
                if (sm.getSuperMap() == null) continue;
                this.combine(sm.getSuperMap(), topEntity, true, globals, errors);
            }
        }
        for (SynonymMap sm : synonyms) {
            this.combineGlobals(sm, globals, errors);
        }
        time.stop();
        return synonyms;
    }

    public List<SynonymMap> prune(List<SynonymMap> synonyms) {
        HashMultimap removed = HashMultimap.create();
        List<SynonymMap> prune = this.prune(synonyms, (Multimap<ExpandedAttribute, SynonymGroup>)removed);
        for (Map.Entry rem : removed.entries()) {
            String location = ((ExpandedAttribute)rem.getKey()).getEnclosingType() + "." + ((ExpandedAttribute)rem.getKey()).getName();
            LOGGER.trace("Removed broken synonyms on " + location + "[" + ((SynonymGroup)rem.getValue()).toPathsString() + "]");
        }
        return prune;
    }

    public List<SynonymMap> prune(List<SynonymMap> synonyms, Multimap<ExpandedAttribute, SynonymGroup> removed) {
        Timer timer = IngesterGenerator.GENERATOR_METRICS.timer("pruning model");
        Timer.Context time = timer.time();
        HashMap replacedMaps = new HashMap();
        List<SynonymMap> pruned = synonyms.stream().map(s -> this.removeUnconnectedEntities((SynonymMap)s, replacedMaps, removed)).collect(Collectors.toList());
        time.stop();
        return pruned;
    }

    private void combine(SynonymMap map, Entity entity, boolean actualMatch, Collection<Entity> globals, List<MappingError> errors) {
        if (map.getLinkedEntities().contains(entity)) {
            return;
        }
        if (actualMatch) {
            map.getLinkedEntities().add(entity);
        }
        for (AttributeGroupMapping mappedGroup : map.getMappedGroups()) {
            for (SynonymGroup sg : mappedGroup.getGroup().getSynonymGroups()) {
                for (SynonymValue sv : sg.getSynonymValues()) {
                    Entity endEntity = this.combinePath(entity, sv, mappedGroup, actualMatch, globals, map, errors);
                    if (endEntity == null) continue;
                    this.combine(mappedGroup.getMappings(), endEntity, true, globals, errors);
                    for (SynonymMap superMap = mappedGroup.getMappings().getSuperMap(); superMap != null; superMap = superMap.getSuperMap()) {
                        this.combine(superMap, endEntity, true, globals, errors);
                    }
                }
                for (SynonymCondition condition : sg.getConditions()) {
                    for (SynonymTest test : condition.getCondition()) {
                        for (SynonymValue sv : test.getPaths()) {
                            this.combinePath(entity, sv, mappedGroup, actualMatch, globals, map, errors);
                        }
                    }
                }
            }
        }
    }

    private Set<Attribute> getAllAttributes(Entity parentEntity, Collection<Entity> globals) {
        return this.entityAttributeCache.computeIfAbsent(parentEntity, e -> {
            HashSet<Attribute> result = new HashSet<Attribute>();
            ArrayDeque<Entity> entitiesToCheck = new ArrayDeque<Entity>();
            HashSet<Entity> checked = new HashSet<Entity>();
            entitiesToCheck.add(parentEntity);
            while (!entitiesToCheck.isEmpty()) {
                Entity entity = (Entity)entitiesToCheck.remove();
                if (checked.contains(entity)) continue;
                checked.add(entity);
                List<Attribute> attributes = entity.getAttributes();
                result.addAll(attributes);
                Set<Attribute> substitutedAttributes = this.getSubstitutedAttributes(parentEntity, entity, globals);
                result.addAll(substitutedAttributes);
                entitiesToCheck.addAll(entity.getKnownExtendingEntities());
            }
            return result;
        });
    }

    private Set<Attribute> getSubstitutedAttributes(Entity parentEntity, Entity currentEntity, Collection<Entity> globals) {
        HashSet<Attribute> substitutedAttributes = new HashSet<Attribute>();
        Entity globalParentEntity = globals.stream().filter(globalEntity -> parentEntity.equals(globalEntity)).map(Entity::getExtendedEntity).filter(Objects::nonNull).findFirst().orElse(null);
        if (globalParentEntity == null) {
            return substitutedAttributes;
        }
        for (Attribute attribute : currentEntity.getAttributes()) {
            this.addSubstitutedAttributes(globalParentEntity, attribute.getType(), globals, substitutedAttributes);
        }
        return substitutedAttributes;
    }

    private void addSubstitutedAttributes(Entity parentEntity, Entity attrEntity, Collection<Entity> globals, Set<Attribute> result) {
        for (Entity knownExtendingEntity : attrEntity.getKnownExtendingEntities()) {
            Set<Attribute> substitutedAttributes = parentEntity.getAttributes().stream().filter(a -> knownExtendingEntity.equals(a.getType())).collect(Collectors.toSet());
            if (!substitutedAttributes.isEmpty()) {
                substitutedAttributes.forEach(substitutedAttribute -> {
                    if (!result.contains(substitutedAttribute)) {
                        LOGGER.trace("Adding substituted attribute {}{} from {} to parentEntity {}", new Object[]{substitutedAttribute.getName(), substitutedAttribute.getCardinality().toShortString(), knownExtendingEntity.getName().getName(), parentEntity.getName().getName()});
                        result.add((Attribute)substitutedAttribute);
                    }
                });
            }
            this.addSubstitutedAttributes(parentEntity, knownExtendingEntity, globals, result);
        }
    }

    private Entity combinePath(Entity entity, SynonymValue sv, AttributeGroupMapping mappedGroup, boolean actualMatch, Collection<Entity> globals, SynonymMap startPoint, List<MappingError> errors) {
        Entity currentEntity = entity;
        Entity result = null;
        for (Element pathElement : sv.getSynonymPath()) {
            String pathElementName = pathElement.getName();
            boolean matched = !actualMatch;
            Set<Attribute> atts = this.getAllAttributes(currentEntity, globals);
            for (Attribute att : atts) {
                String attName = att.getName();
                Entity attEntity = att.getType();
                if (!attName.equals(pathElementName)) continue;
                matched = true;
                if (pathElement.getEntity() != null) {
                    Cardinality card = Cardinality.max(pathElement.getCardinality(), att.getCardinality());
                    pathElement.setEntity(pathElement.getEntity(), card);
                } else {
                    pathElement.setEntity(attEntity, att.getCardinality());
                }
                if (attEntity.hasData() && !mappedGroup.getMappings().isBasic() && actualMatch) {
                    errors.add(new MappingError(MappingError.MappingErrorLevel.ERROR, String.format(BASIC_ERROR_STRING, startPoint.getRosetta().getName(), mappedGroup.getGroup().attsToString(), mappedGroup.getMappings().getRosetta().getName(), entity.getName().getName(), sv.toPathString())));
                }
                currentEntity = attEntity;
                result = attEntity;
            }
            if (matched) continue;
            return null;
        }
        return result;
    }

    private void combineGlobals(SynonymMap mapping, Collection<Entity> globals, List<MappingError> errors) {
        List maps = StreamUtils.flattenTreeC((Object)mapping, sm -> sm.childMappings()).collect(Collectors.toList());
        for (SynonymMap map : maps) {
            for (Entity e : globals) {
                this.combine(map, e, false, globals, errors);
                while (map.getSuperMap() != null) {
                    this.combine(map.getSuperMap(), e, false, globals, errors);
                    map = map.getSuperMap();
                }
            }
        }
    }

    private SynonymMap removeUnconnectedEntities(SynonymMap synonym, Map<SynonymMap, SynonymMap> replacedMaps, Multimap<ExpandedAttribute, SynonymGroup> removed) {
        if (synonym == null) {
            return null;
        }
        if (replacedMaps.containsKey(synonym)) {
            SynonymMap synonymMap = replacedMaps.get(synonym);
            return synonymMap;
        }
        if (synonym.getRosetta() instanceof RosettaEnumeration) {
            return synonym;
        }
        SynonymMap parentMap = this.removeUnconnectedEntities(synonym.getSuperMap(), replacedMaps, removed);
        SynonymMap result = new SynonymMap(synonym.getRosetta(), parentMap);
        replacedMaps.put(synonym, result);
        for (AttributeGroupMapping mappedGroups : synonym.getMappedGroups()) {
            AttributeGroup group = this.removeUnconnected(mappedGroups.getGroup(), removed);
            if (group == null) continue;
            SynonymMap newMap = this.removeUnconnectedEntities(mappedGroups.getMappings(), replacedMaps, removed);
            result.addMapping(group, newMap);
            result.getMergeSynonyms().putAll(synonym.getMergeSynonyms());
        }
        for (Map.Entry s : synonym.getConditionalCaptures().entries()) {
            if (!this.isConnected((SynonymValue)s.getKey())) continue;
            result.getConditionalCaptures().put((Object)((SynonymValue)s.getKey()), (Object)((SynonymCondition)s.getValue()));
        }
        return result;
    }

    private AttributeGroup removeUnconnected(AttributeGroup pair, Multimap<ExpandedAttribute, SynonymGroup> removed) {
        List<SynonymGroup> synonymPaths = ((Stream)pair.getSynonymGroups().stream().sequential()).map(sg -> this.removeUnconnected((SynonymGroup)sg, removed, pair)).filter(Objects::nonNull).collect(Collectors.toList());
        if (synonymPaths.isEmpty()) {
            return null;
        }
        return new AttributeGroup(synonymPaths, pair.getAttributePath());
    }

    private SynonymGroup removeUnconnected(SynonymGroup sg, Multimap<ExpandedAttribute, SynonymGroup> removed, AttributeGroup pair) {
        boolean prunedCondition = sg.getConditions().stream().anyMatch(c -> this.isUnconnected((SynonymCondition)c));
        if (prunedCondition) {
            ExpandedAttribute expandedAttribute = pair.getAttributePath().get(pair.getAttributePath().size() - 1);
            removed.put((Object)expandedAttribute, (Object)sg);
            return null;
        }
        if (sg.getSynonymValues().isEmpty()) {
            return sg;
        }
        ArrayList<SynonymValue> paths = new ArrayList<SynonymValue>();
        for (SynonymValue val : sg.getSynonymValues()) {
            if (!this.isConnected(val)) continue;
            paths.add(val);
        }
        if (paths.isEmpty()) {
            ExpandedAttribute expandedAttribute = pair.getAttributePath().get(pair.getAttributePath().size() - 1);
            removed.put((Object)expandedAttribute, (Object)sg);
            return null;
        }
        return new SynonymGroup(paths, sg.getConditions(), sg.getMapperName(), sg.getFormatString(), sg.getPatternMatcher(), sg.getPatternReplace(), sg.isRemoveHtml());
    }

    private boolean isUnconnected(SynonymCondition c) {
        return c.getCondition().stream().anyMatch(t -> this.isUnconnected((SynonymTest)t));
    }

    private boolean isUnconnected(SynonymTest t) {
        return t.getPaths().stream().anyMatch(v -> !this.isConnected((SynonymValue)v));
    }

    private boolean isConnected(SynonymValue sv) {
        return sv.getSynonymPath().stream().anyMatch(e -> e.getEntity() != null);
    }
}

