/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate.synonymmap;

import com.regnosys.rosetta.translate.datamodel.Cardinality;
import com.regnosys.rosetta.translate.datamodel.Entity;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class Element {
    private final String name;
    private Entity entity;
    private Cardinality cardinality;

    public Element(String name, Entity entity) {
        this(name);
        this.entity = entity;
    }

    public Element(String name) {
        this.name = name;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public Cardinality getCardinality() {
        return this.cardinality;
    }

    public void setEntity(Entity entity, Cardinality cardinality) {
        this.entity = entity;
        this.cardinality = cardinality;
    }

    public String getName() {
        return this.name;
    }

    public static List<Element> toElementList(String path) {
        if (path.contains(".")) {
            throw new RuntimeException("Path may not contain dot chars: " + path);
        }
        return Arrays.stream(path.split("->")).map(s -> new Element((String)s)).collect(Collectors.toList());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entity == null ? 0 : this.entity.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Element other = (Element)obj;
        if (this.entity == null ? other.entity != null : !this.entity.equals(other.entity)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        String ent = this.entity == null ? "null" : this.entity.getName().toString();
        return "Element [name=" + this.name + ", entity=" + ent + "]";
    }
}

