/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate.synonymmap;

import com.google.common.collect.Ordering;
import com.regnosys.rosetta.generator.object.ExpandedAttribute;
import com.regnosys.rosetta.translate.synonymmap.SynonymGroup;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;

public class AttributeGroup
implements Comparable<AttributeGroup> {
    private final List<ExpandedAttribute> attributePath;
    private final List<SynonymGroup> synonymGroups;
    private static final Comparator<AttributeGroup> COMPARATOR = Comparator.comparing(AttributeGroup::getAttributePath, Ordering.from(Comparator.comparing(ExpandedAttribute::getName)).lexicographical()).thenComparing(AttributeGroup::getSynonymGroups, Ordering.from(Comparator.comparing(SynonymGroup::toString)).lexicographical());

    public AttributeGroup(List<SynonymGroup> synonymGroups, List<ExpandedAttribute> attributePath) {
        this.attributePath = attributePath;
        LinkedHashSet<SynonymGroup> sgSet = new LinkedHashSet<SynonymGroup>(synonymGroups);
        this.synonymGroups = new ArrayList<SynonymGroup>(sgSet);
    }

    public List<SynonymGroup> getSynonymGroups() {
        return this.synonymGroups;
    }

    public List<ExpandedAttribute> getAttributePath() {
        return this.attributePath;
    }

    public String attsToString() {
        return this.attributePath.stream().map(att -> this.attToString((ExpandedAttribute)att)).collect(Collectors.joining(", "));
    }

    private String attToString(ExpandedAttribute att) {
        return att.getName() + (att.getSup() > 1 ? "*" : "");
    }

    public static String attributeName(ExpandedAttribute att) {
        String name = att.getName();
        return name;
    }

    public String toString() {
        String atts = this.attsToString();
        return this.synonymGroups + "[" + atts + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributePath == null ? 0 : this.attributePath.hashCode());
        result = 31 * result + (this.synonymGroups == null ? 0 : this.synonymGroups.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeGroup other = (AttributeGroup)obj;
        if (this.attributePath == null ? other.attributePath != null : !this.attributePath.equals(other.attributePath)) {
            return false;
        }
        return !(this.synonymGroups == null ? other.synonymGroups != null : !this.synonymGroups.equals(other.synonymGroups));
    }

    @Override
    public int compareTo(AttributeGroup l2) {
        return COMPARATOR.compare(this, l2);
    }

    public boolean startsWith(String string) {
        return this.attributePath.size() > 0 && this.attributePath.get(0).getName().equals(string);
    }

    public long hashForGeneration() {
        long result = 0L;
        for (ExpandedAttribute expandedAttribute : this.attributePath) {
            result += (long)expandedAttribute.getName().hashCode();
            String enclosingType = expandedAttribute.getEnclosingType();
            if (enclosingType == null) continue;
            result += (long)enclosingType.hashCode();
        }
        result *= 8191L;
        for (SynonymGroup sg : this.synonymGroups) {
            result += sg.hashForGeneration();
        }
        return result;
    }
}

