/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate.datamodel.json;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.regnosys.rosetta.common.util.UrlUtils;
import com.regnosys.rosetta.translate.IngestException;
import com.regnosys.rosetta.translate.datamodel.Attribute;
import com.regnosys.rosetta.translate.datamodel.Entity;
import com.regnosys.rosetta.translate.datamodel.Schema;
import com.regnosys.rosetta.translate.datamodel.json.JsonAttribute;
import com.regnosys.rosetta.translate.datamodel.json.JsonEntity;
import com.regnosys.rosetta.translate.datamodel.json.JsonSchemaParser;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class CreateiQJsonSchemaParser
implements JsonSchemaParser {
    private static final Logger LOG = Logger.getLogger(JsonSchemaParser.class);
    private Map<String, Entity> definitions;

    @Override
    public Schema parseModel(URL input) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            Map jsonMap = (Map)objectMapper.readValue(UrlUtils.openURL((URL)input), (TypeReference)new TypeReference<Map<String, Object>>(){});
            List<Attribute> attributes = this.processMap(jsonMap);
            Collection globalEntities = attributes.stream().map(a -> a.getType()).collect(Collectors.toList());
            return new Schema(attributes, globalEntities);
        }
        catch (IOException e) {
            throw new IngestException("Error when ingesting json", e);
        }
    }

    List<Attribute> processMap(Map<String, Object> map) {
        this.definitions = this.handleDefinitions(map);
        List<? extends Object> children = this.tryGetChildren(map).orElseThrow(() -> new UnsupportedOperationException("No children or repeatChildren found"));
        ArrayList<Attribute> allAttributes = new ArrayList<Attribute>(children.size());
        for (Object object : children) {
            Map childMap = (Map)object;
            Attribute firstLevelAttribute = this.constructAttributeTree(childMap, null).get();
            allAttributes.add(firstLevelAttribute);
        }
        ArrayList<Attribute> root = new ArrayList<Attribute>();
        root.add(new JsonAttribute("id", new JsonEntity("id", "string")));
        root.add(this.createPartyAttribute("partyA"));
        root.add(this.createPartyAttribute("partyB"));
        root.add(this.createDocAttribute());
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(2);
        arrayList.add(new JsonAttribute("partyA", new JsonEntity("partyA", "#partyAnswers", allAttributes)));
        arrayList.add(new JsonAttribute("partyB", new JsonEntity("partyB", "#partyAnswers", allAttributes)));
        JsonEntity answers = new JsonEntity("answers", "container", arrayList);
        root.add(new JsonAttribute("answers", answers));
        return root;
    }

    private Attribute createDocAttribute() {
        JsonAttribute idAttr = new JsonAttribute("id", new JsonEntity("id", "string"));
        JsonAttribute docYearAttr = new JsonAttribute("year", new JsonEntity("year", "integer"));
        JsonAttribute docTypeAttr = new JsonAttribute("documentType", new JsonEntity("documentType", "string"));
        JsonAttribute docGovLawAttr = new JsonAttribute("governingLaw", new JsonEntity("governingLaw", "string"));
        JsonAttribute docAbbreviationAttr = new JsonAttribute("abbreviation", new JsonEntity("abbreviation", "string"));
        JsonAttribute docDescriptionAttr = new JsonAttribute("description", new JsonEntity("description", "string"));
        JsonAttribute docPublisherAttr = new JsonAttribute("publisher", new JsonEntity("publisher", "string"));
        JsonAttribute hasSchemaAttr = new JsonAttribute("hasSchema", new JsonEntity("hasSchema", "boolean"));
        JsonAttribute docVersionAttr = new JsonAttribute("version", new JsonEntity("version", "string"));
        return new JsonAttribute("document", new JsonEntity("document", "container", Lists.newArrayList((Object[])new Attribute[]{idAttr, docYearAttr, docTypeAttr, docGovLawAttr, docAbbreviationAttr, docDescriptionAttr, docPublisherAttr, hasSchemaAttr, docVersionAttr})));
    }

    private Attribute createPartyAttribute(String party) {
        List<Attribute> entityAttributes = Arrays.asList(new JsonAttribute("id", new JsonEntity("id", "string")), new JsonAttribute("name", new JsonEntity("name", "string")));
        JsonAttribute entityAttr = new JsonAttribute("entity", new JsonEntity("entity", "container", entityAttributes));
        List<Attribute> accountAttributes = Arrays.asList(new JsonAttribute("id", new JsonEntity("id", "string")), new JsonAttribute("name", new JsonEntity("name", "string")));
        JsonAttribute accountAttr = new JsonAttribute("account", new JsonEntity("account", "container", accountAttributes));
        return new JsonAttribute(party, new JsonEntity(party, "container", Arrays.asList(entityAttr, accountAttr)));
    }

    private Optional<Attribute> constructAttributeTree(Map<String, Object> childMap, Entity current) {
        if (childMap.containsKey("name")) {
            Optional<List<? extends Object>> optional;
            Optional<Attribute> attr;
            String propertyName = this.getName(childMap);
            String propertyType = this.getType(childMap);
            Entity entity = this.constructEntity(propertyName, propertyType);
            if ("radio".equals(propertyType)) {
                List list = (List)childMap.get("options");
                for (Object e : list) {
                    Optional<List<? extends Object>> children2;
                    Map optionMap = (Map)e;
                    if (!optionMap.containsKey("children") || !(children2 = this.tryGetChildren(optionMap)).isPresent()) continue;
                    Entity newCurrent = current == null ? entity : current;
                    for (Object object : children2.get()) {
                        attr = this.constructAttributeTree((Map)object, newCurrent);
                        if (!attr.isPresent()) continue;
                        newCurrent.addAttribute(attr.get());
                    }
                }
            }
            if ((optional = this.tryGetChildren(childMap)).isPresent()) {
                for (Object object : optional.get()) {
                    if (this.isMap(object)) {
                        Optional<Attribute> attr2 = this.constructAttributeTree((Map)object, entity);
                        if (!attr2.isPresent()) continue;
                        entity.addAttribute((Attribute)attr2.get());
                        continue;
                    }
                    if (!this.isList(object)) continue;
                    for (Object innerItem : (List)object) {
                        if (this.isMap(innerItem)) {
                            Optional<Attribute> attr3 = this.constructAttributeTree((Map)innerItem, entity);
                            if (!attr3.isPresent()) continue;
                            entity.addAttribute(attr3.get());
                            continue;
                        }
                        if (!this.isList(innerItem)) continue;
                        List innerList = (List)innerItem;
                        for (Object object2 : innerList) {
                            attr = this.constructAttributeTree((Map)object2, entity);
                            if (!attr.isPresent()) continue;
                            entity.addAttribute(attr.get());
                        }
                    }
                }
                return Optional.of(new JsonAttribute(propertyName, entity));
            }
            return Optional.of(new JsonAttribute(propertyName, entity));
        }
        if ("group".equals(childMap.get("type"))) {
            Entity newCurrent = current;
            Optional<List<? extends Object>> children = this.tryGetChildren(childMap);
            if (children.isPresent()) {
                for (Object object : children.get()) {
                    if (this.isMap(object)) {
                        Optional<Attribute> attr = this.constructAttributeTree((Map)object, newCurrent);
                        if (!attr.isPresent()) continue;
                        newCurrent.addAttribute(attr.get());
                        continue;
                    }
                    if (!this.isList(object)) continue;
                    List innerList = (List)object;
                    for (Object obj : innerList) {
                        Optional<Attribute> attr = this.constructAttributeTree((Map)obj, newCurrent);
                        if (!attr.isPresent()) continue;
                        newCurrent.addAttribute(attr.get());
                    }
                }
            }
        } else if (childMap.containsKey("$ref")) {
            String refname = (String)childMap.get("$ref");
            JsonEntity refEntity = new JsonEntity((JsonEntity)this.definitions.get(refname));
            refEntity.getAttributes().forEach(a -> current.addAttribute((Attribute)a));
        }
        return Optional.empty();
    }

    private Entity constructEntity(String propertyName, String propertyType) {
        if (propertyType.startsWith("#")) {
            JsonEntity otherEntity = (JsonEntity)this.definitions.get(propertyType);
            List<Attribute> attributes = this.getContainerEntityAttributes(otherEntity);
            return new JsonEntity(propertyName, propertyType, attributes);
        }
        return new JsonEntity(propertyName, propertyType);
    }

    private List<Attribute> getContainerEntityAttributes(JsonEntity otherEntity) {
        assert (otherEntity.getType().equals("definition"));
        return otherEntity.getAttributes().get(0).getType().getAttributes();
    }

    private Optional<List<? extends Object>> tryGetChildren(Map<String, Object> childMap) {
        Object children = null;
        if (childMap.containsKey("children")) {
            children = childMap.get("children");
        } else if (childMap.containsKey("repeatChildren")) {
            children = childMap.get("repeatChildren");
        }
        return Optional.ofNullable(children).map(this::toList);
    }

    private List<?> toList(Object children) {
        if (children instanceof LinkedHashMap) {
            return Arrays.asList(children);
        }
        if (children instanceof List) {
            return (List)children;
        }
        throw new UnsupportedOperationException("Children contains unexpected type [%s]" + children.getClass());
    }

    Map<String, Entity> handleDefinitions(Map<String, Object> map) {
        LinkedHashMap<String, Entity> definedTypes = new LinkedHashMap<String, Entity>();
        if (map.containsKey("definitions")) {
            for (Map.Entry def : ((Map)map.get("definitions")).entrySet()) {
                String propertyName = (String)def.getKey();
                if (this.isMap(def.getValue())) {
                    Map actual = (Map)def.getValue();
                    if (!actual.containsKey("name")) {
                        actual.put("name", propertyName);
                    }
                    JsonEntity entity = new JsonEntity(propertyName, "definition");
                    definedTypes.put("#" + propertyName, entity);
                    Optional<Attribute> attr = this.constructAttributeTree(actual, entity);
                    if (!attr.isPresent()) continue;
                    entity.addAttribute(attr.get());
                    continue;
                }
                LOG.debug((Object)("Definition [ " + propertyName + " ] contains a List. Ignoring atm."));
            }
        }
        return this.flattenAnyDoublyContained(definedTypes);
    }

    private Map<String, Entity> flattenAnyDoublyContained(Map<String, Entity> definedTypes) {
        Set<Map.Entry<String, Entity>> entrySet = definedTypes.entrySet();
        for (Map.Entry<String, Entity> entry : entrySet) {
            Attribute attribute;
            Entity containerEntity = entry.getValue();
            String containerName = containerEntity.getName().getName();
            if (containerEntity.getAttributes().size() != 1 || !(attribute = containerEntity.getAttributes().get(0)).getName().equals(containerName) || !containerName.startsWith("17")) continue;
            entry.setValue(attribute.getType());
        }
        return definedTypes;
    }

    private String getName(Map<String, Object> map) {
        if (map.containsKey("name")) {
            Map nameMap;
            Object nameC = map.get("name");
            if (nameC instanceof String) {
                return (String)nameC;
            }
            if (this.isMap(nameC) && (nameMap = (Map)nameC).containsKey("position") && nameMap.containsKey("suffix")) {
                return (String)nameMap.get("position") + (String)nameMap.get("suffix");
            }
        }
        throw new UnsupportedOperationException("map does not contain 'name' property");
    }

    private String getType(Map<String, Object> childMap) {
        if (childMap.containsKey("type")) {
            return (String)childMap.get("type");
        }
        if (childMap.containsKey("$ref")) {
            return (String)childMap.get("$ref");
        }
        throw new UnsupportedOperationException("child map does not contain 'type' or '$ref' property");
    }

    private boolean isMap(Object obj) {
        return obj instanceof Map;
    }

    private boolean isList(Object obj) {
        return obj instanceof List;
    }
}

