/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate;

import com.google.common.collect.Multimap;
import com.google.inject.Injector;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.Path;
import com.regnosys.rosetta.translate.GeneratorPathUtil;
import com.regnosys.rosetta.translate.HandlerCache;
import com.regnosys.rosetta.translate.HandlerSupplier;
import com.regnosys.rosetta.translate.MappingProcessorSupplier;
import com.regnosys.rosetta.translate.MergeSynonymValue;
import com.regnosys.rosetta.translate.ParseHandler;
import com.regnosys.rosetta.translate.basic.BasicParseHandler;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ROMParseHandler<T extends RosettaModelObjectBuilder>
extends ParseHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ROMParseHandler.class);
    private final Map<String, List<String>> conditionPathCache = new HashMap<String, List<String>>();
    protected final Injector injector;
    protected final MappingContext mappingContext;
    protected Multimap<List<String>, HandlerSupplier> handlers;
    protected Multimap<List<String>, MappingProcessorSupplier> mappingProcessors;
    private T underlying;

    public static <T extends RosettaModelObjectBuilder, B extends RosettaModelObjectBuilder> void evaluateConditionalPaths(ROMParseHandler<T> rmoXmlParseHandler, HandlerCache<B> underlyers, Consumer<ROMParseHandler<B>> setter, Collection<String> path) {
        rmoXmlParseHandler.evaluateConditionalPaths(underlyers, setter, path);
    }

    public ROMParseHandler(Injector injector, MappingContext mappingContext) {
        this.rosettaPath = new Path();
        this.injector = injector;
        this.mappingContext = mappingContext;
    }

    public T getUnderlying() {
        return this.underlying;
    }

    public void setUnderlying(T underlying) {
        this.underlying = underlying;
    }

    protected <B extends RosettaModelObjectBuilder, H extends ROMParseHandler<B>> H findOrNew(HandlerCache<B> underlyers, String attribute, Path fullPath, Supplier<H> supplier) {
        return (H)underlyers.getOrCreateHandler(attribute, fullPath, supplier);
    }

    protected List<String> toStrings(Path path) {
        return path.getElements().stream().map(p -> p.getPathName()).collect(Collectors.toList());
    }

    public Collection<Map.Entry<RosettaPath, ? extends MappingProcessor>> getMappingProcessorForPath(Path localPath, Path parentPath, MappingContext mappingContext) {
        return this.mappingProcessors.get(this.toStrings(localPath)).stream().map(mp -> (Map.Entry)mp.apply(parentPath, mappingContext)).collect(Collectors.toList());
    }

    public Collection<List<String>> getMappingProcessorMatchPaths() {
        return this.mappingProcessors.keySet();
    }

    public Collection<List<String>> getHandlerMatchPaths() {
        return this.handlers.keySet();
    }

    public Collection<ParseHandler> getHandlersForPath(Path localPath, Path parentPath) {
        return this.handlers.get(this.toStrings(localPath)).stream().map(h -> (ParseHandler)h.apply(localPath, parentPath)).collect(Collectors.toList());
    }

    protected <H extends ParseHandler> H useOrNew(H handlerField, Supplier<H> supplier) {
        if (handlerField == null) {
            ParseHandler handler = (ParseHandler)supplier.get();
            return (H)handler;
        }
        return handlerField;
    }

    protected <B extends RosettaModelObjectBuilder> void evaluateConditionalPaths(HandlerCache<B> underlyers, Consumer<ROMParseHandler<B>> setter, Collection<String> conditionalPaths) {
        this.evaluateConditionalPaths(underlyers, setter, conditionalPaths, (Set<Path> a) -> true);
    }

    protected <B extends RosettaModelObjectBuilder> void evaluateConditionalPaths(ROMParseHandler<B> underlyer, Set<Path> xmlPathsToHere, Consumer<ROMParseHandler<B>> setter, List<String> conditionalPaths) {
        this.evaluateConditionalPaths(underlyer, xmlPathsToHere, setter, conditionalPaths.stream().map(p -> Path.parse((String)p)).collect(Collectors.toList()), a -> true);
    }

    protected <B extends RosettaModelObjectBuilder> void evaluateConditionalPaths(HandlerCache<B> underlyers, Consumer<ROMParseHandler<B>> setter, Collection<String> conditionalPaths, Predicate<Set<Path>> additionalTest) {
        for (ROMParseHandler<B> handler : underlyers.getAllHandlers()) {
            if (!GeneratorPathUtil.matches(handler.getXmlPathsToHere(), conditionalPaths) || !additionalTest.test(handler.getXmlPathsToHere())) continue;
            setter.accept(handler);
        }
    }

    protected <B extends RosettaModelObjectBuilder> void evaluateConditionalPaths(ROMParseHandler<B> handler, Set<Path> xmlPathsToHere, Consumer<ROMParseHandler<B>> setter, List<Path> conditionalPaths, Predicate<Set<Path>> additionalTest) {
        if (handler != null && xmlPathsToHere.stream().anyMatch(p -> GeneratorPathUtil.anyMatch(p, conditionalPaths)) && additionalTest.test(handler.getXmlPathsToHere())) {
            setter.accept(handler);
        }
    }

    protected <A> void useConditionalCache(BasicParseHandler<A> handler, Path path, Map<Path, A> values) {
        handler.setParentSetter(v -> values.put(path, v));
        handler.setParentSupplier(() -> Optional.ofNullable(values.get(path)));
    }

    protected boolean areEqual(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    protected boolean areEqual(String a, Boolean b) {
        if (a == null) {
            return b == null;
        }
        return Boolean.valueOf(a).equals(b);
    }

    protected boolean areEqual(Boolean b, String a) {
        return this.areEqual(a, b);
    }

    protected boolean areEqual(String a, Integer b) {
        if (a == null) {
            return b == null;
        }
        return Integer.valueOf(a).equals(b);
    }

    protected boolean areEqual(Integer b, String a) {
        return this.areEqual(a, b);
    }

    protected int getMappingListIndex(Collection<?> listAttribute, List<MergeSynonymValue> mergeSynonyms) {
        if (!mergeSynonyms.isEmpty()) {
            List excludedPathElements = mergeSynonyms.stream().map(MergeSynonymValue::getExcludePath).collect(Collectors.toList());
            boolean excludedPath = this.getXmlPathsToHere().stream().flatMap(synPath -> synPath.getElements().stream()).map(Path.PathElement::getPathName).anyMatch(pathElementName -> excludedPathElements.contains(pathElementName));
            return Math.max(0, this.sizeOf(listAttribute) - (excludedPath ? 0 : 1));
        }
        return this.sizeOf(listAttribute);
    }

    protected String getSynonymPathForConditionFunc(Set<Path> synonymPaths, String synonymValue) {
        Iterator<Path> iterator = synonymPaths.iterator();
        Path lastPath = null;
        while (iterator.hasNext()) {
            lastPath = iterator.next();
        }
        if (lastPath != null) {
            Path fullPath = lastPath.append(Path.parse((String)synonymValue));
            return this.formatPathWithNoIndexesAndSeparators(fullPath);
        }
        return "";
    }

    protected String formatPathWithNoIndexesAndSeparators(Path path) {
        return path.getElements().stream().map(e -> e.getPathName()).collect(Collectors.joining("->"));
    }

    protected String getValueFromConditionPath(String ... conditionPathEndsWith) {
        return Optional.ofNullable(this.getValuesFromConditionPath(conditionPathEndsWith)).flatMap(values -> values.stream().findFirst()).orElse(null);
    }

    protected List<String> getValuesFromConditionPath(String ... conditionPathEndsWith) {
        if (conditionPathEndsWith == null || conditionPathEndsWith.length == 0) {
            return null;
        }
        String conditionPathEndsWithAsStr = Arrays.toString(conditionPathEndsWith);
        return this.conditionPathCache.computeIfAbsent(Arrays.toString(conditionPathEndsWith), key -> {
            List values = this.mappingContext.getMappings().stream().filter(m -> m.getXmlValue() != null).filter(m -> m.getXmlPath().endsWith(conditionPathEndsWith)).map(m -> m.getXmlValue()).map(o -> String.valueOf(o)).distinct().collect(Collectors.toList());
            LOGGER.debug("Condition-func path {} found values {}", (Object)conditionPathEndsWithAsStr, values);
            return values;
        });
    }

    public Injector getInjector() {
        return this.injector;
    }

    public MappingContext getMappingContext() {
        return this.mappingContext;
    }

    protected static class AnonHandler<T extends RosettaModelObjectBuilder>
    extends ROMParseHandler<T> {
        public AnonHandler(Injector injector, MappingContext mappingContext, Path rosettaPath, T underlying) {
            super(injector, mappingContext);
            this.rosettaPath = rosettaPath;
            this.setUnderlying(underlying);
        }
    }
}

