/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.ingest.test.framework.ingestor.synonym;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.regnosys.ingest.test.framework.ingestor.synonym.MappingResult;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class MappingReport {
    private final List<MappingResult> mappingResults;

    public MappingReport(List<MappingResult> mappingResults) {
        this.mappingResults = mappingResults;
    }

    @JsonProperty
    public boolean isSuccess() {
        return this.getSuccessCount() != 0L && this.getSuccessCount() == (long)this.getExternalPaths();
    }

    @JsonProperty
    public int getExternalPaths() {
        return this.mappingResults.stream().filter(result -> !result.isExcludedExternalPath()).collect(Collectors.toList()).size();
    }

    @JsonProperty
    public List<MappingResult> getMappingResults() {
        return this.mappingResults;
    }

    @JsonProperty
    public Set<MappingResult> getFailures() {
        return this.getMappingResults().stream().filter(mappingResult -> !mappingResult.isSuccess()).filter(failResult -> !failResult.isExcludedExternalPath()).collect(Collectors.toSet());
    }

    @JsonProperty
    public Set<MappingResult> getSuccesses() {
        return this.getMappingResults().stream().filter(MappingResult::isSuccess).filter(successResult -> !successResult.isExcludedExternalPath()).collect(Collectors.toSet());
    }

    @JsonProperty
    public List<String> getExcludedPaths() {
        return this.getMappingResults().stream().filter(MappingResult::isExcludedExternalPath).map(MappingResult::getExternalPathNoMeta).distinct().sorted().collect(Collectors.toList());
    }

    @JsonProperty
    public long getSuccessCount() {
        return this.getSuccesses().size();
    }

    @JsonProperty
    public double getCompleteness() {
        return (double)this.getSuccessCount() / (double)this.getExternalPaths() * 100.0;
    }

    public String toString() {
        return "MappingReport{mappingResults=" + this.mappingResults + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappingReport that = (MappingReport)o;
        return Objects.equals(this.mappingResults, that.mappingResults);
    }

    public int hashCode() {
        return Objects.hash(this.mappingResults);
    }
}

