/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.codec.AckMsg;
import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CloseMsg;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.codec.PostMsg;
import com.refinitiv.eta.codec.RequestMsg;
import com.refinitiv.eta.codec.State;
import com.refinitiv.eta.transport.TransportBuffer;
import com.refinitiv.eta.valueadd.common.VaNode;
import com.refinitiv.eta.valueadd.reactor.Reactor;
import com.refinitiv.eta.valueadd.reactor.ReactorChannel;
import com.refinitiv.eta.valueadd.reactor.ReactorErrorInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorFactory;
import com.refinitiv.eta.valueadd.reactor.ReactorSubmitOptions;
import com.refinitiv.eta.valueadd.reactor.ReactorWarmStandbyHandler;
import com.refinitiv.eta.valueadd.reactor.Watchlist;
import com.refinitiv.eta.valueadd.reactor.WlHandler;
import com.refinitiv.eta.valueadd.reactor.WlInteger;
import com.refinitiv.eta.valueadd.reactor.WlItemAggregationKey;
import com.refinitiv.eta.valueadd.reactor.WlItemGroup;
import com.refinitiv.eta.valueadd.reactor.WlPostTimeoutInfo;
import com.refinitiv.eta.valueadd.reactor.WlRequest;
import com.refinitiv.eta.valueadd.reactor.WlService;
import com.refinitiv.eta.valueadd.reactor.WlView;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;

class WlStream
extends VaNode {
    Watchlist _watchlist;
    WlHandler _handler;
    ReactorChannel _reactorChannel;
    Reactor _reactor;
    int _streamId;
    int _domainType;
    boolean _requestPending;
    WlItemAggregationKey _itemAggregationKey;
    WlService _wlService;
    WlItemGroup _itemGroup;
    long _requestExpireTime;
    RequestMsg _requestMsg;
    int _refreshState;
    LinkedList<WlRequest> _waitingRequestList = new LinkedList();
    LinkedList<WlRequest> _userRequestList = new LinkedList();
    LinkedList<Msg> _msgPool = new LinkedList();
    State _state = CodecFactory.createState();
    ReactorSubmitOptions _submitOptions = ReactorFactory.createReactorSubmitOptions();
    HashMap<Long, HashMap<Long, PostMsg>> _postIdToMsgTable = new HashMap();
    LinkedList<HashMap<Long, PostMsg>> _postMsgHashMapPool = new LinkedList();
    LinkedList<PostMsg> _postMsgPool = new LinkedList();
    LinkedList<WlPostTimeoutInfo> _postTimeoutInfoList = new LinkedList();
    AckMsg _ackMsg;
    CloseMsg _closeMsg;
    WlInteger _tableKey;
    WlInteger _groupTableKey;
    int _requestsPausedCount;
    boolean _paused;
    WlView _aggregateView;
    int _requestsWithViewCount;
    boolean _pendingViewChange;
    boolean _viewSubsetContained;
    Buffer _viewBuffer = CodecFactory.createBuffer();
    ByteBuffer _viewByteBuffer = ByteBuffer.allocateDirect(2048);
    boolean _addedToTimeOutList;

    WlStream() {
        this._ackMsg = (AckMsg)CodecFactory.createMsg();
        this._ackMsg.msgClass(6);
        this._closeMsg = (CloseMsg)CodecFactory.createMsg();
        this._closeMsg.msgClass(5);
        this._addedToTimeOutList = false;
    }

    State state() {
        return this._state;
    }

    WlHandler handler() {
        return this._handler;
    }

    void handler(WlHandler handler) {
        this._handler = handler;
    }

    void watchlist(Watchlist watchlist) {
        this._watchlist = watchlist;
        this._reactorChannel = this._watchlist.reactorChannel();
        this._reactor = this._watchlist.reactor();
    }

    int streamId() {
        return this._streamId;
    }

    void streamId(int streamId) {
        this._streamId = streamId;
    }

    int domainType() {
        return this._domainType;
    }

    void domainType(int domainType) {
        this._domainType = domainType;
    }

    RequestMsg requestMsg() {
        return this._requestMsg;
    }

    int requestMsg(RequestMsg requestMsg) {
        if (this._requestMsg != null) {
            this._requestMsg.clear();
        } else {
            this._requestMsg = (RequestMsg)CodecFactory.createMsg();
        }
        this._requestMsg.msgClass(1);
        return requestMsg.copy((Msg)this._requestMsg, 4095);
    }

    int refreshState() {
        return this._refreshState;
    }

    void refreshState(int refreshState) {
        this._refreshState = refreshState;
    }

    WlService wlService() {
        return this._wlService;
    }

    void wlService(WlService wlService) {
        this._wlService = wlService;
    }

    WlItemGroup itemGroup() {
        return this._itemGroup;
    }

    void itemGroup(WlItemGroup itemGroup) {
        this._itemGroup = itemGroup;
    }

    LinkedList<WlRequest> waitingRequestList() {
        return this._waitingRequestList;
    }

    LinkedList<WlRequest> userRequestList() {
        return this._userRequestList;
    }

    WlItemAggregationKey itemAggregationKey() {
        return this._itemAggregationKey;
    }

    void itemAggregationKey(WlItemAggregationKey itemAggregationKey) {
        this._itemAggregationKey = itemAggregationKey;
    }

    void channelDown() {
        this._refreshState = 0;
        this._requestPending = false;
    }

    void responseReceived() {
        this._requestPending = false;
    }

    public int timeout(ReactorErrorInfo errorInfo) {
        int ret = 0;
        if (this._state.streamState() == 4) {
            return ret;
        }
        long currentTime = System.nanoTime();
        if (this._requestExpireTime <= currentTime && this._requestPending && this.isChannelUp()) {
            this._closeMsg.streamId(this._streamId);
            this._closeMsg.domainType(this._domainType);
            ret = this.sendCloseMsg((Msg)this._closeMsg, errorInfo);
            if (ret >= 0) {
                this._requestPending = false;
                ret = this._handler.requestTimeout(this, errorInfo);
            }
        }
        if (ret == -9 || ret == -4) {
            ret = 0;
        }
        if (ret == -1 && this._reactorChannel.channel().state() != 2) {
            ret = 0;
        }
        if (this._postTimeoutInfoList.size() > 0) {
            while (this._postTimeoutInfoList.peek() != null && this._postTimeoutInfoList.peek().timeout() <= currentTime) {
                long seqNum;
                PostMsg postMsg;
                WlPostTimeoutInfo postTimeoutInfo = this._postTimeoutInfoList.poll();
                HashMap<Long, PostMsg> postSeqNumToMsgTable = this._postIdToMsgTable.get(postTimeoutInfo.postMsg().postId());
                if (postSeqNumToMsgTable != null && (postMsg = postSeqNumToMsgTable.get(seqNum = postTimeoutInfo.postMsg().checkHasSeqNum() ? postTimeoutInfo.postMsg().seqNum() : 0L)) != null) {
                    if (postTimeoutInfo.postMsg().checkAck()) {
                        ret = this.sendNak(postTimeoutInfo.postMsg(), errorInfo);
                    }
                    this._watchlist.numOutstandingPosts(this._watchlist.numOutstandingPosts() - 1);
                    this._postMsgPool.add(postSeqNumToMsgTable.remove(postMsg.seqNum()));
                    if (postSeqNumToMsgTable.size() == 0) {
                        this._postMsgHashMapPool.add(this._postIdToMsgTable.remove(postTimeoutInfo.postMsg().postId()));
                    }
                }
                postTimeoutInfo.returnToPool();
            }
        }
        return ret;
    }

    int sendMsgOnLoop(Msg msg, ReactorSubmitOptions submitOptions, ReactorErrorInfo errorInfo, boolean fromPendingMsg) {
        int ret = this.sendMsg(msg, submitOptions, errorInfo, fromPendingMsg);
        return ret;
    }

    int sendMsg(Msg msg, ReactorSubmitOptions submitOptions, ReactorErrorInfo errorInfo) {
        return this.sendMsg(msg, submitOptions, errorInfo, false);
    }

    int sendMsgOnLoop(Msg msg, ReactorSubmitOptions submitOptions, ReactorErrorInfo errorInfo) {
        int ret = this.sendMsg(msg, submitOptions, errorInfo, false);
        return ret;
    }

    int sendMsgOutOfLoop(Msg msg, ReactorSubmitOptions submitOptions, ReactorErrorInfo errorInfo) {
        int ret = this.sendMsg(msg, submitOptions, errorInfo, false);
        if (ret == -3) {
            errorInfo.clear();
            ret = 0;
        }
        return ret;
    }

    int sendMsg(Msg msg, ReactorSubmitOptions submitOptions, ReactorErrorInfo errorInfo, boolean fromPendingMsg) {
        int ret = 0;
        if (msg.msgClass() == 1) {
            if (this._requestsWithViewCount > 0 && this._requestsWithViewCount == this._userRequestList.size() && this._watchlist._loginHandler._loginRefresh.features().checkHasSupportViewRequests() && this._watchlist._loginHandler._loginRefresh.features().supportViewRequests() == 1L) {
                if (this._pendingViewChange && this._refreshState != 2) {
                    this._viewSubsetContained = false;
                    if (this._aggregateView.viewHandler().aggregateViewContainsNewViews(this._aggregateView)) {
                        this._viewSubsetContained = true;
                    }
                    this._aggregateView.viewHandler().aggregateViewMerge(this._aggregateView);
                    msg.flags(msg.flags() | 0x400);
                    this._viewByteBuffer.clear();
                    this._viewBuffer.data(this._viewByteBuffer);
                    this._watchlist._streamEncodeIterator.clear();
                    this._watchlist._streamEncodeIterator.setBufferAndRWFVersion(this._viewBuffer, this._reactorChannel.majorVersion(), this._reactorChannel.minorVersion());
                    this._aggregateView.viewHandler().encodeViewRequest(this._watchlist._streamEncodeIterator, this._aggregateView);
                    msg.containerType(133);
                    msg.encodedDataBody(this._viewBuffer);
                } else {
                    this.handler().addPendingRequest(null);
                    if (!fromPendingMsg) {
                        return 0;
                    }
                }
            } else {
                this.removeViewFromMsg(msg);
            }
        }
        if (this.isChannelUp()) {
            if (msg.msgClass() != 5) {
                ReactorWarmStandbyHandler wsbHandler;
                if (msg.domainType() != 1 && msg.msgClass() == 1 && this._userRequestList.size() > 0) {
                    if (this._requestsPausedCount == this._userRequestList.size() && this._watchlist._loginHandler._loginRefresh.checkHasFeatures() && this._watchlist._loginHandler._loginRefresh.features().checkHasSupportOptimizedPauseResume() && this._watchlist._loginHandler._loginRefresh.features().supportOptimizedPauseResume() == 1L) {
                        ((RequestMsg)msg).applyPause();
                        this._paused = true;
                    } else if (this._paused) {
                        ((RequestMsg)msg).flags(((RequestMsg)msg).flags() & 0xFFFFFDFF);
                        this._paused = false;
                    }
                }
                if (msg.msgClass() == 1 && msg.domainType() != 1 && msg.domainType() != 5 && msg.domainType() != 4 && this._watchlist.reactor().reactorHandlesWarmStandby(this._watchlist.reactorChannel()) && (wsbHandler = this._watchlist.reactorChannel().warmStandByHandlerImpl).currentWarmStandbyGroupImpl().warmStandbyMode() == 1) {
                    if (wsbHandler.activeReactorChannel() == null) {
                        if (msg != this.requestMsg()) {
                            this.requestMsg((RequestMsg)msg);
                        }
                        this.handler().addPendingRequest(this);
                        return 0;
                    }
                    if (!this._watchlist.reactorChannel().isActiveServer) {
                        this._watchlist._tempWlInteger.value(msg.msgKey().serviceId());
                        WlService wlService = wsbHandler.activeReactorChannel().watchlist()._directoryHandler._serviceCache._servicesByIdTable.get(this._watchlist._tempWlInteger);
                        if (wlService != null) {
                            if (wlService.rdmService().state().serviceState() == 0L || wlService.rdmService().state().acceptingRequests() == 0L) {
                                if (msg != this.requestMsg()) {
                                    this.requestMsg((RequestMsg)msg);
                                }
                                this.handler().addPendingRequest(this);
                                return 0;
                            }
                        } else {
                            if (msg != this.requestMsg()) {
                                this.requestMsg((RequestMsg)msg);
                            }
                            this.handler().addPendingRequest(this);
                            return 0;
                        }
                    }
                }
                if ((ret = this.encodeIntoBufferAndWrite(msg, submitOptions, errorInfo)) >= 0) {
                    if (msg.msgClass() == 1) {
                        if (msg != this._requestMsg && (ret = this.requestMsg((RequestMsg)msg)) < 0) {
                            return ret;
                        }
                        if (!this._requestPending && !((RequestMsg)msg).checkNoRefresh() && this.startRequestTimer(errorInfo) != 0) {
                            return -1;
                        }
                        if (this._pendingViewChange) {
                            this._pendingViewChange = false;
                            if (!((RequestMsg)msg).checkNoRefresh() && !this._viewSubsetContained) {
                                this._refreshState = 2;
                            }
                            if (this._aggregateView != null && (msg.flags() & 0x400) > 0) {
                                this._aggregateView.viewHandler().aggregateViewCommit(this._aggregateView);
                            }
                            if (this._aggregateView != null && this._requestsWithViewCount == 0) {
                                this._aggregateView.viewHandler().aggregateViewDestroy(this._aggregateView);
                                this._aggregateView = null;
                            }
                        }
                    }
                } else if (msg.msgClass() != 8) {
                    if (msg.msgClass() == 1) {
                        if (msg != this.requestMsg()) {
                            this.requestMsg((RequestMsg)msg);
                        }
                        this.handler().addPendingRequest(this);
                    }
                    return ret;
                }
            } else {
                ret = this.sendCloseMsg(msg, errorInfo);
            }
        } else {
            return 0;
        }
        return ret;
    }

    private void removeViewFromMsg(Msg msg) {
        if ((msg.flags() & 0x400) != 0) {
            msg.flags(msg.flags() & 0xFFFFFBFF);
            this._viewBuffer.clear();
            msg.encodedDataBody(this._viewBuffer);
            msg.containerType(128);
            if (this._aggregateView != null && this._aggregateView.viewHandler() != null) {
                this._aggregateView.viewHandler().aggregateViewUncommit(this._aggregateView);
            }
            this._pendingViewChange = true;
            this._viewSubsetContained = false;
        }
    }

    int updatePostTables(PostMsg postMsg, ReactorErrorInfo errorInfo) {
        PostMsg postMsgCopy = this._postMsgPool.poll();
        if (postMsgCopy == null) {
            postMsgCopy = (PostMsg)CodecFactory.createMsg();
        }
        postMsgCopy.clear();
        postMsgCopy.msgClass(8);
        postMsg.copy((Msg)postMsgCopy, 4095);
        HashMap<Long, PostMsg> postSeqNumToMsgTable = this._postIdToMsgTable.get(postMsg.postId());
        if (postSeqNumToMsgTable == null) {
            HashMap<Long, Object> postMsgHashMap = this._postMsgHashMapPool.poll();
            if (postMsgHashMap == null) {
                postMsgHashMap = new HashMap();
            }
            postSeqNumToMsgTable = postMsgHashMap;
            this._postIdToMsgTable.put(postMsg.postId(), postSeqNumToMsgTable);
        }
        long seqNum = postMsg.checkHasSeqNum() ? postMsg.seqNum() : 0L;
        postSeqNumToMsgTable.put(seqNum, postMsgCopy);
        long postExpireTime = (long)this._watchlist.watchlistOptions().postAckTimeout() * 1000000L + System.nanoTime();
        if (this._watchlist.startWatchlistTimer(postExpireTime, this, errorInfo) != 0) {
            return -1;
        }
        WlPostTimeoutInfo postTimeoutInfo = ReactorFactory.createWlPostTimeoutInfo();
        postTimeoutInfo.timeout(postExpireTime);
        postTimeoutInfo.postMsg(postMsg);
        this._postTimeoutInfoList.add(postTimeoutInfo);
        return 0;
    }

    int validatePostSubmit(PostMsg postMsg, ReactorErrorInfo errorInfo) {
        if (this._domainType != 1 || postMsg.checkHasMsgKey()) {
            if (postMsg.domainType() == 1 || postMsg.domainType() == 4 || postMsg.domainType() == 5) {
                return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlStream.submitMsg", "Cannot submit PostMsg with administrative domain type.");
            }
            if (postMsg.checkAck()) {
                if (!postMsg.checkHasPostId()) {
                    return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlStream.submitMsg", "Cannot submit PostMsg requiring ack with no post id.");
                }
                if (!postMsg.checkPostComplete() && !postMsg.checkHasSeqNum()) {
                    return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlStream.submitMsg", "Cannot submit multi-part PostMsg with no sequence number.");
                }
                HashMap<Long, PostMsg> postSeqNumToMsgTable = this._postIdToMsgTable.get(postMsg.postId());
                if (postSeqNumToMsgTable != null) {
                    if (postMsg.checkHasSeqNum()) {
                        if (postSeqNumToMsgTable.containsKey(postMsg.seqNum())) {
                            return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlStream.handlePostSubmit", "Cannot submit multi-part PostMsg with duplicate sequence number " + postMsg.seqNum() + ", postId = " + postMsg.postId());
                        }
                    } else if (!postMsg.checkHasSeqNum()) {
                        return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlStream.handlePostSubmit", "Cannot submit PostMsg with duplicate postId of " + postMsg.postId());
                    }
                }
            }
        } else {
            return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlStream.submitMsg", "Cannot submit PostMsg with no MsgKey.");
        }
        return 0;
    }

    boolean handlePostAck(Msg msg) {
        boolean ret = false;
        HashMap<Long, PostMsg> postSeqNumToMsgTable = this._postIdToMsgTable.get(((AckMsg)msg).ackId());
        if (postSeqNumToMsgTable != null) {
            this._watchlist.numOutstandingPosts(this._watchlist.numOutstandingPosts() - 1);
            long seqNum = ((AckMsg)msg).checkHasSeqNum() ? ((AckMsg)msg).seqNum() : 0L;
            PostMsg postMsg = postSeqNumToMsgTable.get(seqNum);
            if (postMsg != null) {
                this._postMsgPool.add(postSeqNumToMsgTable.remove(postMsg.seqNum()));
                if (postSeqNumToMsgTable.size() == 0) {
                    this._postMsgHashMapPool.add(this._postIdToMsgTable.remove(((AckMsg)msg).ackId()));
                }
                msg.streamId(postMsg.streamId());
                ret = true;
            }
        }
        return ret;
    }

    int sendNak(PostMsg postMsg, ReactorErrorInfo errorInfo) {
        this._ackMsg.streamId(postMsg.streamId());
        this._ackMsg.domainType(postMsg.domainType());
        this._ackMsg.containerType(128);
        this._ackMsg.flags(0);
        this._ackMsg.applyHasNakCode();
        this._ackMsg.nakCode(6);
        this._ackMsg.applyHasText();
        this._ackMsg.text().data("No Ack received for PostMsg with postId = " + postMsg.postId());
        this._ackMsg.ackId(postMsg.postId());
        this._ackMsg.seqNum(postMsg.seqNum());
        if (postMsg.checkHasMsgKey()) {
            if (postMsg.msgKey().checkHasName()) {
                this._ackMsg.applyHasMsgKey();
                this._ackMsg.msgKey().applyHasName();
                this._ackMsg.msgKey().name(postMsg.msgKey().name());
            }
            if (postMsg.msgKey().checkHasServiceId()) {
                this._ackMsg.applyHasMsgKey();
                this._ackMsg.msgKey().applyHasServiceId();
                this._ackMsg.msgKey().serviceId(postMsg.msgKey().serviceId());
            }
        }
        if (postMsg.checkHasSeqNum()) {
            this._ackMsg.applyHasSeqNum();
        }
        WlInteger tempWlInteger = ReactorFactory.createWlInteger();
        tempWlInteger.value(this._ackMsg.streamId());
        return this._watchlist.itemHandler().callbackUser("WlStream.sendNak", (Msg)this._ackMsg, null, this._watchlist.streamIdtoWlRequestTable().get(tempWlInteger), errorInfo);
    }

    int encodeIntoBufferAndWrite(Msg msg, ReactorSubmitOptions submitOptions, ReactorErrorInfo errorInfo) {
        int ret;
        block11: {
            block10: {
                ret = 0;
                if (this._watchlist._reactorChannelInfo.channelInfo().maxFragmentSize() == 0 && (ret = this._reactorChannel.info(this._watchlist._reactorChannelInfo, errorInfo)) < 0) {
                    if (ret == -1 && this._reactorChannel.channel().state() != 2) {
                        return 0;
                    }
                    return ret;
                }
                TransportBuffer buffer = this._reactorChannel.getBuffer(this._watchlist._reactorChannelInfo.channelInfo().maxFragmentSize(), false, errorInfo);
                if (buffer == null) break block10;
                this._watchlist._streamEncodeIterator.clear();
                this._watchlist._streamEncodeIterator.setBufferAndRWFVersion(buffer, this._reactorChannel.majorVersion(), this._reactorChannel.minorVersion());
                ret = msg.encode(this._watchlist._streamEncodeIterator);
                if (ret < 0) {
                    return ret;
                }
                ret = this._reactor.submitChannel(this._reactorChannel, buffer, submitOptions, errorInfo);
                switch (ret) {
                    case -9: 
                    case 0: {
                        break;
                    }
                    case -10: {
                        while (ret == -10) {
                            ret = this._reactor.submitChannel(this._reactorChannel, buffer, submitOptions, errorInfo);
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        break block11;
                    }
                    default: {
                        this._reactorChannel.releaseBuffer(buffer, errorInfo);
                        break;
                    }
                }
                break block11;
            }
            return this._reactor.populateErrorInfo(errorInfo, -3, "Watchlist.encodeIntoBufferAndQueue", "channel out of buffers errorId=" + errorInfo.error().errorId() + " errorText=" + errorInfo.error().text());
        }
        return ret;
    }

    int sendCloseMsg(Msg msg, ReactorErrorInfo errorInfo) {
        int ret = 0;
        do {
            if ((ret = this.encodeIntoBufferAndWrite(msg, this._submitOptions, errorInfo)) != -3 && ret != -9) continue;
            this._watchlist._reactorChnlInfo.clear();
            int ret2 = this._reactorChannel.info(this._watchlist._reactorChnlInfo, errorInfo);
            if (ret2 >= 0) {
                int newNumberOfBuffers = this._watchlist._reactorChnlInfo.channelInfo().guaranteedOutputBuffers() + 2;
                ret2 = this._reactorChannel.ioctl(2, newNumberOfBuffers, errorInfo);
                if (ret2 >= 0) continue;
                return ret2;
            }
            return ret2;
        } while (ret == -3 || ret == -9);
        if (ret == 0) {
            errorInfo.clear();
        }
        return ret;
    }

    void close() {
        assert (!this.inPool());
        this._state.clear();
        this._state.streamState(4);
        this._state.dataState(2);
        if (this._tableKey != null) {
            this._watchlist.streamIdtoWlStreamTable().remove(this._tableKey);
            this._tableKey.returnToPool();
            this._tableKey = null;
        }
        this._requestsPausedCount = 0;
        this._paused = false;
    }

    boolean isChannelUp() {
        return this._reactorChannel.state() == ReactorChannel.State.UP || this._reactorChannel.state() == ReactorChannel.State.READY;
    }

    int startRequestTimer(ReactorErrorInfo errorInfo) {
        int ret = 0;
        this._requestPending = true;
        if (this._watchlist.watchlistOptions().requestTimeout() > 0) {
            this._requestExpireTime = (long)this._watchlist.watchlistOptions().requestTimeout() * 1000000L + System.nanoTime();
            ret = this._watchlist.startWatchlistTimer(this._requestExpireTime, this, errorInfo);
        }
        return ret;
    }

    void tableKey(WlInteger tableKey) {
        this._tableKey = tableKey;
    }

    WlInteger tableKey() {
        return this._tableKey;
    }

    void groupTableKey(WlInteger groupTableKey) {
        this._groupTableKey = groupTableKey;
    }

    WlInteger groupTableKey() {
        return this._groupTableKey;
    }

    boolean requestPending() {
        return this._requestPending;
    }

    int numPausedRequestsCount() {
        return this._requestsPausedCount;
    }

    void numPausedRequestsCount(int numPausedRequestCount) {
        this._requestsPausedCount = numPausedRequestCount;
    }

    void clear() {
        this._streamId = 0;
        this._domainType = 0;
        this._state.clear();
        this._refreshState = 0;
        this._requestPending = false;
        this._handler = null;
        this._ackMsg.clear();
        this._ackMsg.msgClass(6);
        this._closeMsg.clear();
        this._closeMsg.msgClass(5);
        this._requestsPausedCount = 0;
        this._paused = false;
        this._requestMsg = null;
        this._itemAggregationKey = null;
        this._requestExpireTime = 0L;
        this._submitOptions.clear();
        this._itemGroup = null;
        this._tableKey = null;
        this._groupTableKey = null;
        this._wlService = null;
        WlPostTimeoutInfo postTimeoutInfo = null;
        while ((postTimeoutInfo = this._postTimeoutInfoList.poll()) != null) {
            postTimeoutInfo.returnToPool();
        }
        this._postTimeoutInfoList.clear();
        for (HashMap<Long, PostMsg> postMsgHashMap : this._postIdToMsgTable.values()) {
            for (PostMsg postMsg : postMsgHashMap.values()) {
                this._postMsgPool.add(postMsg);
            }
            postMsgHashMap.clear();
            this._postMsgHashMapPool.add(postMsgHashMap);
        }
        this._postIdToMsgTable.clear();
        this._waitingRequestList.clear();
        this._userRequestList.clear();
        if (this._aggregateView != null) {
            this._aggregateView.clear();
            this._aggregateView.returnToPool();
            this._aggregateView = null;
        }
        this._requestsWithViewCount = 0;
        this._reactorChannel = null;
        this._reactor = null;
        this._addedToTimeOutList = false;
    }

    WlView aggregateView() {
        return this._aggregateView;
    }

    public void aggregateView(WlView aggregateView) {
        this._aggregateView = aggregateView;
    }

    @Override
    public void returnToPool() {
        assert (!this.inPool());
        WlPostTimeoutInfo postTimeoutInfo = null;
        while ((postTimeoutInfo = this._postTimeoutInfoList.poll()) != null) {
            postTimeoutInfo.returnToPool();
        }
        this._postTimeoutInfoList.clear();
        if (this._aggregateView != null) {
            this._aggregateView.clear();
            this._aggregateView.returnToPool();
            this._aggregateView = null;
        }
        if (this._addedToTimeOutList) {
            this._addedToTimeOutList = false;
            this._watchlist._streamTimeoutInfoList.remove(this);
        }
        this._handler = null;
        this._requestMsg = null;
        this._itemAggregationKey = null;
        this._reactorChannel = null;
        this._reactor = null;
        this._itemGroup = null;
        this._tableKey = null;
        this._groupTableKey = null;
        this._wlService = null;
        super.returnToPool();
    }

    class RefreshStates {
        static final int REFRESH_NOT_REQUIRED = 0;
        static final int REFRESH_PENDING = 1;
        static final int REFRESH_VIEW_PENDING = 2;
        static final int REFRESH_COMPLETE_PENDING = 3;

        RefreshStates() {
        }
    }
}

