/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.valueadd.common.VaDoubleLinkList;
import com.refinitiv.eta.valueadd.reactor.ReactorErrorInfo;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamBigBuffer;

public class TunnelStreamBigBufferPool {
    final int NUM_POOLS = 32;
    VaDoubleLinkList<TunnelStreamBigBuffer>[] _pools = new VaDoubleLinkList[32];
    int _maxSize;
    int _maxPool;
    int _fragmentSize;
    int _maxNumBuffers;
    int _currentNumBuffers;

    TunnelStreamBigBufferPool(int fragmentSize, int numBuffers) {
        this._fragmentSize = fragmentSize;
        this._maxSize = fragmentSize * 2;
        this._maxNumBuffers = numBuffers;
    }

    TunnelStreamBigBuffer getBuffer(int size, ReactorErrorInfo errorInfo) {
        TunnelStreamBigBuffer buffer = null;
        if (this._currentNumBuffers < this._maxNumBuffers) {
            ++this._currentNumBuffers;
            int poolSize = this._fragmentSize * 2;
            int poolIndex = 0;
            while (size > poolSize) {
                poolSize *= 2;
                ++poolIndex;
            }
            if (poolSize > this._maxSize) {
                this._maxSize = poolSize;
                this._maxPool = poolIndex;
                VaDoubleLinkList<TunnelStreamBigBuffer> pool = new VaDoubleLinkList<TunnelStreamBigBuffer>();
                this._pools[poolIndex] = pool;
                return new TunnelStreamBigBuffer(pool, poolSize, size);
            }
            for (int i = poolIndex; i <= this._maxPool; ++i) {
                if (this._pools[i] == null || (buffer = this._pools[i].pop(TunnelStreamBigBuffer.BIG_BUFFER_LINK)) == null) continue;
                buffer.clear(size);
                return buffer;
            }
            if (this._pools[poolIndex] == null) {
                VaDoubleLinkList pool = new VaDoubleLinkList();
                this._pools[poolIndex] = pool;
            }
            return new TunnelStreamBigBuffer(this._pools[poolIndex], poolSize, size);
        }
        errorInfo.clear();
        errorInfo.code(-1).location("TunnelStreamBigBufferPool.getBuffer");
        errorInfo.error().errorId(-1);
        errorInfo.error().text("Max number of big buffers limit reached");
        return buffer;
    }

    void releaseBuffer(TunnelStreamBigBuffer buffer) {
        --this._currentNumBuffers;
        buffer.pool().pushBack(buffer, TunnelStreamBigBuffer.BIG_BUFFER_LINK);
    }

    int getBuffersUsed() {
        return this._currentNumBuffers;
    }
}

