/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.valueadd.reactor.ReactorAuthTokenInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorErrorInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorServiceEndpointInfo;
import com.refinitiv.eta.valueadd.reactor.RestAuthOptions;
import com.refinitiv.eta.valueadd.reactor.RestConnectOptions;
import com.refinitiv.eta.valueadd.reactor.RestEvent;
import com.refinitiv.eta.valueadd.reactor.RestReactor;
import com.refinitiv.eta.valueadd.reactor.RestRequest;
import com.refinitiv.eta.valueadd.reactor.RestResponse;
import com.refinitiv.eta.valueadd.reactor.RestResultClosure;
import java.util.List;
import java.util.Objects;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RestHandler
implements FutureCallback<ClassicHttpResponse> {
    private RestResultClosure _resultClosure;
    private RestReactor _restReactor;
    private RestEvent _event;
    private RestResponse _response;
    private int _id = 0;
    private Logger loggerClient = null;
    private String _contentString = null;
    RestAuthOptions _authOptions = null;
    RestConnectOptions _restConnectOptions = null;
    ReactorAuthTokenInfo _authTokenInfo = null;
    ReactorErrorInfo _errorInfo = null;
    RestRequest _request = null;
    List<ReactorServiceEndpointInfo> _reactorServiceEndpointInfoList = null;
    SimpleHttpRequest _currentRequestAsync = null;

    RestHandler(RestReactor restReactor, RestResultClosure resultClosure) {
        this._resultClosure = resultClosure;
        this._restReactor = restReactor;
        this._event = new RestEvent(0, resultClosure);
        this._id = 0;
        this.loggerClient = LoggerFactory.getLogger(RestReactor.class);
    }

    RestHandler(RestReactor restReactor, RestAuthOptions authOptions, RestConnectOptions restConnectOptions, ReactorAuthTokenInfo authTokenInfo, ReactorErrorInfo errorInfo) {
        this._resultClosure = restConnectOptions.restResultClosure();
        this._restReactor = restReactor;
        this._event = new RestEvent(0, this._resultClosure);
        this._authOptions = authOptions;
        this._restConnectOptions = restConnectOptions;
        this._authTokenInfo = authTokenInfo;
        this._errorInfo = errorInfo;
        this._id = 1;
        this.loggerClient = LoggerFactory.getLogger(RestReactor.class);
    }

    RestHandler(RestReactor restReactor, RestRequest request, RestConnectOptions restConnectOptions, ReactorAuthTokenInfo authTokenInfo, List<ReactorServiceEndpointInfo> reactorServiceEndpointInfoList, ReactorErrorInfo errorInfo) {
        this._resultClosure = restConnectOptions.restResultClosure();
        this._restReactor = restReactor;
        this._event = new RestEvent(0, this._resultClosure);
        this._request = request;
        this._restConnectOptions = restConnectOptions;
        this._authTokenInfo = authTokenInfo;
        this._reactorServiceEndpointInfoList = reactorServiceEndpointInfoList;
        this._errorInfo = errorInfo;
        this._id = 2;
        this.loggerClient = LoggerFactory.getLogger(RestReactor.class);
    }

    public void completed(ClassicHttpResponse response) {
        if (this._currentRequestAsync != null && this.loggerClient.isTraceEnabled()) {
            this.loggerClient.trace(this._restReactor.prepareRequestString(this._currentRequestAsync, this._restConnectOptions));
        }
        this._event.clear();
        this._event.eventType(0);
        this._event.resultClosure(this._resultClosure);
        this._response = new RestResponse();
        HttpEntity entityFromResponse = response.getEntity();
        String contentString = this._contentString;
        Exception extractingContentException = null;
        if (Objects.isNull(contentString)) {
            try {
                contentString = EntityUtils.toString((HttpEntity)entityFromResponse);
            }
            catch (Exception e) {
                extractingContentException = e;
            }
        }
        if (this.loggerClient.isTraceEnabled()) {
            this.loggerClient.trace(this._restReactor.prepareResponseString(response, contentString, extractingContentException));
        }
        int statusCode = response.getCode();
        switch (statusCode) {
            case 200: {
                RestReactor.convertResponse(response, this._response, this._event.errorInfo(), contentString, extractingContentException);
                if (this._id == 1 && this._restConnectOptions.authRedirect()) {
                    this.clearAuthRedirectParameters();
                }
                if (this._id != 2 || !this._restConnectOptions.discoveryRedirect()) break;
                this.clearDiscoveryRedirectParameters();
                break;
            }
            case 301: 
            case 302: 
            case 307: 
            case 308: {
                String newHost;
                Header location = response.getFirstHeader("Location");
                if (location != null && (newHost = location.getValue()) != null && !newHost.isEmpty()) {
                    if (this._id == 1) {
                        if (!this._restConnectOptions.authRedirect()) {
                            this._restReactor.submitAuthRequest(this._authOptions, this._restConnectOptions, this._authTokenInfo, this._errorInfo, true, newHost);
                            if (statusCode == 301 || statusCode == 308) {
                                Buffer newUrl = CodecFactory.createBuffer();
                                newUrl.data(location.getValue());
                                if (this._authTokenInfo.tokenVersion() == ReactorAuthTokenInfo.TokenVersion.V1) {
                                    this._restConnectOptions.reactorOptions().tokenServiceURL_V1(newUrl);
                                } else {
                                    this._restConnectOptions.reactorOptions().tokenServiceURL_V2(newUrl);
                                }
                            }
                            return;
                        }
                        this.clearAuthRedirectParameters();
                    } else if (this._id == 2) {
                        if (!this._restConnectOptions.discoveryRedirect()) {
                            this._restReactor.submitRequestForServiceDiscovery(this._request, this._restConnectOptions, this._authTokenInfo, this._reactorServiceEndpointInfoList, this._errorInfo, true, newHost);
                            if (statusCode == 301 || statusCode == 308) {
                                Buffer newUrl = CodecFactory.createBuffer();
                                newUrl.data(location.getValue());
                                this._restConnectOptions.reactorOptions().serviceDiscoveryURL(newUrl);
                            }
                        } else {
                            this.clearDiscoveryRedirectParameters();
                        }
                        return;
                    }
                }
                RestReactor.convertResponse(response, this._response, this._event.errorInfo(), contentString, extractingContentException);
                this._event.eventType(1);
                if (this._id == 1 && this._restConnectOptions.authRedirect()) {
                    this.clearAuthRedirectParameters();
                }
                if (this._id != 2 || !this._restConnectOptions.discoveryRedirect()) break;
                this.clearDiscoveryRedirectParameters();
                break;
            }
            case 403: 
            case 404: 
            case 410: 
            case 451: {
                RestReactor.convertResponse(response, this._response, this._event.errorInfo(), contentString, extractingContentException);
                this._event.eventType(3);
                if (this._id == 1 && this._restConnectOptions.authRedirect()) {
                    this.clearAuthRedirectParameters();
                }
                if (this._id != 2 || !this._restConnectOptions.discoveryRedirect()) break;
                this.clearDiscoveryRedirectParameters();
                break;
            }
            default: {
                RestReactor.convertResponse(response, this._response, this._event.errorInfo(), contentString, extractingContentException);
                this._event.eventType(1);
                if (this._id == 1 && this._restConnectOptions.authRedirect()) {
                    this.clearAuthRedirectParameters();
                }
                if (this._id != 2 || !this._restConnectOptions.discoveryRedirect()) break;
                this.clearDiscoveryRedirectParameters();
            }
        }
        RestReactor.processResponse(this._restReactor, this._response, this._event);
    }

    public void clearAuthRedirectParameters() {
        this._restConnectOptions.authRedirect(false);
        this._restConnectOptions.authRedirectLocation(null);
    }

    public void clearDiscoveryRedirectParameters() {
        this._restConnectOptions.discoveryRedirect(false);
        this._restConnectOptions.discoveryRedirectLocation(null);
    }

    public void failed(Exception ex) {
        if (this._currentRequestAsync != null && this.loggerClient.isTraceEnabled()) {
            this.loggerClient.trace(this._restReactor.prepareRequestString(this._currentRequestAsync, this._restConnectOptions));
        }
        this._event.clear();
        this._event.eventType(1);
        this._event.resultClosure(this._resultClosure);
        this._resultClosure.restCallback().RestErrorCallback(this._event, ex.getLocalizedMessage());
        if (this.loggerClient.isTraceEnabled()) {
            this.loggerClient.trace("Failed to send HTTP request, exception = " + RestReactor.getExceptionCause(ex) + "\n");
        }
    }

    public void cancelled() {
        if (this._currentRequestAsync != null && this.loggerClient.isTraceEnabled()) {
            this.loggerClient.trace(this._restReactor.prepareRequestString(this._currentRequestAsync, this._restConnectOptions));
        }
        this._event.clear();
        this._event.eventType(2);
        this._event.resultClosure(this._resultClosure);
        RestReactor.populateErrorInfo(this._event.errorInfo(), -1, "RestHandler.cancelled", "Cancelled REST request.");
        this._resultClosure.restCallback().RestErrorCallback(this._event, this._event.errorInfo().error().text());
    }

    public String toString() {
        return (this._restReactor == null ? "_RestReactor null" : this._restReactor) + ", " + (this._resultClosure == null ? "_resultClosure null" : this._resultClosure) + ", " + (this._event == null ? "_event null" : this._event.toString()) + ", " + (this._response == null ? "_response null" : this._response.toString());
    }

    void contentString(String contentString) {
        this._contentString = contentString;
    }

    void setCurrentRequest(SimpleHttpRequest currentRequest) {
        this._currentRequestAsync = currentRequest;
    }
}

