/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.valueadd.reactor.ReactorDebuggerOptions;
import com.refinitiv.eta.valueadd.reactor.ReactorDebuggerOptionsImpl;
import com.refinitiv.eta.valueadd.reactor.ReactorRestProxyOptions;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import org.apache.hc.client5.http.utils.URIUtils;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.net.URIBuilder;

public class ReactorOptions {
    static final int DEFAULT_HTTPS_PORT = 443;
    static final int DEFAULT_HTTP_PORT = 80;
    static final String DEFAULT_SCHEME = "https";
    static final String API_GATEWAY_HOST = "api.refinitiv.com";
    static final String SERVICE_DISCOVERY_PATH = "/streaming/pricing/v1/";
    static final long DEFAULT_XML_TRACE_MAX_FILE_SIZE = 100000000L;
    private Buffer _serviceDiscoveryURL = CodecFactory.createBuffer();
    private Buffer _tokenServiceURL_V1 = CodecFactory.createBuffer();
    private Buffer _tokenServiceURL_V2 = CodecFactory.createBuffer();
    private Buffer _tempTokenURL = CodecFactory.createBuffer();
    private Buffer _tempDiscoveryURL = CodecFactory.createBuffer();
    private HttpHost _serviceDiscoveryHost;
    private int _restRequestTimeout;
    private double _tokenReissueRatio;
    private int _reissueTokenAttemptLimit;
    private int _reissueTokenAttemptInterval;
    private ReactorRestProxyOptions _restProxyOptions = new ReactorRestProxyOptions();
    private ReactorDebuggerOptions _debuggerOptions = new ReactorDebuggerOptionsImpl();
    Object _userSpecObj = null;
    boolean _xmlTracing = false;
    boolean _xmlTraceToFile = false;
    long _xmlTraceMaxFileSize = 100000000L;
    String _xmlTraceFileName;
    boolean _xmlTraceToMultipleFiles = false;
    boolean _xmlTraceWrite = false;
    boolean _xmlTraceRead = false;
    boolean _xmlTracePing = false;
    int _statistics = 0;

    ReactorOptions() {
        this.clear();
    }

    public int userSpecObj(Object userSpecObj) {
        if (userSpecObj == null) {
            return -5;
        }
        this._userSpecObj = userSpecObj;
        return 0;
    }

    public Object userSpecObj() {
        return this._userSpecObj;
    }

    public void enableXmlTracing() {
        this._xmlTracing = true;
    }

    public void enableXmlTraceToFile() {
        this._xmlTraceToFile = true;
    }

    public void setXmlTraceMaxFileSize(long size) {
        this._xmlTraceMaxFileSize = size;
    }

    public void setXmlTraceFileName(String fileName) {
        this._xmlTraceFileName = fileName;
    }

    public void enableXmlTraceToMultipleFiles() {
        this._xmlTraceToMultipleFiles = true;
    }

    public void enableXmlTraceWrite() {
        this._xmlTraceWrite = true;
    }

    public void enableXmlTraceRead() {
        this._xmlTraceRead = true;
    }

    public void enableXmlTracePing() {
        this._xmlTracePing = true;
    }

    public void xmlTraceWrite(boolean xmlTraceWrite) {
        this._xmlTraceWrite = xmlTraceWrite;
    }

    public void xmlTraceRead(boolean xmlTraceRead) {
        this._xmlTraceRead = xmlTraceRead;
    }

    public void xmlTracePing(boolean xmlTracePing) {
        this._xmlTracePing = xmlTracePing;
    }

    public int serviceDiscoveryURL(Buffer serviceDiscoveryURL) {
        if (serviceDiscoveryURL == null || serviceDiscoveryURL.length() == 0) {
            return -5;
        }
        try {
            URI uri = new URIBuilder(serviceDiscoveryURL.toString()).build();
            HttpHost serviceDiscoveryHost = URIUtils.extractHost((URI)uri);
            if (serviceDiscoveryHost == null) {
                return -5;
            }
            this._serviceDiscoveryHost = serviceDiscoveryHost;
            if (this._serviceDiscoveryHost.getPort() == -1) {
                this._serviceDiscoveryHost = this._serviceDiscoveryHost.getSchemeName().equals(DEFAULT_SCHEME) ? new HttpHost(this._serviceDiscoveryHost.getSchemeName(), this._serviceDiscoveryHost.getHostName(), 443) : new HttpHost(this._serviceDiscoveryHost.getSchemeName(), this._serviceDiscoveryHost.getHostName(), 80);
            }
        }
        catch (URISyntaxException e) {
            return -5;
        }
        return this._serviceDiscoveryURL.data(serviceDiscoveryURL.data(), serviceDiscoveryURL.position(), serviceDiscoveryURL.length());
    }

    public Buffer serviceDiscoveryURL() {
        return this._serviceDiscoveryURL;
    }

    public int tokenServiceURL(Buffer tokenServiceURL) {
        if (this._tokenServiceURL_V1 == null) {
            this._tokenServiceURL_V1 = CodecFactory.createBuffer();
        }
        return this._tokenServiceURL_V1.data(tokenServiceURL.data(), tokenServiceURL.position(), tokenServiceURL.length());
    }

    public int tokenServiceURL_V1(Buffer tokenServiceURL) {
        if (this._tokenServiceURL_V1 == null) {
            this._tokenServiceURL_V1 = CodecFactory.createBuffer();
        }
        return this._tokenServiceURL_V1.data(tokenServiceURL.data(), tokenServiceURL.position(), tokenServiceURL.length());
    }

    public int tokenServiceURL_V2(Buffer tokenServiceURL) {
        if (this._tokenServiceURL_V2 == null) {
            this._tokenServiceURL_V2 = CodecFactory.createBuffer();
        }
        return this._tokenServiceURL_V2.data(tokenServiceURL.data(), tokenServiceURL.position(), tokenServiceURL.length());
    }

    public void statistics(int statistics) {
        this._statistics = statistics;
    }

    public boolean readStatSet() {
        return (this._statistics & 1) != 0;
    }

    public boolean writeStatSet() {
        return (this._statistics & 2) != 0;
    }

    public boolean pingStatSet() {
        return (this._statistics & 4) != 0;
    }

    public Buffer tokenServiceURL() {
        return this._tokenServiceURL_V1;
    }

    public Buffer tokenServiceURL_V1() {
        return this._tokenServiceURL_V1;
    }

    public Buffer tokenServiceURL_V2() {
        return this._tokenServiceURL_V2;
    }

    public int restRequestTimeout() {
        return this._restRequestTimeout;
    }

    public void restRequestTimeout(int requestTimeout) {
        this._restRequestTimeout = requestTimeout;
    }

    public double tokenReissueRatio() {
        return this._tokenReissueRatio;
    }

    public void tokenReissueRatio(double tokenReissueRatio) {
        this._tokenReissueRatio = tokenReissueRatio;
    }

    public int reissueTokenAttemptLimit() {
        return this._reissueTokenAttemptLimit;
    }

    public void reissueTokenAttemptLimit(int reissueTokenAttempLimit) {
        this._reissueTokenAttemptLimit = reissueTokenAttempLimit;
    }

    public int reissueTokenAttemptInterval() {
        return this._reissueTokenAttemptInterval;
    }

    public void reissueTokenAttemptInterval(int reissueTokenAttemptInterval) {
        this._reissueTokenAttemptInterval = reissueTokenAttemptInterval;
    }

    boolean xmlTracing() {
        return this._xmlTracing;
    }

    boolean xmlTraceToFile() {
        return this._xmlTraceToFile;
    }

    long xmlTraceMaxFileSize() {
        return this._xmlTraceMaxFileSize;
    }

    String xmlTraceFileName() {
        return this._xmlTraceFileName;
    }

    boolean xmlTraceToMultipleFiles() {
        return this._xmlTraceToMultipleFiles;
    }

    boolean xmlTraceWrite() {
        return this._xmlTraceWrite;
    }

    boolean xmlTraceRead() {
        return this._xmlTraceRead;
    }

    boolean xmlTracePing() {
        return this._xmlTracePing;
    }

    public int statistics() {
        return this._statistics;
    }

    public void clear() {
        this._userSpecObj = null;
        this._xmlTracing = false;
        this._xmlTraceToFile = false;
        this._xmlTraceMaxFileSize = 100000000L;
        this._xmlTraceFileName = null;
        this._xmlTraceToMultipleFiles = false;
        this._xmlTraceRead = true;
        this._xmlTraceWrite = true;
        this._xmlTracePing = true;
        this._statistics = 0;
        this._serviceDiscoveryURL.data("https://api.refinitiv.com/streaming/pricing/v1/");
        this._serviceDiscoveryHost = new HttpHost(DEFAULT_SCHEME, API_GATEWAY_HOST, 443);
        this._restRequestTimeout = 45000;
        this._tokenReissueRatio = 0.8;
        this._reissueTokenAttemptLimit = -1;
        this._reissueTokenAttemptInterval = 5000;
        this._debuggerOptions.clear();
    }

    void copy(ReactorOptions options) {
        ByteBuffer byteBuffer;
        this._userSpecObj = options._userSpecObj;
        this._xmlTracing = options._xmlTracing;
        this._xmlTraceToFile = options._xmlTraceToFile;
        this._xmlTraceMaxFileSize = options._xmlTraceMaxFileSize;
        this._xmlTraceFileName = options._xmlTraceFileName;
        this._xmlTraceToMultipleFiles = options._xmlTraceToMultipleFiles;
        this._xmlTraceWrite = options._xmlTraceWrite;
        this._xmlTracePing = options._xmlTracePing;
        this._xmlTraceRead = options._xmlTraceRead;
        this._statistics = options._statistics;
        this._tokenReissueRatio = options._tokenReissueRatio;
        this._reissueTokenAttemptLimit = options._reissueTokenAttemptLimit < -1 ? -1 : options._reissueTokenAttemptLimit;
        this._reissueTokenAttemptInterval = options._reissueTokenAttemptInterval;
        this._restRequestTimeout = options._restRequestTimeout;
        if (options.serviceDiscoveryURL() != null) {
            byteBuffer = ByteBuffer.allocate(options._serviceDiscoveryURL.length());
            options._serviceDiscoveryURL.copy(byteBuffer);
            this._serviceDiscoveryURL.data(byteBuffer);
            this._serviceDiscoveryHost = new HttpHost(options.serviceDiscoveryHost().getSchemeName(), options.serviceDiscoveryHost().getHostName(), options.serviceDiscoveryHost().getPort());
        }
        if (options._tokenServiceURL_V1 != null) {
            byteBuffer = ByteBuffer.allocate(options._tokenServiceURL_V1.length());
            options._tokenServiceURL_V1.copy(byteBuffer);
            this._tokenServiceURL_V1.data(byteBuffer);
        }
        if (options._tokenServiceURL_V2 != null) {
            byteBuffer = ByteBuffer.allocate(options._tokenServiceURL_V2.length());
            options._tokenServiceURL_V2.copy(byteBuffer);
            this._tokenServiceURL_V2.data(byteBuffer);
        }
        if (options._restProxyOptions != null) {
            options._restProxyOptions.copy(this._restProxyOptions);
        }
        options._debuggerOptions.copy(this._debuggerOptions);
    }

    HttpHost serviceDiscoveryHost() {
        return this._serviceDiscoveryHost;
    }

    public ReactorDebuggerOptions debuggerOptions() {
        return this._debuggerOptions;
    }

    public void debuggerOptions(ReactorDebuggerOptions debuggerOptions) {
        if (debuggerOptions != null) {
            debuggerOptions.copy(this._debuggerOptions);
        }
    }

    public ReactorRestProxyOptions restProxyOptions() {
        return this._restProxyOptions;
    }

    public static class StatisticFlags {
        public static final int NONE = 0;
        public static final int READ = 1;
        public static final int WRITE = 2;
        public static final int PING = 4;

        private StatisticFlags() {
            throw new AssertionError();
        }
    }
}

