/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CloseMsg;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.CodecReturnCodes;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.codec.MsgKey;
import com.refinitiv.eta.codec.RefreshMsg;
import com.refinitiv.eta.codec.RequestMsg;
import com.refinitiv.eta.codec.State;
import com.refinitiv.eta.codec.StatusMsg;
import com.refinitiv.eta.codec.XmlTraceDump;
import com.refinitiv.eta.json.converter.ConversionResults;
import com.refinitiv.eta.json.converter.ConverterFactory;
import com.refinitiv.eta.json.converter.DecodeJsonMsgOptions;
import com.refinitiv.eta.json.converter.GetJsonErrorParams;
import com.refinitiv.eta.json.converter.GetJsonMsgOptions;
import com.refinitiv.eta.json.converter.JsonConverter;
import com.refinitiv.eta.json.converter.JsonConverterBuilder;
import com.refinitiv.eta.json.converter.JsonConverterError;
import com.refinitiv.eta.json.converter.JsonMsg;
import com.refinitiv.eta.json.converter.ParseJsonOptions;
import com.refinitiv.eta.json.converter.RWFToJsonOptions;
import com.refinitiv.eta.json.converter.ServiceNameIdConverter;
import com.refinitiv.eta.json.util.JsonFactory;
import com.refinitiv.eta.transport.Channel;
import com.refinitiv.eta.transport.ConnectOptions;
import com.refinitiv.eta.transport.ConnectionTypes;
import com.refinitiv.eta.transport.Error;
import com.refinitiv.eta.transport.InitArgs;
import com.refinitiv.eta.transport.ReadArgs;
import com.refinitiv.eta.transport.ReadArgsImpl;
import com.refinitiv.eta.transport.Server;
import com.refinitiv.eta.transport.Transport;
import com.refinitiv.eta.transport.TransportBuffer;
import com.refinitiv.eta.transport.TransportFactory;
import com.refinitiv.eta.transport.TransportReturnCodes;
import com.refinitiv.eta.transport.WriteArgs;
import com.refinitiv.eta.transport.WriteArgsImpl;
import com.refinitiv.eta.valueadd.common.SelectableBiDirectionalQueue;
import com.refinitiv.eta.valueadd.common.VaDoubleLinkList;
import com.refinitiv.eta.valueadd.common.VaNode;
import com.refinitiv.eta.valueadd.common.VaPool;
import com.refinitiv.eta.valueadd.common.VaQueue;
import com.refinitiv.eta.valueadd.domainrep.rdm.MsgBase;
import com.refinitiv.eta.valueadd.domainrep.rdm.dictionary.DictionaryClose;
import com.refinitiv.eta.valueadd.domainrep.rdm.dictionary.DictionaryMsg;
import com.refinitiv.eta.valueadd.domainrep.rdm.dictionary.DictionaryMsgFactory;
import com.refinitiv.eta.valueadd.domainrep.rdm.dictionary.DictionaryMsgType;
import com.refinitiv.eta.valueadd.domainrep.rdm.dictionary.DictionaryRefresh;
import com.refinitiv.eta.valueadd.domainrep.rdm.dictionary.DictionaryRequest;
import com.refinitiv.eta.valueadd.domainrep.rdm.dictionary.DictionaryStatus;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.ConsumerStatusService;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.DirectoryClose;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.DirectoryConsumerStatus;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.DirectoryMsg;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.DirectoryMsgFactory;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.DirectoryMsgType;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.DirectoryRefresh;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.DirectoryRequest;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.DirectoryStatus;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.DirectoryUpdate;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.Service;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginClose;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginConsumerConnectionStatus;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginMsg;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginMsgFactory;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginMsgType;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginRefresh;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginRequest;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginStatus;
import com.refinitiv.eta.valueadd.domainrep.rdm.queue.QueueMsg;
import com.refinitiv.eta.valueadd.reactor.ConsumerRole;
import com.refinitiv.eta.valueadd.reactor.CosCommon;
import com.refinitiv.eta.valueadd.reactor.FileDumper;
import com.refinitiv.eta.valueadd.reactor.NIProviderRole;
import com.refinitiv.eta.valueadd.reactor.ProviderRole;
import com.refinitiv.eta.valueadd.reactor.RDMDictionaryMsgCallback;
import com.refinitiv.eta.valueadd.reactor.RDMDictionaryMsgEvent;
import com.refinitiv.eta.valueadd.reactor.RDMDirectoryMsgCallback;
import com.refinitiv.eta.valueadd.reactor.RDMDirectoryMsgEvent;
import com.refinitiv.eta.valueadd.reactor.RDMLoginMsgCallback;
import com.refinitiv.eta.valueadd.reactor.RDMLoginMsgEvent;
import com.refinitiv.eta.valueadd.reactor.ReactorAcceptOptions;
import com.refinitiv.eta.valueadd.reactor.ReactorAuthTokenEvent;
import com.refinitiv.eta.valueadd.reactor.ReactorAuthTokenEventCallback;
import com.refinitiv.eta.valueadd.reactor.ReactorAuthTokenInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorChannel;
import com.refinitiv.eta.valueadd.reactor.ReactorChannelEvent;
import com.refinitiv.eta.valueadd.reactor.ReactorChannelInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorConnectInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorConnectOptions;
import com.refinitiv.eta.valueadd.reactor.ReactorDebugger;
import com.refinitiv.eta.valueadd.reactor.ReactorDispatchOptions;
import com.refinitiv.eta.valueadd.reactor.ReactorErrorInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorFactory;
import com.refinitiv.eta.valueadd.reactor.ReactorJsonConversionEvent;
import com.refinitiv.eta.valueadd.reactor.ReactorJsonConversionEventCallback;
import com.refinitiv.eta.valueadd.reactor.ReactorJsonConverterOptions;
import com.refinitiv.eta.valueadd.reactor.ReactorMsgEvent;
import com.refinitiv.eta.valueadd.reactor.ReactorOAuthCredential;
import com.refinitiv.eta.valueadd.reactor.ReactorOAuthCredentialEvent;
import com.refinitiv.eta.valueadd.reactor.ReactorOAuthCredentialEventCallback;
import com.refinitiv.eta.valueadd.reactor.ReactorOAuthCredentialRenewal;
import com.refinitiv.eta.valueadd.reactor.ReactorOAuthCredentialRenewalOptions;
import com.refinitiv.eta.valueadd.reactor.ReactorOptions;
import com.refinitiv.eta.valueadd.reactor.ReactorPackedBuffer;
import com.refinitiv.eta.valueadd.reactor.ReactorPerServiceBasedOptions;
import com.refinitiv.eta.valueadd.reactor.ReactorRole;
import com.refinitiv.eta.valueadd.reactor.ReactorServiceDiscoveryOptions;
import com.refinitiv.eta.valueadd.reactor.ReactorServiceEndpointEvent;
import com.refinitiv.eta.valueadd.reactor.ReactorServiceEndpointInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorServiceNameToIdCallback;
import com.refinitiv.eta.valueadd.reactor.ReactorSubmitOptions;
import com.refinitiv.eta.valueadd.reactor.ReactorTokenSession;
import com.refinitiv.eta.valueadd.reactor.ReactorWLSubmitMsgOptions;
import com.refinitiv.eta.valueadd.reactor.ReactorWSBService;
import com.refinitiv.eta.valueadd.reactor.ReactorWSRecoveryMsgInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorWarmStandbyEvent;
import com.refinitiv.eta.valueadd.reactor.ReactorWarmStandbyEventPool;
import com.refinitiv.eta.valueadd.reactor.ReactorWarmStandbyGroup;
import com.refinitiv.eta.valueadd.reactor.ReactorWarmStandbyGroupImpl;
import com.refinitiv.eta.valueadd.reactor.ReactorWarmStandbyHandler;
import com.refinitiv.eta.valueadd.reactor.ReactorWarmStandbyServerInfo;
import com.refinitiv.eta.valueadd.reactor.RestAuthOptions;
import com.refinitiv.eta.valueadd.reactor.RestClient;
import com.refinitiv.eta.valueadd.reactor.RestConnectOptions;
import com.refinitiv.eta.valueadd.reactor.RestReactorOptions;
import com.refinitiv.eta.valueadd.reactor.ServiceNameIdConverterClient;
import com.refinitiv.eta.valueadd.reactor.TunnelStream;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamAuthInfo;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamMsgEvent;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamQueueMsgEvent;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamRejectOptions;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamRequestEvent;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamStateInfo;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamStatusEvent;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamSubmitOptions;
import com.refinitiv.eta.valueadd.reactor.Watchlist;
import com.refinitiv.eta.valueadd.reactor.WlInteger;
import com.refinitiv.eta.valueadd.reactor.WlRequest;
import com.refinitiv.eta.valueadd.reactor.WlService;
import com.refinitiv.eta.valueadd.reactor.WlStream;
import com.refinitiv.eta.valueadd.reactor.WlStreamStatusFlags;
import com.refinitiv.eta.valueadd.reactor.Worker;
import com.refinitiv.eta.valueadd.reactor.WorkerEvent;
import com.refinitiv.eta.valueadd.reactor.WorkerEventTypes;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.quartz.CronExpression;

public class Reactor {
    boolean _reactorActive = false;
    static final int SHUTDOWN_TIMEOUT_IN_SECONDS = 5;
    ReactorOptions _reactorOptions = ReactorFactory.createReactorOptions();
    ReactorChannel _reactorChannel = null;
    ReactorChannelInfo _reactorChannelInfo = ReactorFactory.createReactorChannelInfo();
    FileDumper _fileDumper;
    VaPool _reactorChannelPool = new VaPool(true);
    SelectableBiDirectionalQueue _workerQueue = null;
    Worker _worker = null;
    ExecutorService _esWorker = null;
    VaDoubleLinkList<ReactorChannel> _reactorChannelQueue = new VaDoubleLinkList();
    Lock _reactorLock = new ReentrantLock();
    int _reactorChannelCount;
    EncodeIterator _eIter = CodecFactory.createEncodeIterator();
    DecodeIterator _dIter = CodecFactory.createDecodeIterator();
    Msg _msg = CodecFactory.createMsg();
    WriteArgs _writeArgs = TransportFactory.createWriteArgs();
    WriteArgs _writeArgsAggregator = TransportFactory.createWriteArgs();
    ReactorSubmitOptions reactorSubmitOptions = ReactorFactory.createReactorSubmitOptions();
    ReadArgs _readArgsAggregator = TransportFactory.createReadArgs();
    InitArgs _initArgs = TransportFactory.createInitArgs();
    LoginMsg _loginMsg = LoginMsgFactory.createMsg();
    CloseMsg _closeMsg = (CloseMsg)CodecFactory.createMsg();
    DirectoryMsg _directoryMsg = DirectoryMsgFactory.createMsg();
    DictionaryMsg _dictionaryMsg = DictionaryMsgFactory.createMsg();
    private XmlTraceDump xmlDumpTrace = CodecFactory.createXmlTraceDump();
    private StringBuilder xmlString = new StringBuilder(1500);
    private HashMap<Msg, TransportBuffer> _submitMsgMap = new HashMap();
    private HashMap<MsgBase, TransportBuffer> _submitRdmMsgMap = new HashMap();
    private HashMap<String, ReactorTokenSession> _tokenManagementMap = new HashMap(5);
    private Lock _tokenManagementLock = new ReentrantLock();
    RestClient _restClient;
    ReactorTokenSession _tokenSessionForCredentialRenewalCallback;
    private String _defaultTokenURLV1String = "https://api.refinitiv.com/auth/oauth2/v1/token";
    private Buffer _tokenURLV1String = CodecFactory.createBuffer();
    private String _defaultTokenURLV2String = "https://api.refinitiv.com/auth/oauth2/v2/token";
    private Buffer _tokenURLV2String = CodecFactory.createBuffer();
    private String _defaultServiceDiscoveryString = "https://api.refinitiv.com/streaming/pricing/v1/";
    private Buffer _seviceDiscoveryString = CodecFactory.createBuffer();
    private List<ReactorServiceEndpointInfo> _reactorServiceEndpointInfoList = new ArrayList<ReactorServiceEndpointInfo>(50);
    RestReactorOptions _restReactorOptions;
    private TunnelStreamStateInfo _tunnelStreamStateInfo;
    private TunnelStreamAuthInfo _authInfo = ReactorFactory.createTunnelStreamAuthInfo();
    private State _tmpState = CodecFactory.createState();
    private TunnelStreamRequestEvent _tunnelStreamRequestEvent = new TunnelStreamRequestEvent();
    private TunnelStreamSubmitOptions _tunnelStreamSubmitOptions = ReactorFactory.createTunnelStreamSubmitOptions();
    private TunnelStreamRejectOptions _tunnelStreamRejectOptions = ReactorFactory.createTunnelStreamRejectOptions();
    private boolean _finalStatusEvent;
    WlInteger _tempWlInteger = ReactorFactory.createWlInteger();
    JsonConverter jsonConverter = null;
    Object jsonConverterUserSpec = null;
    private ServiceNameIdConverterClient serviceNameIdConverterClient = null;
    ReactorServiceNameToIdCallback serviceNameToIdCallback;
    ReactorJsonConversionEventCallback JsonConversionEventCallback;
    private ReactorJsonConversionEvent jsonConversionEvent = new ReactorJsonConversionEvent();
    private boolean closeChannelFromFailure = false;
    private boolean sendJsonConvError = false;
    private ParseJsonOptions parseJsonOptions = ConverterFactory.createParseJsonOptions();
    JsonConverterError converterError = ConverterFactory.createJsonConverterError();
    JsonConverterError getMessageError = ConverterFactory.createJsonConverterError();
    private DecodeJsonMsgOptions decodeJsonMsgOptions = ConverterFactory.createDecodeJsonMsgOptions();
    private JsonMsg jsonMsg = ConverterFactory.createJsonMsg();
    private Msg jsonDecodeMsg = CodecFactory.createMsg();
    private GetJsonErrorParams jsonErrorParams = ConverterFactory.createJsonErrorParams();
    private Buffer jsonErrorOutputBuffer = CodecFactory.createBuffer();
    RWFToJsonOptions rwfToJsonOptions = ConverterFactory.createRWFToJsonOptions();
    ConversionResults conversionResults = ConverterFactory.createConversionResults();
    GetJsonMsgOptions getJsonMsgOptions = ConverterFactory.createGetJsonMsgOptions();
    HashMap<TransportBuffer, ReactorPackedBuffer> packedBufferHashMap = new HashMap();
    HashMap<TransportBuffer, TransportBuffer> writeCallAgainMap = new HashMap();
    ReactorWarmStandbyEventPool reactorWarmStandbyEventPool = new ReactorWarmStandbyEventPool(30);
    VaQueue warmstandbyChannelPool;
    VaQueue closingWarmStandbyChannel;
    static String JSON_PONG_MESSAGE = "{\"Type\":\"Pong\"}";
    ReactorDebugger debugger;

    Reactor(ReactorOptions options, ReactorErrorInfo errorInfo) {
        if (errorInfo == null) {
            throw new UnsupportedOperationException("ReactorErrorInfo cannot be null");
        }
        if (options != null) {
            if (options.tokenReissueRatio() < 0.05 || options.tokenReissueRatio() > 0.95) {
                this.populateErrorInfo(errorInfo, -1, "Reactor.constructor", "The token reissue ratio must be in between 0.05 to 0.95.");
                return;
            }
            if (options.reissueTokenAttemptInterval() < 0) {
                this.populateErrorInfo(errorInfo, -1, "Reactor.constructor", "The token reissue attempt interval is less than zero.");
                return;
            }
            this._reactorOptions.copy(options);
            this.debugger = ReactorFactory.createReactorDebugger(this._reactorOptions.debuggerOptions().outputStream(), this._reactorOptions.debuggerOptions().capacity());
            if (options.xmlTraceToFile()) {
                this._fileDumper = new FileDumper(options.xmlTraceFileName(), options.xmlTraceToMultipleFiles(), options.xmlTraceMaxFileSize());
            }
        } else {
            this.populateErrorInfo(errorInfo, -1, "Reactor.constructor", "options was null and cannot continue.");
            return;
        }
        if (this.initializeTransport(errorInfo) != 0) {
            return;
        }
        if (this.initializeReactor(errorInfo) != 0) {
            return;
        }
        this._tunnelStreamStateInfo = new TunnelStreamStateInfo();
        errorInfo.clear();
        this._reactorActive = true;
        this._finalStatusEvent = true;
    }

    int initializeTransport(ReactorErrorInfo errorInfo) {
        this._initArgs.clear();
        this._initArgs.globalLocking(true);
        this._initArgs.socketProtocolPoolLimit(ReactorFactory._socketProtocolPoolLimit);
        if (Transport.initialize((InitArgs)this._initArgs, (Error)errorInfo.error()) != 0) {
            return this.populateErrorInfo(errorInfo, -1, "Reactor.initializeTransport", errorInfo.error().text());
        }
        return 0;
    }

    int initializeReactor(ReactorErrorInfo errorInfo) {
        try {
            if (this._reactorOptions.serviceDiscoveryURL() == null || this._reactorOptions.serviceDiscoveryURL().length() == 0) {
                this._seviceDiscoveryString.data(this._defaultServiceDiscoveryString);
                this._reactorOptions.serviceDiscoveryURL(this._seviceDiscoveryString);
            }
            if (this._reactorOptions.tokenServiceURL_V1() == null || this._reactorOptions.tokenServiceURL_V1().length() == 0) {
                this._tokenURLV1String.data(this._defaultTokenURLV1String);
                this._reactorOptions.tokenServiceURL_V1(this._tokenURLV1String);
            }
            if (this._reactorOptions.tokenServiceURL_V2() == null || this._reactorOptions.tokenServiceURL_V2().length() == 0) {
                this._tokenURLV2String.data(this._defaultTokenURLV2String);
                this._reactorOptions.tokenServiceURL_V2(this._tokenURLV2String);
            }
            this._workerQueue = new SelectableBiDirectionalQueue();
            this._reactorChannel = ReactorFactory.createReactorChannel(this);
            this._reactorChannel.reactor(this);
            this._reactorChannel.userSpecObj(this);
            this._reactorChannel.selectableChannel(this._workerQueue.readChannel());
            this._reactorChannel.pingHandler().trackPings(this._reactorOptions.pingStatSet());
            this._worker = new Worker(this._reactorChannel, this._workerQueue.remote());
            this._esWorker = Executors.newSingleThreadExecutor();
            this._esWorker.execute(this._worker);
        }
        catch (NullPointerException | RejectedExecutionException e) {
            return this.populateErrorInfo(errorInfo, -1, "Reactor.initializeReactor", "failed to initialize the Worker, exception=" + e.getLocalizedMessage());
        }
        return 0;
    }

    int populateErrorInfo(ReactorErrorInfo errorInfo, int reactorReturnCode, String location, String text) {
        errorInfo.clear();
        errorInfo.code(reactorReturnCode).location(location);
        errorInfo.error().errorId(reactorReturnCode);
        if (text != null) {
            errorInfo.error().text(text);
        }
        return reactorReturnCode;
    }

    public Object userSpecObj() {
        return this._reactorOptions.userSpecObj();
    }

    public boolean isShutdown() {
        return !this._reactorActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int shutdown(ReactorErrorInfo errorInfo) {
        int retval = 0;
        this._reactorLock.lock();
        try {
            if (!this._reactorActive) {
                int n = retval;
                return n;
            }
            if (this._restClient != null) {
                this._restClient.shutdown();
            }
            Object reactorChannel = this._reactorChannelQueue.start(ReactorChannel.REACTOR_CHANNEL_LINK);
            while (reactorChannel != null) {
                if (reactorChannel != null && ((ReactorChannel)reactorChannel).state() != ReactorChannel.State.CLOSED) {
                    if (errorInfo.error().text() == null) {
                        errorInfo.error().text("Reactor shutting down...");
                    }
                    this.sendChannelEventCallback(2, (ReactorChannel)reactorChannel, errorInfo);
                    if (((ReactorChannel)reactorChannel).state() != ReactorChannel.State.CLOSED) {
                        this.closeChannel((ReactorChannel)reactorChannel, errorInfo);
                    }
                }
                reactorChannel = this._reactorChannelQueue.forth(ReactorChannel.REACTOR_CHANNEL_LINK);
            }
            this._reactorChannelQueue = null;
            this._reactorChannelCount = 0;
            this.sendWorkerEvent(WorkerEventTypes.SHUTDOWN, null);
            this._esWorker.shutdown();
            while (!this._esWorker.awaitTermination(5L, TimeUnit.SECONDS)) {
            }
            this._esWorker = null;
            this._worker = null;
            if (this.packedBufferHashMap.size() > 0) {
                for (ReactorPackedBuffer packedBuffer : this.packedBufferHashMap.values()) {
                    packedBuffer.returnToPool();
                }
                this.packedBufferHashMap.clear();
            }
            this.writeCallAgainMap.clear();
            this._workerQueue.shutdown();
            this._workerQueue = null;
            this._reactorChannel.returnToPool();
            this._reactorChannel = null;
            this.serviceNameToIdCallback = null;
            this.JsonConversionEventCallback = null;
            this.jsonConverter = null;
            this.jsonConverterUserSpec = null;
            this.serviceNameIdConverterClient = null;
            int tRetCode = Transport.uninitialize();
            if (tRetCode != 0) {
                retval = -1;
            }
        }
        catch (InterruptedException e) {
            int n = this.populateErrorInfo(errorInfo, -1, "Reactor.shutdown", "Exception occurred while waiting for Worker thread to terminate, exception=" + e.getLocalizedMessage());
            return n;
        }
        finally {
            this._reactorActive = false;
            this._reactorLock.unlock();
        }
        return retval;
    }

    public ReactorChannel reactorChannel() {
        return this._reactorChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int accept(Server server, ReactorAcceptOptions reactorAcceptOptions, ReactorRole role, ReactorErrorInfo errorInfo) {
        this._reactorLock.lock();
        try {
            if (errorInfo == null) {
                System.out.println("Reactor.accept(): ReactorErrorInfo cannot be null, aborting.");
                int n = -1;
                return n;
            }
            if (!this._reactorActive) {
                int n = this.populateErrorInfo(errorInfo, -10, "Reactor.accept", "Reactor is not active, aborting.");
                return n;
            }
            if (reactorAcceptOptions == null) {
                int n = this.populateErrorInfo(errorInfo, -1, "Reactor.accept", "reactorAcceptOptions cannot be null, aborting.");
                return n;
            }
            if (role == null) {
                int n = this.populateErrorInfo(errorInfo, -1, "Reactor.accept", "role cannot be null, aborting.");
                return n;
            }
            if (role.channelEventCallback() == null) {
                int n = this.populateErrorInfo(errorInfo, -1, "Reactor.accept", "role must have a channelEventCallback defined, aborting.");
                return n;
            }
            if (role.defaultMsgCallback() == null) {
                int n = this.populateErrorInfo(errorInfo, -1, "Reactor.accept", "role must have a defaultMsgCallback defined, aborting.");
                return n;
            }
            if (role.type() != 2) {
                int n = this.populateErrorInfo(errorInfo, -1, "Reactor.accept", "role must be Provider Role, aborting.");
                return n;
            }
            if (reactorAcceptOptions.initTimeout() < 1) {
                int n = this.populateErrorInfo(errorInfo, -1, "Reactor.accept", "ReactorAcceptOptions.timeout must be greater than zero, aborting.");
                return n;
            }
            ReactorChannel reactorChannel = ReactorFactory.createReactorChannel(this);
            reactorChannel.state(ReactorChannel.State.INITIALIZING);
            reactorChannel.role(role);
            reactorChannel.reactor(this);
            reactorChannel.initializationTimeout(reactorAcceptOptions.initTimeout());
            reactorChannel.server(server);
            this._reactorChannelQueue.pushBack(reactorChannel, ReactorChannel.REACTOR_CHANNEL_LINK);
            reactorAcceptOptions.acceptOptions().channelReadLocking(true);
            reactorAcceptOptions.acceptOptions().channelWriteLocking(true);
            Channel channel = server.accept(reactorAcceptOptions.acceptOptions(), errorInfo.error());
            if (channel == null) {
                int n = this.populateErrorInfo(errorInfo, -1, "Reactor.accept", "Server.accept() failed, error=" + errorInfo.error().text());
                return n;
            }
            reactorChannel.selectableChannelFromChannel(channel);
            reactorChannel.userSpecObj(reactorAcceptOptions.acceptOptions().userSpecObject());
            if (!this.sendWorkerEvent(WorkerEventTypes.CHANNEL_INIT, reactorChannel)) {
                reactorChannel.state(ReactorChannel.State.DOWN);
                this.sendAndHandleChannelEventCallback("Reactor.accept", 2, reactorChannel, errorInfo);
                int n = this.populateErrorInfo(errorInfo, -1, "Reactor.accept", "sendWorkerEvent() failed");
                return n;
            }
            reactorChannel.sendPingMessage(reactorAcceptOptions.websocketAcceptOptions().sendPingMessage);
            if (this._reactorOptions.debuggerOptions().debugConnectionLevel()) {
                this.debugger.writeDebugInfo("Reactor@%d, Server@%d accepts reactor channel@%d on channel fd=%d.]\n", this.hashCode(), server.hashCode(), reactorChannel.hashCode(), ReactorDebugger.getChannelId(reactorChannel));
            }
        }
        finally {
            this._reactorLock.unlock();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int connect(ReactorConnectOptions reactorConnectOptions, ReactorRole role, ReactorErrorInfo errorInfo) {
        this._reactorLock.lock();
        boolean sendAuthTokenEvent = false;
        ReactorTokenSession tokenSession = null;
        ReactorWarmStandbyHandler warmStandbyHandlerImpl = null;
        try {
            ReactorWarmStandbyGroupImpl reactorWarmStandbyGroupImpl2;
            if (errorInfo == null) {
                System.out.println("Reactor.connect(): ReactorErrorInfo cannot be null, aborting.");
                int n = -1;
                return n;
            }
            if (!this._reactorActive) {
                int n = this.populateErrorInfo(errorInfo, -10, "Reactor.connect", "Reactor is not active, aborting.");
                return n;
            }
            if (reactorConnectOptions == null) {
                int n = this.populateErrorInfo(errorInfo, -1, "Reactor.connect", "reactorConnectOptions cannot be null, aborting.");
                return n;
            }
            if (role == null) {
                int n = this.populateErrorInfo(errorInfo, -1, "Reactor.connect", "role cannot be null, aborting.");
                return n;
            }
            if (role.channelEventCallback() == null) {
                int n = this.populateErrorInfo(errorInfo, -1, "Reactor.connect", "role must have a channelEventCallback defined, aborting.");
                return n;
            }
            if (role.defaultMsgCallback() == null) {
                int n = this.populateErrorInfo(errorInfo, -1, "Reactor.connect", "role must have a defaultMsgCallback defined, aborting.");
                return n;
            }
            if (role.type() == 1) {
                if (((ConsumerRole)role).rdmDirectoryRequest() != null && ((ConsumerRole)role).rdmLoginRequest() == null) {
                    int n = this.populateErrorInfo(errorInfo, -1, "Reactor.connect", "Must specify an rdmLoginRequest if specifying an rdmDirectoryRequest, aborting.");
                    return n;
                }
                if (((ConsumerRole)role).dictionaryDownloadMode() == 1 && ((ConsumerRole)role).watchlistOptions().enableWatchlist()) {
                    int n = this.populateErrorInfo(errorInfo, -6, "Reactor.connect", "Cannot specify a dictionary download when watchlist is enabled.");
                    return n;
                }
                if (((ConsumerRole)role).dictionaryDownloadMode() == 1 && ((ConsumerRole)role).rdmDirectoryRequest() == null) {
                    int n = this.populateErrorInfo(errorInfo, -1, "Reactor.connect", "Must specify an rdmDirectoryRequest if specifying a dictionary download, aborting.");
                    return n;
                }
            } else if (role.type() == 3) {
                if (((NIProviderRole)role).rdmDirectoryRefresh() != null && ((NIProviderRole)role).rdmLoginRequest() == null) {
                    int n = this.populateErrorInfo(errorInfo, -1, "Reactor.connect", "Must specify an rdmLoginRequest if specifying an rdmDirectoryRequest, aborting.");
                    return n;
                }
            } else if (role.type() == 2) {
                int n = this.populateErrorInfo(errorInfo, -1, "Reactor.connect", "role must be Consumer or NIProvider Role, aborting.");
                return n;
            }
            if (reactorConnectOptions.connectionList().size() == 0 && reactorConnectOptions.reactorWarmStandbyGroupList() == null) {
                int n = this.populateErrorInfo(errorInfo, -1, "Reactor.connect", "ReactorConnectOptions.connectionList() must have at least one ReactorConnectInfo or warm standby group configured, aborting.");
                return n;
            }
            if (reactorConnectOptions.reactorPreferredHostOptions().isPreferredHostEnabled() && reactorConnectOptions.connectionList() != null && reactorConnectOptions.connectionList().size() > 0 && (reactorConnectOptions.reactorPreferredHostOptions().connectionListIndex() >= reactorConnectOptions.connectionList().size() || reactorConnectOptions.reactorPreferredHostOptions().connectionListIndex() < 0)) {
                int n = this.populateErrorInfo(errorInfo, -1, "Reactor.connect", "Configured preferredHostOptions connectionListIndex is out of bounds, aborting.");
                return n;
            }
            if (reactorConnectOptions.reactorPreferredHostOptions().isPreferredHostEnabled() && reactorConnectOptions.reactorWarmStandbyGroupList() != null && reactorConnectOptions.reactorWarmStandbyGroupList().size() > 0 && (reactorConnectOptions.reactorPreferredHostOptions().warmStandbyGroupListIndex() >= reactorConnectOptions.reactorWarmStandbyGroupList().size() || reactorConnectOptions.reactorPreferredHostOptions().warmStandbyGroupListIndex() < 0)) {
                int n = this.populateErrorInfo(errorInfo, -1, "Reactor.connect", "Configured preferredHostOptions warmStandbyGroupList is out of bounds, aborting.");
                return n;
            }
            if (reactorConnectOptions.reactorPreferredHostOptions().isPreferredHostEnabled() && reactorConnectOptions.reactorPreferredHostOptions().detectionTimeInterval() < 0L) {
                int n = this.populateErrorInfo(errorInfo, -1, "Reactor.connect", "Configured preferredHostOptions detectionTimeInterval is invalid, aborting.");
                return n;
            }
            ReactorChannel reactorChannel = ReactorFactory.createReactorChannel(this);
            reactorChannel.reactor(this);
            reactorChannel.reactorConnectOptions(reactorConnectOptions);
            reactorConnectOptions._reactorPreferredHostOptions.copy(reactorChannel._preferredHostOptions);
            if (reactorChannel._preferredHostOptions.isPreferredHostEnabled() && reactorChannel._preferredHostOptions.detectionTimeSchedule() != null && !reactorChannel._preferredHostOptions.detectionTimeSchedule().isEmpty()) {
                try {
                    reactorChannel._cronExpression = new CronExpression(reactorChannel._preferredHostOptions.detectionTimeSchedule());
                }
                catch (ParseException e) {
                    int n = this.populateErrorInfo(errorInfo, -1, "Reactor.connect", "Parse exception occured on preferredHostOptions scheduled cron time, aborting.");
                    this._reactorLock.unlock();
                    return n;
                }
            }
            if (reactorConnectOptions.connectionList().size() > 0) {
                if (reactorConnectOptions.reactorPreferredHostOptions().isPreferredHostEnabled() && reactorConnectOptions.reactorPreferredHostOptions().connectionListIndex() < reactorConnectOptions.connectionList().size() && reactorConnectOptions.reactorPreferredHostOptions().connectionListIndex() >= 0) {
                    reactorChannel.setCurrentReactorConnectInfo(reactorChannel.getReactorConnectOptions().connectionList().get(reactorConnectOptions.reactorPreferredHostOptions().connectionListIndex()));
                    reactorChannel.setCurrentConnectOptionsInfo(reactorChannel._connectOptionsInfoList.get(reactorConnectOptions.reactorPreferredHostOptions().connectionListIndex()));
                    reactorChannel.userSpecObj(reactorChannel.getReactorConnectOptions().connectionList().get(reactorConnectOptions.reactorPreferredHostOptions().connectionListIndex()).connectOptions().userSpecObject());
                } else {
                    reactorChannel.setCurrentReactorConnectInfo(reactorChannel.getReactorConnectOptions().connectionList().get(0));
                    reactorChannel.setCurrentConnectOptionsInfo(reactorChannel._connectOptionsInfoList.get(0));
                    reactorChannel.userSpecObj(reactorChannel.getReactorConnectOptions().connectionList().get(0).connectOptions().userSpecObject());
                }
            }
            reactorChannel.role(role);
            if (role.type() == 1 && ((ConsumerRole)role).watchlistOptions().enableWatchlist()) {
                Watchlist watchlist = ReactorFactory.createWatchlist(reactorChannel, (ConsumerRole)role);
                reactorChannel.watchlist(watchlist);
                if (reactorConnectOptions.reactorWarmStandbyGroupList() != null && reactorConnectOptions.reactorWarmStandbyGroupList().size() > 0) {
                    watchlist.watchlistOptions().enableWarmStandby(true);
                    warmStandbyHandlerImpl = new ReactorWarmStandbyHandler();
                    warmStandbyHandlerImpl.connectionOptions(reactorChannel.getReactorConnectOptions());
                    if (reactorChannel._preferredHostOptions.isPreferredHostEnabled() && reactorChannel._preferredHostOptions.warmStandbyGroupListIndex() >= 0 && reactorChannel._preferredHostOptions.warmStandbyGroupListIndex() < reactorConnectOptions.reactorWarmStandbyGroupList().size()) {
                        warmStandbyHandlerImpl.currentWarmStandbyGroupIndex(reactorChannel._preferredHostOptions.warmStandbyGroupListIndex());
                        if (reactorChannel._preferredHostOptions.warmStandbyGroupListIndex() > 0) {
                            warmStandbyHandlerImpl.previousWarmStandbyGroupIndex(-1);
                        } else if (reactorChannel._preferredHostOptions.warmStandbyGroupListIndex() == 0) {
                            warmStandbyHandlerImpl.previousWarmStandbyGroupIndex(0);
                        }
                    } else {
                        warmStandbyHandlerImpl.currentWarmStandbyGroupIndex(0);
                    }
                    for (int i = 0; i < reactorChannel.getReactorConnectOptions().reactorWarmStandbyGroupList().size(); ++i) {
                        reactorWarmStandbyGroupImpl2 = (ReactorWarmStandbyGroupImpl)warmStandbyHandlerImpl.getConnectionOptions().reactorWarmStandbyGroupList().get(i);
                        if (reactorWarmStandbyGroupImpl2.warmStandbyMode() == 2) {
                            int j;
                            ReactorPerServiceBasedOptions serviceOpts = warmStandbyHandlerImpl.currentWarmStandbyGroupImpl().startingActiveServer().perServiceBasedOptions();
                            for (j = 0; j < serviceOpts.serviceNameList().size(); ++j) {
                                Buffer serviceName = serviceOpts.serviceNameList().get(j);
                                if (serviceName.length() <= 0) continue;
                                ReactorWSBService service = ReactorFactory.createWsbService();
                                service.serviceName.data(serviceName.toString().trim());
                                if (warmStandbyHandlerImpl.currentWarmStandbyGroupImpl()._startupServiceNameList.containsKey(service.serviceName)) continue;
                                service.standbyListIndex = -1;
                                warmStandbyHandlerImpl.currentWarmStandbyGroupImpl()._startupServiceNameList.put(service.serviceName, service);
                            }
                            for (j = 0; j < warmStandbyHandlerImpl.currentWarmStandbyGroupImpl().standbyServerList().size(); ++j) {
                                ReactorWarmStandbyServerInfo serverInfo = warmStandbyHandlerImpl.currentWarmStandbyGroupImpl().standbyServerList().get(j);
                                for (int k = 0; k < serverInfo.perServiceBasedOptions().serviceNameList().size(); ++k) {
                                    Buffer serviceName = serverInfo.perServiceBasedOptions().serviceNameList().get(k);
                                    if (serviceName.length() <= 0) continue;
                                    ReactorWSBService service = ReactorFactory.createWsbService();
                                    service.serviceName.data(serviceName.toString().trim());
                                    if (warmStandbyHandlerImpl.currentWarmStandbyGroupImpl()._startupServiceNameList.containsKey(service.serviceName)) continue;
                                    service.standbyListIndex = j;
                                    warmStandbyHandlerImpl.currentWarmStandbyGroupImpl()._startupServiceNameList.put(service.serviceName, service);
                                }
                            }
                            continue;
                        }
                        if (reactorWarmStandbyGroupImpl2.warmStandbyMode() == 1) continue;
                        reactorChannel.returnToPool();
                        int serviceOpts = this.populateErrorInfo(errorInfo, -1, "Reactor.connect", "Invalid Warm Standby Configuration");
                        return serviceOpts;
                    }
                    if (reactorConnectOptions.reactorPreferredHostOptions().isPreferredHostEnabled() && reactorConnectOptions.reactorPreferredHostOptions().warmStandbyGroupListIndex() <= reactorConnectOptions.reactorWarmStandbyGroupList().size() && reactorConnectOptions.reactorPreferredHostOptions().warmStandbyGroupListIndex() >= 0) {
                        ReactorWarmStandbyGroupImpl wsbGroupImpl = (ReactorWarmStandbyGroupImpl)warmStandbyHandlerImpl.warmStandbyGroupList().get(reactorConnectOptions.reactorPreferredHostOptions().warmStandbyGroupListIndex());
                        reactorChannel.setCurrentReactorConnectInfo(wsbGroupImpl.startingActiveServer().reactorConnectInfo());
                        reactorChannel.setCurrentConnectOptionsInfo(wsbGroupImpl.startingConnectOptionsInfo);
                        reactorChannel._switchingToPreferredWSBGroup = true;
                    } else {
                        reactorChannel.setCurrentReactorConnectInfo(warmStandbyHandlerImpl.currentWarmStandbyGroupImpl().startingActiveServer().reactorConnectInfo());
                        reactorChannel.setCurrentConnectOptionsInfo(warmStandbyHandlerImpl.currentWarmStandbyGroupImpl().startingConnectOptionsInfo);
                    }
                    if (reactorChannel._reactorConnectOptions._connectionList.size() > 0) {
                        warmStandbyHandlerImpl.hasConnectionList(true);
                    }
                    if (reactorChannel.getCurrentReactorConnectInfo().connectOptions().unifiedNetworkInfo().address() != null && reactorChannel.getCurrentReactorConnectInfo().connectOptions().unifiedNetworkInfo().serviceName() != null) {
                        reactorChannel.isStartingServerConfig = true;
                        reactorChannel.standByGroupListIndex = 0;
                        reactorChannel.initializationTimeout(reactorChannel.getCurrentReactorConnectInfo().initTimeout());
                        reactorChannel.warmStandByHandlerImpl = warmStandbyHandlerImpl;
                        reactorChannel.userSpecObj(reactorChannel.getCurrentReactorConnectInfo().connectOptions().userSpecObject());
                    } else if (warmStandbyHandlerImpl.currentWarmStandbyGroupImpl().startingActiveServer().reactorConnectInfo().enableSessionManagement()) {
                        reactorChannel.isStartingServerConfig = true;
                        reactorChannel.initializationTimeout(reactorChannel.getCurrentReactorConnectInfo().initTimeout());
                        reactorChannel.warmStandByHandlerImpl = warmStandbyHandlerImpl;
                        reactorChannel.userSpecObj(reactorChannel.getCurrentReactorConnectInfo().connectOptions().userSpecObject());
                    } else {
                        reactorChannel.state(ReactorChannel.State.DOWN);
                        this.sendAndHandleChannelEventCallback("Reactor.connect", 2, reactorChannel, errorInfo);
                        this.removeReactorChannel(reactorChannel);
                        reactorChannel.returnToPool();
                        int wsbGroupImpl = this.populateErrorInfo(errorInfo, -1, "Reactor.connect", "There is no valid connection information for a starting server of the warm standby feature.");
                        return wsbGroupImpl;
                    }
                    reactorChannel.standByServerListIndex = -1;
                    reactorChannel.reactorChannelType(1);
                    warmStandbyHandlerImpl.mainReactorChannelImpl(ReactorFactory.createReactorChannel(this));
                    warmStandbyHandlerImpl.mainReactorChannelImpl().warmStandByHandlerImpl = warmStandbyHandlerImpl;
                    warmStandbyHandlerImpl.mainReactorChannelImpl().role(reactorChannel.role());
                    warmStandbyHandlerImpl.setConnectingToStartingServerState();
                    warmStandbyHandlerImpl.mainReactorChannelImpl().reactor(this);
                    warmStandbyHandlerImpl.mainReactorChannelImpl().warmStandByHandlerImpl = warmStandbyHandlerImpl;
                    warmStandbyHandlerImpl.mainReactorChannelImpl().state(ReactorChannel.State.UP);
                    warmStandbyHandlerImpl.currentWarmStandbyGroupImpl().currentStartingServerIndex = -1;
                    warmStandbyHandlerImpl.startingReactorChannel(reactorChannel);
                    warmStandbyHandlerImpl.mainReactorChannelImpl().reactorChannelType(1);
                    warmStandbyHandlerImpl.mainReactorChannelImpl()._preferredHostOptions = reactorChannel._preferredHostOptions;
                    warmStandbyHandlerImpl.warmStandByHandlerLock().lock();
                    try {
                        warmStandbyHandlerImpl.channelList().add(reactorChannel);
                    }
                    finally {
                        warmStandbyHandlerImpl.warmStandByHandlerLock().unlock();
                    }
                }
            }
            if (reactorChannel.getCurrentReactorConnectInfo().initTimeout() < 1) {
                this.removeReactorChannel(reactorChannel);
                reactorChannel.returnToPool();
                int watchlist = this.populateErrorInfo(errorInfo, -1, "Reactor.connect", "ReactorConnectOptions.timeout must be greater than zero, aborting.");
                return watchlist;
            }
            if (reactorChannel.getCurrentReactorConnectInfo().connectOptions().blocking()) {
                this.removeReactorChannel(reactorChannel);
                reactorChannel.returnToPool();
                int watchlist = this.populateErrorInfo(errorInfo, -1, "Reactor.connect", "ReactorConnectOptions.connectOptions.blocking must be false, aborting.");
                return watchlist;
            }
            if (Reactor.enableSessionManagement(reactorConnectOptions)) {
                try {
                    this.setupRestClient(errorInfo);
                }
                catch (Exception e) {
                    reactorChannel.returnToPool();
                    int reactorWarmStandbyGroupImpl2 = this.populateErrorInfo(errorInfo, -1, "Reactor.setupRestClient", "failed to initialize the RESTClient, exception=" + e.getLocalizedMessage());
                    this._reactorLock.unlock();
                    return reactorWarmStandbyGroupImpl2;
                }
                ReactorOAuthCredential oAuthCredential = this.retriveOAuthCredentialFromConsumerRole(role, errorInfo);
                if (oAuthCredential != null) {
                    tokenSession = this.getTokenSession(oAuthCredential, errorInfo);
                    if (tokenSession == null) {
                        reactorChannel.returnToPool();
                        int e = errorInfo.code();
                        return e;
                    }
                    reactorChannel.tokenSession(tokenSession);
                } else {
                    reactorChannel.returnToPool();
                    int e = errorInfo.code();
                    return e;
                }
            }
            if (reactorChannel.getCurrentReactorConnectInfo().enableSessionManagement()) {
                if (this.sessionManagementStartup(tokenSession, reactorChannel.getCurrentReactorConnectInfo(), role, reactorChannel, true, errorInfo) != 0) {
                    this.removeReactorChannel(reactorChannel);
                    reactorChannel.returnToPool();
                    int oAuthCredential = errorInfo.code();
                    return oAuthCredential;
                }
                reactorChannel.applyAccessToken();
                tokenSession.originalExpiresIn(tokenSession.authTokenInfo().expiresIn());
                sendAuthTokenEvent = true;
                tokenSession.receivedAuthToken();
                if (tokenSession.oAuthCredential().reactorOAuthCredentialEventCallback() != null) {
                    tokenSession.oAuthCredential().password().clear();
                    tokenSession.oAuthCredential().clientSecret().clear();
                    tokenSession.oAuthCredential().clientJwk().clear();
                    tokenSession.authOptoins().clearSensitiveInfo();
                }
            }
            if (this._reactorOptions.debuggerOptions().debugConnectionLevel()) {
                this.debugger.writeDebugInfo("Reactor@%d, Reactor channel@%d session startup executed on channel fd=%d, session management enabled: %b]\n", this.hashCode(), reactorChannel.hashCode(), ReactorDebugger.getChannelId(reactorChannel), Reactor.enableSessionManagement(reactorConnectOptions));
            }
            reactorChannel.userSpecObj(reactorChannel.getCurrentReactorConnectInfo().connectOptions().userSpecObject());
            reactorChannel.initializationTimeout(reactorChannel.getCurrentReactorConnectInfo().initTimeout());
            reactorChannel.state(ReactorChannel.State.INITIALIZING);
            this._reactorChannelQueue.pushBack(reactorChannel, ReactorChannel.REACTOR_CHANNEL_LINK);
            ConnectOptions connectOptions = reactorChannel.getCurrentReactorConnectInfo().connectOptions();
            connectOptions.channelReadLocking(true);
            connectOptions.channelWriteLocking(true);
            if (reactorConnectOptions.reactorWarmStandbyGroupList() != null && reactorConnectOptions.reactorWarmStandbyGroupList().size() > 0) {
                for (int i = 0; i < reactorChannel.getReactorConnectOptions().reactorWarmStandbyGroupList().size(); ++i) {
                    reactorWarmStandbyGroupImpl2 = (ReactorWarmStandbyGroupImpl)reactorChannel.getReactorConnectOptions().reactorWarmStandbyGroupList().get(i);
                    for (int j = 0; j < reactorWarmStandbyGroupImpl2.standbyServerList().size(); ++j) {
                        reactorWarmStandbyGroupImpl2.standbyServerList().get(j).reactorConnectInfo().connectOptions().channelReadLocking(true);
                        reactorWarmStandbyGroupImpl2.standbyServerList().get(j).reactorConnectInfo().connectOptions().channelWriteLocking(true);
                    }
                }
            }
            Channel channel = Transport.connect((ConnectOptions)connectOptions, (Error)errorInfo.error());
            reactorChannel.selectableChannelFromChannel(channel);
            if (role.type() == 1 && ((ConsumerRole)role).watchlistOptions().enableWatchlist() && ((ConsumerRole)role).watchlistOptions().channelOpenCallback() != null) {
                this.sendAndHandleChannelEventCallback("Reactor.connect", 7, reactorChannel, errorInfo);
            }
            if (sendAuthTokenEvent) {
                boolean retVal;
                this.sendAuthTokenEventCallback(reactorChannel, tokenSession.authTokenInfo(), errorInfo);
                reactorChannel.sessionMgntState(ReactorChannel.SessionMgntState.RECEIVED_AUTH_TOKEN);
                if (!tokenSession.isInitialized() && !(retVal = tokenSession.authTokenInfo().tokenVersion() == ReactorAuthTokenInfo.TokenVersion.V1 ? this.sendAuthTokenWorkerEvent(tokenSession) : this.sendAuthTokenWorkerEvent(reactorChannel, tokenSession))) {
                    this.removeReactorChannel(reactorChannel);
                    reactorChannel.returnToPool();
                    this._reactorChannelQueue.remove(reactorChannel, ReactorChannel.REACTOR_CHANNEL_LINK);
                    int n = this.populateErrorInfo(errorInfo, -1, "Reactor.connect", "sendAuthTokenWorkerEvent() failed");
                    return n;
                }
            }
            if (this._reactorOptions.debuggerOptions().debugConnectionLevel()) {
                if (channel != null) {
                    this.debugger.writeDebugInfo("Reactor@%d, Reactor channel@%d connection executed on channel fd=%d.]\n", this.hashCode(), reactorChannel.hashCode(), ReactorDebugger.getChannelId(reactorChannel));
                } else {
                    this.debugger.writeDebugInfo("Reactor@%d, Reactor channel@%d is DOWN on channel fd=%d.]\n", this.hashCode(), reactorChannel.hashCode(), ReactorDebugger.getChannelId(reactorChannel));
                }
            }
            if (channel == null) {
                if (reactorChannel.server() == null && !reactorChannel.recoveryAttemptLimitReached()) {
                    reactorChannel.state(ReactorChannel.State.DOWN_RECONNECTING);
                    this.sendAndHandleChannelEventCallback("Reactor.connect", 3, reactorChannel, errorInfo);
                } else {
                    reactorChannel.state(ReactorChannel.State.DOWN);
                    this.sendAndHandleChannelEventCallback("Reactor.connect", 2, reactorChannel, errorInfo);
                }
            } else if (!this.sendWorkerEvent(WorkerEventTypes.CHANNEL_INIT, reactorChannel)) {
                reactorChannel.state(ReactorChannel.State.DOWN);
                this.sendAndHandleChannelEventCallback("Reactor.connect", 2, reactorChannel, errorInfo);
                this.removeReactorChannel(reactorChannel);
                reactorChannel.returnToPool();
                this._reactorChannelQueue.remove(reactorChannel, ReactorChannel.REACTOR_CHANNEL_LINK);
                int n = this.populateErrorInfo(errorInfo, -1, "Reactor.connect", "sendWorkerEvent() failed");
                return n;
            }
        }
        finally {
            this._reactorLock.unlock();
        }
        return 0;
    }

    static final boolean compareOAuthCredential(Reactor reactor, ReactorOAuthCredential current, ReactorOAuthCredential other, ReactorErrorInfo errorInfo) {
        if (current.reactorOAuthCredentialEventCallback() != other.reactorOAuthCredentialEventCallback()) {
            reactor.populateErrorInfo(errorInfo, -6, "Reactor.compareOAuthCredential", "The ReactorOAuthCredentialEventCallback of ReactorOAuthCredential is not equal for the existing token session.");
            return false;
        }
        if (current.reactorOAuthCredentialEventCallback() == null) {
            if (!current.clientSecret().equals(other.clientSecret())) {
                reactor.populateErrorInfo(errorInfo, -6, "Reactor.compareOAuthCredential", "The Client secret of ReactorOAuthCredential is not equal for the existing token session.");
                return false;
            }
            if (!current.password().equals(other.password())) {
                reactor.populateErrorInfo(errorInfo, -6, "Reactor.compareOAuthCredential", "The password of ReactorOAuthCredential is not equal for the existing token session.");
                return false;
            }
        }
        if (!current.clientId().equals(other.clientId())) {
            reactor.populateErrorInfo(errorInfo, -6, "Reactor.compareOAuthCredential", "The Client ID of ReactorOAuthCredential is not equal for the existing token session.");
            return false;
        }
        if (!current.tokenScope().equals(other.tokenScope())) {
            reactor.populateErrorInfo(errorInfo, -6, "Reactor.compareOAuthCredential", "The token scope of ReactorOAuthCredential is not equal for the existing token session.");
            return false;
        }
        if (current.takeExclusiveSignOnControl() != other.takeExclusiveSignOnControl()) {
            reactor.populateErrorInfo(errorInfo, -6, "Reactor.compareOAuthCredential", "The takeExclusiveSignOnControl of ReactorOAuthCredential is not equal for the existing token session.");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ReactorTokenSession getTokenSession(ReactorOAuthCredential oAuthCredential, ReactorErrorInfo errorInfo) {
        if (oAuthCredential.userName().length() == 0) return new ReactorTokenSession(this, oAuthCredential);
        try {
            String userName = oAuthCredential.userName().toString();
            this._tokenManagementLock.lock();
            ReactorTokenSession tokenSession = this._tokenManagementMap.get(oAuthCredential.userName().toString());
            if (tokenSession == null) {
                tokenSession = new ReactorTokenSession(this, oAuthCredential);
                this._tokenManagementMap.put(userName, tokenSession);
                return tokenSession;
            }
            if (!tokenSession.checkMiniumTimeForReissue(errorInfo)) {
                ReactorTokenSession reactorTokenSession = null;
                return reactorTokenSession;
            }
            if (Reactor.compareOAuthCredential(this, tokenSession.oAuthCredential(), oAuthCredential, errorInfo)) return tokenSession;
            ReactorTokenSession reactorTokenSession = null;
            return reactorTokenSession;
        }
        finally {
            this._tokenManagementLock.unlock();
        }
    }

    void removeTokenSession(ReactorTokenSession tokenSession) {
        if (tokenSession == null) {
            return;
        }
        this._tokenManagementLock.lock();
        try {
            this._tokenManagementMap.remove(tokenSession.oAuthCredential().userName().toString());
        }
        finally {
            this._tokenManagementLock.unlock();
        }
    }

    void removeAllTokenSession() {
        this._tokenManagementLock.lock();
        try {
            for (ReactorTokenSession tokenSession : this._tokenManagementMap.values()) {
                tokenSession.removeAllReactorChannel();
            }
            this._tokenManagementMap.clear();
        }
        finally {
            this._tokenManagementLock.unlock();
        }
    }

    int numberOfTokenSession() {
        this._tokenManagementLock.lock();
        try {
            int n = this._tokenManagementMap.size();
            return n;
        }
        finally {
            this._tokenManagementLock.unlock();
        }
    }

    void removeReactorChannel(ReactorChannel reactorChannel) {
        ReactorTokenSession tokenSession = reactorChannel.tokenSession();
        if (tokenSession != null && tokenSession.removeReactorChannel(reactorChannel) == 0) {
            this.removeTokenSession(tokenSession);
        }
    }

    static final boolean enableSessionManagement(ReactorConnectOptions reactorConnectOptions) {
        int i;
        for (i = 0; i < reactorConnectOptions.connectionList().size(); ++i) {
            if (!reactorConnectOptions.connectionList().get(i).enableSessionManagement()) continue;
            return true;
        }
        for (i = 0; i < reactorConnectOptions.reactorWarmStandbyGroupList().size(); ++i) {
            if (reactorConnectOptions.reactorWarmStandbyGroupList().get(i).startingActiveServer().reactorConnectInfo().enableSessionManagement()) {
                return true;
            }
            for (int j = 0; j < reactorConnectOptions.reactorWarmStandbyGroupList().get(i).standbyServerList().size(); ++j) {
                if (!reactorConnectOptions.reactorWarmStandbyGroupList().get(i).standbyServerList().get(j).reactorConnectInfo().enableSessionManagement()) continue;
                return true;
            }
        }
        return false;
    }

    ReactorOAuthCredential retriveOAuthCredentialFromConsumerRole(ReactorRole role, ReactorErrorInfo errorInfo) {
        Buffer clientJwk;
        Buffer userName;
        LoginRequest loginRequest = null;
        ReactorOAuthCredential oauthCredential = null;
        ReactorOAuthCredential oauthCredentialOut = null;
        if (role.type() == 1) {
            oauthCredential = ((ConsumerRole)role).reactorOAuthCredential();
            loginRequest = ((ConsumerRole)role).rdmLoginRequest();
        } else if (role.type() == 3) {
            this.populateErrorInfo(errorInfo, -6, "Reactor.copyOAuthCredentialForSessionManagement", "The session management supports only on the ReactorRoleTypes.CONSUMER type.");
            return null;
        }
        if (loginRequest == null && oauthCredential == null) {
            this.populateErrorInfo(errorInfo, -6, "Reactor.copyOAuthCredentialForSessionManagement", "There is no user credential available for enabling session management.");
            return null;
        }
        Buffer buffer = oauthCredential != null && oauthCredential.userName().length() != 0 ? oauthCredential.userName() : (userName = loginRequest != null && loginRequest.userName().length() != 0 ? loginRequest.userName() : null);
        Buffer password = oauthCredential != null && oauthCredential.password().length() != 0 ? oauthCredential.password() : (loginRequest != null && loginRequest.password().length() != 0 ? loginRequest.password() : null);
        Buffer clientId = oauthCredential != null && oauthCredential.clientId().length() != 0 ? oauthCredential.clientId() : ((ConsumerRole)role).clientId();
        Buffer clientSecret = oauthCredential != null && oauthCredential.clientSecret().length() != 0 ? oauthCredential.clientSecret() : null;
        Buffer buffer2 = clientJwk = oauthCredential != null && oauthCredential.clientJwk().length() != 0 ? oauthCredential.clientJwk() : null;
        if (!(clientSecret != null && clientSecret.length() != 0 || clientJwk != null && clientJwk.length() != 0)) {
            if (userName == null || userName.length() == 0) {
                this.populateErrorInfo(errorInfo, -6, "Reactor.copyOAuthCredentialForSessionManagement", "Failed to copy OAuth credential for enabling the session management; OAuth user name does not exist.");
                return null;
            }
            if (clientId == null || clientId.length() == 0) {
                this.populateErrorInfo(errorInfo, -6, "Reactor.copyOAuthCredentialForSessionManagement", "Failed to copy OAuth credential for enabling the session management; OAuth client ID does not exist.");
                return null;
            }
            if (password == null || password.length() == 0) {
                this.populateErrorInfo(errorInfo, -6, "Reactor.copyOAuthCredentialForSessionManagement", "Failed to copy OAuth credential for enabling the session management; OAuth password does not exist.");
                return null;
            }
            oauthCredentialOut = ReactorFactory.createReactorOAuthCredential();
            oauthCredentialOut.userName().data(userName.toString());
            oauthCredentialOut.password().data(password.toString());
            oauthCredentialOut.clientId().data(clientId.toString());
            if (oauthCredential != null) {
                if (oauthCredential.clientSecret().length() != 0) {
                    oauthCredentialOut.clientSecret().data(oauthCredential.clientSecret().toString());
                }
                if (oauthCredential.tokenScope().length() != 0) {
                    oauthCredentialOut.tokenScope().data(oauthCredential.tokenScope().toString());
                }
                oauthCredentialOut.takeExclusiveSignOnControl(oauthCredential.takeExclusiveSignOnControl());
                oauthCredentialOut.reactorOAuthCredentialEventCallback(oauthCredential.reactorOAuthCredentialEventCallback());
                oauthCredentialOut.userSpecObj(oauthCredential.userSpecObj());
            }
            return oauthCredentialOut;
        }
        if (!(clientSecret != null && clientSecret.length() != 0 || clientJwk != null && clientJwk.length() != 0)) {
            this.populateErrorInfo(errorInfo, -6, "Reactor.copyOAuthCredentialForSessionManagement", "Failed to copy OAuth credential for enabling the session management; OAuth client secret or JWK does not exist.");
            return null;
        }
        if (clientId == null || clientId.length() == 0) {
            this.populateErrorInfo(errorInfo, -6, "Reactor.copyOAuthCredentialForSessionManagement", "Failed to copy OAuth credential for enabling the session management; OAuth client Id does not exist.");
            return null;
        }
        oauthCredentialOut = ReactorFactory.createReactorOAuthCredential();
        if (clientSecret != null) {
            oauthCredentialOut.clientSecret().data(clientSecret.toString());
        }
        if (clientJwk != null) {
            oauthCredentialOut.clientJwk().data(clientJwk.toString());
        }
        oauthCredentialOut.clientId().data(clientId.toString());
        if (oauthCredential != null) {
            if (oauthCredential.tokenScope().length() != 0) {
                oauthCredentialOut.tokenScope().data(oauthCredential.tokenScope().toString());
            }
            if (oauthCredential.audience() != null && oauthCredential.audience().length() != 0) {
                oauthCredentialOut.audience().data(oauthCredential.audience().toString());
            }
            oauthCredentialOut.reactorOAuthCredentialEventCallback(oauthCredential.reactorOAuthCredentialEventCallback());
            oauthCredentialOut.userSpecObj(oauthCredential.userSpecObj());
        }
        return oauthCredentialOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int sessionManagementStartup(ReactorTokenSession tokenSession, ReactorConnectInfo reactorConnectInfo, ReactorRole role, ReactorChannel reactorChannel, boolean isBlocking, ReactorErrorInfo errorInfo) {
        LoginRequest loginRequest = null;
        if (role.type() == 1) {
            loginRequest = ((ConsumerRole)role).rdmLoginRequest();
        }
        if (loginRequest != null && reactorChannel._loginRequestForEDP == null) {
            reactorChannel._loginRequestForEDP = (LoginRequest)LoginMsgFactory.createMsg();
            reactorChannel._loginRequestForEDP.rdmMsgType(LoginMsgType.REQUEST);
            loginRequest.copy(reactorChannel._loginRequestForEDP);
            reactorChannel._loginRequestForEDP.userNameType(5);
            reactorChannel._loginRequestForEDP.flags(reactorChannel._loginRequestForEDP.flags() & 0xFFFFFFF7);
        }
        if (Reactor.requestServiceDiscovery(reactorConnectInfo)) {
            switch (reactorConnectInfo.connectOptions().connectionType()) {
                case 1: {
                    if (reactorConnectInfo.connectOptions().encryptionOptions().connectionType() == 7) {
                        reactorChannel.restConnectOptions().transport(2);
                        reactorChannel.restConnectOptions().dataFormat(2);
                        break;
                    }
                    reactorChannel.restConnectOptions().transport(1);
                    reactorChannel.restConnectOptions().dataFormat(1);
                    break;
                }
                default: {
                    this.populateErrorInfo(errorInfo, -5, "Reactor.connect", "Reactor.connect(): Invalid connection type: " + ConnectionTypes.toString((int)reactorConnectInfo.connectOptions().connectionType()) + " for requesting Delivery Platform service discovery.");
                    return -5;
                }
            }
        }
        tokenSession.lock();
        reactorChannel.state(ReactorChannel.State.EDP_RT);
        tokenSession.setProxyInfo(reactorConnectInfo, this._reactorOptions.restProxyOptions());
        try {
            if (tokenSession.sessionMgntState() == ReactorTokenSession.SessionState.REQUEST_TOKEN_FAILURE || tokenSession.sessionMgntState() == ReactorTokenSession.SessionState.STOP_TOKEN_REQUEST || tokenSession.sessionMgntState() == ReactorTokenSession.SessionState.REQ_AUTH_TOKEN_USING_PASSWORD || tokenSession.sessionMgntState() == ReactorTokenSession.SessionState.REQ_AUTH_TOKEN_USING_REFRESH_TOKEN || tokenSession.sessionMgntState() == ReactorTokenSession.SessionState.REQ_AUTH_TOKEN_USING_V2_CREDENTIAL) {
                int n = 0;
                return n;
            }
            if (!tokenSession.hasAccessToken()) {
                if (this._restClient.getAuthAccessTokenInfo(tokenSession.authOptoins(), tokenSession.restConnectOptions(), tokenSession.authTokenInfo(), isBlocking, errorInfo) != 0) {
                    int n = errorInfo.code();
                    return n;
                }
                if (!isBlocking) {
                    int n = 0;
                    return n;
                }
            }
        }
        finally {
            tokenSession.unlock();
        }
        if (Reactor.requestServiceDiscovery(reactorConnectInfo)) {
            if (this._restClient.getServiceDiscovery(reactorChannel.restConnectOptions(), tokenSession.authTokenInfo(), isBlocking, reactorChannel.reactorServiceEndpointInfoList(), errorInfo) != 0) {
                return errorInfo.code();
            }
            if (isBlocking) {
                if (reactorChannel.applyServiceDiscoveryEndpoint(reactorChannel.getCurrentReactorConnectInfo(), errorInfo) != 0) {
                    return errorInfo.code();
                }
                reactorChannel.state(ReactorChannel.State.EDP_RT_DONE);
            }
        } else {
            reactorChannel.state(ReactorChannel.State.EDP_RT_DONE);
        }
        return 0;
    }

    static boolean requestServiceDiscovery(ReactorConnectInfo reactorConnectInfo) {
        return reactorConnectInfo.connectOptions().unifiedNetworkInfo().address() == null && reactorConnectInfo.connectOptions().unifiedNetworkInfo().serviceName() == null || reactorConnectInfo.connectOptions().unifiedNetworkInfo().address() != null && reactorConnectInfo.connectOptions().unifiedNetworkInfo().address().equals("") && reactorConnectInfo.connectOptions().unifiedNetworkInfo().serviceName() != null && reactorConnectInfo.connectOptions().unifiedNetworkInfo().serviceName().equals("");
    }

    ReactorOptions reactorOptions() {
        return this._reactorOptions;
    }

    private static final int sendQueryServiceDiscoveryEvent(ReactorServiceDiscoveryOptions options, List<ReactorServiceEndpointInfo> reactorServiceEndpointInfoList, ReactorErrorInfo errorInfo) {
        ReactorServiceEndpointEvent reactorServiceEndpointEvent = ReactorFactory.createReactorServiceEndpointEvent();
        ReactorErrorInfo errorInfoTemp = reactorServiceEndpointEvent._errorInfo;
        if (reactorServiceEndpointInfoList != null) {
            reactorServiceEndpointEvent._reactorServiceEndpointInfoList = reactorServiceEndpointInfoList;
        } else {
            reactorServiceEndpointEvent._errorInfo = errorInfo;
        }
        reactorServiceEndpointEvent._userSpecObject = options.userSpecObject();
        options.reactorServiceEndpointEventCallback().reactorServiceEndpointEventCallback(reactorServiceEndpointEvent);
        reactorServiceEndpointEvent._errorInfo = errorInfoTemp;
        reactorServiceEndpointEvent.returnToPool();
        return errorInfo.code();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int queryServiceDiscovery(ReactorServiceDiscoveryOptions options, ReactorErrorInfo errorInfo) {
        this._reactorLock.lock();
        try {
            RestConnectOptions connOptions;
            ReactorAuthTokenInfo authTokenInfo;
            if (errorInfo == null) {
                int n = -5;
                return n;
            }
            if (!this._reactorActive) {
                int n = this.populateErrorInfo(errorInfo, -10, "Reactor.queryServiceDiscovery", "Reactor is not active, aborting.");
                return n;
            }
            if (options == null) {
                int n = this.populateErrorInfo(errorInfo, -5, "Reactor.queryServiceDiscovery", "Reactor.queryServiceDiscovery(): options cannot be null, aborting.");
                return n;
            }
            if (options.reactorServiceEndpointEventCallback() == null) {
                int n = this.populateErrorInfo(errorInfo, -5, "Reactor.queryServiceDiscovery", "Reactor.queryServiceDiscovery(): ReactorServiceEndpointEventCallback cannot be null, aborting.");
                return n;
            }
            if (options.userName() == null || options.userName().length() == 0) {
                if (options.clientId() == null || options.clientId().length() == 0) {
                    int n = this.populateErrorInfo(errorInfo, -5, "Reactor.queryServiceDiscovery", "Required parameter username or clientId are not set");
                    return n;
                }
            } else if (options.clientId() == null || options.clientId().length() == 0) {
                int n = this.populateErrorInfo(errorInfo, -5, "Reactor.queryServiceDiscovery", "Required parameter clientId is not set");
                return n;
            }
            if (!(options.password() != null && options.password().length() != 0 || options.clientSecret() != null && options.clientSecret().length() != 0 || options.clientJWK() != null && options.clientJWK().length() != 0)) {
                int n = this.populateErrorInfo(errorInfo, -5, "Reactor.queryServiceDiscovery", "Required parameter(one of the following) password, clientSecret, and clientJWK are not set");
                return n;
            }
            switch (options.transport()) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    this.populateErrorInfo(errorInfo, -4, "Reactor.queryServiceDiscovery", "Reactor.queryServiceDiscovery(): Invalid transport protocol type " + options.transport());
                    int n = -4;
                    return n;
                }
            }
            switch (options.dataFormat()) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    this.populateErrorInfo(errorInfo, -4, "Reactor.queryServiceDiscovery", "Reactor.queryServiceDiscovery(): Invalid dataformat protocol type " + options.dataFormat());
                    int n = -4;
                    return n;
                }
            }
            try {
                this.setupRestClient(errorInfo);
            }
            catch (Exception e) {
                int n = this.populateErrorInfo(errorInfo, -1, "Reactor.setupRestClient", "failed to initialize the RESTClient, exception=" + e.getLocalizedMessage());
                this._reactorLock.unlock();
                return n;
            }
            this._tokenManagementLock.lock();
            ReactorTokenSession tokenSession = null;
            try {
                tokenSession = this._tokenManagementMap.get(options.userName().toString());
            }
            finally {
                this._tokenManagementLock.unlock();
            }
            if (tokenSession == null) {
                RestAuthOptions authOptions = new RestAuthOptions(options.takeExclusiveSignOnControl());
                authTokenInfo = new ReactorAuthTokenInfo();
                connOptions = new RestConnectOptions(this.reactorOptions());
                if (options.userName() == null || options.userName().length() == 0) {
                    authTokenInfo.tokenVersion(ReactorAuthTokenInfo.TokenVersion.V2);
                } else {
                    authTokenInfo.tokenVersion(ReactorAuthTokenInfo.TokenVersion.V1);
                }
                authOptions.username(options.userName().toString());
                authOptions.password(options.password().toString());
                authOptions.clientId(options.clientId().toString());
                authOptions.clientSecret(options.clientSecret().toString());
                authOptions.clientJwk(options.clientJWK().toString());
                authOptions.audience(options.audience().toString());
                authOptions.tokenScope(options.tokenScope().toString());
                connOptions.applyServiceDiscoveryOptions(options, this._reactorOptions.restProxyOptions());
                if (this._restClient.getAuthAccessTokenInfo(authOptions, connOptions, authTokenInfo, true, errorInfo) != 0) {
                    Reactor.sendQueryServiceDiscoveryEvent(options, null, errorInfo);
                    int n = 0;
                    return n;
                }
            } else {
                authTokenInfo = tokenSession.authTokenInfo();
                connOptions = tokenSession.restConnectOptions();
            }
            this._reactorServiceEndpointInfoList.clear();
            if (this._restClient.getServiceDiscovery(connOptions, authTokenInfo, true, this._reactorServiceEndpointInfoList, errorInfo) != 0) {
                Reactor.sendQueryServiceDiscoveryEvent(options, null, errorInfo);
            } else {
                Reactor.sendQueryServiceDiscoveryEvent(options, this._reactorServiceEndpointInfoList, errorInfo);
            }
        }
        finally {
            this._reactorLock.unlock();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int submitOAuthCredentialRenewal(ReactorOAuthCredentialRenewalOptions renewalOptions, ReactorOAuthCredentialRenewal oAuthCredentialRenewal, ReactorErrorInfo errorInfo) {
        this._reactorLock.lock();
        try {
            ReactorTokenSession tokenSession = null;
            if (errorInfo == null) {
                int n = -5;
                return n;
            }
            if (!this._reactorActive) {
                int n = this.populateErrorInfo(errorInfo, -10, "Reactor.submitOAuthCredentialRenewal", "Reactor is not active, aborting.");
                return n;
            }
            if (renewalOptions == null) {
                int n = this.populateErrorInfo(errorInfo, -5, "Reactor.submitOAuthCredentialRenewal", "renewalOptions cannot be null, aborting.");
                return n;
            }
            if (oAuthCredentialRenewal == null) {
                int n = this.populateErrorInfo(errorInfo, -5, "Reactor.submitOAuthCredentialRenewal", "oAuthCredentialRenewal cannot be null, aborting.");
                return n;
            }
            tokenSession = this._tokenSessionForCredentialRenewalCallback;
            if (tokenSession == null) {
                if (!(oAuthCredentialRenewal.userName() != null && oAuthCredentialRenewal.userName().length() != 0 || oAuthCredentialRenewal.clientId() != null && oAuthCredentialRenewal.clientId().length() != 0)) {
                    int n = this.populateErrorInfo(errorInfo, -5, "Reactor.submitOAuthCredentialRenewal", "ReactorOAuthCredentialRenewal.userName() or clientId() not provided, aborting.");
                    return n;
                }
                if (oAuthCredentialRenewal.clientId() == null || oAuthCredentialRenewal.clientId().length() == 0) {
                    int n = this.populateErrorInfo(errorInfo, -5, "Reactor.submitOAuthCredentialRenewal", "ReactorOAuthCredentialRenewal.clientId() not provided, aborting.");
                    return n;
                }
                if (renewalOptions.reactorAuthTokenEventCallback() == null) {
                    int n = this.populateErrorInfo(errorInfo, -5, "Reactor.submitOAuthCredentialRenewal", "ReactorOAuthCredentialRenewalOptions.reactorAuthTokenEventCallback() not provided, aborting.");
                    return n;
                }
            }
            if (!(oAuthCredentialRenewal.password() != null && oAuthCredentialRenewal.password().length() != 0 || oAuthCredentialRenewal.clientSecret() != null && oAuthCredentialRenewal.clientSecret().length() != 0 || oAuthCredentialRenewal.clientJWK() != null && oAuthCredentialRenewal.clientJWK().length() != 0)) {
                int n = this.populateErrorInfo(errorInfo, -5, "Reactor.submitOAuthCredentialRenewal", "ReactorOAuthCredentialRenewal.password(), clientSecret() or clientJWK() not provided, aborting.");
                return n;
            }
            try {
                this.setupRestClient(errorInfo);
            }
            catch (Exception e) {
                int n = this.populateErrorInfo(errorInfo, -1, "Reactor.setupRestClient", "failed to initialize the RESTClient, exception=" + e.getLocalizedMessage());
                this._reactorLock.unlock();
                return n;
            }
            switch (renewalOptions.renewalModes()) {
                case 1: {
                    break;
                }
                case 2: {
                    if (tokenSession != null && tokenSession.oAuthCredential().reactorOAuthCredentialEventCallback() == null) {
                        int e = this.populateErrorInfo(errorInfo, -5, "Reactor.submitOAuthCredentialRenewal", "Support changing password of the token session when ReactorOAuthCredential.reactorOAuthCredentialEventCallback() is specified only., aborting.");
                        return e;
                    }
                    if (oAuthCredentialRenewal.newPassword() != null && !oAuthCredentialRenewal.newPassword().isBlank()) break;
                    int e = this.populateErrorInfo(errorInfo, -5, "Reactor.submitOAuthCredentialRenewal", "ReactorOAuthCredentialRenewal.newPassword() not provided, aborting.");
                    return e;
                }
                default: {
                    int e = this.populateErrorInfo(errorInfo, -5, "Reactor.submitOAuthCredentialRenewal", "Invalid ReactorOAuthCredentialRenewalOptions.RenewalModes(" + renewalOptions.renewalModes() + "), aborting.");
                    return e;
                }
            }
            ReactorOAuthCredentialRenewal oAuthCredentialRenewalCopy = Reactor.copyReactorOAuthCredentialRenewal(tokenSession, renewalOptions, oAuthCredentialRenewal);
            if (tokenSession != null) {
                tokenSession.sendAuthRequestWithSensitiveInfo(oAuthCredentialRenewalCopy.password().toString(), oAuthCredentialRenewalCopy.newPassword().toString(), oAuthCredentialRenewalCopy.clientSecret().toString(), oAuthCredentialRenewalCopy.clientJWK().toString());
            } else {
                RestAuthOptions restAuthOptions = new RestAuthOptions(oAuthCredentialRenewal.takeExclusiveSignOnControl());
                RestConnectOptions restConnectOptions = new RestConnectOptions(this._reactorOptions);
                ReactorAuthTokenInfo authTokenInfo = new ReactorAuthTokenInfo();
                restConnectOptions.applyProxyInfo(renewalOptions);
                restAuthOptions.username(oAuthCredentialRenewalCopy.userName().toString());
                restAuthOptions.clientId(oAuthCredentialRenewalCopy.clientId().toString());
                restAuthOptions.password(oAuthCredentialRenewalCopy.password().toString());
                restAuthOptions.newPassword(oAuthCredentialRenewalCopy.newPassword().toString());
                restAuthOptions.clientSecret(oAuthCredentialRenewalCopy.clientSecret().toString());
                restAuthOptions.clientJwk(oAuthCredentialRenewalCopy.clientJWK().toString());
                restAuthOptions.audience(oAuthCredentialRenewalCopy.audience().toString());
                if (!restAuthOptions.username().isEmpty()) {
                    authTokenInfo.tokenVersion(ReactorAuthTokenInfo.TokenVersion.V1);
                } else {
                    authTokenInfo.tokenVersion(ReactorAuthTokenInfo.TokenVersion.V2);
                }
                if (this._restClient.getAuthAccessTokenInfo(restAuthOptions, restConnectOptions, authTokenInfo, true, errorInfo) != 0) {
                    int n = errorInfo.code();
                    return n;
                }
                ReactorAuthTokenEventCallback callback = renewalOptions.reactorAuthTokenEventCallback();
                ReactorAuthTokenEvent reactorAuthTokenEvent = ReactorFactory.createReactorAuthTokenEvent();
                reactorAuthTokenEvent.reactorChannel(null);
                reactorAuthTokenEvent.reactorAuthTokenInfo(authTokenInfo);
                ReactorErrorInfo errorInfoTemp = reactorAuthTokenEvent._errorInfo;
                reactorAuthTokenEvent._errorInfo = errorInfo;
                callback.reactorAuthTokenEventCallback(reactorAuthTokenEvent);
                reactorAuthTokenEvent._errorInfo = errorInfoTemp;
                reactorAuthTokenEvent.returnToPool();
            }
            oAuthCredentialRenewalCopy.clear();
        }
        finally {
            this._reactorLock.unlock();
        }
        return 0;
    }

    private static ReactorOAuthCredentialRenewal copyReactorOAuthCredentialRenewal(ReactorTokenSession tokenSession, ReactorOAuthCredentialRenewalOptions renewalOptions, ReactorOAuthCredentialRenewal oAuthCredentialRenewal) {
        ReactorOAuthCredentialRenewal oAuthCredentialRenewalOut = new ReactorOAuthCredentialRenewal();
        if (tokenSession == null) {
            oAuthCredentialRenewalOut.userName().data(oAuthCredentialRenewal.userName().toString());
            oAuthCredentialRenewalOut.clientId().data(oAuthCredentialRenewal.clientId().toString());
            oAuthCredentialRenewalOut.tokenScope().data(oAuthCredentialRenewal.tokenScope().toString());
            oAuthCredentialRenewalOut.audience().data(oAuthCredentialRenewal.audience().toString());
        }
        oAuthCredentialRenewalOut.password().data(oAuthCredentialRenewal.password().toString());
        if (oAuthCredentialRenewal.clientSecret().length() != 0) {
            oAuthCredentialRenewalOut.clientSecret().data(oAuthCredentialRenewal.clientSecret().toString());
        }
        if (oAuthCredentialRenewal.clientJWK().length() != 0) {
            oAuthCredentialRenewalOut.clientJWK().data(oAuthCredentialRenewal.clientJWK().toString());
        }
        if (renewalOptions.renewalModes() == 2) {
            oAuthCredentialRenewalOut.newPassword().data(oAuthCredentialRenewal.newPassword().toString());
        }
        return oAuthCredentialRenewalOut;
    }

    private void setupRestClient(ReactorErrorInfo errorInfo) {
        if (this._restClient != null) {
            return;
        }
        this._restReactorOptions = new RestReactorOptions();
        this._restReactorOptions.connectTimeout(0);
        this._restReactorOptions.soTimeout(this._reactorOptions.restRequestTimeout());
        this._restClient = new RestClient(this._restReactorOptions, errorInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loginReissue(ReactorChannel reactorChannel, String authToken, ReactorErrorInfo errorInfo) {
        if (reactorChannel.state() == ReactorChannel.State.CLOSED || reactorChannel.state() == ReactorChannel.State.DOWN || reactorChannel.state() == ReactorChannel.State.EDP_RT) {
            return;
        }
        LoginRequest loginRequest = null;
        if (reactorChannel.enableSessionManagement()) {
            if (reactorChannel._loginRequestForEDP != null) {
                loginRequest = reactorChannel._loginRequestForEDP;
                loginRequest.userName().data(authToken);
            }
        } else {
            switch (reactorChannel.role().type()) {
                case 1: {
                    loginRequest = ((ConsumerRole)reactorChannel.role()).rdmLoginRequest();
                    break;
                }
                case 3: {
                    loginRequest = ((NIProviderRole)reactorChannel.role()).rdmLoginRequest();
                    break;
                }
            }
        }
        if (loginRequest != null) {
            this._reactorLock.lock();
            try {
                reactorChannel.watchlist().loginHandler().sendLoginRequest(true, errorInfo);
            }
            finally {
                this._reactorLock.unlock();
            }
        }
    }

    boolean sendAuthTokenWorkerEvent(ReactorTokenSession tokenSession) {
        boolean retVal = true;
        tokenSession.isInitialized(true);
        WorkerEvent event = ReactorFactory.createWorkerEvent();
        event.eventType(WorkerEventTypes.TOKEN_MGNT);
        event._restClient = this._restClient;
        event._tokenSession = tokenSession;
        retVal = this._workerQueue.write(event);
        return retVal;
    }

    boolean sendAuthTokenWorkerEvent(ReactorChannel reactorChannel, ReactorTokenSession tokenSession) {
        boolean retVal = true;
        tokenSession.isInitialized(true);
        WorkerEvent event = ReactorFactory.createWorkerEvent();
        event.eventType(WorkerEventTypes.TOKEN_MGNT);
        event._restClient = this._restClient;
        event._tokenSession = tokenSession;
        event._reactorChannel = reactorChannel;
        retVal = this._workerQueue.write(event);
        return retVal;
    }

    boolean sendAuthTokenEvent(ReactorChannel reactorChannel, ReactorTokenSession tokenSession, ReactorErrorInfo reactorErrorInfo) {
        boolean retVal = true;
        WorkerEvent event = ReactorFactory.createWorkerEvent();
        event.eventType(WorkerEventTypes.TOKEN_MGNT);
        event._restClient = this._restClient;
        event._tokenSession = tokenSession;
        event._reactorChannel = reactorChannel;
        this.populateErrorInfo(event.errorInfo(), reactorErrorInfo.code(), reactorErrorInfo.location(), reactorErrorInfo.error().text());
        retVal = this._workerQueue.remote().write(event);
        return retVal;
    }

    boolean sendWarmStandbyEvent(ReactorChannel reactorChannel, ReactorWarmStandbyEvent warmStandbyEvent, ReactorErrorInfo reactorErrorInfo) {
        boolean retVal = true;
        WorkerEvent event = ReactorFactory.createWorkerEvent();
        event.eventType(WorkerEventTypes.WARM_STANDBY);
        event._restClient = this._restClient;
        event._reactorChannel = reactorChannel;
        event._warmStandbyEventType = warmStandbyEvent.warmStandbyEventType();
        event._warmStandbyHandler = reactorChannel.warmStandByHandlerImpl;
        event._serviceId = warmStandbyEvent.serviceID;
        event._streamId = warmStandbyEvent.streamID;
        event._warmStandbyService = warmStandbyEvent.wsbService;
        this.populateErrorInfo(event.errorInfo(), reactorErrorInfo.code(), reactorErrorInfo.location(), reactorErrorInfo.error().text());
        retVal = this._workerQueue.remote().write(event);
        return retVal;
    }

    boolean sendCredentialRenewalEvent(ReactorTokenSession tokenSession, ReactorErrorInfo reactorErrorInfo) {
        boolean retVal = true;
        WorkerEvent event = ReactorFactory.createWorkerEvent();
        event.eventType(WorkerEventTypes.TOKEN_CREDENTIAL_RENEWAL);
        event._restClient = this._restClient;
        event._tokenSession = tokenSession;
        this.populateErrorInfo(event.errorInfo(), reactorErrorInfo.code(), reactorErrorInfo.location(), reactorErrorInfo.error().text());
        retVal = this._workerQueue.remote().write(event);
        return retVal;
    }

    boolean sendWorkerEvent(WorkerEventTypes eventType, ReactorChannel reactorChannel) {
        boolean retVal = true;
        WorkerEvent event = ReactorFactory.createWorkerEvent();
        event.eventType(eventType);
        event.reactorChannel(reactorChannel);
        retVal = this._workerQueue.write(event);
        return retVal;
    }

    boolean sendWorkerEvent(WorkerEventTypes eventType, ReactorChannel reactorChannel, long timeout) {
        boolean retVal = true;
        WorkerEvent event = ReactorFactory.createWorkerEvent();
        event.eventType(eventType);
        event.reactorChannel(reactorChannel);
        event.timeout(timeout);
        retVal = this._workerQueue.write(event);
        return retVal;
    }

    boolean sendWorkerEvent(WorkerEventTypes eventType, ReactorChannel reactorChannel, TunnelStream tunnelStream, long timeout) {
        boolean retVal = true;
        WorkerEvent event = ReactorFactory.createWorkerEvent();
        event.eventType(eventType);
        event.reactorChannel(reactorChannel);
        event.tunnelStream(tunnelStream);
        event.timeout(timeout);
        retVal = this._workerQueue.write(event);
        return retVal;
    }

    boolean sendDispatchNowEvent(ReactorChannel reactorChannel) {
        boolean retVal = true;
        WorkerEvent event = ReactorFactory.createWorkerEvent();
        event.eventType(WorkerEventTypes.TUNNEL_STREAM_DISPATCH_NOW);
        event.reactorChannel(reactorChannel);
        if (this._reactorOptions.debuggerOptions().debugTunnelStreamLevel()) {
            this.debugger.writeDebugInfo("Reactor@%d, Reactor channel@%d put a tunnel stream DISPATCH_NOW event on channel fd=%d.]\n", this.hashCode(), reactorChannel.hashCode(), ReactorDebugger.getChannelId(reactorChannel));
        }
        retVal = this._workerQueue.remote().write(event);
        return retVal;
    }

    boolean sendWatchlistDispatchNowEvent(ReactorChannel reactorChannel) {
        boolean retVal = true;
        WorkerEvent event = ReactorFactory.createWorkerEvent();
        event.eventType(WorkerEventTypes.WATCHLIST_DISPATCH_NOW);
        event.reactorChannel(reactorChannel);
        retVal = this._workerQueue.remote().write(event);
        return retVal;
    }

    boolean sendChannelWarningEvent(ReactorChannel reactorChannel, ReactorErrorInfo reactorErrorInfo) {
        boolean retVal = true;
        WorkerEvent event = ReactorFactory.createWorkerEvent();
        event._restClient = this._restClient;
        event.eventType(WorkerEventTypes.WARNING);
        event.reactorChannel(reactorChannel);
        this.populateErrorInfo(event.errorInfo(), reactorErrorInfo.code(), reactorErrorInfo.location(), reactorErrorInfo.error().text());
        retVal = this._workerQueue.remote().write(event);
        return retVal;
    }

    private int sendChannelEventCallback(int eventType, ReactorChannel reactorChannel, ReactorErrorInfo errorInfo) {
        ReactorChannelEvent reactorChannelEvent = ReactorFactory.createReactorChannelEvent();
        reactorChannelEvent.eventType(eventType);
        this.populateErrorInfo(reactorChannelEvent.errorInfo(), errorInfo.code(), errorInfo.location(), errorInfo.error().text());
        ReactorChannel callbackChannel = reactorChannel;
        if (reactorChannel.warmStandByHandlerImpl != null) {
            callbackChannel = reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl();
            if (reactorChannel.channel() == null && reactorChannel.selectableChannel() != null) {
                callbackChannel.selectableChannel(reactorChannel.selectableChannel());
            } else {
                callbackChannel.selectableChannelFromChannel(reactorChannel.channel());
            }
            callbackChannel.userSpecObj(reactorChannel.userSpecObj());
            callbackChannel.reactorChannelType(reactorChannel.reactorChannelType());
        }
        reactorChannelEvent.reactorChannel(callbackChannel);
        int retval = reactorChannel.role().channelEventCallback().reactorChannelEventCallback(reactorChannelEvent);
        reactorChannelEvent.returnToPool();
        return retval;
    }

    int sendAuthTokenEventCallback(ReactorChannel reactorChannel, ReactorAuthTokenInfo authTokenInfo, ReactorErrorInfo errorInfo) {
        int retval;
        ReactorAuthTokenEventCallback callback = reactorChannel.reactorAuthTokenEventCallback();
        if (callback != null && reactorChannel.enableSessionManagement()) {
            ReactorAuthTokenEvent reactorAuthTokenEvent = ReactorFactory.createReactorAuthTokenEvent();
            reactorAuthTokenEvent.reactorAuthTokenInfo(authTokenInfo);
            ReactorErrorInfo errorInfoTemp = reactorAuthTokenEvent._errorInfo;
            reactorAuthTokenEvent._errorInfo = errorInfo;
            ReactorChannel callbackChannel = reactorChannel;
            if (this.reactorHandlesWarmStandby(reactorChannel)) {
                callbackChannel = reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl();
                callbackChannel.selectableChannelFromChannel(reactorChannel.channel());
                callbackChannel.userSpecObj(reactorChannel.userSpecObj());
                callbackChannel.reactorChannelType(reactorChannel.reactorChannelType());
            }
            reactorAuthTokenEvent.reactorChannel(callbackChannel);
            retval = callback.reactorAuthTokenEventCallback(reactorAuthTokenEvent);
            reactorAuthTokenEvent._errorInfo = errorInfoTemp;
            reactorAuthTokenEvent.returnToPool();
            if (retval != 0) {
                this.populateErrorInfo(errorInfo, retval, "Reactor.sendAuthTokenEventCallback", "retval of " + retval + " is not a valid ReactorCallbackReturnCodes. This caused the Reactor to shutdown.");
                this.shutdown(errorInfo);
                return -1;
            }
        } else {
            retval = -2;
        }
        return retval;
    }

    int sendOAuthCredentialEventCallback(ReactorTokenSession tokenSession, ReactorErrorInfo errorInfo) {
        int retval = 0;
        ReactorOAuthCredential oAuthCredential = tokenSession.oAuthCredential();
        ReactorOAuthCredentialEventCallback callback = oAuthCredential.reactorOAuthCredentialEventCallback();
        if (callback != null) {
            ReactorOAuthCredentialEvent reactorOAuthCredentialEvent = ReactorFactory.createReactorOAuthCredentialEvent();
            reactorOAuthCredentialEvent.reactorOAuthCredentialRenewal(tokenSession.oAuthCredentialRenewal());
            reactorOAuthCredentialEvent.reactorChannel(null);
            reactorOAuthCredentialEvent._reactor = this;
            reactorOAuthCredentialEvent._userSpecObj = tokenSession.oAuthCredential().userSpecObj();
            ReactorErrorInfo errorInfoTemp = reactorOAuthCredentialEvent._errorInfo;
            reactorOAuthCredentialEvent._errorInfo = errorInfo;
            retval = callback.reactorOAuthCredentialEventCallback(reactorOAuthCredentialEvent);
            reactorOAuthCredentialEvent._errorInfo = errorInfoTemp;
            reactorOAuthCredentialEvent.returnToPool();
            if (retval != 0) {
                this.populateErrorInfo(errorInfo, retval, "Reactor.sendOAuthCredentialEventCallback", "retval of " + retval + " is not a valid ReactorCallbackReturnCodes. This caused the Reactor to shutdown.");
                this.shutdown(errorInfo);
                return -1;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int sendAndHandleChannelEventCallback(String location, int eventType, ReactorChannel reactorChannel, ReactorErrorInfo errorInfo) {
        int originalEventType = eventType;
        boolean closeChannelAfterCallback = false;
        boolean incrementWsbGroupIndex = false;
        boolean movingtoWsbGroupOrChanelSet = false;
        ReactorWarmStandbyHandler warmStandbyHandler = null;
        ReactorWarmStandbyGroupImpl warmStandbyGroupImpl = null;
        boolean sendCallbackToUser = true;
        if (eventType == 3) {
            if (reactorChannel.role().type() == 1) {
                ((ConsumerRole)reactorChannel.role()).receivedFieldDictionaryResp(false);
                ((ConsumerRole)reactorChannel.role()).receivedEnumDictionaryResp(false);
            } else if (reactorChannel.role().type() == 3) {
                ((NIProviderRole)reactorChannel.role()).receivedFieldDictionaryResp(false);
                ((NIProviderRole)reactorChannel.role()).receivedEnumDictionaryResp(false);
            }
        }
        if (eventType == 2 || eventType == 3) {
            if (reactorChannel.watchlist() == null) {
                this._tmpState.clear();
                this._tmpState.streamState(3);
                this._tmpState.dataState(2);
                this._tmpState.text().data("Channel closed.");
                TunnelStream tunnelStream = reactorChannel.tunnelStreamManager()._tunnelStreamList.start(TunnelStream.MANAGER_LINK);
                while (tunnelStream != null) {
                    this.sendAndHandleTunnelStreamStatusEventCallback(location, reactorChannel, tunnelStream, null, null, this._tmpState, errorInfo);
                    tunnelStream = reactorChannel.tunnelStreamManager()._tunnelStreamList.forth(TunnelStream.MANAGER_LINK);
                }
                if (!reactorChannel._preferredHostOptions.isPreferredHostEnabled()) {
                    reactorChannel._haveAttemptedFirstConnectionListEntry = true;
                }
            } else if (this.reactorHandlesWarmStandby(reactorChannel) && this._reactorActive) {
                warmStandbyHandler = reactorChannel.warmStandByHandlerImpl;
                warmStandbyGroupImpl = warmStandbyHandler.currentWarmStandbyGroupImpl();
                if (eventType == 2 && reactorChannel.reconnectAttemptLimit() != 0) {
                    int numberOfStandbyChannels;
                    boolean recoverChannel = false;
                    int warmStandbyChannelListSize = warmStandbyHandler.channelList().size();
                    int n = numberOfStandbyChannels = warmStandbyChannelListSize > 0 ? warmStandbyChannelListSize - 1 : 0;
                    if (reactorChannel.isStartingServerConfig) {
                        if (warmStandbyHandler.currentWarmStandbyGroupIndex() + 1 < warmStandbyHandler.getConnectionOptions().reactorWarmStandbyGroupList().size()) {
                            warmStandbyHandler.setMoveToNextWSBGroupState();
                            recoverChannel = true;
                        } else if (warmStandbyHandler.getConnectionOptions().connectionList().size() > 0) {
                            recoverChannel = true;
                        } else if (warmStandbyHandler.startingReactorChannel()._preferredHostOptions.isPreferredHostEnabled()) {
                            recoverChannel = true;
                            if (reactorChannel._currentPHTimerEvent != null) {
                                for (ReactorChannel wsbChannel : reactorChannel.warmStandByHandlerImpl.channelList()) {
                                    if (reactorChannel == wsbChannel || wsbChannel.state() == ReactorChannel.State.DOWN || wsbChannel.state() == ReactorChannel.State.DOWN_RECONNECTING) continue;
                                    reactorChannel._currentPHTimerEvent.reactorChannel(wsbChannel);
                                    wsbChannel._currentPHTimerEvent = reactorChannel._currentPHTimerEvent;
                                    reactorChannel._currentPHTimerEvent = null;
                                    break;
                                }
                            }
                            reactorChannel.resetReconnectTimers();
                        }
                        if (recoverChannel) {
                            warmStandbyHandler.setClosingStandbyChannelsState();
                            eventType = 3;
                        }
                        boolean isSelectedTeableChannelRemoved = true;
                        if (reactorChannel.selectableChannel() != null) {
                            isSelectedTeableChannelRemoved = warmStandbyHandler.mainReactorChannelImpl().warmStandbyChannelInfo().selectableChannelList().remove(reactorChannel.channel().selectableChannel());
                        }
                        if (!(Reactor.isWarmStandbyChannelClosed(warmStandbyHandler, reactorChannel) || reactorChannel.switchingToPreferredHost() || reactorChannel.switchingToPreferredWSBGroup())) {
                            eventType = 6;
                            if (!isSelectedTeableChannelRemoved) {
                                sendCallbackToUser = false;
                            }
                        } else if (eventType == 2 && reactorChannel._phForcingChannelDown) {
                            reactorChannel.warmStandByHandlerImpl.mainChannelState(1);
                            reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl().state(ReactorChannel.State.DOWN);
                            reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl().close(errorInfo);
                        } else if (eventType == 2) {
                            reactorChannel.warmStandByHandlerImpl.mainChannelState(1);
                            reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl().state(ReactorChannel.State.DOWN);
                        } else {
                            reactorChannel.warmStandByHandlerImpl.mainChannelState(2);
                            reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl().state(ReactorChannel.State.DOWN_RECONNECTING);
                        }
                        warmStandbyHandler.currentWarmStandbyGroupImpl().startingServerIsDown = true;
                    } else {
                        if (reactorChannel._currentPHTimerEvent != null) {
                            for (ReactorChannel wsbChannel : reactorChannel.warmStandByHandlerImpl.channelList()) {
                                if (reactorChannel == wsbChannel || wsbChannel.state() == ReactorChannel.State.DOWN || wsbChannel.state() == ReactorChannel.State.DOWN_RECONNECTING) continue;
                                reactorChannel._currentPHTimerEvent.reactorChannel(wsbChannel);
                                wsbChannel._currentPHTimerEvent = reactorChannel._currentPHTimerEvent;
                                reactorChannel._currentPHTimerEvent = null;
                                break;
                            }
                        }
                        if (warmStandbyHandler.currentWarmStandbyGroupIndex() + 1 < warmStandbyHandler.getConnectionOptions().reactorWarmStandbyGroupList().size() || warmStandbyHandler.hasConnectionList()) {
                            eventType = 3;
                        }
                        if (!Reactor.isWarmStandbyChannelClosed(warmStandbyHandler, reactorChannel)) {
                            if (reactorChannel.selectableChannel() != null) {
                                warmStandbyHandler.mainReactorChannelImpl().warmStandbyChannelInfo().selectableChannelList().remove(reactorChannel.channel().selectableChannel());
                            }
                            eventType = 6;
                        } else if ((warmStandbyHandler.getConnectionOptions().reactorWarmStandbyGroupList().size() > 1 || warmStandbyHandler.hasConnectionList()) && warmStandbyHandler.startingReactorChannel()._preferredHostOptions.isPreferredHostEnabled()) {
                            eventType = 3;
                            warmStandbyHandler.currentWarmStandbyGroupImpl().startingServerIsDown = true;
                            if (reactorChannel.selectableChannel() != null) {
                                warmStandbyHandler.mainReactorChannelImpl().warmStandbyChannelInfo().selectableChannelList().remove(reactorChannel.channel().selectableChannel());
                            }
                            warmStandbyHandler.setMoveToNextWSBGroupState();
                        }
                        closeChannelAfterCallback = true;
                        warmStandbyHandler.warmStandByHandlerLock().lock();
                        try {
                            warmStandbyHandler.channelList().remove(reactorChannel);
                        }
                        finally {
                            warmStandbyHandler.warmStandByHandlerLock().unlock();
                        }
                        warmStandbyGroupImpl.incrementClosingStandbyCount();
                    }
                    if (warmStandbyHandler.currentWarmStandbyGroupImpl().startingServerIsDown && (numberOfStandbyChannels == 0 || numberOfStandbyChannels == warmStandbyGroupImpl.closingStandbyCount() || reactorChannel._ignoreClosedStandbyCount)) {
                        int state = warmStandbyHandler.warmStandbyHandlerState();
                        warmStandbyHandler.warmStandbyHandlerState(state &= 0xFFFFFFDF);
                        reactorChannel._ignoreClosedStandbyCount = false;
                        movingtoWsbGroupOrChanelSet = true;
                        if (eventType != 2) {
                            if ((warmStandbyHandler.warmStandbyHandlerState() & 0x40) != 0) {
                                warmStandbyHandler.warmStandbyHandlerState(8);
                                warmStandbyHandler.startingReactorChannel().reactorChannelType(1);
                                warmStandbyHandler.startingReactorChannel().resetReconnectTimers();
                                incrementWsbGroupIndex = true;
                                this.queueRequestsForWSBGroupRecovery(warmStandbyHandler, errorInfo);
                                warmStandbyHandler.startingReactorChannel().sendReqFromQueue = false;
                            } else if (warmStandbyHandler.getConnectionOptions().connectionList().size() > 0) {
                                warmStandbyHandler.warmStandbyHandlerState(16);
                                warmStandbyHandler.startingReactorChannel().reactorChannelType(0);
                                warmStandbyHandler.startingReactorChannel().resetReconnectTimers();
                            }
                        }
                    } else if (reactorChannel._queueRequestsForDiscovery) {
                        reactorChannel._queueRequestsForDiscovery = false;
                        this.queueRequestsForWSBGroupRecovery(warmStandbyHandler, errorInfo);
                        warmStandbyHandler.startingReactorChannel().sendReqFromQueue = false;
                    }
                } else if (eventType == 3) {
                    if (reactorChannel.selectableChannel() != null) {
                        reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl().warmStandbyChannelInfo().selectableChannelList().remove(reactorChannel.selectableChannel());
                    }
                    if ((reactorChannel.warmStandByHandlerImpl.warmStandbyHandlerState() & 1) != 0 && !Reactor.isWarmStandbyChannelClosed(reactorChannel.warmStandByHandlerImpl, reactorChannel)) {
                        eventType = 6;
                    } else if (reactorChannel._queueRequestsForDiscovery) {
                        reactorChannel._queueRequestsForDiscovery = false;
                        this.queueRequestsForWSBGroupRecovery(warmStandbyHandler, errorInfo);
                        warmStandbyHandler.startingReactorChannel().sendReqFromQueue = false;
                    }
                } else if (!reactorChannel.isStartingServerConfig && reactorChannel.reconnectAttemptLimit() == 0 && !Reactor.isWarmStandbyChannelClosed(warmStandbyHandler, reactorChannel)) {
                    if (reactorChannel.selectableChannel() != null) {
                        warmStandbyHandler.mainReactorChannelImpl().warmStandbyChannelInfo().selectableChannelList().remove(reactorChannel.channel().selectableChannel());
                    }
                    eventType = 6;
                }
                if (reactorChannel.channel() != null && reactorChannel.channel().state() == -1) {
                    if (warmStandbyGroupImpl.warmStandbyMode() == 1) {
                        if (reactorChannel.isActiveServer) {
                            for (int i = 0; i < warmStandbyHandler.channelList().size(); ++i) {
                                ReactorChannel nextReactorChannel = warmStandbyHandler.channelList().get(i);
                                if (reactorChannel == nextReactorChannel || nextReactorChannel.channel() == null || nextReactorChannel.channel().state() != ReactorChannel.State.UP.ordinal()) continue;
                                ReactorWarmStandbyEvent reactorWarmStandbyEvent = this.reactorWarmStandbyEventPool.getEvent(errorInfo);
                                reactorChannel.warmStandByHandlerImpl.nextActiveReactorChannel(nextReactorChannel);
                                reactorWarmStandbyEvent.eventType = 2;
                                reactorWarmStandbyEvent.reactorChannel = reactorChannel;
                                reactorWarmStandbyEvent.nextReactorChannel = nextReactorChannel;
                                this.sendWarmStandbyEvent(reactorChannel, reactorWarmStandbyEvent, errorInfo);
                                break;
                            }
                        } else if (warmStandbyHandler.activeReactorChannel() == null) {
                            boolean selectedAsActiveServer = false;
                            if (warmStandbyGroupImpl.downloadConfigActiveServer == -1 && reactorChannel.isStartingServerConfig) {
                                selectedAsActiveServer = true;
                            } else if (!reactorChannel.isStartingServerConfig && warmStandbyGroupImpl.downloadConfigActiveServer == reactorChannel.standByServerListIndex) {
                                selectedAsActiveServer = true;
                            }
                            if (selectedAsActiveServer) {
                                for (int i = 0; i < warmStandbyHandler.channelList().size(); ++i) {
                                    ReactorChannel nextReactorChannel = warmStandbyHandler.channelList().get(i);
                                    if (reactorChannel == nextReactorChannel || nextReactorChannel.channel() == null || nextReactorChannel.channel().state() != 2) continue;
                                    ReactorWarmStandbyEvent reactorWarmStandbyEvent = this.reactorWarmStandbyEventPool.getEvent(errorInfo);
                                    reactorWarmStandbyEvent.eventType = 2;
                                    reactorWarmStandbyEvent.reactorChannel = reactorChannel;
                                    reactorWarmStandbyEvent.nextReactorChannel = nextReactorChannel;
                                    this.sendWarmStandbyEvent(reactorChannel, reactorWarmStandbyEvent, errorInfo);
                                    break;
                                }
                            }
                        }
                    } else {
                        ReactorWarmStandbyEvent reactorWarmStandbyEvent = this.reactorWarmStandbyEventPool.getEvent(errorInfo);
                        reactorWarmStandbyEvent.eventType = 5;
                        reactorWarmStandbyEvent.reactorChannel = reactorChannel;
                        this.sendWarmStandbyEvent(reactorChannel, reactorWarmStandbyEvent, errorInfo);
                    }
                }
            } else if (reactorChannel.warmStandByHandlerImpl != null) {
                if (!reactorChannel.isStartingServerConfig) {
                    closeChannelAfterCallback = true;
                    eventType = 3;
                }
                if (eventType == 2) {
                    reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl().state(ReactorChannel.State.DOWN);
                } else {
                    reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl().state(ReactorChannel.State.DOWN_RECONNECTING);
                    if (reactorChannel.selectableChannel() != null) {
                        reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl().warmStandbyChannelInfo().selectableChannelList().remove(reactorChannel.selectableChannel());
                    }
                }
            } else if (!reactorChannel._preferredHostOptions.isPreferredHostEnabled()) {
                reactorChannel._haveAttemptedFirstConnectionListEntry = true;
            }
            if (this._reactorOptions.debuggerOptions().debugConnectionLevel()) {
                this.debugger.writeDebugInfo("Reactor@%d, Reactor channel@%d is DOWN on channel fd=%d.]\n", this.hashCode(), reactorChannel.hashCode(), ReactorDebugger.getChannelId(reactorChannel));
            }
        } else if (eventType == 1) {
            if (this.reactorHandlesWarmStandby(reactorChannel) || reactorChannel.warmStandByHandlerImpl != null && reactorChannel._preferredHostOptions.isPreferredHostEnabled()) {
                reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl().warmStandbyChannelInfo().selectableChannelList().add(reactorChannel.selectableChannel());
                reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl().selectableChannelFromChannel(reactorChannel.channel());
                reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl().userSpecObj(reactorChannel.userSpecObj());
                if (reactorChannel.getCurrentReactorConnectInfo() == reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl().startingActiveServer().reactorConnectInfo()) {
                    reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl().startingServerIsDown = false;
                }
                if (reactorChannel._phSwitchingFromChannelListToWSB || reactorChannel._phSwitchingFromWSBToChannelList) {
                    reactorChannel.warmStandByHandlerImpl.mainChannelState(0);
                    if (reactorChannel._phSwitchingFromWSBToChannelList) {
                        reactorChannel.warmStandByHandlerImpl.setMovedToChannelList();
                    }
                    reactorChannel._phSwitchingFromChannelListToWSB = false;
                    reactorChannel._phSwitchingFromWSBToChannelList = false;
                }
                if (reactorChannel.warmStandByHandlerImpl.mainChannelState() < 3) {
                    reactorChannel.warmStandByHandlerImpl.mainChannelState(3);
                    reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl().state(ReactorChannel.State.UP);
                } else {
                    eventType = 6;
                    if ((reactorChannel.warmStandByHandlerImpl.ioCtlCodes() & 1) != 0) {
                        reactorChannel.channel().ioctl(1, reactorChannel.warmStandByHandlerImpl.maxNumBuffers(), errorInfo.error());
                    }
                    if ((reactorChannel.warmStandByHandlerImpl.ioCtlCodes() & 2) != 0) {
                        reactorChannel.channel().ioctl(2, reactorChannel.warmStandByHandlerImpl.numGuaranteedBuffers(), errorInfo.error());
                    }
                    if ((reactorChannel.warmStandByHandlerImpl.ioCtlCodes() & 4) != 0) {
                        reactorChannel.channel().ioctl(3, reactorChannel.warmStandByHandlerImpl.highWaterMark(), errorInfo.error());
                    }
                    if ((reactorChannel.warmStandByHandlerImpl.ioCtlCodes() & 8) != 0) {
                        reactorChannel.channel().ioctl(5, reactorChannel.warmStandByHandlerImpl.systemWriteBuffers(), errorInfo.error());
                    }
                    if ((reactorChannel.warmStandByHandlerImpl.ioCtlCodes() & 0x10) != 0) {
                        reactorChannel.channel().ioctl(4, reactorChannel.warmStandByHandlerImpl.systemReadBuffers(), errorInfo.error());
                    }
                    if ((reactorChannel.warmStandByHandlerImpl.ioCtlCodes() & 0x20) != 0) {
                        reactorChannel.channel().ioctl(9, reactorChannel.warmStandByHandlerImpl.compressionThreshold(), errorInfo.error());
                    }
                }
            } else if (reactorChannel.warmStandByHandlerImpl != null) {
                reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl().state(ReactorChannel.State.UP);
            } else if (!reactorChannel._preferredHostOptions.isPreferredHostEnabled()) {
                reactorChannel._haveAttemptedFirstConnectionListEntry = true;
            }
        } else if (eventType == 4) {
            if (this.reactorHandlesWarmStandby(reactorChannel)) {
                if (reactorChannel.warmStandByHandlerImpl.mainChannelState() == 3) {
                    reactorChannel.warmStandByHandlerImpl.mainChannelState(4);
                    reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl().state(ReactorChannel.State.READY);
                }
            } else if (reactorChannel.warmStandByHandlerImpl != null) {
                reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl().state(ReactorChannel.State.READY);
            }
        }
        if (eventType == 2 && reactorChannel._phForcingChannelDown && (reactorChannel.warmStandByHandlerImpl == null || reactorChannel._phForcingChannelDown_isStartingActive)) {
            eventType = 3;
        }
        if (eventType == 3 && reactorChannel._preferredHostOptions.isPreferredHostEnabled() && (reactorChannel._switchingToPreferredHost || reactorChannel._switchingToPreferredWSBGroup) && reactorChannel.preferredHostChannel() != null) {
            this.populateErrorInfo(errorInfo, 0, location, "Reactor has connected to Preferred Host, closing old connection.");
        }
        Channel tempHoldChannel = null;
        if ((originalEventType == 2 || originalEventType == 3) && (reactorChannel.warmStandByHandlerImpl != null && (reactorChannel.warmStandByHandlerImpl.startingReactorChannel().switchingToPreferredHost() || reactorChannel.warmStandByHandlerImpl.startingReactorChannel().switchingToPreferredWSBGroup()) || reactorChannel.switchingToPreferredHost() || reactorChannel.switchingToPreferredWSBGroup()) && reactorChannel.channel() != null && reactorChannel.channel().state() == 2) {
            tempHoldChannel = reactorChannel.channel();
            reactorChannel.channel(null);
        }
        int retval = 0;
        if (sendCallbackToUser) {
            retval = this.sendChannelEventCallback(eventType, reactorChannel, errorInfo);
            if (errorInfo._code == 0) {
                errorInfo.clear();
            }
        }
        if (this.reactorHandlesWarmStandby(reactorChannel) && (eventType == 6 || eventType == 1 || eventType == 3) && reactorChannel.selectableChannel() != null) {
            if (originalEventType != 1) {
                reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl().warmStandbyChannelInfo().oldSelectableChannelList().remove(reactorChannel.selectableChannel());
            } else {
                reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl().warmStandbyChannelInfo().oldSelectableChannelList().add(reactorChannel.selectableChannel());
            }
        } else if (reactorChannel.warmStandByHandlerImpl != null && (eventType == 6 || eventType == 1 || eventType == 3) && reactorChannel.selectableChannel() != null) {
            if (originalEventType != 1) {
                reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl().warmStandbyChannelInfo().oldSelectableChannelList().remove(reactorChannel.selectableChannel());
            } else {
                reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl().warmStandbyChannelInfo().oldSelectableChannelList().add(reactorChannel.selectableChannel());
            }
        } else if (eventType == 6 && reactorChannel.selectableChannel() != null) {
            reactorChannel.oldSelectableChannel(reactorChannel.selectableChannel());
        }
        if (originalEventType == 2 || originalEventType == 3) {
            if (reactorChannel.watchlist() != null) {
                reactorChannel.watchlist().channelDown();
            }
            if (tempHoldChannel != null) {
                reactorChannel.channel(tempHoldChannel);
            }
            if (this.reactorHandlesWarmStandby(reactorChannel) && this._reactorActive && warmStandbyGroupImpl.warmStandbyMode() == 1 && reactorChannel.isActiveServer) {
                reactorChannel.isActiveServer = false;
                reactorChannel.warmStandByHandlerImpl.activeReactorChannel(null);
            }
            if (incrementWsbGroupIndex && !reactorChannel._phForcingChannelDown && !reactorChannel.warmStandByHandlerImpl.startingReactorChannel()._preferredHostOptions.isPreferredHostEnabled()) {
                warmStandbyHandler.incrementWarmStandbyGroupIndex();
                if (warmStandbyHandler.currentWarmStandbyGroupImpl().warmStandbyMode() == 2) {
                    reactorChannel.copyActiveServiceOptions();
                }
            }
            if (reactorChannel.state() != ReactorChannel.State.CLOSED && !reactorChannel._phForcingChannelDown) {
                if (movingtoWsbGroupOrChanelSet && warmStandbyHandler != null) {
                    this.sendWorkerEvent(WorkerEventTypes.CHANNEL_DOWN, warmStandbyHandler.startingReactorChannel());
                } else {
                    this.sendWorkerEvent(WorkerEventTypes.CHANNEL_DOWN, reactorChannel);
                }
            } else if (reactorChannel._phForcingChannelDown && !reactorChannel._phForcingChannelDown_isStartingActive && reactorChannel.warmStandByHandlerImpl != null) {
                this.sendWorkerEvent(WorkerEventTypes.PREFERRED_HOST_CHANNEL_DOWN, reactorChannel);
            } else if (reactorChannel._phForcingChannelDown && reactorChannel.warmStandByHandlerImpl == null) {
                this.sendWorkerEvent(WorkerEventTypes.PREFERRED_HOST_CHANNEL_CLOSE, reactorChannel);
            } else if (reactorChannel._phForcingChannelDown && reactorChannel._phForcingChannelDown_isStartingActive && reactorChannel.warmStandByHandlerImpl != null) {
                this.sendWorkerEvent(WorkerEventTypes.PREFERRED_HOST_CHANNEL_CLOSE, reactorChannel);
            }
            reactorChannel._phForcingChannelDown = false;
            reactorChannel._phForcingChannelDown_isStartingActive = false;
        }
        if (closeChannelAfterCallback) {
            this.closeChannel(reactorChannel, errorInfo);
        }
        if (retval == -1) {
            this.populateErrorInfo(errorInfo, -1, location, "ReactorCallbackReturnCodes.FAILURE was returned from reactorChannelEventCallback(). This caused the Reactor to shutdown.");
            this.shutdown(errorInfo);
            return -1;
        }
        if (retval == -2) {
            this.populateErrorInfo(errorInfo, -1, location, "ReactorCallbackReturnCodes.RAISE is not a valid return code from reactorChannelEventCallback(). This caused the Reactor to shutdown.");
            this.shutdown(errorInfo);
            return -1;
        }
        if (retval != 0) {
            this.populateErrorInfo(errorInfo, -1, location, "retval of " + retval + " is not a valid ReactorCallbackReturnCodes. This caused the Reactor to shutdown.");
            this.shutdown(errorInfo);
            return -1;
        }
        return retval;
    }

    private int sendDefaultMsgCallback(ReactorChannel reactorChannel, TransportBuffer transportBuffer, Msg msg, WlRequest wlRequest) {
        StatusMsg statusMsg;
        boolean callbackToClient = this.warmStandbySendCallback(msg, wlRequest, reactorChannel);
        ReactorChannel callbackChannel = reactorChannel;
        if (callbackToClient) {
            ReactorMsgEvent reactorMsgEvent = ReactorFactory.createReactorMsgEvent();
            reactorMsgEvent.transportBuffer(transportBuffer);
            reactorMsgEvent.msg(msg);
            if (this.reactorHandlesWarmStandby(reactorChannel)) {
                callbackChannel = reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl();
                callbackChannel.selectableChannelFromChannel(reactorChannel.channel());
                callbackChannel.userSpecObj(reactorChannel.userSpecObj());
            }
            reactorMsgEvent.reactorChannel(callbackChannel);
            if (wlRequest != null) {
                reactorMsgEvent.streamInfo().serviceName(wlRequest.streamInfo().serviceName());
                reactorMsgEvent.streamInfo().userSpecObject(wlRequest.streamInfo().userSpecObject());
            } else {
                reactorMsgEvent.streamInfo().clear();
            }
            int retval = callbackChannel.role().defaultMsgCallback().defaultMsgCallback(reactorMsgEvent);
            reactorMsgEvent.returnToPool();
            return retval;
        }
        if (reactorChannel.warmStandByHandlerImpl.readMsgChannel() == reactorChannel && msg != null && msg.msgClass() == 3 && ((statusMsg = (StatusMsg)msg).state().streamState() == 4 || statusMsg.state().streamState() == 3 || statusMsg.state().streamState() == 5)) {
            ReactorWSRecoveryMsgInfo msgInfo = new ReactorWSRecoveryMsgInfo();
            msgInfo._containerType = 128;
            msgInfo._domainType = msg.domainType();
            msgInfo._streamId = msg.streamId();
            msgInfo._userSpecObject = wlRequest.streamInfo()._userSpecObject;
            msgInfo._flags |= 0x20;
            msgInfo._msgState.streamState(3);
            msgInfo._msgState.dataState(statusMsg.state().dataState());
            msgInfo._msgState.code(statusMsg.state().code());
            if (statusMsg.state().text().length() != 0) {
                ByteBuffer textBytes = ByteBuffer.allocate(statusMsg.state().text().length());
                statusMsg.state().text().copy(textBytes);
                msgInfo._msgState.text().data(textBytes);
            }
            if (wlRequest != null && !wlRequest.streamInfo()._serviceName.isEmpty()) {
                ByteBuffer serviceBytes = ByteBuffer.allocate(wlRequest.streamInfo()._serviceName.length());
                serviceBytes.put(wlRequest.streamInfo()._serviceName.getBytes());
                msgInfo._serviceName.data(serviceBytes);
            }
            if (msg.msgKey().flags() != 0) {
                msgInfo._flags |= 8;
                if ((msg.msgKey().flags() & 1) != 0) {
                    msgInfo._msgKey.applyHasServiceId();
                    msgInfo._msgKey.serviceId(msg.msgKey().serviceId());
                }
                if ((msg.msgKey().flags() & 2) != 0) {
                    ByteBuffer nameBytes = ByteBuffer.allocate(statusMsg.state().text().length());
                    statusMsg.state().text().copy(nameBytes);
                    msgInfo._msgKey.name().data(nameBytes);
                    msgInfo._msgKey.applyHasName();
                }
                if ((msg.msgKey().flags() & 4) != 0) {
                    msgInfo._msgKey.applyHasNameType();
                    msgInfo._msgKey.nameType(msg.msgKey().nameType());
                }
                if ((msg.msgKey().flags() & 8) != 0) {
                    msgInfo._msgKey.applyHasFilter();
                    msgInfo._msgKey.filter(msg.msgKey().filter());
                }
                if ((msg.msgKey().flags() & 0x10) != 0) {
                    msgInfo._msgKey.applyHasIdentifier();
                    msgInfo._msgKey.identifier(msg.msgKey().identifier());
                }
            }
            reactorChannel._watchlistRecoveryMsgList.add(msgInfo);
        }
        return 0;
    }

    int sendAndHandleDefaultMsgCallback(String location, ReactorChannel reactorChannel, TransportBuffer transportBuffer, Msg msg, WlRequest wlRequest, ReactorErrorInfo errorInfo) {
        this._tempWlInteger.value(msg.streamId());
        TunnelStream tunnelStream = reactorChannel.streamIdtoTunnelStreamTable().get(this._tempWlInteger);
        if (tunnelStream != null) {
            return this.handleTunnelStreamMsg(reactorChannel, tunnelStream, transportBuffer, msg, errorInfo);
        }
        int retval = this.sendDefaultMsgCallback(reactorChannel, transportBuffer, msg, wlRequest);
        if (retval == -1) {
            this.populateErrorInfo(errorInfo, -1, location, "ReactorCallbackReturnCodes.FAILURE was returned from defaultMsgCallback(). This caused the Reactor to shutdown.");
            this.shutdown(errorInfo);
            return -1;
        }
        if (retval == -2) {
            this.populateErrorInfo(errorInfo, -1, location, "ReactorCallbackReturnCodes.RAISE is not a valid return code from defaultMsgCallback(). This caused the Reactor to shutdown.");
            this.shutdown(errorInfo);
            return -1;
        }
        if (retval != 0) {
            this.populateErrorInfo(errorInfo, -1, location, "retval of " + retval + " is not a valid ReactorCallbackReturnCodes. This caused the Reactor to shutdown.");
            this.shutdown(errorInfo);
            return -1;
        }
        return retval;
    }

    int sendAndHandleDefaultMsgCallback(String location, ReactorChannel reactorChannel, TransportBuffer transportBuffer, Msg msg, ReactorErrorInfo errorInfo) {
        this._tempWlInteger.value(msg.streamId());
        TunnelStream tunnelStream = reactorChannel.streamIdtoTunnelStreamTable().get(this._tempWlInteger);
        if (tunnelStream != null) {
            return this.handleTunnelStreamMsg(reactorChannel, tunnelStream, transportBuffer, msg, errorInfo);
        }
        int retval = this.sendDefaultMsgCallback(reactorChannel, transportBuffer, msg, null);
        if (retval == -1) {
            this.populateErrorInfo(errorInfo, -1, location, "ReactorCallbackReturnCodes.FAILURE was returned from defaultMsgCallback(). This caused the Reactor to shutdown.");
            this.shutdown(errorInfo);
            return -1;
        }
        if (retval == -2) {
            this.populateErrorInfo(errorInfo, -1, location, "ReactorCallbackReturnCodes.RAISE is not a valid return code from defaultMsgCallback(). This caused the Reactor to shutdown.");
            this.shutdown(errorInfo);
            return -1;
        }
        if (retval != 0) {
            this.populateErrorInfo(errorInfo, -1, location, "retval of " + retval + " is not a valid ReactorCallbackReturnCodes. This caused the Reactor to shutdown.");
            this.shutdown(errorInfo);
            return -1;
        }
        return retval;
    }

    int sendTunnelStreamStatusEventCallback(ReactorChannel reactorChannel, TunnelStream tunnelStream, TransportBuffer transportBuffer, Msg msg, State state, LoginMsg loginMsg, ReactorErrorInfo errorInfo) {
        if (tunnelStream.statusEventCallback() == null) {
            return -1;
        }
        TunnelStreamStatusEvent tunnelStreamEvent = ReactorFactory.createTunnelStreamStatusEvent();
        this._tempWlInteger.value(tunnelStream.streamId());
        if (state != null && state.streamState() != 1 && reactorChannel.streamIdtoTunnelStreamTable().containsKey(this._tempWlInteger)) {
            tunnelStream.expireImmediateMessages(errorInfo.error());
            TunnelStream tempTunnelStream = reactorChannel.streamIdtoTunnelStreamTable().remove(this._tempWlInteger);
            tempTunnelStream.tableKey().returnToPool();
            if (state.streamState() != 4 && state.streamState() != 3) {
                tunnelStream.close(this._finalStatusEvent, errorInfo.error());
            } else {
                reactorChannel.tunnelStreamManager().removeTunnelStream(tunnelStream);
            }
            if (this._reactorOptions.debuggerOptions().debugTunnelStreamLevel()) {
                this.debugger.writeDebugInfo("Reactor@%d, Reactor channel@%d handles tunnel stream closes (stream ID=%d) on channel fd=%d.]\n", this.hashCode(), reactorChannel.hashCode(), tunnelStream.streamId(), ReactorDebugger.getChannelId(reactorChannel));
            }
        }
        tunnelStreamEvent.reactorChannel(reactorChannel);
        tunnelStreamEvent.transportBuffer(transportBuffer);
        tunnelStreamEvent.msg(msg);
        if (state != null) {
            state.copy(tunnelStreamEvent.state());
        }
        tunnelStreamEvent.tunnelStream(tunnelStream);
        if (loginMsg != null) {
            this._authInfo.clear();
            this._authInfo.loginMsg(loginMsg);
            tunnelStreamEvent.authInfo(this._authInfo);
        }
        int retval = tunnelStream.statusEventCallback().statusEventCallback(tunnelStreamEvent);
        this._authInfo.clear();
        tunnelStreamEvent.returnToPool();
        return retval;
    }

    int sendAndHandleTunnelStreamStatusEventCallback(String location, ReactorChannel reactorChannel, TunnelStream tunnelStream, TransportBuffer transportBuffer, Msg msg, State state, ReactorErrorInfo errorInfo) {
        int retval = this.sendTunnelStreamStatusEventCallback(reactorChannel, tunnelStream, transportBuffer, msg, state, null, errorInfo);
        if (retval == -1) {
            this.populateErrorInfo(errorInfo, -1, location, "ReactorCallbackReturnCodes.FAILURE was returned from tunnelStreamStatusEventCallback(). This caused the Reactor to shutdown.");
            this.shutdown(errorInfo);
            return -1;
        }
        if (retval == -2) {
            this.populateErrorInfo(errorInfo, -1, location, "ReactorCallbackReturnCodes.RAISE is not a valid return code from tunnelStreamStatusEventCallback(). This caused the Reactor to shutdown.");
            this.shutdown(errorInfo);
            return -1;
        }
        if (retval != 0) {
            this.populateErrorInfo(errorInfo, -1, location, "retval of " + retval + " is not a valid ReactorCallbackReturnCodes. This caused the Reactor to shutdown.");
            this.shutdown(errorInfo);
            return -1;
        }
        return retval;
    }

    private int sendTunnelStreamMsgCallback(ReactorChannel reactorChannel, TunnelStream tunnelStream, TransportBuffer transportBuffer, Msg msg, int containerType) {
        if (tunnelStream.defaultMsgCallback() == null) {
            return -1;
        }
        TunnelStreamMsgEvent tunnelStreamMsgEvent = ReactorFactory.createTunnelStreamMsgEvent();
        tunnelStreamMsgEvent.reactorChannel(reactorChannel);
        tunnelStreamMsgEvent.transportBuffer(transportBuffer);
        tunnelStreamMsgEvent.msg(msg);
        tunnelStreamMsgEvent.tunnelStream(tunnelStream);
        tunnelStreamMsgEvent.containerType(containerType);
        int retval = tunnelStream.defaultMsgCallback().defaultMsgCallback(tunnelStreamMsgEvent);
        tunnelStreamMsgEvent.returnToPool();
        return retval;
    }

    int sendAndHandleTunnelStreamMsgCallback(String location, ReactorChannel reactorChannel, TunnelStream tunnelStream, TransportBuffer transportBuffer, Msg msg, int containerType, ReactorErrorInfo errorInfo) {
        int retval = this.sendTunnelStreamMsgCallback(reactorChannel, tunnelStream, transportBuffer, msg, containerType);
        if (retval == -1) {
            this.populateErrorInfo(errorInfo, -1, location, "ReactorCallbackReturnCodes.FAILURE was returned from tunnelStreamDefaultMsgCallback(). This caused the Reactor to shutdown.");
            this.shutdown(errorInfo);
            return -1;
        }
        if (retval == -2) {
            this.populateErrorInfo(errorInfo, -1, location, "ReactorCallbackReturnCodes.RAISE is not a valid return code from tunnelStreamDefaultMsgCallback(). This caused the Reactor to shutdown.");
            this.shutdown(errorInfo);
            return -1;
        }
        if (retval != 0) {
            this.populateErrorInfo(errorInfo, -1, location, "retval of " + retval + " is not a valid ReactorCallbackReturnCodes. This caused the Reactor to shutdown.");
            this.shutdown(errorInfo);
            return -1;
        }
        return retval;
    }

    private int sendQueueMsgCallback(ReactorChannel reactorChannel, TunnelStream tunnelStream, TransportBuffer transportBuffer, Msg msg, QueueMsg queueMsg) {
        int retval;
        if (tunnelStream.queueMsgCallback() != null) {
            TunnelStreamQueueMsgEvent queueMsgEvent = ReactorFactory.createQueueMsgEvent();
            queueMsgEvent.reactorChannel(reactorChannel);
            queueMsgEvent.transportBuffer(transportBuffer);
            queueMsgEvent.msg(msg);
            queueMsgEvent.tunnelStream(tunnelStream);
            queueMsgEvent.queueMsg(queueMsg);
            retval = tunnelStream.queueMsgCallback().queueMsgCallback(queueMsgEvent);
            queueMsgEvent.returnToPool();
        } else {
            retval = -2;
        }
        return retval;
    }

    int sendAndHandleQueueMsgCallback(String location, ReactorChannel reactorChannel, TunnelStream tunnelStream, TransportBuffer transportBuffer, Msg msg, QueueMsg queueMsg, ReactorErrorInfo errorInfo) {
        int retval = this.sendQueueMsgCallback(reactorChannel, tunnelStream, transportBuffer, msg, queueMsg);
        if (retval == -1) {
            this.populateErrorInfo(errorInfo, -1, location, "ReactorCallbackReturnCodes.FAILURE was returned from queueMsgCallback(). This caused the Reactor to shutdown.");
            this.shutdown(errorInfo);
            return -1;
        }
        if (retval != -2 && retval != 0) {
            this.populateErrorInfo(errorInfo, -1, location, "retval of " + retval + " was returned from tunnelStreamQueueMsgCallback() and is not a valid ReactorCallbackReturnCodes. This caused the Reactor to shutdown.");
            this.shutdown(errorInfo);
            return -1;
        }
        return retval;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int sendLoginMsgCallback(ReactorChannel reactorChannel, TransportBuffer transportBuffer, Msg msg, LoginMsg loginMsg, WlRequest wlRequest) {
        int retval;
        RDMLoginMsgEvent rdmLoginMsgEvent;
        RDMLoginMsgCallback callback;
        boolean sendCallback;
        block79: {
            block61: {
                block64: {
                    block62: {
                        boolean responseMatch;
                        block77: {
                            block76: {
                                block78: {
                                    LoginRefresh refreshRdmMsg;
                                    block66: {
                                        block65: {
                                            block75: {
                                                block74: {
                                                    block73: {
                                                        block72: {
                                                            block71: {
                                                                block70: {
                                                                    block69: {
                                                                        block68: {
                                                                            block67: {
                                                                                block63: {
                                                                                    sendCallback = false;
                                                                                    callback = null;
                                                                                    switch (reactorChannel.role().type()) {
                                                                                        case 1: {
                                                                                            callback = ((ConsumerRole)reactorChannel.role()).loginMsgCallback();
                                                                                            break;
                                                                                        }
                                                                                        case 2: {
                                                                                            callback = ((ProviderRole)reactorChannel.role()).loginMsgCallback();
                                                                                            break;
                                                                                        }
                                                                                        case 3: {
                                                                                            callback = ((NIProviderRole)reactorChannel.role()).loginMsgCallback();
                                                                                            break;
                                                                                        }
                                                                                    }
                                                                                    rdmLoginMsgEvent = ReactorFactory.createRDMLoginMsgEvent();
                                                                                    rdmLoginMsgEvent.reactorChannel(reactorChannel);
                                                                                    rdmLoginMsgEvent.transportBuffer(transportBuffer);
                                                                                    rdmLoginMsgEvent.msg(msg);
                                                                                    rdmLoginMsgEvent.rdmLoginMsg(loginMsg);
                                                                                    if (wlRequest != null) {
                                                                                        rdmLoginMsgEvent.streamInfo().serviceName(wlRequest.streamInfo().serviceName());
                                                                                        rdmLoginMsgEvent.streamInfo().userSpecObject(wlRequest.streamInfo().userSpecObject());
                                                                                    } else {
                                                                                        rdmLoginMsgEvent.streamInfo().clear();
                                                                                    }
                                                                                    if (!this.reactorHandlesWarmStandby(reactorChannel)) break block61;
                                                                                    if (rdmLoginMsgEvent.rdmLoginMsg().rdmMsgType() != LoginMsgType.REFRESH) break block62;
                                                                                    refreshRdmMsg = (LoginRefresh)rdmLoginMsgEvent._loginMsg;
                                                                                    if (refreshRdmMsg.state().streamState() == 1 && refreshRdmMsg.state().dataState() == 1 && reactorChannel.warmStandByHandlerImpl.rdmLoginState().streamState() == 1 && reactorChannel.warmStandByHandlerImpl.rdmLoginState().dataState() == 2) {
                                                                                        refreshRdmMsg.state().copy(reactorChannel.warmStandByHandlerImpl.rdmLoginState());
                                                                                        sendCallback = true;
                                                                                    }
                                                                                    if (!refreshRdmMsg.features().checkHasSupportStandby()) {
                                                                                        ReactorWarmStandbyEvent reactorWarmStandbyEvent = this.reactorWarmStandbyEventPool.getEvent(rdmLoginMsgEvent.errorInfo());
                                                                                        this.populateErrorInfo(rdmLoginMsgEvent.errorInfo(), -1, "sendLoginMsgCallback", "The login response does not support warm standby functionality.");
                                                                                        reactorWarmStandbyEvent.eventType = 7;
                                                                                        this.sendWarmStandbyEvent(reactorChannel, reactorWarmStandbyEvent, rdmLoginMsgEvent.errorInfo());
                                                                                        rdmLoginMsgEvent.returnToPool();
                                                                                        return 0;
                                                                                    }
                                                                                    if (refreshRdmMsg.features().supportStandby() != 1L) {
                                                                                        ReactorWarmStandbyEvent reactorWarmStandbyEvent = this.reactorWarmStandbyEventPool.getEvent(rdmLoginMsgEvent.errorInfo());
                                                                                        reactorWarmStandbyEvent.eventType = 7;
                                                                                        this.populateErrorInfo(rdmLoginMsgEvent.errorInfo(), -1, "sendLoginMsgCallback", "The login response does not support the warm standby functionality.");
                                                                                        this.sendWarmStandbyEvent(reactorChannel, reactorWarmStandbyEvent, rdmLoginMsgEvent.errorInfo());
                                                                                        rdmLoginMsgEvent.returnToPool();
                                                                                        return 0;
                                                                                    }
                                                                                    if (refreshRdmMsg.features().checkHasSupportStandbyMode()) {
                                                                                        if ((refreshRdmMsg.features().supportStandbyMode() & 2L) != 2L && reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl().warmStandbyMode() == 2) {
                                                                                            ReactorWarmStandbyEvent reactorWarmStandbyEvent = this.reactorWarmStandbyEventPool.getEvent(rdmLoginMsgEvent.errorInfo());
                                                                                            this.populateErrorInfo(rdmLoginMsgEvent.errorInfo(), -1, "sendLoginMsgCallback", "The login response does not support Service-based warm standby functionality.");
                                                                                            reactorWarmStandbyEvent.eventType = 7;
                                                                                            this.sendWarmStandbyEvent(reactorChannel, reactorWarmStandbyEvent, rdmLoginMsgEvent.errorInfo());
                                                                                            rdmLoginMsgEvent.returnToPool();
                                                                                            return 0;
                                                                                        }
                                                                                        if ((refreshRdmMsg.features().supportStandbyMode() & 1L) != 1L && reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl().warmStandbyMode() == 1) {
                                                                                            ReactorWarmStandbyEvent reactorWarmStandbyEvent = this.reactorWarmStandbyEventPool.getEvent(rdmLoginMsgEvent.errorInfo());
                                                                                            reactorWarmStandbyEvent.eventType = 7;
                                                                                            this.populateErrorInfo(rdmLoginMsgEvent.errorInfo(), -1, "sendLoginMsgCallback", "The login response does not support Login-based warm standby functionality.");
                                                                                            this.sendWarmStandbyEvent(reactorChannel, reactorWarmStandbyEvent, rdmLoginMsgEvent.errorInfo());
                                                                                            rdmLoginMsgEvent.returnToPool();
                                                                                            return 0;
                                                                                        }
                                                                                    }
                                                                                    if ((reactorChannel.warmStandByHandlerImpl.warmStandbyHandlerState() & 1) != 0) break block63;
                                                                                    sendCallback = true;
                                                                                    reactorChannel.warmStandByHandlerImpl.rdmLoginRefresh(refreshRdmMsg);
                                                                                    reactorChannel.warmStandByHandlerImpl.setPrimaryLoginResponseState();
                                                                                    if (reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl().warmStandbyMode() == 1) {
                                                                                        reactorChannel._loginConsumerStatus.clear();
                                                                                        reactorChannel._loginConsumerStatus.streamId(msg.streamId());
                                                                                        reactorChannel._loginConsumerStatus.flags(1);
                                                                                        reactorChannel._loginConsumerStatus.warmStandbyInfo().warmStandbyMode(0L);
                                                                                        if (this.submitChannel(reactorChannel, reactorChannel._loginConsumerStatus, this.reactorSubmitOptions, rdmLoginMsgEvent.errorInfo()) < 0) {
                                                                                            if (reactorChannel.server() == null && !reactorChannel.recoveryAttemptLimitReached()) {
                                                                                                reactorChannel.state(ReactorChannel.State.DOWN_RECONNECTING);
                                                                                                this.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 3, reactorChannel, rdmLoginMsgEvent.errorInfo());
                                                                                                rdmLoginMsgEvent.returnToPool();
                                                                                                return 0;
                                                                                            }
                                                                                            reactorChannel.state(ReactorChannel.State.DOWN);
                                                                                            this.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 2, reactorChannel, rdmLoginMsgEvent.errorInfo());
                                                                                            rdmLoginMsgEvent.returnToPool();
                                                                                            return 0;
                                                                                        }
                                                                                        reactorChannel.isActiveServer = true;
                                                                                        reactorChannel.warmStandByHandlerImpl.activeReactorChannel(reactorChannel);
                                                                                    }
                                                                                    break block64;
                                                                                }
                                                                                responseMatch = true;
                                                                                if (!refreshRdmMsg.checkHasAttrib()) break block65;
                                                                                if (!reactorChannel.warmStandByHandlerImpl.rdmLoginRefresh().checkHasAttrib()) break block66;
                                                                                if (!refreshRdmMsg.attrib().checkHasSingleOpen()) break block67;
                                                                                if (reactorChannel.warmStandByHandlerImpl.rdmLoginRefresh().attrib().checkHasSingleOpen()) {
                                                                                    if (refreshRdmMsg.attrib().singleOpen() != reactorChannel.warmStandByHandlerImpl.rdmLoginRefresh().attrib().singleOpen()) {
                                                                                        responseMatch = false;
                                                                                    }
                                                                                    break block68;
                                                                                } else {
                                                                                    responseMatch = false;
                                                                                }
                                                                                break block68;
                                                                            }
                                                                            if (reactorChannel.warmStandByHandlerImpl.rdmLoginRefresh().attrib().checkHasSingleOpen()) {
                                                                                responseMatch = false;
                                                                            }
                                                                        }
                                                                        if (!refreshRdmMsg.attrib().checkHasAllowSuspectData()) break block69;
                                                                        if (reactorChannel.warmStandByHandlerImpl.rdmLoginRefresh().attrib().checkHasAllowSuspectData()) {
                                                                            if (refreshRdmMsg.attrib().allowSuspectData() != reactorChannel.warmStandByHandlerImpl.rdmLoginRefresh().attrib().allowSuspectData()) {
                                                                                responseMatch = false;
                                                                            }
                                                                            break block70;
                                                                        } else {
                                                                            responseMatch = false;
                                                                        }
                                                                        break block70;
                                                                    }
                                                                    if (reactorChannel.warmStandByHandlerImpl.rdmLoginRefresh().attrib().checkHasAllowSuspectData()) {
                                                                        responseMatch = false;
                                                                    }
                                                                }
                                                                if (!refreshRdmMsg.attrib().checkHasProvidePermissionExpressions()) break block71;
                                                                if (reactorChannel.warmStandByHandlerImpl.rdmLoginRefresh().attrib().checkHasProvidePermissionExpressions()) {
                                                                    if (refreshRdmMsg.attrib().providePermissionExpressions() != reactorChannel.warmStandByHandlerImpl.rdmLoginRefresh().attrib().providePermissionExpressions()) {
                                                                        responseMatch = false;
                                                                    }
                                                                    break block72;
                                                                } else {
                                                                    responseMatch = false;
                                                                }
                                                                break block72;
                                                            }
                                                            if (reactorChannel.warmStandByHandlerImpl.rdmLoginRefresh().attrib().checkHasProvidePermissionExpressions()) {
                                                                responseMatch = false;
                                                            }
                                                        }
                                                        if (!refreshRdmMsg.attrib().checkHasProvidePermissionProfile()) break block73;
                                                        if (reactorChannel.warmStandByHandlerImpl.rdmLoginRefresh().attrib().checkHasProvidePermissionProfile()) {
                                                            if (refreshRdmMsg.attrib().providePermissionProfile() != reactorChannel.warmStandByHandlerImpl.rdmLoginRefresh().attrib().providePermissionProfile()) {
                                                                responseMatch = false;
                                                            }
                                                            break block74;
                                                        } else {
                                                            responseMatch = false;
                                                        }
                                                        break block74;
                                                    }
                                                    if (reactorChannel.warmStandByHandlerImpl.rdmLoginRefresh().attrib().checkHasProvidePermissionProfile()) {
                                                        responseMatch = false;
                                                    }
                                                }
                                                if (!refreshRdmMsg.attrib().checkHasProvidePermissionProfile()) break block75;
                                                if (reactorChannel.warmStandByHandlerImpl.rdmLoginRefresh().attrib().checkHasProvidePermissionProfile()) {
                                                    if (refreshRdmMsg.attrib().providePermissionProfile() != reactorChannel.warmStandByHandlerImpl.rdmLoginRefresh().attrib().providePermissionProfile()) {
                                                        responseMatch = false;
                                                    }
                                                    break block66;
                                                } else {
                                                    responseMatch = false;
                                                }
                                                break block66;
                                            }
                                            if (reactorChannel.warmStandByHandlerImpl.rdmLoginRefresh().attrib().checkHasProvidePermissionProfile()) {
                                                responseMatch = false;
                                            }
                                            break block66;
                                        }
                                        if (reactorChannel.warmStandByHandlerImpl.rdmLoginRefresh().checkHasAttrib()) {
                                            responseMatch = false;
                                        }
                                    }
                                    if (!refreshRdmMsg.checkHasFeatures()) break block76;
                                    if (!reactorChannel.warmStandByHandlerImpl.rdmLoginRefresh().checkHasFeatures()) break block77;
                                    if (!refreshRdmMsg.features().checkHasSupportPost()) break block78;
                                    if (reactorChannel.warmStandByHandlerImpl.rdmLoginRefresh().features().checkHasSupportPost()) {
                                        if (refreshRdmMsg.features().supportOMMPost() != reactorChannel.warmStandByHandlerImpl.rdmLoginRefresh().features().supportOMMPost()) {
                                            responseMatch = false;
                                        }
                                        break block77;
                                    } else {
                                        responseMatch = false;
                                    }
                                    break block77;
                                }
                                if (reactorChannel.warmStandByHandlerImpl.rdmLoginRefresh().features().checkHasSupportPost()) {
                                    responseMatch = false;
                                }
                                break block77;
                            }
                            if (reactorChannel.warmStandByHandlerImpl.rdmLoginRefresh().checkHasFeatures()) {
                                responseMatch = false;
                            }
                        }
                        if (!responseMatch) {
                            ReactorWarmStandbyEvent reactorWarmStandbyEvent = this.reactorWarmStandbyEventPool.getEvent(rdmLoginMsgEvent.errorInfo());
                            reactorWarmStandbyEvent.eventType = 7;
                            this.populateErrorInfo(rdmLoginMsgEvent.errorInfo(), -1, "sendLoginMsgCallback", "The login response does not support the same features as the primary warm standby login.");
                            this.sendWarmStandbyEvent(reactorChannel, reactorWarmStandbyEvent, rdmLoginMsgEvent.errorInfo());
                            rdmLoginMsgEvent.returnToPool();
                            return 0;
                        }
                        if (reactorChannel.warmStandByHandlerImpl.activeReactorChannel() != null) {
                            if (reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl().warmStandbyMode() == 1) {
                                reactorChannel._loginConsumerStatus.clear();
                                reactorChannel._loginConsumerStatus.streamId(msg.streamId());
                                reactorChannel._loginConsumerStatus.flags(1);
                                reactorChannel._loginConsumerStatus.warmStandbyInfo().warmStandbyMode(1L);
                                if (this.submitChannel(reactorChannel, reactorChannel._loginConsumerStatus, this.reactorSubmitOptions, rdmLoginMsgEvent.errorInfo()) < 0) {
                                    if (reactorChannel.server() == null && !reactorChannel.recoveryAttemptLimitReached()) {
                                        reactorChannel.state(ReactorChannel.State.DOWN_RECONNECTING);
                                        this.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 3, reactorChannel, rdmLoginMsgEvent.errorInfo());
                                        rdmLoginMsgEvent.returnToPool();
                                        return 0;
                                    }
                                    reactorChannel.state(ReactorChannel.State.DOWN);
                                    this.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 2, reactorChannel, rdmLoginMsgEvent.errorInfo());
                                    rdmLoginMsgEvent.returnToPool();
                                    return 0;
                                }
                            }
                            break block64;
                        } else if (reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl().warmStandbyMode() == 1) {
                            reactorChannel._loginConsumerStatus.clear();
                            reactorChannel._loginConsumerStatus.streamId(msg.streamId());
                            reactorChannel._loginConsumerStatus.flags(1);
                            reactorChannel._loginConsumerStatus.warmStandbyInfo().warmStandbyMode(0L);
                            if (reactorChannel.submit(reactorChannel._loginConsumerStatus, this.reactorSubmitOptions, rdmLoginMsgEvent.errorInfo()) < 0) {
                                if (reactorChannel.server() == null && !reactorChannel.recoveryAttemptLimitReached()) {
                                    reactorChannel.state(ReactorChannel.State.DOWN_RECONNECTING);
                                    this.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 3, reactorChannel, rdmLoginMsgEvent.errorInfo());
                                    rdmLoginMsgEvent.returnToPool();
                                    return 0;
                                }
                                reactorChannel.state(ReactorChannel.State.DOWN);
                                this.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 2, reactorChannel, rdmLoginMsgEvent.errorInfo());
                                rdmLoginMsgEvent.returnToPool();
                                return 0;
                            }
                            reactorChannel.isActiveServer = true;
                            reactorChannel.warmStandByHandlerImpl.activeReactorChannel(reactorChannel);
                        }
                        break block64;
                    }
                    if (rdmLoginMsgEvent.rdmLoginMsg().rdmMsgType() == LoginMsgType.STATUS) {
                        LoginStatus statusRdmMsg = (LoginStatus)rdmLoginMsgEvent.rdmLoginMsg();
                        if (Reactor.isWarmStandbyChannelClosed(reactorChannel.warmStandByHandlerImpl, null)) {
                            sendCallback = true;
                            statusRdmMsg.state().copy(reactorChannel.warmStandByHandlerImpl.rdmLoginState());
                        } else {
                            if (statusRdmMsg.state().streamState() == 4) {
                                ReactorWarmStandbyEvent reactorWarmStandbyEvent = this.reactorWarmStandbyEventPool.getEvent(rdmLoginMsgEvent.errorInfo());
                                this.populateErrorInfo(rdmLoginMsgEvent.errorInfo(), -1, "sendLoginMsgCallback", "Server has rejected the Login request.");
                                reactorWarmStandbyEvent.eventType = 7;
                                this.sendWarmStandbyEvent(reactorChannel, reactorWarmStandbyEvent, rdmLoginMsgEvent.errorInfo());
                            }
                            if (reactorChannel.warmStandByHandlerImpl.channelList().size() == 1) {
                                sendCallback = true;
                                reactorChannel.warmStandByHandlerImpl.rdmLoginState().streamState(1);
                                reactorChannel.warmStandByHandlerImpl.rdmLoginState().dataState(2);
                            }
                        }
                    }
                }
                if (sendCallback) {
                    reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl().selectableChannelFromChannel(reactorChannel.channel());
                    reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl().userSpecObj(reactorChannel.userSpecObj());
                    rdmLoginMsgEvent.reactorChannel(reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl());
                }
                break block79;
            }
            sendCallback = true;
        }
        if (callback != null && sendCallback) {
            if (this.reactorHandlesWarmStandby(reactorChannel)) {
                rdmLoginMsgEvent.reactorChannel(reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl());
                if (reactorChannel.channel() != null) {
                    reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl().selectableChannelFromChannel(reactorChannel.channel());
                }
                reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl().userSpecObj(reactorChannel.userSpecObj());
            }
            retval = callback.rdmLoginMsgCallback(rdmLoginMsgEvent);
        } else {
            retval = sendCallback ? -2 : 0;
        }
        rdmLoginMsgEvent.returnToPool();
        return retval;
    }

    int sendAndHandleLoginMsgCallback(String location, ReactorChannel reactorChannel, TransportBuffer transportBuffer, Msg msg, LoginMsg loginMsg, WlRequest wlRequest, ReactorErrorInfo errorInfo) {
        int retval = this.sendLoginMsgCallback(reactorChannel, transportBuffer, msg, loginMsg, wlRequest);
        if (retval == -1) {
            this.populateErrorInfo(errorInfo, -1, location, "ReactorCallbackReturnCodes.FAILURE was returned from rdmLoginMsgCallback(). This caused the Reactor to shutdown.");
            this.shutdown(errorInfo);
            return -1;
        }
        if (retval != -2 && retval != 0) {
            this.populateErrorInfo(errorInfo, -1, location, "retval of " + retval + " was returned from rdmLoginMsgCallback() and is not a valid ReactorCallbackReturnCodes. This caused the Reactor to shutdown.");
            this.shutdown(errorInfo);
            return -1;
        }
        return retval;
    }

    int sendAndHandleLoginMsgCallback(String location, ReactorChannel reactorChannel, TransportBuffer transportBuffer, Msg msg, LoginMsg loginMsg, ReactorErrorInfo errorInfo) {
        int retval = this.sendLoginMsgCallback(reactorChannel, transportBuffer, msg, loginMsg, null);
        if (retval == -1) {
            this.populateErrorInfo(errorInfo, -1, location, "ReactorCallbackReturnCodes.FAILURE was returned from rdmLoginMsgCallback(). This caused the Reactor to shutdown.");
            this.shutdown(errorInfo);
            return -1;
        }
        if (retval != -2 && retval != 0) {
            this.populateErrorInfo(errorInfo, -1, location, "retval of " + retval + " was returned from rdmLoginMsgCallback() and is not a valid ReactorCallbackReturnCodes. This caused the Reactor to shutdown.");
            this.shutdown(errorInfo);
            return -1;
        }
        return retval;
    }

    private int sendDirectoryMsgCallback(ReactorChannel reactorChannel, TransportBuffer transportBuffer, Msg msg, DirectoryMsg directoryMsg, WlRequest wlRequest) {
        int retval;
        RDMDirectoryMsgCallback callback = null;
        switch (reactorChannel.role().type()) {
            case 1: {
                callback = ((ConsumerRole)reactorChannel.role()).directoryMsgCallback();
                break;
            }
            case 2: {
                callback = ((ProviderRole)reactorChannel.role()).directoryMsgCallback();
                break;
            }
            case 3: {
                break;
            }
        }
        if (callback != null) {
            ReactorChannel callbackChannel = reactorChannel;
            RDMDirectoryMsgEvent rdmDirectoryMsgEvent = ReactorFactory.createRDMDirectoryMsgEvent();
            rdmDirectoryMsgEvent.transportBuffer(transportBuffer);
            rdmDirectoryMsgEvent.msg(msg);
            rdmDirectoryMsgEvent.rdmDirectoryMsg(directoryMsg);
            if (this.reactorHandlesWarmStandby(reactorChannel)) {
                callbackChannel = reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl();
                callbackChannel.selectableChannelFromChannel(reactorChannel.channel());
                callbackChannel.userSpecObj(reactorChannel.userSpecObj());
                boolean isChannelClosed = Reactor.isWarmStandbyChannelClosed(reactorChannel.warmStandByHandlerImpl, null);
                ReactorWarmStandbyGroupImpl wsbGroup = reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl();
                if ((reactorChannel.warmStandByHandlerImpl.warmStandbyHandlerState() & 4) == 0 && (!isChannelClosed || reactorChannel._phSwitchingFromChannelListToWSB)) {
                    for (int i = 0; i < wsbGroup._updateServiceList.size(); ++i) {
                        wsbGroup._updateServiceList.get((int)i).updateServiceFilter = 0;
                    }
                    wsbGroup._updateServiceList.clear();
                } else {
                    if (reactorChannel.channel() == null || reactorChannel.channel().state() != 2) {
                        for (WlService watchlistService : reactorChannel.watchlist()._directoryHandler._serviceCache._serviceList) {
                            ReactorWSBService wsbService = wsbGroup._perServiceById.get(watchlistService._tableKey);
                            if (wsbService == null) continue;
                            if (wsbService.channels.contains(reactorChannel)) {
                                wsbService.channels.remove(reactorChannel);
                            }
                            if (wsbService.channels.size() != 0) continue;
                            wsbService.serviceAction = 3;
                            wsbGroup._updateServiceList.add(wsbService);
                        }
                    }
                    if (wsbGroup._updateServiceList.size() > 0) {
                        DirectoryUpdate updateMsg = (DirectoryUpdate)reactorChannel._wsbDirectoryUpdate;
                        updateMsg.clear();
                        updateMsg.streamId(directoryMsg.streamId());
                        for (int i = 0; i < wsbGroup._updateServiceList.size(); ++i) {
                            ReactorWSBService service = wsbGroup._updateServiceList.get(i);
                            service.serviceInfo.flags(service.updateServiceFilter);
                            service.serviceInfo.action(service.serviceAction);
                            if ((service.updateServiceFilter & 2) != 0) {
                                service.serviceState.copy(service.serviceInfo.state());
                            }
                            updateMsg.serviceList().add(service.serviceInfo);
                            service.updateServiceFilter = 0;
                            if (service.serviceInfo.action() != 3) continue;
                            wsbGroup._perServiceById.remove(service.serviceId);
                        }
                        rdmDirectoryMsgEvent.transportBuffer(null);
                        rdmDirectoryMsgEvent.msg(null);
                        rdmDirectoryMsgEvent.rdmDirectoryMsg(updateMsg);
                    } else {
                        return 0;
                    }
                }
            }
            rdmDirectoryMsgEvent.reactorChannel(callbackChannel);
            if (wlRequest != null) {
                rdmDirectoryMsgEvent.streamInfo().serviceName(wlRequest.streamInfo().serviceName());
                rdmDirectoryMsgEvent.streamInfo().userSpecObject(wlRequest.streamInfo().userSpecObject());
            } else {
                rdmDirectoryMsgEvent.streamInfo().clear();
            }
            retval = callback.rdmDirectoryMsgCallback(rdmDirectoryMsgEvent);
            if (this.reactorHandlesWarmStandby(reactorChannel)) {
                reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl()._updateServiceList.clear();
            }
            rdmDirectoryMsgEvent.returnToPool();
        } else {
            retval = -2;
        }
        return retval;
    }

    int sendAndHandleDirectoryMsgCallback(String location, ReactorChannel reactorChannel, TransportBuffer transportBuffer, Msg msg, DirectoryMsg directoryMsg, WlRequest wlRequest, ReactorErrorInfo errorInfo) {
        int retval = this.sendDirectoryMsgCallback(reactorChannel, transportBuffer, msg, directoryMsg, wlRequest);
        if (retval == -1) {
            this.populateErrorInfo(errorInfo, -1, location, "ReactorCallbackReturnCodes.FAILURE was returned from rdmDirectoryMsgCallback(). This caused the Reactor to shutdown.");
            this.shutdown(errorInfo);
            return -1;
        }
        if (retval != -2 && retval != 0) {
            this.populateErrorInfo(errorInfo, -1, location, "retval of " + retval + " was returned from rdmDirectoryMsgCallback() and is not a valid ReactorCallbackReturnCodes. This caused the Reactor to shutdown.");
            this.shutdown(errorInfo);
            return -1;
        }
        return retval;
    }

    int sendAndHandleDirectoryMsgCallback(String location, ReactorChannel reactorChannel, TransportBuffer transportBuffer, Msg msg, DirectoryMsg directoryMsg, ReactorErrorInfo errorInfo) {
        int retval = this.sendDirectoryMsgCallback(reactorChannel, transportBuffer, msg, directoryMsg, null);
        if (retval == -1) {
            this.populateErrorInfo(errorInfo, -1, location, "ReactorCallbackReturnCodes.FAILURE was returned from rdmDirectoryMsgCallback(). This caused the Reactor to shutdown.");
            this.shutdown(errorInfo);
            return -1;
        }
        if (retval != -2 && retval != 0) {
            this.populateErrorInfo(errorInfo, -1, location, "retval of " + retval + " was returned from rdmDirectoryMsgCallback() and is not a valid ReactorCallbackReturnCodes. This caused the Reactor to shutdown.");
            this.shutdown(errorInfo);
            return -1;
        }
        return retval;
    }

    private int sendDictionaryMsgCallback(ReactorChannel reactorChannel, TransportBuffer transportBuffer, Msg msg, DictionaryMsg dictionaryMsg, WlRequest wlRequest, ReactorErrorInfo errorInfo) {
        int retval;
        RDMDictionaryMsgCallback callback = null;
        boolean callbackToClient = this.warmStandbySendCallback(msg, wlRequest, reactorChannel);
        switch (reactorChannel.role().type()) {
            case 1: {
                callback = ((ConsumerRole)reactorChannel.role()).dictionaryMsgCallback();
                break;
            }
            case 2: {
                callback = ((ProviderRole)reactorChannel.role()).dictionaryMsgCallback();
                break;
            }
            case 3: {
                callback = ((NIProviderRole)reactorChannel.role()).dictionaryMsgCallback();
                break;
            }
        }
        if (callback != null) {
            DictionaryRefresh dictRefresh;
            if (this.reactorHandlesWarmStandby(reactorChannel) && dictionaryMsg.rdmMsgType() == DictionaryMsgType.REFRESH && (dictRefresh = (DictionaryRefresh)dictionaryMsg).checkHasInfo()) {
                switch (dictRefresh.dictionaryType()) {
                    case 1: {
                        if (callbackToClient) {
                            if ((reactorChannel.warmStandByHandlerImpl.warmStandbyHandlerState() & 0x80) != 0) break;
                            reactorChannel.warmStandByHandlerImpl.rdmFieldVersion(this.getMajorDictionaryVersion(dictRefresh.version()));
                            reactorChannel.warmStandByHandlerImpl.setReceivedPrimaryFieldDictionaryState();
                            break;
                        }
                        if ((reactorChannel.warmStandByHandlerImpl.warmStandbyHandlerState() & 0x80) == 0) break;
                        int majorVersion = this.getMajorDictionaryVersion(dictRefresh.version());
                        if (reactorChannel.warmStandByHandlerImpl.rdmFieldVersion() == majorVersion) break;
                        ReactorWarmStandbyEvent reactorWarmStandbyEvent = this.reactorWarmStandbyEventPool.getEvent(errorInfo);
                        this.populateErrorInfo(errorInfo, -1, "sendDictionaryMsgCallback", "The major version of field dictionary response from standby server does not match with the primary server.");
                        reactorWarmStandbyEvent.eventType = 7;
                        if (this.sendWarmStandbyEvent(reactorChannel, reactorWarmStandbyEvent, errorInfo)) break;
                        return -1;
                    }
                    case 2: {
                        if (!callbackToClient) break;
                        if ((reactorChannel.warmStandByHandlerImpl.warmStandbyHandlerState() & 0x100) == 0) {
                            reactorChannel.warmStandByHandlerImpl.rdmEnumTypeVersion(this.getMajorDictionaryVersion(dictRefresh.version()));
                            reactorChannel.warmStandByHandlerImpl.setReceivedPrimaryEnumDictionaryState();
                            break;
                        }
                        if ((reactorChannel.warmStandByHandlerImpl.warmStandbyHandlerState() & 0x100) == 0) break;
                        int majorVersion = this.getMajorDictionaryVersion(dictRefresh.version());
                        if (reactorChannel.warmStandByHandlerImpl.rdmEnumTypeVersion() == majorVersion) break;
                        ReactorWarmStandbyEvent reactorWarmStandbyEvent = this.reactorWarmStandbyEventPool.getEvent(errorInfo);
                        this.populateErrorInfo(errorInfo, -1, "sendDictionaryMsgCallback", "The major version of enum type dictionary response from standby server does not match with the primary server.");
                        reactorWarmStandbyEvent.eventType = 7;
                        if (this.sendWarmStandbyEvent(reactorChannel, reactorWarmStandbyEvent, errorInfo)) break;
                        return -1;
                    }
                }
            }
            if (callbackToClient) {
                ReactorChannel callbackChannel = reactorChannel;
                RDMDictionaryMsgEvent rdmDictionaryMsgEvent = ReactorFactory.createRDMDictionaryMsgEvent();
                rdmDictionaryMsgEvent.transportBuffer(transportBuffer);
                rdmDictionaryMsgEvent.msg(msg);
                rdmDictionaryMsgEvent.rdmDictionaryMsg(dictionaryMsg);
                if (this.reactorHandlesWarmStandby(reactorChannel)) {
                    callbackChannel = reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl();
                    callbackChannel.selectableChannelFromChannel(reactorChannel.channel());
                    callbackChannel.userSpecObj(reactorChannel.userSpecObj());
                }
                rdmDictionaryMsgEvent.reactorChannel(callbackChannel);
                if (wlRequest != null) {
                    rdmDictionaryMsgEvent.streamInfo().serviceName(wlRequest.streamInfo().serviceName());
                    rdmDictionaryMsgEvent.streamInfo().userSpecObject(wlRequest.streamInfo().userSpecObject());
                } else {
                    rdmDictionaryMsgEvent.streamInfo().clear();
                }
                retval = callback.rdmDictionaryMsgCallback(rdmDictionaryMsgEvent);
                rdmDictionaryMsgEvent.returnToPool();
            } else {
                retval = 0;
            }
        } else {
            retval = -2;
        }
        return retval;
    }

    int sendAndHandleDictionaryMsgCallback(String location, ReactorChannel reactorChannel, TransportBuffer transportBuffer, Msg msg, DictionaryMsg dictionaryMsg, WlRequest wlRequest, ReactorErrorInfo errorInfo) {
        int retval = this.sendDictionaryMsgCallback(reactorChannel, transportBuffer, msg, dictionaryMsg, wlRequest, errorInfo);
        if (retval == -1) {
            this.populateErrorInfo(errorInfo, -1, location, "ReactorCallbackReturnCodes.FAILURE was returned from rdmDictionaryMsgCallback(). This caused the Reactor to shutdown.");
            this.shutdown(errorInfo);
            return -1;
        }
        if (retval != -2 && retval != 0) {
            this.populateErrorInfo(errorInfo, -1, location, "retval of " + retval + " was returned from rdmDictionaryMsgCallback() and is not a valid ReactorCallbackReturnCodes. This caused the Reactor to shutdown.");
            this.shutdown(errorInfo);
            return -1;
        }
        return retval;
    }

    private int sendAndHandleDictionaryMsgCallback(String location, ReactorChannel reactorChannel, TransportBuffer transportBuffer, Msg msg, DictionaryMsg dictionaryMsg, ReactorErrorInfo errorInfo) {
        int retval = this.sendDictionaryMsgCallback(reactorChannel, transportBuffer, msg, dictionaryMsg, null, errorInfo);
        if (retval == -1) {
            this.populateErrorInfo(errorInfo, -1, location, "ReactorCallbackReturnCodes.FAILURE was returned from rdmDictionaryMsgCallback(). This caused the Reactor to shutdown.");
            this.shutdown(errorInfo);
            return -1;
        }
        if (retval != -2 && retval != 0) {
            this.populateErrorInfo(errorInfo, -1, location, "retval of " + retval + " was returned from rdmDictionaryMsgCallback() and is not a valid ReactorCallbackReturnCodes. This caused the Reactor to shutdown.");
            this.shutdown(errorInfo);
            return -1;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int dispatchChannel(ReactorChannel reactorChannel, ReactorDispatchOptions dispatchOptions, ReactorErrorInfo errorInfo) {
        this._reactorLock.lock();
        if (this._reactorOptions.debuggerOptions().debugConnectionLevel()) {
            this.debugger.incNumOfDispatchCalls();
        }
        try {
            if (reactorChannel.state() == ReactorChannel.State.CLOSED) {
                int n = this.populateErrorInfo(errorInfo, -1, "Reactor.dispatchChannel", "ReactorChannel is closed, aborting.");
                return n;
            }
            if (reactorChannel != this._reactorChannel) {
                if (this._reactorOptions.debuggerOptions().debugEventQueueLevel()) {
                    this.debugger.writeDebugInfo("Reactor@%d, Per Reactor channel@%d event count %d to be dispatched on channel fd=%d.]\n", this.hashCode(), reactorChannel.hashCode(), this._workerQueue.countNumberOfReadQueueElements(node -> ((WorkerEvent)node).reactorChannel() == reactorChannel), ReactorDebugger.getChannelId(reactorChannel));
                }
                int maxMessages = dispatchOptions.maxMessages();
                int msgCount = 0;
                int retval = 0;
                if (!this.isReactorChannelReady(reactorChannel)) {
                    ReactorChannel.State currentState = reactorChannel.state();
                    if (currentState != ReactorChannel.State.EDP_RT && currentState != ReactorChannel.State.EDP_RT_DONE && currentState != ReactorChannel.State.EDP_RT_FAILED) {
                        if (reactorChannel.warmStandByHandlerImpl != null) {
                            if (reactorChannel.warmStandByHandlerImpl.startingReactorChannel().preferredHostChannel() != null || reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl().preferredHostChannel() != null) {
                                int n = retval;
                                return n;
                            }
                            if (reactorChannel.warmStandByHandlerImpl.startingReactorChannel()._switchingToPreferredHost || reactorChannel.warmStandByHandlerImpl.startingReactorChannel()._switchingToPreferredWSBGroup) {
                                int n = retval;
                                return n;
                            }
                        } else {
                            if (reactorChannel.preferredHostChannel() != null) {
                                int n = retval;
                                return n;
                            }
                            if (reactorChannel._switchingToPreferredHost || reactorChannel._switchingToPreferredWSBGroup) {
                                int n = retval;
                                return n;
                            }
                        }
                        int n = this.populateErrorInfo(errorInfo, -1, "Reactor.dispatchChannel", "ReactorChannel is not active, aborting.");
                        return n;
                    }
                    int n = retval;
                    return n;
                }
                do {
                    retval = this.performChannelRead(reactorChannel, dispatchOptions.readArgs(), errorInfo);
                } while (this.isReactorChannelReady(reactorChannel) && ++msgCount < maxMessages && retval > 0);
                int n = retval;
                return n;
            }
            if (this._reactorOptions.debuggerOptions().debugEventQueueLevel()) {
                this.debugger.writeDebugInfo("Reactor@%d, reactor event count %d to be dispatched.]\n", this.hashCode(), this._workerQueue.countNumberOfReadQueueElements(node -> ((WorkerEvent)node).reactorChannel() == this._reactorChannel));
                this.debugger.writeDebugInfo("Reactor@%d, %d events to be dispatched from active channels event queue.]\n", this.hashCode(), this._workerQueue.countNumberOfReadQueueElements(node -> ((WorkerEvent)node).reactorChannel() != this._reactorChannel && ((WorkerEvent)node).reactorChannel() != null));
            }
            int maxMessages = dispatchOptions.maxMessages();
            int retval = 0;
            for (int msgCount = 0; msgCount < maxMessages && this._workerQueue.readQueueSize() > 0; ++msgCount) {
                retval = this.processWorkerEvent(errorInfo);
                if (retval >= 0) continue;
                int n = retval;
                return n;
            }
            int n = this._workerQueue.readQueueSize();
            return n;
        }
        finally {
            this._reactorLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int submitChannel(ReactorChannel reactorChannel, TransportBuffer buffer, ReactorSubmitOptions submitOptions, ReactorErrorInfo errorInfo) {
        int ret = 0;
        TransportBuffer writeBuffer = buffer;
        boolean releaseUserBuffer = false;
        this._reactorLock.lock();
        try {
            if (!this.isReactorChannelReady(reactorChannel)) {
                ret = -1;
                int n = this.populateErrorInfo(errorInfo, -1, "Reactor.submitChannel", "ReactorChannel is closed, aborting.");
                return n;
            }
            if (reactorChannel != this._reactorChannel) {
                boolean isPackedBuffer;
                ReactorPackedBuffer packedBufferImpl = null;
                boolean bl = this.packedBufferHashMap.size() == 0 ? false : (isPackedBuffer = (packedBufferImpl = this.packedBufferHashMap.get(buffer)) != null);
                if (isPackedBuffer && packedBufferImpl.nextRWFBufferPosition() == 0) {
                    isPackedBuffer = false;
                }
                if (reactorChannel.channel().protocolType() == 2 && !isPackedBuffer) {
                    TransportBuffer writeAgainBuffer;
                    TransportBuffer transportBuffer = writeAgainBuffer = this.writeCallAgainMap.size() > 0 ? this.writeCallAgainMap.remove(buffer) : null;
                    if (Objects.isNull(writeAgainBuffer)) {
                        if (Objects.isNull(this.jsonConverter)) {
                            int n = this.populateErrorInfo(errorInfo, -1, "Reactor.submitChannel", "The JSON converter library has not been initialized properly.");
                            return n;
                        }
                        this.jsonDecodeMsg.clear();
                        this._dIter.clear();
                        ret = this._dIter.setBufferAndRWFVersion(buffer, reactorChannel.majorVersion(), reactorChannel.minorVersion());
                        ret = this.jsonDecodeMsg.decode(this._dIter);
                        if (ret == 0) {
                            this.converterError.clear();
                            this.rwfToJsonOptions.clear();
                            this.rwfToJsonOptions.setJsonProtocolType(2);
                            if (this.jsonConverter.convertRWFToJson(this.jsonDecodeMsg, this.rwfToJsonOptions, this.conversionResults, this.converterError) != 0) {
                                int n = this.populateErrorInfo(errorInfo, -1, "Reactor.submitChannel", "Failed to convert RWF to JSON protocol. Error text: " + this.converterError.getText());
                                return n;
                            }
                            TransportBuffer jsonBuffer = reactorChannel.getBuffer(this.conversionResults.getLength(), false, errorInfo);
                            if (Objects.isNull(jsonBuffer)) {
                                int n = this.populateErrorInfo(errorInfo, -1, "Reactor.submitChannel", "Failed to get a buffer for sending JSON message. Error text: " + errorInfo.error().text());
                                return n;
                            }
                            this.getJsonMsgOptions.clear();
                            this.getJsonMsgOptions.jsonProtocolType(2);
                            this.getJsonMsgOptions.isCloseMsg(this.jsonDecodeMsg.msgClass() == 5);
                            if (this.jsonConverter.getJsonBuffer(jsonBuffer, this.getJsonMsgOptions, this.converterError) != 0) {
                                int n = this.populateErrorInfo(errorInfo, -1, "Reactor.submitChannel", "Failed to get converted JSON message. Error text: " + this.converterError.getText());
                                return n;
                            }
                            releaseUserBuffer = true;
                            writeBuffer = jsonBuffer;
                        }
                    } else {
                        releaseUserBuffer = true;
                        writeBuffer = writeAgainBuffer;
                    }
                }
                if ((this._reactorOptions.xmlTracing() || this._reactorOptions.xmlTraceToFile()) && this._reactorOptions.xmlTraceWrite()) {
                    this.xmlString.setLength(0);
                    this.xmlString.append("\n<!-- Outgoing Reactor message -->\n").append("<!-- ").append(reactorChannel.selectableChannel().toString()).append(" -->\n").append("<!-- ").append(new Date()).append(" -->\n");
                    this.xmlDumpTrace.dumpBuffer(reactorChannel.channel(), reactorChannel.channel().protocolType(), writeBuffer, null, this.xmlString, errorInfo.error());
                    if (this._reactorOptions.xmlTracing()) {
                        System.out.println(this.xmlString);
                    }
                    if (this._reactorOptions.xmlTraceToFile()) {
                        this._fileDumper.dump(this.xmlString.toString());
                    }
                }
                if ((ret = reactorChannel.channel().write(writeBuffer, submitOptions.writeArgs(), errorInfo.error())) > 0 || ret == -9 || ret == -10) {
                    if (this.sendFlushRequest(reactorChannel, "Reactor.submitChannel", errorInfo) != 0) {
                        int n = -1;
                        return n;
                    }
                    if (ret != -10) {
                        if (Objects.nonNull(packedBufferImpl)) {
                            this.packedBufferHashMap.remove(buffer);
                            packedBufferImpl.returnToPool();
                        }
                        ret = 0;
                    } else {
                        if (buffer != writeBuffer) {
                            this.writeCallAgainMap.put(buffer, writeBuffer);
                        }
                        releaseUserBuffer = false;
                        ret = -2;
                    }
                } else if (ret < 0) {
                    this.populateErrorInfo(errorInfo, -1, "Reactor.submitChannel", "channel write failure chnl=" + reactorChannel.channel().selectableChannel() + " errorId=" + errorInfo.error().errorId() + " errorText=" + errorInfo.error().text());
                    releaseUserBuffer = false;
                    ret = -1;
                } else {
                    reactorChannel.flushAgain(false);
                    if (Objects.nonNull(packedBufferImpl)) {
                        this.packedBufferHashMap.remove(buffer);
                        packedBufferImpl.returnToPool();
                    }
                }
                if (releaseUserBuffer) {
                    reactorChannel.releaseBuffer(buffer, errorInfo);
                }
            }
        }
        finally {
            this._reactorLock.unlock();
        }
        if (ret == 0) {
            reactorChannel.pingHandler().sentMsg();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int submitChannel(ReactorChannel reactorChannel, Msg msg, ReactorSubmitOptions submitOptions, ReactorErrorInfo errorInfo) {
        int ret;
        block15: {
            ret = 0;
            this._reactorLock.lock();
            try {
                TransportBuffer writeBuffer;
                if (!this.isReactorChannelReady(reactorChannel)) {
                    ret = -1;
                    int n = this.populateErrorInfo(errorInfo, -1, "Reactor.submitChannel", "ReactorChannel is closed, aborting.");
                    return n;
                }
                if (reactorChannel == this._reactorChannel) break block15;
                if (this._submitMsgMap.size() > 0 && this._submitMsgMap.containsKey(msg)) {
                    TransportBuffer writeBuffer2 = this._submitMsgMap.get(msg);
                    ret = this.submitChannel(reactorChannel, writeBuffer2, submitOptions, errorInfo);
                    if (ret != -2) {
                        this._submitMsgMap.remove(msg);
                    }
                    int n = ret;
                    return n;
                }
                int msgSize = this.encodedMsgSize(msg);
                while ((writeBuffer = reactorChannel.channel().getBuffer(msgSize, false, errorInfo.error())) != null) {
                    this._eIter.clear();
                    this._eIter.setBufferAndRWFVersion(writeBuffer, reactorChannel.channel().majorVersion(), reactorChannel.channel().minorVersion());
                    ret = msg.encode(this._eIter);
                    if (ret == 0) {
                        ret = this.submitChannel(reactorChannel, writeBuffer, submitOptions, errorInfo);
                        if (ret == -2) {
                            this._submitMsgMap.put(msg, writeBuffer);
                        }
                    } else {
                        if (ret == -21) {
                            reactorChannel.channel().releaseBuffer(writeBuffer, errorInfo.error());
                            msgSize *= 2;
                            continue;
                        }
                        reactorChannel.channel().releaseBuffer(writeBuffer, errorInfo.error());
                        this.populateErrorInfo(errorInfo, -1, "Reactor.submitChannel", "message encoding failure chnl=" + reactorChannel.channel().selectableChannel() + " errorId=" + errorInfo.error().errorId() + " errorText=" + errorInfo.error().text());
                        ret = -1;
                    }
                    break block15;
                }
                if (this.sendFlushRequest(reactorChannel, "Reactor.submitChannel", errorInfo) != 0) {
                    int n = -1;
                    return n;
                }
                this.populateErrorInfo(errorInfo, -3, "Reactor.submitChannel", "channel out of buffers chnl=" + reactorChannel.channel().selectableChannel() + " errorId=" + errorInfo.error().errorId() + " errorText=" + errorInfo.error().text());
                ret = -3;
            }
            finally {
                this._reactorLock.unlock();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int submitChannel(ReactorChannel reactorChannel, MsgBase rdmMsg, ReactorSubmitOptions submitOptions, ReactorErrorInfo errorInfo) {
        int ret;
        block19: {
            ret = 0;
            this._reactorLock.lock();
            try {
                TransportBuffer writeBuffer;
                if (!this._reactorActive) {
                    int n = this.populateErrorInfo(errorInfo, -10, "Reactor.submitChannel", "Reactor is not active, aborting.");
                    return n;
                }
                if (!this.isReactorChannelReady(reactorChannel)) {
                    ret = -1;
                    int n = this.populateErrorInfo(errorInfo, -1, "Reactor.submitChannel", "ReactorChannel is closed, aborting.");
                    return n;
                }
                if (reactorChannel == this._reactorChannel) break block19;
                if (this._submitRdmMsgMap.size() > 0 && this._submitRdmMsgMap.containsKey(rdmMsg)) {
                    TransportBuffer writeBuffer2 = this._submitRdmMsgMap.get(rdmMsg);
                    ret = this.submitChannel(reactorChannel, writeBuffer2, submitOptions, errorInfo);
                    if (ret != -2) {
                        this._submitRdmMsgMap.remove(rdmMsg);
                    }
                    int n = ret;
                    return n;
                }
                int bufferSize = this.getMaxFragmentSize(reactorChannel, errorInfo);
                if (bufferSize < 0) {
                    int n = bufferSize;
                    return n;
                }
                while ((writeBuffer = reactorChannel.channel().getBuffer(bufferSize, false, errorInfo.error())) != null) {
                    this._eIter.clear();
                    this._eIter.setBufferAndRWFVersion(writeBuffer, reactorChannel.channel().majorVersion(), reactorChannel.channel().minorVersion());
                    ret = rdmMsg.encode(this._eIter);
                    if (ret == 0) {
                        ret = this.submitChannel(reactorChannel, writeBuffer, submitOptions, errorInfo);
                        if (ret == -2) {
                            this._submitRdmMsgMap.put(rdmMsg, writeBuffer);
                        }
                    } else {
                        if (ret == -21) {
                            reactorChannel.channel().releaseBuffer(writeBuffer, errorInfo.error());
                            bufferSize *= 2;
                            continue;
                        }
                        reactorChannel.channel().releaseBuffer(writeBuffer, errorInfo.error());
                        this.populateErrorInfo(errorInfo, -1, "Reactor.submitChannel", "message encoding failure chnl=" + reactorChannel.channel().selectableChannel() + " errorId=" + errorInfo.error().errorId() + " errorText=" + errorInfo.error().text());
                        ret = -1;
                    }
                    break block19;
                }
                if (this.sendFlushRequest(reactorChannel, "Reactor.submitChannel", errorInfo) != 0) {
                    int n = -1;
                    return n;
                }
                this.populateErrorInfo(errorInfo, -3, "Reactor.submitChannel", "channel out of buffers chnl=" + reactorChannel.channel().selectableChannel() + " errorId=" + errorInfo.error().errorId() + " errorText=" + errorInfo.error().text());
                ret = -3;
            }
            finally {
                this._reactorLock.unlock();
            }
        }
        return ret;
    }

    int disconnect(ReactorChannel reactorChannel, String location, ReactorErrorInfo errorInfo) {
        if (reactorChannel.server() == null && !reactorChannel.recoveryAttemptLimitReached()) {
            reactorChannel.state(ReactorChannel.State.DOWN_RECONNECTING);
        } else {
            reactorChannel.state(ReactorChannel.State.DOWN);
        }
        if (this._reactorOptions.debuggerOptions().debugConnectionLevel()) {
            this.debugger.writeDebugInfo("Reactor@%d, Reactor channel@%d disconnected with status = %s on channel fd=%d.]\n", this.hashCode(), reactorChannel.hashCode(), reactorChannel.state().equals((Object)ReactorChannel.State.DOWN) ? "DOWN" : "DOWN_RECONNECTING", ReactorDebugger.getChannelId(reactorChannel));
        }
        if (reactorChannel.server() == null && !reactorChannel.recoveryAttemptLimitReached()) {
            return this.sendAndHandleChannelEventCallback(location, 3, reactorChannel, errorInfo);
        }
        return this.sendAndHandleChannelEventCallback(location, 2, reactorChannel, errorInfo);
    }

    int preferredHostSwitch(ReactorChannel reactorChannel, String location, ReactorErrorInfo errorInfo) {
        if (this._reactorOptions.debuggerOptions().debugConnectionLevel()) {
            this.debugger.writeDebugInfo("Reactor@%d, Reactor channel@%d disconnected with status = %s on channel fd=%d.]\n", this.hashCode(), reactorChannel.hashCode(), reactorChannel.state().equals((Object)ReactorChannel.State.DOWN) ? "DOWN" : "DOWN_RECONNECTING", ReactorDebugger.getChannelId(reactorChannel));
        }
        int retCode = this.sendAndHandleChannelEventCallback(location, 3, reactorChannel, errorInfo);
        return retCode;
    }

    private int processRwfMessage(TransportBuffer transportBuffer, Buffer buffer, ReactorChannel reactorChannel, ReactorErrorInfo errorInfo) {
        this._dIter.clear();
        if (Objects.nonNull(buffer)) {
            this._dIter.setBufferAndRWFVersion(buffer, reactorChannel.channel().majorVersion(), reactorChannel.channel().minorVersion());
        } else {
            this._dIter.setBufferAndRWFVersion(transportBuffer, reactorChannel.channel().majorVersion(), reactorChannel.channel().minorVersion());
        }
        this._msg.clear();
        int retval = this._msg.decode(this._dIter);
        if (retval != 0) {
            return this.populateErrorInfo(errorInfo, -1, "Reactor.performChannelRead", "initial decode of msg failed, errorId=" + errorInfo.error().errorId() + " text=" + errorInfo.error().text());
        }
        WlStream wlStream = null;
        this._tempWlInteger.value(this._msg.streamId());
        if (reactorChannel.watchlist() != null && (wlStream = reactorChannel.watchlist().streamIdtoWlStreamTable().get(this._tempWlInteger)) != null) {
            if (reactorChannel.reactor().reactorHandlesWarmStandby(reactorChannel) ? (retval = reactorChannel.watchlist().readMsgWSB(wlStream, reactorChannel, this._dIter, this._msg, errorInfo)) < 0 : (retval = reactorChannel.watchlist().readMsg(wlStream, this._dIter, this._msg, errorInfo)) < 0) {
                return retval;
            }
        } else if (reactorChannel.server() != null && this._msg.msgClass() == 1 && ((RequestMsg)this._msg).checkPrivateStream() && ((RequestMsg)this._msg).checkQualifiedStream()) {
            retval = this.handleTunnelStreamRequest(reactorChannel, (RequestMsg)this._msg, errorInfo);
            if (retval != 0) {
                return retval;
            }
        } else if (reactorChannel.role().type() != 1 || !((ConsumerRole)reactorChannel.role()).watchlistOptions().enableWatchlist()) {
            if (this.reactorHandlesWarmStandby(reactorChannel)) {
                reactorChannel.warmStandByHandlerImpl.readMsgChannel(reactorChannel);
                if (this.processChannelMessage(reactorChannel, this._dIter, this._msg, transportBuffer, errorInfo) == -1) {
                    return -1;
                }
                reactorChannel.warmStandByHandlerImpl.readMsgChannel(null);
            } else if (this.processChannelMessage(reactorChannel, this._dIter, this._msg, transportBuffer, errorInfo) == -1) {
                return -1;
            }
        }
        return 0;
    }

    private int sendJSONMessage(TransportBuffer msgBuffer, ReactorChannel reactorChannel, ReactorErrorInfo errorInfo) {
        this.reactorSubmitOptions.clear();
        int ret = reactorChannel.channel().write(msgBuffer, this.reactorSubmitOptions.writeArgs(), errorInfo.error());
        if (ret > 0 || ret == -9) {
            if (this.sendFlushRequest(reactorChannel, "Reactor.sendJSONMessage", errorInfo) != 0) {
                return -1;
            }
            ret = 0;
        } else if (ret < 0) {
            this.populateErrorInfo(errorInfo, -1, "Reactor.sendJSONMessage", "channel write failure chnl=" + reactorChannel.channel().selectableChannel() + " errorId=" + errorInfo.error().errorId() + " errorText=" + errorInfo.error().text());
            reactorChannel.releaseBuffer(msgBuffer, errorInfo);
            ret = -1;
        } else {
            reactorChannel.flushAgain(false);
        }
        return ret;
    }

    private int performChannelRead(ReactorChannel reactorChannel, ReadArgs readArgs, ReactorErrorInfo errorInfo) {
        TransportBuffer msgBuf = reactorChannel.channel().read(readArgs, errorInfo.error());
        if (msgBuf != null) {
            if ((this._reactorOptions.xmlTracing() || this._reactorOptions.xmlTraceToFile()) && this._reactorOptions.xmlTraceRead()) {
                this.xmlString.setLength(0);
                this.xmlString.append("\n<!-- Incoming Reactor message -->\n").append("<!-- ").append(reactorChannel.selectableChannel().toString()).append(" -->\n").append("<!-- ").append(new Date()).append(" -->\n");
                this.xmlDumpTrace.dumpBuffer(reactorChannel.channel(), reactorChannel.channel().protocolType(), msgBuf, null, this.xmlString, errorInfo.error());
                if (this._reactorOptions.xmlTracing()) {
                    System.out.println(this.xmlString);
                }
                if (this._reactorOptions.xmlTraceToFile()) {
                    this._fileDumper.dump(this.xmlString.toString());
                }
            }
            reactorChannel.pingHandler().receivedMsg();
            if (reactorChannel.channel().protocolType() == 2) {
                TransportBuffer msgBuffer;
                boolean failedToConvertJSONMsg = true;
                String jsonErrorMsg = null;
                if (Objects.isNull(this.jsonConverter)) {
                    return this.populateErrorInfo(errorInfo, -1, "Reactor.performChannelRead", "The JSON converter library has not been initialized properly.");
                }
                this.parseJsonOptions.clear();
                this.parseJsonOptions.setProtocolType(reactorChannel.channel().protocolType());
                this.converterError.clear();
                int retval = this.jsonConverter.parseJsonBuffer(msgBuf, this.parseJsonOptions, this.converterError);
                if (retval == 0) {
                    this.decodeJsonMsgOptions.clear();
                    this.decodeJsonMsgOptions.setJsonProtocolType(2);
                    this.decodeJsonMsgOptions.setMajorVersion(reactorChannel.channel().majorVersion());
                    this.decodeJsonMsgOptions.setMinorVersion(reactorChannel.channel().minorVersion());
                    if (Objects.nonNull(this.serviceNameIdConverterClient)) {
                        this.serviceNameIdConverterClient.setReactorChannel(reactorChannel);
                    }
                    this.jsonMsg.clear();
                    while ((retval = this.jsonConverter.decodeJsonMsg(this.jsonMsg, this.decodeJsonMsgOptions, this.converterError)) != 14 && retval == 0) {
                        switch (this.jsonMsg.jsonMsgClass()) {
                            case 1: {
                                failedToConvertJSONMsg = false;
                                if (this._reactorOptions.xmlTracing() || this._reactorOptions.xmlTraceToFile()) {
                                    this.xmlString.setLength(0);
                                    this.xmlString.append("\n<!-- Dump Reactor message -->\n").append("<!-- ").append(reactorChannel.selectableChannel().toString()).append(" -->\n").append("<!-- ").append(new Date()).append(" -->\n");
                                    this.xmlDumpTrace.dumpBuffer(reactorChannel.majorVersion(), reactorChannel.minorVersion(), 0, this.jsonMsg.rwfMsg().encodedMsgBuffer(), null, this.xmlString, errorInfo.error());
                                    if (this._reactorOptions.xmlTracing()) {
                                        System.out.println(this.xmlString);
                                    }
                                    if (this._reactorOptions.xmlTraceToFile()) {
                                        this._fileDumper.dump(this.xmlString.toString());
                                    }
                                }
                                if ((retval = this.processRwfMessage(msgBuf, this.jsonMsg.rwfMsg().encodedMsgBuffer(), reactorChannel, errorInfo)) == 0) break;
                                return retval;
                            }
                            case 2: {
                                failedToConvertJSONMsg = false;
                                msgBuffer = reactorChannel.getBuffer(JSON_PONG_MESSAGE.length(), false, errorInfo);
                                if (Objects.nonNull(msgBuffer)) {
                                    msgBuffer.data().put(JSON_PONG_MESSAGE.getBytes());
                                    if (this._reactorOptions.xmlTracing() || this._reactorOptions.xmlTraceToFile()) {
                                        this.xmlString.setLength(0);
                                        this.xmlString.append("\n<!-- Outgoing Reactor message -->\n").append("<!-- ").append(reactorChannel.selectableChannel().toString()).append(" -->\n").append("<!-- ").append(new Date()).append(" -->\n");
                                        this.xmlDumpTrace.dumpBuffer(reactorChannel.channel(), 2, msgBuffer, null, this.xmlString, errorInfo.error());
                                        if (this._reactorOptions.xmlTracing()) {
                                            System.out.println(this.xmlString);
                                        }
                                        if (this._reactorOptions.xmlTraceToFile()) {
                                            this._fileDumper.dump(this.xmlString.toString());
                                        }
                                    }
                                    retval = this.sendJSONMessage(msgBuffer, reactorChannel, errorInfo);
                                    break;
                                }
                                retval = -1;
                                break;
                            }
                            case 3: {
                                failedToConvertJSONMsg = false;
                                break;
                            }
                            case 4: {
                                this.xmlString.setLength(0);
                                this.xmlDumpTrace.dumpBuffer(reactorChannel.channel(), 2, msgBuf, null, this.xmlString, errorInfo.error());
                                jsonErrorMsg = this.xmlString.toString();
                                this.populateErrorInfo(errorInfo, -1, "Reactor.performChannelRead", "Received JSON error message: " + jsonErrorMsg);
                                failedToConvertJSONMsg = false;
                                retval = -1;
                            }
                        }
                        if (retval == 0) {
                            failedToConvertJSONMsg = true;
                            continue;
                        }
                        break;
                    }
                } else {
                    failedToConvertJSONMsg = false;
                    this.populateErrorInfo(errorInfo, -1, "Reactor.performChannelRead", "Failed to parse JSON message: " + this.converterError.getText());
                }
                if (retval < 0) {
                    if (failedToConvertJSONMsg) {
                        this.jsonErrorParams.clear();
                        this.jsonErrorParams.fillParams(this.converterError, this.jsonMsg.rwfMsg().streamId());
                        this.jsonErrorOutputBuffer.clear();
                        this.getMessageError.clear();
                        retval = this.jsonConverter.getErrorMessage(this.jsonErrorOutputBuffer, this.jsonErrorParams, this.getMessageError);
                        if (retval == 0 && this.sendJsonConvError) {
                            msgBuffer = reactorChannel.getBuffer(this.jsonErrorOutputBuffer.length(), false, errorInfo);
                            if (Objects.nonNull(msgBuffer)) {
                                msgBuffer.data().put(this.jsonErrorOutputBuffer.data());
                                retval = this.sendJSONMessage(msgBuffer, reactorChannel, errorInfo);
                            } else {
                                retval = -1;
                            }
                        }
                    }
                    if (Objects.nonNull(this.JsonConversionEventCallback) && this.converterError.getCode() != 0) {
                        this.jsonConversionEvent.clear();
                        this.jsonConversionEvent.reactorChannel(reactorChannel);
                        if (failedToConvertJSONMsg) {
                            this.populateErrorInfo(this.jsonConversionEvent.errorInfo(), -1, "Reactor.performChannelRead", "Failed to convert JSON message: " + this.jsonErrorOutputBuffer.toString());
                        } else {
                            this.populateErrorInfo(this.jsonConversionEvent.errorInfo(), -1, "Reactor.performChannelRead", "Failed to convert JSON message: " + this.converterError.getText());
                        }
                        this.jsonConversionEvent.userSpec = this.jsonConverterUserSpec;
                        this.jsonConversionEvent.error().text(this.jsonConversionEvent.errorInfo().error().text());
                        this.jsonConversionEvent.error().errorId(-1);
                        int cret = this.JsonConversionEventCallback.reactorJsonConversionEventCallback(this.jsonConversionEvent);
                        if (cret == -1) {
                            return this.populateErrorInfo(errorInfo, -1, "Reactor.performChannelRead", "Error return code" + cret + " from the ReactorJsonConversionEventCallback callback.");
                        }
                    }
                    if (this.closeChannelFromFailure && retval != 0) {
                        if (reactorChannel.server() == null && !reactorChannel.recoveryAttemptLimitReached()) {
                            reactorChannel.state(ReactorChannel.State.DOWN_RECONNECTING);
                        } else {
                            reactorChannel.state(ReactorChannel.State.DOWN);
                        }
                        if (reactorChannel.server() == null && !reactorChannel.recoveryAttemptLimitReached()) {
                            this.sendAndHandleChannelEventCallback("Reactor.performChannelRead", 3, reactorChannel, errorInfo);
                        } else {
                            this.sendAndHandleChannelEventCallback("Reactor.performChannelRead", 2, reactorChannel, errorInfo);
                        }
                        return 0;
                    }
                }
            } else {
                int retval = this.processRwfMessage(msgBuf, null, reactorChannel, errorInfo);
                if (retval != 0) {
                    return retval;
                }
            }
        } else if (readArgs.readRetVal() == -1) {
            if (reactorChannel.server() == null && !reactorChannel.recoveryAttemptLimitReached()) {
                reactorChannel.state(ReactorChannel.State.DOWN_RECONNECTING);
            } else {
                reactorChannel.state(ReactorChannel.State.DOWN);
            }
            if (reactorChannel.server() == null && !reactorChannel.recoveryAttemptLimitReached()) {
                this.sendAndHandleChannelEventCallback("Reactor.performChannelRead", 3, reactorChannel, errorInfo);
            } else {
                this.sendAndHandleChannelEventCallback("Reactor.performChannelRead", 2, reactorChannel, errorInfo);
            }
        } else if (readArgs.readRetVal() == -14) {
            reactorChannel.selectableChannelFromChannel(reactorChannel.channel());
            reactorChannel.oldSelectableChannel(reactorChannel.channel().oldSelectableChannel());
            if (this.reactorHandlesWarmStandby(reactorChannel)) {
                reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl().warmStandbyChannelInfo().selectableChannelList().remove(reactorChannel.channel().oldSelectableChannel());
                reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl().warmStandbyChannelInfo().selectableChannelList().add(reactorChannel.channel().selectableChannel());
            }
            if (!this.sendWorkerEvent(WorkerEventTypes.FD_CHANGE, reactorChannel)) {
                reactorChannel.state(ReactorChannel.State.DOWN);
                this.sendAndHandleChannelEventCallback("Reactor.performChannelRead", 2, reactorChannel, errorInfo);
                return this.populateErrorInfo(errorInfo, -1, "Reactor.performChannelRead", "sendWorkerEvent() failed");
            }
            this.sendAndHandleChannelEventCallback("Reactor.performChannelRead", 6, reactorChannel, errorInfo);
            if (this.reactorHandlesWarmStandby(reactorChannel)) {
                reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl().warmStandbyChannelInfo().oldSelectableChannelList().remove(reactorChannel.channel().oldSelectableChannel());
            }
        } else if (readArgs.readRetVal() == -13) {
            if ((this._reactorOptions.xmlTracing() || this._reactorOptions.xmlTraceToFile()) && this._reactorOptions.xmlTracePing()) {
                this.xmlString.setLength(0);
                this.xmlString.append("\n<!-- Incoming Ping message -->\n").append("<!-- ").append(reactorChannel.selectableChannel().toString()).append(" -->\n").append("<!-- ").append(new Date()).append(" -->\n");
                if (this._reactorOptions.xmlTracing()) {
                    System.out.println(this.xmlString);
                }
                if (this._reactorOptions.xmlTraceToFile()) {
                    this._fileDumper.dump(this.xmlString.toString());
                }
            }
            reactorChannel.pingHandler().receivedMsg();
        }
        if (readArgs.readRetVal() == -13 && this._reactorOptions.pingStatSet()) {
            reactorChannel.pingHandler().receivedPing();
        }
        if (this._reactorOptions.readStatSet()) {
            ((ReadArgsImpl)this._readArgsAggregator).bytesRead(this.overflowSafeAggregate(this._readArgsAggregator.bytesRead(), readArgs.bytesRead()));
            ((ReadArgsImpl)this._readArgsAggregator).uncompressedBytesRead(this.overflowSafeAggregate(this._readArgsAggregator.uncompressedBytesRead(), readArgs.uncompressedBytesRead()));
        }
        if (readArgs.readRetVal() > 0) {
            return readArgs.readRetVal();
        }
        return 0;
    }

    private int handleTunnelStreamRequest(ReactorChannel reactorChannel, RequestMsg msg, ReactorErrorInfo errorInfo) {
        boolean isValid = false;
        String rejectString = null;
        this._tunnelStreamRequestEvent.clear();
        if (((ProviderRole)reactorChannel.role()).tunnelStreamListenerCallback() != null) {
            this._tempWlInteger.value(msg.streamId());
            if (!reactorChannel.streamIdtoTunnelStreamTable().containsKey(this._tempWlInteger)) {
                if (msg.containerType() == 135 && msg.msgKey().checkHasFilter()) {
                    int ret = this._tunnelStreamRequestEvent.classOfService().decodeCommonProperties(this._reactorChannel, msg.encodedDataBody(), errorInfo);
                    if (ret == 0) {
                        int requestedStreamVersion = this._tunnelStreamRequestEvent.classOfService().common().streamVersion();
                        if (requestedStreamVersion <= 2) {
                            isValid = true;
                        } else {
                            rejectString = "Unsupported class of service stream version: " + requestedStreamVersion;
                        }
                    } else {
                        rejectString = "Class of service common properties decode failed with return code: " + ret + " <" + errorInfo.error().text() + ">";
                    }
                    if (this._reactorOptions.debuggerOptions().debugTunnelStreamLevel()) {
                        this.debugger.writeDebugInfo("Reactor@%d, Reactor channel@%d receives a tunnel stream request (stream ID=%d) on channel fd=%d.]\n", this.hashCode(), reactorChannel.hashCode(), msg.streamId(), ReactorDebugger.getChannelId(reactorChannel));
                    }
                } else {
                    rejectString = "TunnelStream request must contain FILTER_LIST and have filter in message key";
                }
            } else {
                rejectString = "TunnelStream is already open for stream id " + msg.streamId();
            }
        } else {
            rejectString = "Provider does not support TunnelStreams";
        }
        if (isValid) {
            this._tunnelStreamRequestEvent.reactorChannel(reactorChannel);
            this._tunnelStreamRequestEvent.domainType(msg.domainType());
            this._tunnelStreamRequestEvent.streamId(msg.streamId());
            this._tunnelStreamRequestEvent.serviceId(msg.msgKey().serviceId());
            this._tunnelStreamRequestEvent.name(msg.msgKey().name().toString());
            this._tunnelStreamRequestEvent.msg(msg);
            this._tunnelStreamRequestEvent.classOfServiceFilter(msg.msgKey().filter());
            this._tunnelStreamRequestEvent.errorInfo(errorInfo);
            return ((ProviderRole)reactorChannel.role()).tunnelStreamListenerCallback().listenerCallback(this._tunnelStreamRequestEvent);
        }
        this._tunnelStreamRejectOptions.clear();
        this._tunnelStreamRejectOptions.state().streamState(4);
        this._tunnelStreamRejectOptions.state().dataState(2);
        this._tunnelStreamRejectOptions.state().code(0);
        this._tunnelStreamRejectOptions.state().text().data(rejectString);
        this._tunnelStreamRequestEvent.clear();
        this._tunnelStreamRequestEvent.reactorChannel(reactorChannel);
        this._tunnelStreamRequestEvent.domainType(((RequestMsg)this._msg).domainType());
        this._tunnelStreamRequestEvent.streamId(((RequestMsg)this._msg).streamId());
        this._tunnelStreamRequestEvent.serviceId(((RequestMsg)this._msg).msgKey().serviceId());
        this._tunnelStreamRequestEvent.name(((RequestMsg)this._msg).msgKey().name().toString());
        if (reactorChannel.rejectTunnelStream(this._tunnelStreamRequestEvent, this._tunnelStreamRejectOptions, errorInfo) < 0) {
            return -1;
        }
        this.sendAndHandleChannelEventCallback("Reactor.handleTunnelStreamRequest", 5, reactorChannel, errorInfo);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processWorkerEvent(ReactorErrorInfo errorInfo) {
        WorkerEvent event;
        block125: {
            event = (WorkerEvent)this._workerQueue.read();
            if (event == null) {
                return 0;
            }
            this.populateErrorInfo(errorInfo, event.errorInfo().code(), event.errorInfo().location(), event.errorInfo().error().text());
            WorkerEventTypes eventType = event.eventType();
            ReactorChannel reactorChannel = event.reactorChannel();
            int ret = 0;
            switch (eventType) {
                case FLUSH_DONE: {
                    reactorChannel.flushRequested(false);
                    if (reactorChannel.flushAgain() && this.sendFlushRequest(reactorChannel, "Reactor.processWorkerEvent", errorInfo) != 0) {
                        event.returnToPool();
                        return -1;
                    }
                    if (reactorChannel.watchlist() == null || (ret = reactorChannel.watchlist().dispatch(errorInfo)) == 0) break;
                    this.populateErrorInfo(errorInfo, ret, "Reactor.processWorkerEvent", "Watchlist dispatch failed - " + errorInfo.error().text());
                    event.returnToPool();
                    return ret;
                }
                case CHANNEL_UP: {
                    this.processChannelUp(event, errorInfo);
                    break;
                }
                case CHANNEL_DOWN: {
                    this.populateErrorInfo(errorInfo, 0, "Reactor.processWorkerEvent", errorInfo.error().text());
                    this.processChannelDown(event, errorInfo);
                    break;
                }
                case CHANNEL_CLOSE_ACK: {
                    if (reactorChannel.watchlist() != null) {
                        reactorChannel.watchlist().close();
                        reactorChannel.watchlist(null);
                    }
                    reactorChannel.returnToPool();
                    break;
                }
                case WARNING: {
                    this.populateErrorInfo(errorInfo, 0, "Reactor.processWorkerEvent", errorInfo.error().text());
                    this.sendChannelEventCallback(5, event.reactorChannel(), errorInfo);
                    break;
                }
                case TOKEN_MGNT: {
                    this.populateErrorInfo(errorInfo, errorInfo.code(), "Reactor.processWorkerEvent", errorInfo.error().text());
                    this.sendAuthTokenEventCallback(reactorChannel, event._tokenSession.authTokenInfo(), errorInfo);
                    errorInfo.code(0);
                    break;
                }
                case TOKEN_CREDENTIAL_RENEWAL: {
                    this.populateErrorInfo(errorInfo, 0, "Reactor.processWorkerEvent", errorInfo.error().text());
                    this._tokenSessionForCredentialRenewalCallback = event._tokenSession;
                    this.sendOAuthCredentialEventCallback(event._tokenSession, errorInfo);
                    this._tokenSessionForCredentialRenewalCallback = null;
                    break;
                }
                case SHUTDOWN: {
                    this.processWorkerShutdown(event, "Reactor.processWorkerEvent", errorInfo);
                    break;
                }
                case TUNNEL_STREAM_DISPATCH_TIMEOUT: {
                    reactorChannel.clearTunnelStreamManagerExpireTime();
                }
                case TUNNEL_STREAM_DISPATCH_NOW: {
                    while ((ret = reactorChannel.tunnelStreamManager().dispatch(errorInfo.error())) > 0) {
                    }
                    if (ret < 0) {
                        if (ret == -7) {
                            if (reactorChannel.state() != ReactorChannel.State.DOWN && reactorChannel.state() != ReactorChannel.State.DOWN_RECONNECTING) {
                                if (reactorChannel.server() == null && !reactorChannel.recoveryAttemptLimitReached()) {
                                    reactorChannel.state(ReactorChannel.State.DOWN_RECONNECTING);
                                    this.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 3, reactorChannel, errorInfo);
                                } else {
                                    reactorChannel.state(ReactorChannel.State.DOWN);
                                    this.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 2, reactorChannel, errorInfo);
                                }
                            }
                            ret = 0;
                        } else {
                            this.populateErrorInfo(errorInfo, ret, "Reactor.processWorkerEvent", "TunnelStream dispatch failed - " + errorInfo.error().text());
                        }
                    }
                    if ((ret = reactorChannel.checkTunnelManagerEvents(errorInfo)) == 0) break;
                    event.returnToPool();
                    return ret;
                }
                case WATCHLIST_TIMEOUT: {
                    if (reactorChannel.watchlist() == null || (ret = reactorChannel.watchlist().timeout(errorInfo)) == 0) break;
                    event.returnToPool();
                    return ret;
                }
                case WATCHLIST_DISPATCH_NOW: {
                    if (reactorChannel.watchlist() == null || (ret = reactorChannel.watchlist().dispatch(errorInfo)) == 0) break;
                    event.returnToPool();
                    return ret;
                }
                case WARM_STANDBY: {
                    if (reactorChannel.watchlist() == null) break;
                    ret = reactorChannel.watchlist().timeout(errorInfo);
                    if (ret != 0) {
                        event.returnToPool();
                        return ret;
                    }
                    if (!reactorChannel.watchlist().watchlistOptions().enableWarmStandby()) break;
                    ReactorChannel pReactorChannel = event.reactorChannel();
                    ReactorWarmStandbyHandler warmStandByHandlerImpl = null;
                    ReactorWarmStandbyGroupImpl warmStandbyGroup = null;
                    ReactorChannel processReactorChannel = null;
                    if (pReactorChannel != null) {
                        warmStandByHandlerImpl = pReactorChannel.warmStandByHandlerImpl;
                        warmStandbyGroup = pReactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl();
                    }
                    ReactorChannel startingReactorChannel = null;
                    switch (event.warmStandbyEventType()) {
                        case 0: {
                            break;
                        }
                        case 9: {
                            for (int queueCount = 0; queueCount < warmStandByHandlerImpl.channelList().size(); ++queueCount) {
                                processReactorChannel = warmStandByHandlerImpl.channelList().get(queueCount);
                                if (processReactorChannel == reactorChannel) continue;
                                this.sendWatchlistDispatchNowEvent(processReactorChannel);
                            }
                            break block125;
                        }
                        case 2: {
                            if (warmStandbyGroup.warmStandbyMode() == 1 && warmStandByHandlerImpl.nextActiveReactorChannel() != null) {
                                if (reactorChannel._loginConsumerStatus == null) {
                                    reactorChannel._loginConsumerStatus = (LoginConsumerConnectionStatus)LoginMsgFactory.createMsg();
                                    reactorChannel._loginConsumerStatus.rdmMsgType(LoginMsgType.CONSUMER_CONNECTION_STATUS);
                                }
                                reactorChannel._loginConsumerStatus.clear();
                                reactorChannel._loginConsumerStatus.streamId(1);
                                reactorChannel._loginConsumerStatus.flags(1);
                                reactorChannel._loginConsumerStatus.warmStandbyInfo().warmStandbyMode(0L);
                                if (this.submitChannel(warmStandByHandlerImpl.nextActiveReactorChannel(), reactorChannel._loginConsumerStatus, this.reactorSubmitOptions, errorInfo) < 0) {
                                    if (warmStandByHandlerImpl.nextActiveReactorChannel().server() == null && !warmStandByHandlerImpl.nextActiveReactorChannel().recoveryAttemptLimitReached()) {
                                        warmStandByHandlerImpl.nextActiveReactorChannel().state(ReactorChannel.State.DOWN_RECONNECTING);
                                        this.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 3, warmStandByHandlerImpl.nextActiveReactorChannel(), errorInfo);
                                        break;
                                    }
                                    warmStandByHandlerImpl.nextActiveReactorChannel().state(ReactorChannel.State.DOWN);
                                    this.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 2, warmStandByHandlerImpl.nextActiveReactorChannel(), errorInfo);
                                    break;
                                }
                                warmStandByHandlerImpl.nextActiveReactorChannel().isActiveServer = true;
                                reactorChannel.warmStandByHandlerImpl.activeReactorChannel(warmStandByHandlerImpl.nextActiveReactorChannel());
                                this.reactorWSBFanoutStatusMsg(warmStandByHandlerImpl.nextActiveReactorChannel(), errorInfo);
                                warmStandByHandlerImpl.nextActiveReactorChannel(null);
                                break;
                            }
                            break block125;
                        }
                        case 5: {
                            ret = this.wsbServiceSwitchActiveToStandbyChannelDown(reactorChannel, reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl(), warmStandByHandlerImpl, true, reactorChannel.getEDPErrorInfo());
                            if (ret != 0) {
                                return ret;
                            }
                            break block125;
                        }
                        case 10: {
                            ReactorWarmStandbyHandler returnWarmStandbyHandler = event._warmStandbyHandler;
                            if (returnWarmStandbyHandler != null) {
                                this.closingWarmStandbyChannel.remove(returnWarmStandbyHandler.reactorQueueLink());
                                this.warmstandbyChannelPool.add(returnWarmStandbyHandler.reactorQueueLink());
                                break;
                            }
                            break block125;
                        }
                        case 7: {
                            if (reactorChannel.isStartingServerConfig) {
                                warmStandbyGroup.startingActiveServer().isActiveChannelConfig(false);
                            } else {
                                warmStandbyGroup.standbyServerList().get(reactorChannel.standByServerListIndex).isActiveChannelConfig(false);
                            }
                            ReactorChannel callbackChannel = reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl();
                            callbackChannel.selectableChannelFromChannel(reactorChannel.channel());
                            callbackChannel.userSpecObj(reactorChannel.userSpecObj());
                            callbackChannel.reactorChannelType(reactorChannel.reactorChannelType());
                            event.reactorChannel(callbackChannel);
                            int callbackEventType = reactorChannel.warmStandByHandlerImpl.channelList().size() == 1 ? 2 : 6;
                            if (event.errorInfo() != null) {
                                event._errorInfo = event.errorInfo();
                            }
                            callbackChannel.warmStandbyChannelInfo().selectableChannelList().remove(reactorChannel.channel().selectableChannel());
                            int retval = this.sendChannelEventCallback(callbackEventType, callbackChannel, event._errorInfo);
                            callbackChannel.warmStandbyChannelInfo().oldSelectableChannelList().remove(reactorChannel.channel().selectableChannel());
                            if (retval == -1) {
                                this.populateErrorInfo(errorInfo, -1, "processWorkerCallback.RemoveServerFromWSBGroup", "ReactorCallbackReturnCodes.FAILURE was returned from reactorChannelEventCallback(). This caused the Reactor to shutdown.");
                                this.shutdown(errorInfo);
                                return -1;
                            }
                            if (retval == -2) {
                                this.populateErrorInfo(errorInfo, -1, "processWorkerCallback.RemoveServerFromWSBGroup", "ReactorCallbackReturnCodes.RAISE is not a valid return code from reactorChannelEventCallback(). This caused the Reactor to shutdown.");
                                this.shutdown(errorInfo);
                                return -1;
                            }
                            if (retval != 0) {
                                this.populateErrorInfo(errorInfo, -1, "processWorkerCallback.RemoveServerFromWSBGroup", "retval of " + retval + " is not a valid ReactorCallbackReturnCodes. This caused the Reactor to shutdown.");
                                this.shutdown(errorInfo);
                                return -1;
                            }
                            ((ReactorWarmStandbyGroupImpl)reactorChannel.warmStandByHandlerImpl.warmStandbyGroupList().get(reactorChannel.standByGroupListIndex)).incrementClosingStandbyCount();
                            warmStandByHandlerImpl.warmStandByHandlerLock().lock();
                            try {
                                reactorChannel.warmStandByHandlerImpl.channelList().remove(reactorChannel);
                            }
                            finally {
                                warmStandByHandlerImpl.warmStandByHandlerLock().unlock();
                            }
                            ret = this.closeChannel(reactorChannel, errorInfo);
                            if (ret != 0) {
                                return ret;
                            }
                            break block125;
                        }
                        case 1: {
                            ReactorWarmStandbyServerInfo warmStandbyServerInfo = null;
                            ReactorChannel standbyReactorChannel = null;
                            Watchlist startingWatchlist = null;
                            ReactorTokenSession tokenSession = null;
                            startingReactorChannel = warmStandByHandlerImpl.startingReactorChannel();
                            startingWatchlist = startingReactorChannel.watchlist();
                            if (warmStandByHandlerImpl.channelList().size() == warmStandbyGroup.standbyServerList().size() + 1) break;
                            warmStandbyGroup.resetClosingStandbyCount();
                            warmStandByHandlerImpl.startingReactorChannel()._ignoreClosedStandbyCount = false;
                            for (int index = 0; index < warmStandbyGroup.standbyServerList().size(); ++index) {
                                tokenSession = null;
                                warmStandbyServerInfo = warmStandbyGroup.standbyServerList().get(index);
                                standbyReactorChannel = ReactorFactory.createReactorChannel(this);
                                standbyReactorChannel._reactorConnectOptions = startingReactorChannel.getReactorConnectOptions();
                                standbyReactorChannel.initializationTimeout(warmStandbyServerInfo.reactorConnectInfo().initTimeout());
                                standbyReactorChannel.userSpecObj(warmStandbyServerInfo.reactorConnectInfo().connectOptions().userSpecObject());
                                standbyReactorChannel.flags(startingReactorChannel.flags);
                                standbyReactorChannel.reconnectAttemptLimit(startingReactorChannel.reconnectAttemptLimit());
                                standbyReactorChannel.reconnectMinDelay(startingReactorChannel.reconnectMinDelay());
                                standbyReactorChannel.reconnectMaxDelay(startingReactorChannel.reconnectMaxDelay());
                                standbyReactorChannel.reconnectAttemptCount(0);
                                standbyReactorChannel.standByServerListIndex = index;
                                standbyReactorChannel.standByGroupListIndex = warmStandByHandlerImpl.currentWarmStandbyGroupIndex();
                                standbyReactorChannel.reactorChannelType(1);
                                standbyReactorChannel.reactor(this);
                                this._reactorChannelQueue.pushBack(standbyReactorChannel, ReactorChannel.REACTOR_CHANNEL_LINK);
                                standbyReactorChannel.setCurrentReactorConnectInfo(warmStandbyServerInfo.reactorConnectInfo());
                                standbyReactorChannel.setCurrentConnectOptionsInfo(warmStandbyGroup.standbyConnectOptionsInfoList.get(index));
                                standbyReactorChannel.role(ReactorFactory.createConsumerRole());
                                ((ConsumerRole)standbyReactorChannel.role()).copy((ConsumerRole)startingReactorChannel.role());
                                if (standbyReactorChannel.role().type() != 1 || !((ConsumerRole)standbyReactorChannel.role()).watchlistOptions().enableWatchlist()) continue;
                                Watchlist watchlist = new Watchlist(standbyReactorChannel, (ConsumerRole)standbyReactorChannel.role());
                                standbyReactorChannel.watchlist(watchlist);
                                watchlist.watchlistOptions().enableWarmStandby(true);
                                watchlist._reactor = this;
                                standbyReactorChannel.warmStandByHandlerImpl = warmStandByHandlerImpl;
                                standbyReactorChannel.isActiveServer = false;
                                if (warmStandbyServerInfo.reactorConnectInfo().enableSessionManagement()) {
                                    boolean retVal;
                                    try {
                                        this.setupRestClient(errorInfo);
                                    }
                                    catch (Exception e) {
                                        this.removeReactorChannel(standbyReactorChannel);
                                        standbyReactorChannel.returnToPool();
                                        this._reactorChannelQueue.remove(standbyReactorChannel, ReactorChannel.REACTOR_CHANNEL_LINK);
                                        return this.populateErrorInfo(errorInfo, -1, "Reactor.setupRestClient", "failed to initialize the RESTClient, exception=" + e.getLocalizedMessage());
                                    }
                                    ReactorOAuthCredential oAuthCredential = this.retriveOAuthCredentialFromConsumerRole(standbyReactorChannel.role(), errorInfo);
                                    if (oAuthCredential != null) {
                                        tokenSession = this.getTokenSession(oAuthCredential, errorInfo);
                                        if (tokenSession == null) {
                                            standbyReactorChannel.returnToPool();
                                            return errorInfo.code();
                                        }
                                    } else {
                                        standbyReactorChannel.returnToPool();
                                        return errorInfo.code();
                                    }
                                    standbyReactorChannel.tokenSession(tokenSession);
                                    if (this.sessionManagementStartup(tokenSession, warmStandbyServerInfo.reactorConnectInfo(), standbyReactorChannel.role(), standbyReactorChannel, true, errorInfo) != 0) {
                                        this.removeReactorChannel(standbyReactorChannel);
                                        standbyReactorChannel.returnToPool();
                                        return errorInfo.code();
                                    }
                                    standbyReactorChannel.applyAccessToken();
                                    tokenSession.receivedAuthToken();
                                    tokenSession.originalExpiresIn(tokenSession.authTokenInfo().expiresIn());
                                    this.sendAuthTokenEventCallback(standbyReactorChannel, tokenSession.authTokenInfo(), errorInfo);
                                    standbyReactorChannel.sessionMgntState(ReactorChannel.SessionMgntState.RECEIVED_AUTH_TOKEN);
                                    if (!tokenSession.isInitialized() && !(retVal = tokenSession.authTokenInfo().tokenVersion() == ReactorAuthTokenInfo.TokenVersion.V1 ? this.sendAuthTokenWorkerEvent(tokenSession) : this.sendAuthTokenWorkerEvent(standbyReactorChannel, tokenSession))) {
                                        this.removeReactorChannel(standbyReactorChannel);
                                        standbyReactorChannel.returnToPool();
                                        this._reactorChannelQueue.remove(standbyReactorChannel, ReactorChannel.REACTOR_CHANNEL_LINK);
                                        return this.populateErrorInfo(errorInfo, -1, "Reactor.connect", "sendAuthTokenWorkerEvent() failed");
                                    }
                                    if (tokenSession.oAuthCredential().reactorOAuthCredentialEventCallback() != null) {
                                        tokenSession.oAuthCredential().password().clear();
                                        tokenSession.oAuthCredential().clientSecret().clear();
                                        tokenSession.authOptoins().clearSensitiveInfo();
                                    }
                                }
                                if (watchlist != null) {
                                    if (((ConsumerRole)standbyReactorChannel.role()).rdmLoginRequest() != null) {
                                        if (watchlist.submitMsg(((ConsumerRole)standbyReactorChannel.role()).rdmLoginRequest(), this.reactorSubmitOptions, errorInfo) != 0) {
                                            ++this._reactorChannelCount;
                                            this.cleanUpWSBRequestQueue(standbyReactorChannel.warmStandByHandlerImpl, standbyReactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl());
                                            ((ReactorWarmStandbyGroupImpl)reactorChannel.warmStandByHandlerImpl.warmStandbyGroupList().get(reactorChannel.standByGroupListIndex)).incrementClosingStandbyCount();
                                            if (this.closeChannel(standbyReactorChannel, errorInfo) == 0) continue;
                                            return -1;
                                        }
                                    } else if (startingWatchlist.loginHandler()._loginRequest != null && watchlist.submitMsg(startingWatchlist.loginHandler()._loginRequest, this.reactorSubmitOptions, errorInfo) != 0) {
                                        ++this._reactorChannelCount;
                                        this.cleanUpWSBRequestQueue(standbyReactorChannel.warmStandByHandlerImpl, standbyReactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl());
                                        ((ReactorWarmStandbyGroupImpl)reactorChannel.warmStandByHandlerImpl.warmStandbyGroupList().get(reactorChannel.standByGroupListIndex)).incrementClosingStandbyCount();
                                        if (this.closeChannel(standbyReactorChannel, errorInfo) == 0) continue;
                                        return -1;
                                    }
                                    if (((ConsumerRole)standbyReactorChannel.role()).rdmDirectoryRequest() != null && watchlist.submitMsg(((ConsumerRole)standbyReactorChannel.role()).rdmDirectoryRequest(), this.reactorSubmitOptions, errorInfo) != 0) {
                                        ++this._reactorChannelCount;
                                        this.cleanUpWSBRequestQueue(standbyReactorChannel.warmStandByHandlerImpl, standbyReactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl());
                                        ((ReactorWarmStandbyGroupImpl)reactorChannel.warmStandByHandlerImpl.warmStandbyGroupList().get(reactorChannel.standByGroupListIndex)).incrementClosingStandbyCount();
                                        if (this.closeChannel(standbyReactorChannel, errorInfo) == 0) continue;
                                        return -1;
                                    }
                                }
                                warmStandByHandlerImpl.warmStandByHandlerLock().lock();
                                try {
                                    warmStandByHandlerImpl.channelList().add(standbyReactorChannel);
                                }
                                finally {
                                    warmStandByHandlerImpl.warmStandByHandlerLock().unlock();
                                }
                                Channel channel = Transport.connect((ConnectOptions)warmStandbyServerInfo.reactorConnectInfo().connectOptions(), (Error)errorInfo.error());
                                standbyReactorChannel.selectableChannelFromChannel(channel);
                                standbyReactorChannel.reactor(this);
                                ++this._reactorChannelCount;
                                if (this._reactorOptions.debuggerOptions().debugConnectionLevel()) {
                                    if (channel != null) {
                                        this.debugger.writeDebugInfo("Reactor@%d, Reactor channel@%d connection executed on channel fd=%d.]\n", this.hashCode(), standbyReactorChannel.hashCode(), ReactorDebugger.getChannelId(standbyReactorChannel));
                                    } else {
                                        this.debugger.writeDebugInfo("Reactor@%d, Reactor channel@%d is DOWN on channel fd=%d.]\n", this.hashCode(), standbyReactorChannel.hashCode(), ReactorDebugger.getChannelId(standbyReactorChannel));
                                    }
                                }
                                standbyReactorChannel.state(ReactorChannel.State.INITIALIZING);
                                standbyReactorChannel._preferredHostOptions = startingReactorChannel._preferredHostOptions;
                                if (channel == null) {
                                    if (standbyReactorChannel.server() == null && !standbyReactorChannel.recoveryAttemptLimitReached()) {
                                        standbyReactorChannel.state(ReactorChannel.State.DOWN_RECONNECTING);
                                        this.sendAndHandleChannelEventCallback("Reactor.connect", 3, standbyReactorChannel, errorInfo);
                                        continue;
                                    }
                                    standbyReactorChannel.state(ReactorChannel.State.DOWN);
                                    this.sendAndHandleChannelEventCallback("Reactor.connect", 2, standbyReactorChannel, errorInfo);
                                    continue;
                                }
                                if (this.sendWorkerEvent(WorkerEventTypes.CHANNEL_INIT, standbyReactorChannel)) continue;
                                standbyReactorChannel.state(ReactorChannel.State.DOWN);
                                this.sendAndHandleChannelEventCallback("Reactor.connect", 2, standbyReactorChannel, errorInfo);
                                this.removeReactorChannel(standbyReactorChannel);
                                standbyReactorChannel.returnToPool();
                                this._reactorChannelQueue.remove(standbyReactorChannel, ReactorChannel.REACTOR_CHANNEL_LINK);
                                return this.populateErrorInfo(errorInfo, -1, "Reactor.connect", "sendWorkerEvent() failed");
                            }
                            break block125;
                        }
                        case 11: {
                            warmStandByHandlerImpl.warmStandByHandlerLock().lock();
                            if (warmStandByHandlerImpl.currentWarmStandbyGroupImpl().warmStandbyMode() == 1) {
                                if (warmStandByHandlerImpl.activeReactorChannel() != null) {
                                    warmStandByHandlerImpl.activeReactorChannel().isActiveServer = false;
                                    if (reactorChannel._loginConsumerStatus == null) {
                                        reactorChannel._loginConsumerStatus = (LoginConsumerConnectionStatus)LoginMsgFactory.createMsg();
                                        reactorChannel._loginConsumerStatus.rdmMsgType(LoginMsgType.CONSUMER_CONNECTION_STATUS);
                                    }
                                    reactorChannel._loginConsumerStatus.clear();
                                    reactorChannel._loginConsumerStatus.streamId(1);
                                    reactorChannel._loginConsumerStatus.flags(1);
                                    reactorChannel._loginConsumerStatus.warmStandbyInfo().warmStandbyMode(1L);
                                    if (this.submitChannel(warmStandByHandlerImpl.activeReactorChannel(), reactorChannel._loginConsumerStatus, this.reactorSubmitOptions, errorInfo) < 0) {
                                        if (warmStandByHandlerImpl.startingReactorChannel().server() == null && !warmStandByHandlerImpl.startingReactorChannel().recoveryAttemptLimitReached()) {
                                            warmStandByHandlerImpl.startingReactorChannel().state(ReactorChannel.State.DOWN_RECONNECTING);
                                            this.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 3, warmStandByHandlerImpl.startingReactorChannel(), errorInfo);
                                        } else {
                                            warmStandByHandlerImpl.startingReactorChannel().state(ReactorChannel.State.DOWN);
                                            this.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 2, warmStandByHandlerImpl.startingReactorChannel(), errorInfo);
                                        }
                                    }
                                }
                                if (reactorChannel._loginConsumerStatus == null) {
                                    reactorChannel._loginConsumerStatus = (LoginConsumerConnectionStatus)LoginMsgFactory.createMsg();
                                    reactorChannel._loginConsumerStatus.rdmMsgType(LoginMsgType.CONSUMER_CONNECTION_STATUS);
                                }
                                reactorChannel._loginConsumerStatus.clear();
                                reactorChannel._loginConsumerStatus.streamId(1);
                                reactorChannel._loginConsumerStatus.flags(1);
                                reactorChannel._loginConsumerStatus.warmStandbyInfo().warmStandbyMode(0L);
                                if (this.submitChannel(warmStandByHandlerImpl.startingReactorChannel(), reactorChannel._loginConsumerStatus, this.reactorSubmitOptions, errorInfo) < 0) {
                                    if (warmStandByHandlerImpl.startingReactorChannel().server() == null && !warmStandByHandlerImpl.startingReactorChannel().recoveryAttemptLimitReached()) {
                                        warmStandByHandlerImpl.startingReactorChannel().state(ReactorChannel.State.DOWN_RECONNECTING);
                                        this.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 3, warmStandByHandlerImpl.startingReactorChannel(), errorInfo);
                                        warmStandByHandlerImpl.warmStandByHandlerLock().unlock();
                                        break;
                                    }
                                    warmStandByHandlerImpl.startingReactorChannel().state(ReactorChannel.State.DOWN);
                                    this.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 2, warmStandByHandlerImpl.startingReactorChannel(), errorInfo);
                                    warmStandByHandlerImpl.warmStandByHandlerLock().unlock();
                                    break;
                                }
                                warmStandByHandlerImpl.startingReactorChannel().isActiveServer = true;
                                warmStandByHandlerImpl.activeReactorChannel(warmStandByHandlerImpl.startingReactorChannel());
                                this.reactorWSBFanoutStatusMsg(warmStandByHandlerImpl.startingReactorChannel(), errorInfo);
                                warmStandByHandlerImpl.nextActiveReactorChannel(null);
                            } else if (warmStandbyGroup.warmStandbyMode() == 2) {
                                for (ReactorChannel channel : warmStandByHandlerImpl.channelList()) {
                                    if (channel == null || channel.channel() == null || channel.channel().state() != 2) continue;
                                    if (this.preferredHostFallbackForWSBService(channel, errorInfo) != 0) {
                                        warmStandByHandlerImpl.warmStandByHandlerLock().unlock();
                                        return -1;
                                    }
                                    channel._switchingToPreferredWSBGroup = false;
                                }
                                pReactorChannel._switchingToPreferredWSBGroup = false;
                                for (WlInteger serviceId : warmStandbyGroup._perServiceById.keySet()) {
                                    warmStandbyGroup._perServiceById.get((Object)serviceId).preferredHostSwitched = false;
                                }
                            }
                            warmStandByHandlerImpl.warmStandByHandlerLock().unlock();
                            reactorChannel._switchingToPreferredWSBGroup = false;
                            this.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 8, reactorChannel, reactorChannel.getEDPErrorInfo());
                            break;
                        }
                    }
                    break;
                }
                case PREFERRED_HOST_SWITCH_CHANNEL: {
                    boolean switchingFromChannelListToWSB = true;
                    boolean switchToWSB = false;
                    if (reactorChannel.warmStandByHandlerImpl != null) {
                        for (ReactorWarmStandbyGroup wsbGroup : reactorChannel.warmStandByHandlerImpl.startingReactorChannel().getReactorConnectOptions().reactorWarmStandbyGroupList()) {
                            if (reactorChannel.preferredHostChannel() != null && wsbGroup.startingActiveServer().reactorConnectInfo().connectOptions().unifiedNetworkInfo().address().equals(reactorChannel.preferredHostChannel().hostname()) && wsbGroup.startingActiveServer().reactorConnectInfo().connectOptions().unifiedNetworkInfo().serviceName().equals(String.valueOf(reactorChannel.preferredHostChannel().port()))) {
                                switchToWSB = true;
                            }
                            if (reactorChannel.warmStandByHandlerImpl.startingReactorChannel().getCurrentReactorConnectInfo() == wsbGroup.startingActiveServer().reactorConnectInfo()) {
                                switchingFromChannelListToWSB = false;
                            }
                            for (ReactorWarmStandbyServerInfo standbyInfo : wsbGroup.standbyServerList()) {
                                if (reactorChannel.warmStandByHandlerImpl.startingReactorChannel().getCurrentReactorConnectInfo() != standbyInfo.reactorConnectInfo()) continue;
                                switchingFromChannelListToWSB = false;
                            }
                        }
                        if (switchingFromChannelListToWSB) {
                            reactorChannel.warmStandByHandlerImpl.startingReactorChannel()._ignoreClosedStandbyCount = true;
                            reactorChannel.warmStandByHandlerImpl.startingReactorChannel()._phSwitchingFromChannelListToWSB = true;
                            reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl().reactorChannelType(0);
                        }
                        if (reactorChannel._phTempConnectOptionsInfo != null) {
                            reactorChannel.warmStandByHandlerImpl.startingReactorChannel().setCurrentConnectOptionsInfo(reactorChannel._phTempConnectOptionsInfo);
                        }
                        if (reactorChannel._phTempReactorConnectInfo != null) {
                            reactorChannel.warmStandByHandlerImpl.startingReactorChannel().setCurrentReactorConnectInfo(reactorChannel._phTempReactorConnectInfo);
                        }
                        if (reactorChannel._phTempReactorConnectOptions != null) {
                            reactorChannel.warmStandByHandlerImpl.startingReactorChannel()._reactorConnectOptions = reactorChannel._phTempReactorConnectOptions;
                        }
                        reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl().preferredHostChannel(reactorChannel.preferredHostChannel());
                    } else {
                        switchingFromChannelListToWSB = false;
                    }
                    reactorChannel.initiateSwitch(true, switchingFromChannelListToWSB);
                    if (reactorChannel.warmStandByHandlerImpl != null) {
                        if (reactorChannel._phTempUserSpecObj != null) {
                            reactorChannel.warmStandByHandlerImpl.startingReactorChannel().userSpecObj(reactorChannel._phTempUserSpecObj);
                        }
                        if (!switchToWSB) break;
                        reactorChannel.warmStandByHandlerImpl.startingReactorChannel().reactorChannelType(1);
                        break;
                    }
                    if (reactorChannel._phTempUserSpecObj == null) break;
                    reactorChannel.userSpecObj(reactorChannel._phTempUserSpecObj);
                    break;
                }
                case PREFERRED_HOST_START_FALLBACK: {
                    this.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 9, reactorChannel, reactorChannel.getEDPErrorInfo());
                    break;
                }
                case PREFERRED_HOST_COMPLETE: {
                    if (reactorChannel.warmStandByHandlerImpl != null) {
                        reactorChannel.warmStandByHandlerImpl.startingReactorChannel()._switchingToPreferredWSBGroup = false;
                        reactorChannel.warmStandByHandlerImpl.startingReactorChannel()._switchingToPreferredHost = false;
                    } else {
                        reactorChannel._switchingToPreferredWSBGroup = false;
                        reactorChannel._switchingToPreferredHost = false;
                    }
                    this.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 8, reactorChannel, reactorChannel.getEDPErrorInfo());
                    break;
                }
                case PREFERRED_HOST_NO_FALLBACK: {
                    this.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 10, reactorChannel, reactorChannel.getEDPErrorInfo());
                    break;
                }
                case PREFERRED_HOST_CHANNEL_CLOSE_ACK: {
                    if (reactorChannel.warmStandByHandlerImpl != null && reactorChannel != reactorChannel.warmStandByHandlerImpl.startingReactorChannel()) break;
                    if (reactorChannel.warmStandByHandlerImpl != null) {
                        if (reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl().preferredHostChannel() != null) {
                            reactorChannel.selectableChannelFromChannel(reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl().preferredHostChannel());
                            reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl().preferredHostChannel(null);
                        }
                    } else if (reactorChannel.preferredHostChannel() != null) {
                        reactorChannel.selectableChannelFromChannel(reactorChannel.preferredHostChannel());
                        reactorChannel.preferredHostChannel(null);
                    }
                    if (reactorChannel.warmStandByHandlerImpl != null) {
                        if (reactorChannel._phTempConnectOptionsInfo != null) {
                            reactorChannel.setCurrentConnectOptionsInfo(reactorChannel.warmStandByHandlerImpl.startingReactorChannel().getCurrentConnectOptionsInfo());
                        }
                        if (reactorChannel._phTempReactorConnectInfo != null) {
                            reactorChannel.setCurrentReactorConnectInfo(reactorChannel.warmStandByHandlerImpl.startingReactorChannel().getCurrentReactorConnectInfo());
                        }
                        if (reactorChannel._phTempReactorConnectOptions != null) {
                            reactorChannel._reactorConnectOptions = reactorChannel.warmStandByHandlerImpl.startingReactorChannel()._reactorConnectOptions;
                        }
                        if (reactorChannel._phTempUserSpecObj != null) {
                            reactorChannel.userSpecObj(reactorChannel.warmStandByHandlerImpl.startingReactorChannel().userSpecObj());
                        }
                        reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl().preferredHostChannel(null);
                        reactorChannel.warmStandByHandlerImpl.startingReactorChannel().preferredHostChannel(null);
                    }
                    reactorChannel._phTempConnectOptionsInfo = null;
                    reactorChannel._phTempReactorConnectInfo = null;
                    reactorChannel._phTempUserSpecObj = null;
                    reactorChannel._phTempReactorConnectOptions = null;
                    if (reactorChannel.warmStandByHandlerImpl != null) {
                        event.reactorChannel(reactorChannel.warmStandByHandlerImpl.startingReactorChannel());
                        event.reactorChannel().state(ReactorChannel.State.DOWN_RECONNECTING);
                    }
                    this.processChannelUp(event, errorInfo);
                    if (reactorChannel.warmStandByHandlerImpl != null) {
                        this.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 8, reactorChannel.warmStandByHandlerImpl.startingReactorChannel(), reactorChannel.getEDPErrorInfo());
                    } else {
                        this.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 8, reactorChannel, reactorChannel.getEDPErrorInfo());
                    }
                    if (reactorChannel.warmStandByHandlerImpl != null) {
                        if (!this._reactorOptions.debuggerOptions().debugConnectionLevel()) break;
                        this.debugger.writeDebugInfo("Switched to WarmStandByGroup Index: " + event.reactorChannel()._preferredHostOptions.warmStandbyGroupListIndex(), this.hashCode(), this.hashCode());
                        break;
                    }
                    if (!this._reactorOptions.debuggerOptions().debugConnectionLevel()) break;
                    this.debugger.writeDebugInfo("Switched to Connection List Index: " + event.reactorChannel()._preferredHostOptions.connectionListIndex(), this.hashCode(), this.hashCode());
                    break;
                }
                case PREFERRED_HOST_SUBMIT_MSG_RECOVERY_QUEUE: {
                    if (reactorChannel.warmStandByHandlerImpl == null) break;
                    this.queueRequestsForWSBGroupRecovery(reactorChannel.warmStandByHandlerImpl, errorInfo);
                    reactorChannel.warmStandByHandlerImpl.startingReactorChannel().sendReqFromQueue = false;
                    break;
                }
                default: {
                    event.returnToPool();
                    return this.populateErrorInfo(errorInfo, -1, "Reactor.processWorkerEvent", "received an unexpected WorkerEventType of " + (Object)((Object)eventType));
                }
            }
        }
        event.returnToPool();
        return errorInfo.code();
    }

    private boolean checkWhetherTheActiveReactorChannelHasServiceAsPreferred(ReactorChannel reactorChannel, Buffer serviceName) {
        ReactorPerServiceBasedOptions serviceOptions = reactorChannel.isStartingServerConfig ? reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl().startingActiveServer().perServiceBasedOptions() : reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl().standbyServerList().get(reactorChannel.standByServerListIndex).perServiceBasedOptions();
        for (Buffer preferredServiceName : serviceOptions.serviceNameList()) {
            if (!preferredServiceName.equals(serviceName)) continue;
            return true;
        }
        return false;
    }

    int preferredHostFallbackForWSBService(ReactorChannel reactorChannel, ReactorErrorInfo errorInfo) {
        ReactorPerServiceBasedOptions serviceOptions = reactorChannel.isStartingServerConfig ? reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl().startingActiveServer().perServiceBasedOptions() : reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl().standbyServerList().get(reactorChannel.standByServerListIndex).perServiceBasedOptions();
        for (Buffer serviceName : serviceOptions.serviceNameList()) {
            WlService service = reactorChannel.watchlist().directoryHandler().service(serviceName.toString());
            if (service == null || service.rdmService().state() == null || service.rdmService().state().serviceState() != 1L || service.rdmService().state().acceptingRequests() != 1L) continue;
            WlInteger serviceId = ReactorFactory.createWlInteger();
            serviceId.value(service.rdmService().serviceId());
            ReactorWSBService wsbService = reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl()._perServiceById.get(serviceId);
            boolean hasAsPreferredServiceName = this.checkWhetherTheActiveReactorChannelHasServiceAsPreferred(wsbService.activeChannel, serviceName);
            if (wsbService == null || wsbService.preferredHostSwitched || reactorChannel == wsbService.activeChannel || hasAsPreferredServiceName) continue;
            ReactorChannel oldChannel = wsbService.activeChannel;
            if (oldChannel.channel().state() == 2) {
                if (oldChannel._serviceConsumerStatus == null) {
                    oldChannel._serviceConsumerStatus = (ConsumerStatusService)((Object)DirectoryMsgFactory.createMsg());
                }
                oldChannel._serviceConsumerStatus.applyHasWarmStandbyMode();
                oldChannel._serviceConsumerStatus.serviceId(service.rdmService().serviceId());
                oldChannel._serviceConsumerStatus.flags(2);
                oldChannel._serviceConsumerStatus.warmStandbyMode(1L);
                oldChannel._directoryConsumerStatus.clear();
                oldChannel._directoryConsumerStatus.streamId(oldChannel.watchlist().directoryHandler()._directoryStreamId);
                oldChannel._directoryConsumerStatus.consumerServiceStatusList().add(oldChannel._serviceConsumerStatus);
                if (this.submitChannel(oldChannel, oldChannel._directoryConsumerStatus, this.reactorSubmitOptions, errorInfo) < 0) {
                    if (reactorChannel.warmStandByHandlerImpl.startingReactorChannel().server() == null && !reactorChannel.warmStandByHandlerImpl.startingReactorChannel().recoveryAttemptLimitReached()) {
                        reactorChannel.warmStandByHandlerImpl.startingReactorChannel().state(ReactorChannel.State.DOWN_RECONNECTING);
                        this.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 3, reactorChannel.warmStandByHandlerImpl.startingReactorChannel(), errorInfo);
                    } else {
                        reactorChannel.warmStandByHandlerImpl.startingReactorChannel().state(ReactorChannel.State.DOWN);
                        this.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 2, reactorChannel.warmStandByHandlerImpl.startingReactorChannel(), errorInfo);
                    }
                }
            }
            if (reactorChannel._serviceConsumerStatus == null) {
                reactorChannel._serviceConsumerStatus = (ConsumerStatusService)((Object)DirectoryMsgFactory.createMsg());
            }
            wsbService.activeChannel = reactorChannel;
            reactorChannel._serviceConsumerStatus.applyHasWarmStandbyMode();
            reactorChannel._serviceConsumerStatus.serviceId(service.rdmService().serviceId());
            reactorChannel._serviceConsumerStatus.flags(2);
            reactorChannel._serviceConsumerStatus.warmStandbyMode(0L);
            reactorChannel._directoryConsumerStatus.clear();
            reactorChannel._directoryConsumerStatus.streamId(reactorChannel.watchlist().directoryHandler()._directoryStreamId);
            reactorChannel._directoryConsumerStatus.consumerServiceStatusList().add(reactorChannel._serviceConsumerStatus);
            if (this.submitChannel(reactorChannel, reactorChannel._directoryConsumerStatus, this.reactorSubmitOptions, errorInfo) < 0) {
                if (reactorChannel.warmStandByHandlerImpl.startingReactorChannel().server() != null || reactorChannel.warmStandByHandlerImpl.startingReactorChannel().recoveryAttemptLimitReached()) {
                    reactorChannel.warmStandByHandlerImpl.startingReactorChannel().state(ReactorChannel.State.DOWN);
                    this.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 2, reactorChannel.warmStandByHandlerImpl.startingReactorChannel(), errorInfo);
                    return -1;
                }
                reactorChannel.warmStandByHandlerImpl.startingReactorChannel().state(ReactorChannel.State.DOWN_RECONNECTING);
                this.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 3, reactorChannel.warmStandByHandlerImpl.startingReactorChannel(), errorInfo);
                return 0;
            }
            wsbService.preferredHostSwitched = true;
        }
        return 0;
    }

    void reactorWSBHandleServiceActiveStandby(ReactorChannel reactorChannel, ReactorWarmStandbyGroupImpl warmStandbyGroup, boolean initialActive, ReactorErrorInfo errorInfo) {
        if (warmStandbyGroup.warmStandbyMode() == 2) {
            for (int i = 0; i < reactorChannel.watchlist().directoryHandler()._serviceCache._serviceList.size(); ++i) {
                WlService wlService = reactorChannel.watchlist().directoryHandler()._serviceCache._serviceList.get(i);
                boolean activeService = this.wsbServiceInStartupList(warmStandbyGroup, wlService, reactorChannel);
                ReactorWSBService service = warmStandbyGroup._perServiceById.get(wlService._tableKey);
                if (service.activeChannel == reactorChannel) continue;
                if (service.activeChannel == null && wlService._rdmService.state().serviceState() == 1L && activeService) {
                    reactorChannel._directoryConsumerStatus.clear();
                    reactorChannel._directoryConsumerStatus.streamId(reactorChannel.watchlist().directoryHandler()._directoryStreamId);
                    reactorChannel._serviceConsumerStatus.clear();
                    reactorChannel._serviceConsumerStatus.flags(2);
                    reactorChannel._serviceConsumerStatus.warmStandbyMode(0L);
                    reactorChannel._serviceConsumerStatus.serviceId(wlService._rdmService.serviceId());
                    reactorChannel._directoryConsumerStatus.consumerServiceStatusList().add(reactorChannel._serviceConsumerStatus);
                    if (this.submitChannel(reactorChannel, reactorChannel._directoryConsumerStatus, this.reactorSubmitOptions, errorInfo) < 0) {
                        if (reactorChannel.server() == null && !reactorChannel.recoveryAttemptLimitReached()) {
                            reactorChannel.state(ReactorChannel.State.DOWN_RECONNECTING);
                            this.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 3, reactorChannel, errorInfo);
                            return;
                        }
                        reactorChannel.state(ReactorChannel.State.DOWN);
                        this.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 2, reactorChannel, errorInfo);
                        return;
                    }
                    service.activeChannel = reactorChannel;
                    continue;
                }
                reactorChannel._directoryConsumerStatus.clear();
                reactorChannel._directoryConsumerStatus.streamId(reactorChannel.watchlist().directoryHandler()._directoryStreamId);
                reactorChannel._serviceConsumerStatus.clear();
                reactorChannel._serviceConsumerStatus.flags(2);
                reactorChannel._serviceConsumerStatus.warmStandbyMode(1L);
                reactorChannel._serviceConsumerStatus.serviceId(wlService._rdmService.serviceId());
                reactorChannel._directoryConsumerStatus.consumerServiceStatusList().add(reactorChannel._serviceConsumerStatus);
                if (this.submitChannel(reactorChannel, reactorChannel._directoryConsumerStatus, this.reactorSubmitOptions, errorInfo) >= 0) continue;
                if (reactorChannel.server() == null && !reactorChannel.recoveryAttemptLimitReached()) {
                    reactorChannel.state(ReactorChannel.State.DOWN_RECONNECTING);
                    this.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 3, reactorChannel, errorInfo);
                    return;
                }
                reactorChannel.state(ReactorChannel.State.DOWN);
                this.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 2, reactorChannel, errorInfo);
                return;
            }
            if (!initialActive && this.submitWSBRequestQueue(reactorChannel.warmStandByHandlerImpl, reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl(), reactorChannel, errorInfo) != 0) {
                if (reactorChannel.server() == null && !reactorChannel.recoveryAttemptLimitReached()) {
                    reactorChannel.state(ReactorChannel.State.DOWN_RECONNECTING);
                    this.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 3, reactorChannel, errorInfo);
                    return;
                }
                reactorChannel.state(ReactorChannel.State.DOWN);
                this.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 2, reactorChannel, errorInfo);
                return;
            }
        }
    }

    private void processWorkerShutdown(WorkerEvent event, String location, ReactorErrorInfo errorInfo) {
        this.populateErrorInfo(errorInfo, -1, location, "Worker has shutdown, " + event.errorInfo().toString());
    }

    private void processChannelDown(WorkerEvent event, ReactorErrorInfo errorInfo) {
        ReactorChannel reactorChannel = event.reactorChannel();
        if (reactorChannel.state() != ReactorChannel.State.CLOSED) {
            if (reactorChannel.server() == null && !reactorChannel.recoveryAttemptLimitReached()) {
                reactorChannel.state(ReactorChannel.State.DOWN_RECONNECTING);
                if (reactorChannel._preferredHostOptions.isPreferredHostEnabled() && reactorChannel.switchingToPreferredHost()) {
                    reactorChannel._switchingToPreferredHost = false;
                }
                this.sendAndHandleChannelEventCallback("Reactor.processChannelDown", 3, reactorChannel, errorInfo);
            } else {
                reactorChannel.state(ReactorChannel.State.DOWN);
                this.sendAndHandleChannelEventCallback("Reactor.processChannelDown", 2, reactorChannel, errorInfo);
            }
        }
    }

    private void processChannelUp(WorkerEvent event, ReactorErrorInfo errorInfo) {
        ReactorChannel reactorChannel = event.reactorChannel();
        ReactorRole reactorRole = reactorChannel.role();
        if (reactorChannel.state() == ReactorChannel.State.CLOSED || reactorChannel.state() == ReactorChannel.State.DOWN) {
            return;
        }
        reactorChannel.tunnelStreamManager().setChannel(reactorChannel, errorInfo.error());
        reactorChannel.state(ReactorChannel.State.UP);
        if (reactorChannel.watchlist() == null) {
            reactorChannel.resetReconnectTimers();
        }
        if (reactorRole.type() == 1) {
            boolean checkingPHTimerStartedByChannelUp = reactorChannel._preferredHostTimersStartedByChannelUp;
            if (reactorChannel.warmStandByHandlerImpl != null) {
                checkingPHTimerStartedByChannelUp = reactorChannel.warmStandByHandlerImpl.isPHTimersStartedByChannelUp;
            }
            if (reactorChannel._preferredHostOptions.isPreferredHostEnabled() && !checkingPHTimerStartedByChannelUp) {
                if (reactorChannel._preferredHostOptions.detectionTimeSchedule() != null && !reactorChannel._preferredHostOptions.detectionTimeSchedule().isEmpty()) {
                    try {
                        reactorChannel._cronExpression = new CronExpression(reactorChannel._preferredHostOptions.detectionTimeSchedule());
                    }
                    catch (ParseException e) {
                        this.populateErrorInfo(errorInfo, -1, "Reactor.connect", "Parse exception occured on preferredHostOptions scheduled cron time, aborting.");
                        return;
                    }
                    if (!this.sendWorkerEvent(WorkerEventTypes.PREFERRED_HOST_TIMER, reactorChannel)) {
                        reactorChannel.state(ReactorChannel.State.DOWN);
                        this.sendAndHandleChannelEventCallback("Reactor.connect", 2, reactorChannel, errorInfo);
                        this.removeReactorChannel(reactorChannel);
                        reactorChannel.returnToPool();
                        this._reactorChannelQueue.remove(reactorChannel, ReactorChannel.REACTOR_CHANNEL_LINK);
                        this.populateErrorInfo(errorInfo, -1, "Reactor.connect", "sendWorkerEvent() failed");
                        return;
                    }
                    if (reactorChannel.warmStandByHandlerImpl != null) {
                        reactorChannel.warmStandByHandlerImpl.isPHTimersStartedByChannelUp = true;
                    } else {
                        reactorChannel._preferredHostTimersStartedByChannelUp = true;
                    }
                } else if (reactorChannel._preferredHostOptions.detectionTimeInterval() > 0L) {
                    if (!this.sendWorkerEvent(WorkerEventTypes.PREFERRED_HOST_TIMER, reactorChannel)) {
                        reactorChannel.state(ReactorChannel.State.DOWN);
                        this.sendAndHandleChannelEventCallback("Reactor.connect", 2, reactorChannel, errorInfo);
                        this.removeReactorChannel(reactorChannel);
                        reactorChannel.returnToPool();
                        this._reactorChannelQueue.remove(reactorChannel, ReactorChannel.REACTOR_CHANNEL_LINK);
                        this.populateErrorInfo(errorInfo, -1, "Reactor.connect", "sendWorkerEvent() failed");
                        return;
                    }
                    if (reactorChannel.warmStandByHandlerImpl != null) {
                        reactorChannel.warmStandByHandlerImpl.isPHTimersStartedByChannelUp = true;
                    } else {
                        reactorChannel._preferredHostTimersStartedByChannelUp = true;
                    }
                }
            }
        }
        this._readArgsAggregator.clear();
        this._writeArgsAggregator.clear();
        reactorChannel.pingHandler().resetAggregatedStats();
        if (this._reactorOptions.debuggerOptions().debugConnectionLevel()) {
            this.debugger.writeDebugInfo("Reactor@%d, Reactor channel@%d is UP on channel fd=%d.]\n", this.hashCode(), reactorChannel.hashCode(), ReactorDebugger.getChannelId(reactorChannel));
        }
        if (this.sendAndHandleChannelEventCallback("Reactor.processChannelUp", 1, reactorChannel, errorInfo) != 0) {
            return;
        }
        if (reactorRole.type() == 1) {
            if (reactorChannel.state() == ReactorChannel.State.CLOSED || reactorChannel.state() == ReactorChannel.State.DOWN) {
                return;
            }
            LoginRequest loginRequest = null;
            loginRequest = reactorChannel.enableSessionManagement() ? reactorChannel._loginRequestForEDP : ((ConsumerRole)reactorRole).rdmLoginRequest();
            if (loginRequest != null) {
                if (reactorChannel.watchlist() == null) {
                    this.encodeAndWriteLoginRequest(loginRequest, reactorChannel, errorInfo);
                } else {
                    if (reactorChannel.watchlist()._loginHandler != null && reactorChannel.watchlist()._loginHandler._loginRequestForEDP != null) {
                        reactorChannel.watchlist()._loginHandler._loginRequestForEDP.userName(loginRequest.userName());
                    }
                    reactorChannel.watchlist()._loginHandler.rttEnabled = loginRequest.attrib().checkHasSupportRoundTripLatencyMonitoring();
                    reactorChannel.watchlist().channelUp(errorInfo);
                }
            } else {
                reactorChannel.state(ReactorChannel.State.READY);
                if (this.sendAndHandleChannelEventCallback("Reactor.processChannelUp", 4, reactorChannel, errorInfo) != 0) {
                    return;
                }
            }
        } else if (reactorRole.type() == 3) {
            if (reactorChannel.state() == ReactorChannel.State.CLOSED || reactorChannel.state() == ReactorChannel.State.DOWN) {
                return;
            }
            LoginRequest loginRequest = ((NIProviderRole)reactorRole).rdmLoginRequest();
            if (loginRequest != null) {
                this.encodeAndWriteLoginRequest(loginRequest, reactorChannel, errorInfo);
            } else {
                reactorChannel.state(ReactorChannel.State.READY);
                reactorChannel.clearAccessTokenForV2();
                if (this.sendAndHandleChannelEventCallback("Reactor.processChannelUp", 4, reactorChannel, errorInfo) != 0) {
                    return;
                }
            }
        } else if (reactorRole.type() == 2) {
            reactorChannel.state(ReactorChannel.State.READY);
            if (this.sendAndHandleChannelEventCallback("Reactor.processChannelUp", 4, reactorChannel, errorInfo) != 0) {
                return;
            }
        }
    }

    private void encodeAndWriteLoginRequest(LoginRequest loginRequest, ReactorChannel reactorChannel, ReactorErrorInfo errorInfo) {
        Channel channel = reactorChannel.channel();
        if (channel == null) {
            this.populateErrorInfo(errorInfo, -1, "Reactor.encodeAndWriteLoginRequest", "Failed to obtain an action channel");
            return;
        }
        int bufSize = this.getMaxFragmentSize(reactorChannel, errorInfo);
        if (bufSize < 0) {
            return;
        }
        TransportBuffer msgBuf = channel.getBuffer(bufSize, false, errorInfo.error());
        if (msgBuf == null) {
            this.populateErrorInfo(errorInfo, -1, "Reactor.encodeAndWriteLoginRequest", "Failed to obtain a TransportBuffer, reason=" + errorInfo.error().text());
            return;
        }
        this._eIter.clear();
        this._eIter.setBufferAndRWFVersion(msgBuf, channel.majorVersion(), channel.minorVersion());
        int retval = loginRequest.encode(this._eIter);
        if (retval != 0) {
            reactorChannel.state(ReactorChannel.State.DOWN);
            this.sendAndHandleChannelEventCallback("Reactor.encodeAndWriteLoginRequest", 2, reactorChannel, errorInfo);
            this.populateErrorInfo(errorInfo, -1, "Reactor.encodeAndWriteLoginRequest", "Encoding of login request failed: <" + TransportReturnCodes.toString((int)retval) + ">");
            return;
        }
        if (reactorChannel.channel().protocolType() == 2) {
            if (Objects.isNull(this.jsonConverter)) {
                this.populateErrorInfo(errorInfo, -1, "Reactor.submitChannel", "The JSON converter library has not been initialized properly.");
                return;
            }
            this.jsonDecodeMsg.clear();
            this._dIter.clear();
            int ret = this._dIter.setBufferAndRWFVersion(msgBuf, reactorChannel.majorVersion(), reactorChannel.minorVersion());
            ret = this.jsonDecodeMsg.decode(this._dIter);
            if (ret == 0) {
                this.converterError.clear();
                this.rwfToJsonOptions.clear();
                this.rwfToJsonOptions.setJsonProtocolType(2);
                if (this.jsonConverter.convertRWFToJson(this.jsonDecodeMsg, this.rwfToJsonOptions, this.conversionResults, this.converterError) != 0) {
                    this.populateErrorInfo(errorInfo, -1, "Reactor.submitChannel", "Failed to convert RWF to JSON protocol. Error text: " + this.converterError.getText());
                    return;
                }
                TransportBuffer buffer = reactorChannel.getBuffer(this.conversionResults.getLength(), false, errorInfo);
                if (Objects.isNull(buffer)) {
                    this.populateErrorInfo(errorInfo, -1, "Reactor.submitChannel", "Failed to get a buffer for sending JSON message. Error text: " + errorInfo.error().text());
                    return;
                }
                this.getJsonMsgOptions.clear();
                this.getJsonMsgOptions.jsonProtocolType(2);
                this.getJsonMsgOptions.isCloseMsg(this.jsonDecodeMsg.msgClass() == 5);
                if (this.jsonConverter.getJsonBuffer(buffer, this.getJsonMsgOptions, this.converterError) != 0) {
                    this.populateErrorInfo(errorInfo, -1, "Reactor.submitChannel", "Failed to get converted JSON message. Error text: " + this.converterError.getText());
                    return;
                }
                reactorChannel.releaseBuffer(msgBuf, errorInfo);
                msgBuf = buffer;
            }
        }
        if ((this._reactorOptions.xmlTracing() || this._reactorOptions.xmlTraceToFile()) && this._reactorOptions.xmlTraceWrite()) {
            this.xmlString.setLength(0);
            this.xmlString.append("\n<!-- Outgoing Reactor message -->\n").append("<!-- ").append(reactorChannel.selectableChannel().toString()).append(" -->\n").append("<!-- ").append(new Date()).append(" -->\n");
            this.xmlDumpTrace.dumpBuffer(reactorChannel.channel(), reactorChannel.channel().protocolType(), msgBuf, null, this.xmlString, errorInfo.error());
            if (this._reactorOptions.xmlTracing()) {
                System.out.println(this.xmlString);
            }
            if (this._reactorOptions.xmlTraceToFile()) {
                this._fileDumper.dump(this.xmlString.toString());
            }
        }
        retval = channel.write(msgBuf, this._writeArgs, errorInfo.error());
        if (this._reactorOptions.writeStatSet()) {
            ((WriteArgsImpl)this._writeArgsAggregator).bytesWritten(this.overflowSafeAggregate(this._writeArgsAggregator.bytesWritten(), this._writeArgs.bytesWritten()));
            ((WriteArgsImpl)this._writeArgsAggregator).uncompressedBytesWritten(this.overflowSafeAggregate(this._writeArgsAggregator.uncompressedBytesWritten(), this._writeArgs.uncompressedBytesWritten()));
        }
        if (retval > 0) {
            this.sendFlushRequest(reactorChannel, "Reactor.encodeAndWriteLoginRequest", errorInfo);
        } else if (retval < 0) {
            if (reactorChannel.server() == null && !reactorChannel.recoveryAttemptLimitReached()) {
                reactorChannel.state(ReactorChannel.State.DOWN_RECONNECTING);
                this.sendAndHandleChannelEventCallback("Reactor.encodeAndWriteLoginRequest", 3, reactorChannel, errorInfo);
            } else {
                reactorChannel.state(ReactorChannel.State.DOWN);
                this.sendAndHandleChannelEventCallback("Reactor.encodeAndWriteLoginRequest", 2, reactorChannel, errorInfo);
            }
            this.populateErrorInfo(errorInfo, -1, "Reactor.encodeAndWriteLoginRequest", "Channel.write failed to write login request: <" + CodecReturnCodes.toString((int)retval) + "> error=" + errorInfo.error().text());
        } else {
            reactorChannel.flushAgain(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private int proceedLoginGenericMsg(ReactorChannel reactorChannel, DecodeIterator decodeIterator, Msg msg, ReactorErrorInfo errorInfo) {
        LoginMsg loginGenericMsg;
        block5: {
            block4: {
                loginGenericMsg = this._loginMsg;
                if (!Objects.equals(133, msg.containerType())) break block4;
                loginGenericMsg.rdmMsgType(LoginMsgType.RTT);
                switch (reactorChannel.role().type()) {
                    case 2: {
                        break block5;
                    }
                    case 1: {
                        ConsumerRole consumerRole = (ConsumerRole)reactorChannel.role();
                        if (!consumerRole.rttEnabled()) return -1;
                        this.returnBackRTTMessage(msg, reactorChannel, errorInfo);
                        break block5;
                    }
                    default: {
                        return -1;
                    }
                }
            }
            loginGenericMsg.rdmMsgType(LoginMsgType.CONSUMER_CONNECTION_STATUS);
        }
        if (loginGenericMsg.decode(decodeIterator, msg) == 0) return 0;
        return -2;
    }

    private void returnBackRTTMessage(Msg msg, ReactorChannel reactorChannel, ReactorErrorInfo errorInfo) {
        this.reactorSubmitOptions.clear();
        int retval = this.submitChannel(reactorChannel, msg, this.reactorSubmitOptions, errorInfo);
        if (retval != 0) {
            this.populateErrorInfo(errorInfo, -1, "Reactor.returnBackRTTMessage", "Reactor.submitChannel failed to return back login RTT message: <" + CodecReturnCodes.toString((int)retval) + "> error=" + errorInfo.error().text());
        }
    }

    private void encodeAndWriteDirectoryRequest(DirectoryRequest directoryRequest, ReactorChannel reactorChannel, ReactorErrorInfo errorInfo) {
        Channel channel = reactorChannel.channel();
        int bufSize = this.getMaxFragmentSize(reactorChannel, errorInfo);
        if (bufSize < 0) {
            return;
        }
        TransportBuffer msgBuf = channel.getBuffer(bufSize, false, errorInfo.error());
        if (msgBuf == null) {
            this.populateErrorInfo(errorInfo, -1, "Reactor.encodeAndWriteDirectoryRequest", "Failed to obtain a TransportBuffer, reason=" + errorInfo.error().text());
            return;
        }
        this._eIter.clear();
        this._eIter.setBufferAndRWFVersion(msgBuf, channel.majorVersion(), channel.minorVersion());
        int retval = directoryRequest.encode(this._eIter);
        if (retval != 0) {
            reactorChannel.state(ReactorChannel.State.DOWN);
            this.sendAndHandleChannelEventCallback("Reactor.encodeAndWriteDirectoryRequest", 2, reactorChannel, errorInfo);
            this.populateErrorInfo(errorInfo, -1, "Reactor.encodeAndWriteDirectoryRequest", "Encoding of directory request failed: <" + TransportReturnCodes.toString((int)retval) + ">");
            return;
        }
        if (reactorChannel.channel().protocolType() == 2) {
            if (Objects.isNull(this.jsonConverter)) {
                this.populateErrorInfo(errorInfo, -1, "Reactor.submitChannel", "The JSON converter library has not been initialized properly.");
                return;
            }
            this.jsonDecodeMsg.clear();
            this._dIter.clear();
            int ret = this._dIter.setBufferAndRWFVersion(msgBuf, reactorChannel.majorVersion(), reactorChannel.minorVersion());
            ret = this.jsonDecodeMsg.decode(this._dIter);
            if (ret == 0) {
                this.converterError.clear();
                this.rwfToJsonOptions.clear();
                this.rwfToJsonOptions.setJsonProtocolType(2);
                if (this.jsonConverter.convertRWFToJson(this.jsonDecodeMsg, this.rwfToJsonOptions, this.conversionResults, this.converterError) != 0) {
                    this.populateErrorInfo(errorInfo, -1, "Reactor.submitChannel", "Failed to convert RWF to JSON protocol. Error text: " + this.converterError.getText());
                    return;
                }
                TransportBuffer buffer = reactorChannel.getBuffer(this.conversionResults.getLength(), false, errorInfo);
                if (Objects.isNull(buffer)) {
                    this.populateErrorInfo(errorInfo, -1, "Reactor.submitChannel", "Failed to get a buffer for sending JSON message. Error text: " + errorInfo.error().text());
                    return;
                }
                this.getJsonMsgOptions.clear();
                this.getJsonMsgOptions.jsonProtocolType(2);
                this.getJsonMsgOptions.isCloseMsg(this.jsonDecodeMsg.msgClass() == 5);
                if (this.jsonConverter.getJsonBuffer(buffer, this.getJsonMsgOptions, this.converterError) != 0) {
                    this.populateErrorInfo(errorInfo, -1, "Reactor.submitChannel", "Failed to get converted JSON message. Error text: " + this.converterError.getText());
                    return;
                }
                reactorChannel.releaseBuffer(msgBuf, errorInfo);
                msgBuf = buffer;
            }
        }
        if ((this._reactorOptions.xmlTracing() || this._reactorOptions.xmlTraceToFile()) && this._reactorOptions.xmlTraceWrite()) {
            this.xmlString.setLength(0);
            this.xmlString.append("\n<!-- Outgoing Reactor message -->\n").append("<!-- ").append(reactorChannel.selectableChannel().toString()).append(" -->\n").append("<!-- ").append(new Date()).append(" -->\n");
            this.xmlDumpTrace.dumpBuffer(reactorChannel.channel(), reactorChannel.channel().protocolType(), msgBuf, null, this.xmlString, errorInfo.error());
            if (this._reactorOptions.xmlTracing()) {
                System.out.println(this.xmlString);
            }
            if (this._reactorOptions.xmlTraceToFile()) {
                this._fileDumper.dump(this.xmlString.toString());
            }
        }
        retval = channel.write(msgBuf, this._writeArgs, errorInfo.error());
        if (this._reactorOptions.writeStatSet()) {
            ((WriteArgsImpl)this._writeArgsAggregator).bytesWritten(this.overflowSafeAggregate(this._writeArgsAggregator.bytesWritten(), this._writeArgs.uncompressedBytesWritten()));
            ((WriteArgsImpl)this._writeArgsAggregator).uncompressedBytesWritten(this.overflowSafeAggregate(this._writeArgsAggregator.uncompressedBytesWritten(), this._writeArgs.uncompressedBytesWritten()));
        }
        if (retval > 0) {
            this.sendFlushRequest(reactorChannel, "Reactor.encodeAndWriteDirectoryRequest", errorInfo);
        } else if (retval < 0) {
            if (reactorChannel.server() == null && !reactorChannel.recoveryAttemptLimitReached()) {
                reactorChannel.state(ReactorChannel.State.DOWN_RECONNECTING);
                this.sendAndHandleChannelEventCallback("Reactor.encodeAndWriteDirectoryRequest", 3, reactorChannel, errorInfo);
            } else {
                reactorChannel.state(ReactorChannel.State.DOWN);
                this.sendAndHandleChannelEventCallback("Reactor.encodeAndWriteDirectoryRequest", 2, reactorChannel, errorInfo);
            }
            this.populateErrorInfo(errorInfo, -1, "Reactor.encodeAndWriteDirectoryRequest", "Channel.write failed to write directory request: <" + CodecReturnCodes.toString((int)retval) + "> error=" + errorInfo.error().text());
        } else {
            reactorChannel.flushAgain(false);
        }
    }

    private void encodeAndWriteDirectoryRefresh(DirectoryRefresh directoryRefresh, ReactorChannel reactorChannel, ReactorErrorInfo errorInfo) {
        Channel channel = reactorChannel.channel();
        int bufSize = this.getMaxFragmentSize(reactorChannel, errorInfo);
        if (bufSize < 0) {
            return;
        }
        TransportBuffer msgBuf = channel.getBuffer(bufSize, false, errorInfo.error());
        if (msgBuf == null) {
            this.populateErrorInfo(errorInfo, -1, "Reactor.encodeAndWriteDirectoryRefresh", "Failed to obtain a TransportBuffer, reason=" + errorInfo.error().text());
            return;
        }
        this._eIter.clear();
        this._eIter.setBufferAndRWFVersion(msgBuf, channel.majorVersion(), channel.minorVersion());
        int retval = directoryRefresh.encode(this._eIter);
        if (retval != 0) {
            reactorChannel.state(ReactorChannel.State.DOWN);
            this.sendAndHandleChannelEventCallback("Reactor.encodeAndWriteDirectoryRefresh", 2, reactorChannel, errorInfo);
            this.populateErrorInfo(errorInfo, -1, "Reactor.encodeAndWriteDirectoryRefresh", "Encoding of directory refresh failed: <" + TransportReturnCodes.toString((int)retval) + ">");
            return;
        }
        if (reactorChannel.channel().protocolType() == 2) {
            if (Objects.isNull(this.jsonConverter)) {
                this.populateErrorInfo(errorInfo, -1, "Reactor.submitChannel", "The JSON converter library has not been initialized properly.");
                return;
            }
            this.jsonDecodeMsg.clear();
            this._dIter.clear();
            int ret = this._dIter.setBufferAndRWFVersion(msgBuf, reactorChannel.majorVersion(), reactorChannel.minorVersion());
            ret = this.jsonDecodeMsg.decode(this._dIter);
            if (ret == 0) {
                this.converterError.clear();
                this.rwfToJsonOptions.clear();
                this.rwfToJsonOptions.setJsonProtocolType(2);
                if (this.jsonConverter.convertRWFToJson(this.jsonDecodeMsg, this.rwfToJsonOptions, this.conversionResults, this.converterError) != 0) {
                    this.populateErrorInfo(errorInfo, -1, "Reactor.submitChannel", "Failed to convert RWF to JSON protocol. Error text: " + this.converterError.getText());
                    return;
                }
                TransportBuffer buffer = reactorChannel.getBuffer(this.conversionResults.getLength(), false, errorInfo);
                if (Objects.isNull(buffer)) {
                    this.populateErrorInfo(errorInfo, -1, "Reactor.submitChannel", "Failed to get a buffer for sending JSON message. Error text: " + errorInfo.error().text());
                    return;
                }
                this.getJsonMsgOptions.clear();
                this.getJsonMsgOptions.jsonProtocolType(2);
                this.getJsonMsgOptions.isCloseMsg(this.jsonDecodeMsg.msgClass() == 5);
                if (this.jsonConverter.getJsonBuffer(buffer, this.getJsonMsgOptions, this.converterError) != 0) {
                    this.populateErrorInfo(errorInfo, -1, "Reactor.submitChannel", "Failed to get converted JSON message. Error text: " + this.converterError.getText());
                    return;
                }
                reactorChannel.releaseBuffer(msgBuf, errorInfo);
                msgBuf = buffer;
            }
        }
        if ((this._reactorOptions.xmlTracing() || this._reactorOptions.xmlTraceToFile()) && this._reactorOptions.xmlTraceWrite()) {
            this.xmlString.setLength(0);
            this.xmlString.append("\n<!-- Outgoing Reactor message -->\n").append("<!-- ").append(reactorChannel.selectableChannel().toString()).append(" -->\n").append("<!-- ").append(new Date()).append(" -->\n");
            this.xmlDumpTrace.dumpBuffer(reactorChannel.channel(), reactorChannel.channel().protocolType(), msgBuf, null, this.xmlString, errorInfo.error());
            if (this._reactorOptions.xmlTracing()) {
                System.out.println(this.xmlString);
            }
            if (this._reactorOptions.xmlTraceToFile()) {
                this._fileDumper.dump(this.xmlString.toString());
            }
        }
        retval = channel.write(msgBuf, this._writeArgs, errorInfo.error());
        if (this._reactorOptions.writeStatSet()) {
            ((WriteArgsImpl)this._writeArgsAggregator).bytesWritten(this.overflowSafeAggregate(this._writeArgsAggregator.bytesWritten(), this._writeArgs.bytesWritten()));
            ((WriteArgsImpl)this._writeArgsAggregator).uncompressedBytesWritten(this.overflowSafeAggregate(this._writeArgsAggregator.uncompressedBytesWritten(), this._writeArgs.uncompressedBytesWritten()));
        }
        if (retval > 0) {
            this.sendFlushRequest(reactorChannel, "Reactor.encodeAndWriteDirectoryRefresh", errorInfo);
        } else if (retval < 0) {
            if (reactorChannel.server() == null && !reactorChannel.recoveryAttemptLimitReached()) {
                reactorChannel.state(ReactorChannel.State.DOWN_RECONNECTING);
                this.sendAndHandleChannelEventCallback("Reactor.encodeAndWriteDirectoryRefresh", 3, reactorChannel, errorInfo);
            } else {
                reactorChannel.state(ReactorChannel.State.DOWN);
                this.sendAndHandleChannelEventCallback("Reactor.encodeAndWriteDirectoryRefresh", 2, reactorChannel, errorInfo);
            }
            this.populateErrorInfo(errorInfo, -1, "Reactor.encodeAndWriteDirectoryRefresh", "Channel.write failed to write directory refresh: <" + CodecReturnCodes.toString((int)retval) + "> error=" + errorInfo.error().text());
        } else {
            reactorChannel.flushAgain(false);
        }
    }

    private void encodeAndWriteDictionaryRequest(DictionaryRequest dictionaryRequest, ReactorChannel reactorChannel, ReactorErrorInfo errorInfo) {
        Channel channel = reactorChannel.channel();
        int bufSize = this.getMaxFragmentSize(reactorChannel, errorInfo);
        if (bufSize < 0) {
            return;
        }
        TransportBuffer msgBuf = channel.getBuffer(bufSize, false, errorInfo.error());
        if (msgBuf == null) {
            this.populateErrorInfo(errorInfo, -1, "Reactor.encodeAndWriteDictionaryRequest", "Failed to obtain a TransportBuffer, reason=" + errorInfo.error().text());
            return;
        }
        this._eIter.clear();
        this._eIter.setBufferAndRWFVersion(msgBuf, channel.majorVersion(), channel.minorVersion());
        int retval = dictionaryRequest.encode(this._eIter);
        if (retval != 0) {
            reactorChannel.state(ReactorChannel.State.DOWN);
            this.sendAndHandleChannelEventCallback("Reactor.encodeAndWriteDictionaryRequest", 2, reactorChannel, errorInfo);
            this.populateErrorInfo(errorInfo, -1, "Reactor.encodeAndWriteDictionaryRequest", "Encoding of dictionary request failed: <" + TransportReturnCodes.toString((int)retval) + ">");
            return;
        }
        if (reactorChannel.channel().protocolType() == 2) {
            if (Objects.isNull(this.jsonConverter)) {
                this.populateErrorInfo(errorInfo, -1, "Reactor.submitChannel", "The JSON converter library has not been initialized properly.");
                return;
            }
            this.jsonDecodeMsg.clear();
            this._dIter.clear();
            int ret = this._dIter.setBufferAndRWFVersion(msgBuf, reactorChannel.majorVersion(), reactorChannel.minorVersion());
            ret = this.jsonDecodeMsg.decode(this._dIter);
            if (ret == 0) {
                this.converterError.clear();
                this.rwfToJsonOptions.clear();
                this.rwfToJsonOptions.setJsonProtocolType(2);
                if (this.jsonConverter.convertRWFToJson(this.jsonDecodeMsg, this.rwfToJsonOptions, this.conversionResults, this.converterError) != 0) {
                    this.populateErrorInfo(errorInfo, -1, "Reactor.submitChannel", "Failed to convert RWF to JSON protocol. Error text: " + this.converterError.getText());
                    return;
                }
                TransportBuffer jsonBuffer = reactorChannel.getBuffer(this.conversionResults.getLength(), false, errorInfo);
                if (Objects.isNull(jsonBuffer)) {
                    this.populateErrorInfo(errorInfo, -1, "Reactor.submitChannel", "Failed to get a buffer for sending JSON message. Error text: " + errorInfo.error().text());
                    return;
                }
                this.getJsonMsgOptions.clear();
                this.getJsonMsgOptions.jsonProtocolType(2);
                this.getJsonMsgOptions.isCloseMsg(this.jsonDecodeMsg.msgClass() == 5);
                if (this.jsonConverter.getJsonBuffer(jsonBuffer, this.getJsonMsgOptions, this.converterError) != 0) {
                    this.populateErrorInfo(errorInfo, -1, "Reactor.submitChannel", "Failed to get converted JSON message. Error text: " + this.converterError.getText());
                    return;
                }
                reactorChannel.releaseBuffer(msgBuf, errorInfo);
                msgBuf = jsonBuffer;
            }
        }
        if ((this._reactorOptions.xmlTracing() || this._reactorOptions.xmlTraceToFile()) && this._reactorOptions.xmlTraceWrite()) {
            this.xmlString.setLength(0);
            this.xmlString.append("\n<!-- Outgoing Reactor message -->\n").append("<!-- ").append(reactorChannel.selectableChannel().toString()).append(" -->\n").append("<!-- ").append(new Date()).append(" -->\n");
            this.xmlDumpTrace.dumpBuffer(reactorChannel.channel(), reactorChannel.channel().protocolType(), msgBuf, null, this.xmlString, errorInfo.error());
            if (this._reactorOptions.xmlTracing()) {
                System.out.println(this.xmlString);
            }
            if (this._reactorOptions.xmlTraceToFile()) {
                this._fileDumper.dump(this.xmlString.toString());
            }
        }
        retval = channel.write(msgBuf, this._writeArgs, errorInfo.error());
        if (this._reactorOptions.writeStatSet()) {
            ((WriteArgsImpl)this._writeArgsAggregator).bytesWritten(this.overflowSafeAggregate(this._writeArgsAggregator.bytesWritten(), this._writeArgs.bytesWritten()));
            ((WriteArgsImpl)this._writeArgsAggregator).uncompressedBytesWritten(this.overflowSafeAggregate(this._writeArgsAggregator.uncompressedBytesWritten(), this._writeArgs.uncompressedBytesWritten()));
        }
        if (retval > 0) {
            this.sendFlushRequest(reactorChannel, "Reactor.encodeAndWriteDictionaryRequest", errorInfo);
        } else if (retval < 0) {
            if (reactorChannel.server() == null && !reactorChannel.recoveryAttemptLimitReached()) {
                reactorChannel.state(ReactorChannel.State.DOWN_RECONNECTING);
                this.sendAndHandleChannelEventCallback("Reactor.encodeAndWriteDictionaryRequest", 3, reactorChannel, errorInfo);
            } else {
                reactorChannel.state(ReactorChannel.State.DOWN);
                this.sendAndHandleChannelEventCallback("Reactor.encodeAndWriteDictionaryRequest", 2, reactorChannel, errorInfo);
            }
            this.populateErrorInfo(errorInfo, -1, "Reactor.encodeAndWriteDictionaryRequest", "Channel.write failed to write dictionary request: <" + CodecReturnCodes.toString((int)retval) + "> error=" + errorInfo.error().text());
        } else {
            reactorChannel.flushAgain(false);
        }
    }

    private void encodeAndWriteDictionaryClose(DictionaryClose dictionaryClose, ReactorChannel reactorChannel, ReactorErrorInfo errorInfo) {
        Channel channel = reactorChannel.channel();
        if (channel == null || channel.state() != 2) {
            return;
        }
        int bufSize = this.getMaxFragmentSize(reactorChannel, errorInfo);
        if (bufSize < 0) {
            return;
        }
        TransportBuffer msgBuf = channel.getBuffer(bufSize, false, errorInfo.error());
        if (msgBuf == null) {
            this.populateErrorInfo(errorInfo, -1, "Reactor.encodeAndWriteDictionaryClose", "Failed to obtain a TransportBuffer, reason=" + errorInfo.error().text());
            return;
        }
        this._eIter.clear();
        this._eIter.setBufferAndRWFVersion(msgBuf, channel.majorVersion(), channel.minorVersion());
        int retval = dictionaryClose.encode(this._eIter);
        if (retval != 0) {
            reactorChannel.state(ReactorChannel.State.DOWN);
            this.sendAndHandleChannelEventCallback("Reactor.encodeAndWriteDictionaryClose", 2, reactorChannel, errorInfo);
            this.populateErrorInfo(errorInfo, -1, "Reactor.encodeAndWriteDictionaryClose", "Encoding of dictionary close failed: <" + TransportReturnCodes.toString((int)retval) + ">");
            return;
        }
        if (reactorChannel.channel().protocolType() == 2) {
            if (Objects.isNull(this.jsonConverter)) {
                this.populateErrorInfo(errorInfo, -1, "Reactor.submitChannel", "The JSON converter library has not been initialized properly.");
                return;
            }
            this.jsonDecodeMsg.clear();
            this._dIter.clear();
            int ret = this._dIter.setBufferAndRWFVersion(msgBuf, reactorChannel.majorVersion(), reactorChannel.minorVersion());
            ret = this.jsonDecodeMsg.decode(this._dIter);
            if (ret == 0) {
                this.converterError.clear();
                this.rwfToJsonOptions.clear();
                this.rwfToJsonOptions.setJsonProtocolType(2);
                if (this.jsonConverter.convertRWFToJson(this.jsonDecodeMsg, this.rwfToJsonOptions, this.conversionResults, this.converterError) != 0) {
                    this.populateErrorInfo(errorInfo, -1, "Reactor.submitChannel", "Failed to convert RWF to JSON protocol. Error text: " + this.converterError.getText());
                    return;
                }
                TransportBuffer buffer = reactorChannel.getBuffer(this.conversionResults.getLength(), false, errorInfo);
                if (Objects.isNull(buffer)) {
                    this.populateErrorInfo(errorInfo, -1, "Reactor.submitChannel", "Failed to get a buffer for sending JSON message. Error text: " + errorInfo.error().text());
                    return;
                }
                this.getJsonMsgOptions.clear();
                this.getJsonMsgOptions.jsonProtocolType(2);
                this.getJsonMsgOptions.isCloseMsg(this.jsonDecodeMsg.msgClass() == 5);
                if (this.jsonConverter.getJsonBuffer(buffer, this.getJsonMsgOptions, this.converterError) != 0) {
                    this.populateErrorInfo(errorInfo, -1, "Reactor.submitChannel", "Failed to get converted JSON message. Error text: " + this.converterError.getText());
                    return;
                }
                reactorChannel.releaseBuffer(msgBuf, errorInfo);
                msgBuf = buffer;
            }
        }
        if ((this._reactorOptions.xmlTracing() || this._reactorOptions.xmlTraceToFile()) && this._reactorOptions.xmlTraceWrite()) {
            this.xmlString.setLength(0);
            this.xmlString.append("\n<!-- Outgoing Reactor message -->\n").append("<!-- ").append(reactorChannel.selectableChannel().toString()).append(" -->\n").append("<!-- ").append(new Date()).append(" -->\n");
            this.xmlDumpTrace.dumpBuffer(reactorChannel.channel(), reactorChannel.channel().protocolType(), msgBuf, null, this.xmlString, errorInfo.error());
            if (this._reactorOptions.xmlTracing()) {
                System.out.println(this.xmlString);
            }
            if (this._reactorOptions.xmlTraceToFile()) {
                this._fileDumper.dump(this.xmlString.toString());
            }
        }
        retval = channel.write(msgBuf, this._writeArgs, errorInfo.error());
        if (this._reactorOptions.writeStatSet()) {
            ((WriteArgsImpl)this._writeArgsAggregator).bytesWritten(this.overflowSafeAggregate(this._writeArgsAggregator.bytesWritten(), this._writeArgs.bytesWritten()));
            ((WriteArgsImpl)this._writeArgsAggregator).uncompressedBytesWritten(this.overflowSafeAggregate(this._writeArgsAggregator.uncompressedBytesWritten(), this._writeArgs.uncompressedBytesWritten()));
        }
        if (retval > 0) {
            this.sendFlushRequest(reactorChannel, "Reactor.encodeAndWriteDictionaryClose", errorInfo);
        } else if (retval < 0) {
            if (reactorChannel.server() == null && !reactorChannel.recoveryAttemptLimitReached()) {
                reactorChannel.state(ReactorChannel.State.DOWN_RECONNECTING);
                this.sendAndHandleChannelEventCallback("Reactor.encodeAndWriteDictionaryClose", 3, reactorChannel, errorInfo);
            } else {
                reactorChannel.state(ReactorChannel.State.DOWN);
                this.sendAndHandleChannelEventCallback("Reactor.encodeAndWriteDictionaryClose", 2, reactorChannel, errorInfo);
            }
            this.populateErrorInfo(errorInfo, -1, "Reactor.encodeAndWriteDictionaryClose", "Channel.write failed to write dictionary close: <" + CodecReturnCodes.toString((int)retval) + "> error=" + errorInfo.error().text());
        } else {
            reactorChannel.flushAgain(false);
        }
    }

    int wsbServiceSwitchActiveToStandbyChannelDown(ReactorChannel reactorChannel, ReactorWarmStandbyGroupImpl warmStandbyGroupImpl, ReactorWarmStandbyHandler warmStandbyHandlerImpl, boolean sendMsg, ReactorErrorInfo errorInfo) {
        ReactorWSBService service;
        ReactorWarmStandbyGroupImpl warmStandbyGroup = null;
        ReactorChannel processReactorChannel = null;
        WlService wlService = null;
        for (WlInteger serviceId : warmStandbyGroupImpl._perServiceById.keySet()) {
            service = warmStandbyGroupImpl._perServiceById.get(serviceId);
            if (service == null || service.activeChannel != reactorChannel) continue;
            service.activeChannel = null;
            warmStandbyHandlerImpl.warmStandByHandlerLock().lock();
            for (int i = 0; i < service.channels.size(); ++i) {
                processReactorChannel = service.channels.get(i);
                wlService = processReactorChannel.watchlist().directoryHandler()._serviceCache._servicesByIdTable.get(service.serviceId);
                if (wlService == null || wlService._rdmService.state().serviceState() == 0L) continue;
                if (this.isReactorChannelActive(processReactorChannel)) {
                    this.reactorWSBFanoutStatusMsg(processReactorChannel, errorInfo);
                }
                processReactorChannel._directoryConsumerStatus.clear();
                processReactorChannel._directoryConsumerStatus.streamId(processReactorChannel.watchlist().directoryHandler()._directoryStreamId);
                processReactorChannel._serviceConsumerStatus.clear();
                processReactorChannel._serviceConsumerStatus.flags(2);
                processReactorChannel._serviceConsumerStatus.warmStandbyMode(0L);
                processReactorChannel._serviceConsumerStatus.serviceId(wlService._rdmService.serviceId());
                processReactorChannel._directoryConsumerStatus.consumerServiceStatusList().add(processReactorChannel._serviceConsumerStatus);
                if (this.submitChannel(processReactorChannel, processReactorChannel._directoryConsumerStatus, this.reactorSubmitOptions, errorInfo) < 0) {
                    if (processReactorChannel.server() == null && !processReactorChannel.recoveryAttemptLimitReached()) {
                        processReactorChannel.state(ReactorChannel.State.DOWN_RECONNECTING);
                        this.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 3, processReactorChannel, errorInfo);
                        break;
                    }
                    processReactorChannel.state(ReactorChannel.State.DOWN);
                    this.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 2, processReactorChannel, errorInfo);
                    break;
                }
                service.activeChannel = processReactorChannel;
                processReactorChannel.isActiveServer = true;
                break;
            }
            warmStandbyHandlerImpl.warmStandByHandlerLock().unlock();
        }
        if (reactorChannel != null) {
            warmStandbyGroup = reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl();
        }
        if (warmStandbyGroup.warmStandbyMode() == 2) {
            Iterator<Map.Entry<WlInteger, ReactorWSBService>> iter = warmStandbyGroup._perServiceById.entrySet().iterator();
            block2: while (iter.hasNext()) {
                service = iter.next().getValue();
                if (reactorChannel != service.activeChannel) continue;
                service.activeChannel = null;
                for (int i = 0; i < service.channels.size(); ++i) {
                    processReactorChannel = service.channels.get(i);
                    wlService = processReactorChannel.watchlist().directoryHandler()._serviceCache._servicesByIdTable.get(service.serviceId);
                    if (wlService == null || wlService._rdmService.state().serviceState() == 0L) continue;
                    if (this.isReactorChannelActive(processReactorChannel)) {
                        this.reactorWSBFanoutStatusMsg(processReactorChannel, errorInfo);
                    }
                    processReactorChannel._directoryConsumerStatus.clear();
                    processReactorChannel._directoryConsumerStatus.streamId(processReactorChannel.watchlist().directoryHandler()._directoryStreamId);
                    processReactorChannel._serviceConsumerStatus.clear();
                    processReactorChannel._serviceConsumerStatus.flags(2);
                    processReactorChannel._serviceConsumerStatus.warmStandbyMode(0L);
                    processReactorChannel._serviceConsumerStatus.serviceId(wlService._rdmService.serviceId());
                    processReactorChannel._directoryConsumerStatus.consumerServiceStatusList().add(processReactorChannel._serviceConsumerStatus);
                    if (this.submitChannel(processReactorChannel, processReactorChannel._directoryConsumerStatus, this.reactorSubmitOptions, errorInfo) < 0) {
                        if (processReactorChannel.server() == null && !processReactorChannel.recoveryAttemptLimitReached()) {
                            processReactorChannel.state(ReactorChannel.State.DOWN_RECONNECTING);
                            this.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 3, processReactorChannel, errorInfo);
                            continue block2;
                        }
                        processReactorChannel.state(ReactorChannel.State.DOWN);
                        this.sendAndHandleChannelEventCallback("Reactor.processWorkerEvent", 2, processReactorChannel, errorInfo);
                        continue block2;
                    }
                    service.activeChannel = processReactorChannel;
                    processReactorChannel.isActiveServer = true;
                    continue block2;
                }
            }
        }
        return 0;
    }

    int processChannelMessage(ReactorChannel reactorChannel, DecodeIterator dIter, Msg msg, TransportBuffer transportBuffer, ReactorErrorInfo errorInfo) {
        int retval = 0;
        switch (msg.domainType()) {
            case 1: {
                retval = this.processLoginMessage(reactorChannel, dIter, msg, transportBuffer, errorInfo);
                break;
            }
            case 4: {
                retval = this.processDirectoryMessage(reactorChannel, dIter, msg, transportBuffer, errorInfo);
                break;
            }
            case 5: {
                retval = this.processDictionaryMessage(reactorChannel, dIter, msg, transportBuffer, errorInfo);
                break;
            }
            default: {
                retval = this.sendAndHandleDefaultMsgCallback("Reactor.processChannelMessage", reactorChannel, transportBuffer, msg, errorInfo);
            }
        }
        return retval;
    }

    private int processLoginMessage(ReactorChannel reactorChannel, DecodeIterator dIter, Msg msg, TransportBuffer transportBuffer, ReactorErrorInfo errorInfo) {
        int retval = 0;
        LoginMsg loginMsg = null;
        this._loginMsg.clear();
        switch (msg.msgClass()) {
            case 1: {
                LoginRequest loginRequest = (LoginRequest)this._loginMsg;
                loginRequest.rdmMsgType(LoginMsgType.REQUEST);
                loginRequest.decode(dIter, msg);
                loginMsg = this._loginMsg;
                break;
            }
            case 2: {
                LoginRefresh loginRefresh = (LoginRefresh)this._loginMsg;
                loginRefresh.rdmMsgType(LoginMsgType.REFRESH);
                loginRefresh.decode(dIter, msg);
                loginMsg = this._loginMsg;
                break;
            }
            case 3: {
                LoginStatus loginStatus = (LoginStatus)this._loginMsg;
                loginStatus.rdmMsgType(LoginMsgType.STATUS);
                loginStatus.decode(dIter, msg);
                loginMsg = this._loginMsg;
                break;
            }
            case 5: {
                LoginClose loginClose = (LoginClose)this._loginMsg;
                loginClose.rdmMsgType(LoginMsgType.CLOSE);
                loginClose.decode(dIter, msg);
                loginMsg = this._loginMsg;
                break;
            }
            case 7: {
                retval = this.proceedLoginGenericMsg(reactorChannel, dIter, msg, errorInfo);
                if (retval == -1) {
                    return 0;
                }
                loginMsg = this._loginMsg;
                break;
            }
            case 6: 
            case 8: {
                this._loginMsg.rdmMsgType(LoginMsgType.UNKNOWN);
                break;
            }
        }
        if (retval == 0) {
            retval = this.sendAndHandleLoginMsgCallback("Reactor.processLoginMessage", reactorChannel, transportBuffer, msg, loginMsg, errorInfo);
        }
        if (retval == -2) {
            retval = this.sendAndHandleDefaultMsgCallback("Reactor.processLoginMessage", reactorChannel, transportBuffer, msg, errorInfo);
        }
        if (retval == 0) {
            ReactorRole reactorRole = reactorChannel.role();
            if (reactorChannel.state() == ReactorChannel.State.UP && reactorChannel.role().type() == 1 && msg.streamId() == ((ConsumerRole)reactorRole).rdmLoginRequest().streamId() && this._loginMsg.rdmMsgType() == LoginMsgType.REFRESH && ((LoginRefresh)this._loginMsg).state().streamState() == 1 && ((LoginRefresh)this._loginMsg).state().dataState() == 1) {
                DirectoryRequest directoryRequest = ((ConsumerRole)reactorRole).rdmDirectoryRequest();
                if (directoryRequest != null) {
                    this.encodeAndWriteDirectoryRequest(directoryRequest, reactorChannel, errorInfo);
                } else {
                    reactorChannel.state(ReactorChannel.State.READY);
                    reactorChannel.clearAccessTokenForV2();
                    retval = this.sendAndHandleChannelEventCallback("Reactor.processLoginMessage", 4, reactorChannel, errorInfo);
                    if (retval != 0) {
                        return retval;
                    }
                }
            }
            if (reactorChannel.state() == ReactorChannel.State.UP && reactorChannel.role().type() == 3 && msg.streamId() == ((NIProviderRole)reactorRole).rdmLoginRequest().streamId() && this._loginMsg.rdmMsgType() == LoginMsgType.REFRESH && ((LoginRefresh)this._loginMsg).state().streamState() == 1 && ((LoginRefresh)this._loginMsg).state().dataState() == 1) {
                DirectoryRefresh directoryRefresh = ((NIProviderRole)reactorRole).rdmDirectoryRefresh();
                if (directoryRefresh != null) {
                    this.encodeAndWriteDirectoryRefresh(directoryRefresh, reactorChannel, errorInfo);
                    if (((NIProviderRole)reactorRole).dictionaryDownloadMode() == 1 && ((LoginRefresh)this._loginMsg).checkHasFeatures() && ((LoginRefresh)this._loginMsg).features().checkHasSupportProviderDictionaryDownload() && ((LoginRefresh)this._loginMsg).features().supportProviderDictionaryDownload() == 1L) {
                        int serviceId = ((NIProviderRole)reactorRole).rdmDirectoryRefresh().serviceList().get(0).serviceId();
                        ((NIProviderRole)reactorRole).initDefaultRDMFieldDictionaryRequest();
                        DictionaryRequest dictionaryRequest = ((NIProviderRole)reactorRole).rdmFieldDictionaryRequest();
                        dictionaryRequest.serviceId(serviceId);
                        this.encodeAndWriteDictionaryRequest(dictionaryRequest, reactorChannel, errorInfo);
                        ((NIProviderRole)reactorRole).initDefaultRDMEnumDictionaryRequest();
                        dictionaryRequest = ((NIProviderRole)reactorRole).rdmEnumDictionaryRequest();
                        dictionaryRequest.serviceId(serviceId);
                        this.encodeAndWriteDictionaryRequest(dictionaryRequest, reactorChannel, errorInfo);
                    }
                }
                if (((NIProviderRole)reactorRole).dictionaryDownloadMode() != 1) {
                    reactorChannel.state(ReactorChannel.State.READY);
                    retval = this.sendAndHandleChannelEventCallback("Reactor.processLoginMessage", 4, reactorChannel, errorInfo);
                    if (retval != 0) {
                        return retval;
                    }
                }
            }
        }
        return retval;
    }

    private int processDirectoryMessage(ReactorChannel reactorChannel, DecodeIterator dIter, Msg msg, TransportBuffer transportBuffer, ReactorErrorInfo errorInfo) {
        DirectoryRefresh directoryRefresh;
        int retval = 0;
        this._directoryMsg.clear();
        switch (msg.msgClass()) {
            case 1: {
                DirectoryRequest directoryRequest = (DirectoryRequest)this._directoryMsg;
                directoryRequest.rdmMsgType(DirectoryMsgType.REQUEST);
                directoryRequest.decode(dIter, msg);
                break;
            }
            case 2: {
                directoryRefresh = (DirectoryRefresh)this._directoryMsg;
                directoryRefresh.rdmMsgType(DirectoryMsgType.REFRESH);
                directoryRefresh.decode(dIter, msg);
                break;
            }
            case 3: {
                DirectoryStatus directoryStatus = (DirectoryStatus)this._directoryMsg;
                directoryStatus.rdmMsgType(DirectoryMsgType.STATUS);
                directoryStatus.decode(dIter, msg);
                break;
            }
            case 5: {
                DirectoryClose directoryClose = (DirectoryClose)this._directoryMsg;
                directoryClose.rdmMsgType(DirectoryMsgType.CLOSE);
                directoryClose.decode(dIter, msg);
                break;
            }
            case 7: {
                DirectoryConsumerStatus directoryCS = (DirectoryConsumerStatus)this._directoryMsg;
                directoryCS.rdmMsgType(DirectoryMsgType.CONSUMER_STATUS);
                if (directoryCS.decode(dIter, msg) == 0) break;
                retval = -2;
                break;
            }
            case 4: {
                DirectoryUpdate directoryUpdate = (DirectoryUpdate)this._directoryMsg;
                directoryUpdate.rdmMsgType(DirectoryMsgType.UPDATE);
                directoryUpdate.decode(dIter, msg);
                break;
            }
        }
        if (retval != -2) {
            retval = this.sendAndHandleDirectoryMsgCallback("Reactor.processDirectoryMessage", reactorChannel, transportBuffer, msg, this._directoryMsg, errorInfo);
        }
        if (retval == -2) {
            retval = this.sendAndHandleDefaultMsgCallback("Reactor.processDirectoryMessage", reactorChannel, transportBuffer, msg, errorInfo);
        }
        if (retval == 0) {
            ReactorRole reactorRole = reactorChannel.role();
            if (reactorChannel.state() == ReactorChannel.State.UP && msg.streamId() == ((ConsumerRole)reactorRole).rdmDirectoryRequest().streamId() && reactorChannel.role().type() == 1 && this._directoryMsg.rdmMsgType() == DirectoryMsgType.REFRESH) {
                if (((ConsumerRole)reactorRole).dictionaryDownloadMode() == 1) {
                    directoryRefresh = (DirectoryRefresh)this._directoryMsg;
                    int serviceId = 0;
                    boolean hasFieldDictionary = false;
                    boolean hasEnumTypeDictionary = false;
                    for (Service service : directoryRefresh.serviceList()) {
                        if (service.checkHasInfo()) {
                            for (String dictionaryName : service.info().dictionariesProvidedList()) {
                                if (dictionaryName.equals(((ConsumerRole)reactorRole).fieldDictionaryName().toString())) {
                                    hasFieldDictionary = true;
                                }
                                if (dictionaryName.equals(((ConsumerRole)reactorRole).enumTypeDictionaryName().toString())) {
                                    hasEnumTypeDictionary = true;
                                }
                                if (!hasFieldDictionary || !hasEnumTypeDictionary) continue;
                                serviceId = service.serviceId();
                                break;
                            }
                        }
                        if (!hasFieldDictionary || !hasEnumTypeDictionary) continue;
                        ((ConsumerRole)reactorRole).initDefaultRDMFieldDictionaryRequest();
                        DictionaryRequest dictionaryRequest = ((ConsumerRole)reactorRole).rdmFieldDictionaryRequest();
                        dictionaryRequest.serviceId(serviceId);
                        this.encodeAndWriteDictionaryRequest(dictionaryRequest, reactorChannel, errorInfo);
                        ((ConsumerRole)reactorRole).initDefaultRDMEnumDictionaryRequest();
                        dictionaryRequest = ((ConsumerRole)reactorRole).rdmEnumDictionaryRequest();
                        dictionaryRequest.serviceId(serviceId);
                        this.encodeAndWriteDictionaryRequest(dictionaryRequest, reactorChannel, errorInfo);
                        break;
                    }
                    if (!hasFieldDictionary || !hasEnumTypeDictionary) {
                        System.out.println("Dictionary download not supported by the indicated provider");
                    }
                } else {
                    reactorChannel.state(ReactorChannel.State.READY);
                    reactorChannel.clearAccessTokenForV2();
                    retval = this.sendAndHandleChannelEventCallback("Reactor.processDirectoryMessage", 4, reactorChannel, errorInfo);
                    if (retval != 0) {
                        return retval;
                    }
                }
            }
        }
        return retval;
    }

    private int processDictionaryMessage(ReactorChannel reactorChannel, DecodeIterator dIter, Msg msg, TransportBuffer transportBuffer, ReactorErrorInfo errorInfo) {
        int retval = 0;
        DictionaryRefresh dictionaryRefresh = null;
        this._dictionaryMsg.clear();
        switch (msg.msgClass()) {
            case 1: {
                DictionaryRequest dictionaryRequest = (DictionaryRequest)this._dictionaryMsg;
                dictionaryRequest.rdmMsgType(DictionaryMsgType.REQUEST);
                dictionaryRequest.decode(dIter, msg);
                break;
            }
            case 2: {
                dictionaryRefresh = (DictionaryRefresh)this._dictionaryMsg;
                dictionaryRefresh.rdmMsgType(DictionaryMsgType.REFRESH);
                dictionaryRefresh.decode(dIter, msg);
                break;
            }
            case 3: {
                DictionaryStatus dictionaryStatus = (DictionaryStatus)this._dictionaryMsg;
                dictionaryStatus.rdmMsgType(DictionaryMsgType.STATUS);
                dictionaryStatus.decode(dIter, msg);
                break;
            }
            case 5: {
                DictionaryClose dictionaryClose = (DictionaryClose)this._dictionaryMsg;
                dictionaryClose.rdmMsgType(DictionaryMsgType.CLOSE);
                dictionaryClose.decode(dIter, msg);
                break;
            }
        }
        retval = this.sendAndHandleDictionaryMsgCallback("Reactor.processDictionaryMessage", reactorChannel, transportBuffer, msg, this._dictionaryMsg, errorInfo);
        if (retval == -2) {
            retval = this.sendAndHandleDefaultMsgCallback("Reactor.processDictionaryMessage", reactorChannel, transportBuffer, msg, errorInfo);
        }
        if (retval == 0) {
            boolean receivedFieldDictResponse = false;
            boolean receivedEnumTypeResponse = false;
            ReactorRole reactorRole = reactorChannel.role();
            if (reactorChannel.state() == ReactorChannel.State.UP && reactorChannel.role().type() == 1 && this._dictionaryMsg.rdmMsgType() == DictionaryMsgType.REFRESH && ((ConsumerRole)reactorRole).dictionaryDownloadMode() == 1) {
                if (msg.streamId() == ((ConsumerRole)reactorRole).rdmFieldDictionaryRequest().streamId() && dictionaryRefresh != null && dictionaryRefresh.checkRefreshComplete()) {
                    ((ConsumerRole)reactorRole).receivedFieldDictionaryResp(true);
                    this.encodeAndWriteDictionaryClose(((ConsumerRole)reactorRole).rdmFieldDictionaryClose(), reactorChannel, errorInfo);
                }
                if (msg.streamId() == ((ConsumerRole)reactorRole).rdmEnumDictionaryRequest().streamId() && dictionaryRefresh != null && dictionaryRefresh.checkRefreshComplete()) {
                    ((ConsumerRole)reactorRole).receivedEnumDictionaryResp(true);
                    this.encodeAndWriteDictionaryClose(((ConsumerRole)reactorRole).rdmEnumDictionaryClose(), reactorChannel, errorInfo);
                }
                receivedFieldDictResponse = ((ConsumerRole)reactorRole).receivedFieldDictionaryResp();
                receivedEnumTypeResponse = ((ConsumerRole)reactorRole).receivedEnumDictionaryResp();
            } else if (reactorChannel.state() == ReactorChannel.State.UP && reactorChannel.role().type() == 3 && this._dictionaryMsg.rdmMsgType() == DictionaryMsgType.REFRESH && ((NIProviderRole)reactorRole).dictionaryDownloadMode() == 1) {
                if (msg.streamId() == ((NIProviderRole)reactorRole).rdmFieldDictionaryRequest().streamId() && dictionaryRefresh != null && dictionaryRefresh.checkRefreshComplete()) {
                    ((NIProviderRole)reactorRole).receivedFieldDictionaryResp(true);
                    this.encodeAndWriteDictionaryClose(((NIProviderRole)reactorRole).rdmFieldDictionaryClose(), reactorChannel, errorInfo);
                }
                if (msg.streamId() == ((NIProviderRole)reactorRole).rdmEnumDictionaryRequest().streamId() && dictionaryRefresh != null && dictionaryRefresh.checkRefreshComplete()) {
                    ((NIProviderRole)reactorRole).receivedEnumDictionaryResp(true);
                    receivedEnumTypeResponse = true;
                    this.encodeAndWriteDictionaryClose(((NIProviderRole)reactorRole).rdmEnumDictionaryClose(), reactorChannel, errorInfo);
                }
                receivedFieldDictResponse = ((NIProviderRole)reactorRole).receivedFieldDictionaryResp();
                receivedEnumTypeResponse = ((NIProviderRole)reactorRole).receivedEnumDictionaryResp();
            }
            if (receivedFieldDictResponse && receivedEnumTypeResponse) {
                reactorChannel.state(ReactorChannel.State.READY);
                reactorChannel.clearAccessTokenForV2();
                retval = this.sendAndHandleChannelEventCallback("Reactor.processDictionaryMessage", 4, reactorChannel, errorInfo);
                if (retval != 0) {
                    return retval;
                }
            }
        }
        return retval;
    }

    /*
     * Exception decompiling
     */
    public int dispatchAll(Set<SelectionKey> keySet, ReactorDispatchOptions dispatchOptions, ReactorErrorInfo errorInfo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 16[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int initJsonConverter(ReactorJsonConverterOptions jsonConverterOptions, ReactorErrorInfo errorInfo) {
        JsonConverterError converterError = ConverterFactory.createJsonConverterError();
        this._reactorLock.lock();
        try {
            if (!this._reactorActive) {
                int n = this.populateErrorInfo(errorInfo, -10, "Reactor.initJsonConverter", "Reactor is not active, aborting.");
                return n;
            }
            if (Objects.nonNull(this.jsonConverter)) {
                int n = this.populateErrorInfo(errorInfo, -1, "Reactor.initJsonConverter", "JsonConverter library is already initialized.");
                return n;
            }
            if (jsonConverterOptions.defaultServiceId() > 65535) {
                int n = this.populateErrorInfo(errorInfo, -1, "Reactor.initJsonConverter", "The service ID must be in a range between 0 to 65535.");
                return n;
            }
            this.jsonConverterUserSpec = jsonConverterOptions.userSpec();
            this.serviceNameToIdCallback = jsonConverterOptions.serviceNameToIdCallback();
            this.JsonConversionEventCallback = jsonConverterOptions.jsonConversionEventCallback();
            this.closeChannelFromFailure = jsonConverterOptions.closeChannelFromFailure();
            JsonFactory.initPools((int)jsonConverterOptions.jsonConverterPoolsSize());
            JsonConverterBuilder jsonConverterBuilder = ConverterFactory.createJsonConverterBuilder();
            if (Objects.isNull(this.serviceNameIdConverterClient)) {
                this.serviceNameIdConverterClient = new ServiceNameIdConverterClient(this);
            }
            jsonConverterBuilder.setProperty(10, 2).setProperty(5, jsonConverterOptions.jsonExpandedEnumFields()).setProperty(7, jsonConverterOptions.catchUnknownJsonKeys()).setProperty(8, jsonConverterOptions.catchUnknownJsonFids()).setProperty(9, true).setServiceConverter((ServiceNameIdConverter)this.serviceNameIdConverterClient).setDictionary(jsonConverterOptions.dataDictionary());
            if (jsonConverterOptions.defaultServiceId() >= 0) {
                jsonConverterBuilder.setProperty(3, jsonConverterOptions.defaultServiceId());
            }
            this.jsonConverter = jsonConverterBuilder.build(converterError);
            if (Objects.isNull(this.jsonConverter)) {
                int n = this.populateErrorInfo(errorInfo, -1, "Reactor.initJsonConverter", converterError.getText());
                return n;
            }
            this.sendJsonConvError = jsonConverterOptions.sendJsonConvError();
        }
        finally {
            this._reactorLock.unlock();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int closeChannel(ReactorChannel reactorChannel, ReactorErrorInfo errorInfo) {
        this._reactorLock.lock();
        if (this._reactorOptions.debuggerOptions().debugConnectionLevel()) {
            this.debugger.incNumOfCloseCalls();
            this.debugger.writeDebugInfo("Reactor@%d, closing reactor channel@%d on channel fd=%d.]\n", this.hashCode(), reactorChannel.hashCode(), ReactorDebugger.getChannelId(reactorChannel));
            this.debugger.writeDebugInfo("Reactor@%d, Reactor channel@%d, number of closing call %d and number of dispatching per channel call %d.]\n", this.hashCode(), reactorChannel.hashCode(), this.debugger.getNumOfCloseCalls(), this.debugger.getNumOfDispatchCalls(), ReactorDebugger.getChannelId(reactorChannel));
        }
        try {
            if (errorInfo == null) {
                int n = -1;
                return n;
            }
            if (reactorChannel == null) {
                int n = this.populateErrorInfo(errorInfo, -1, "Reactor.closeChannel", "reactorChannel cannot be null");
                return n;
            }
            if (!this._reactorActive) {
                int n = this.populateErrorInfo(errorInfo, -10, "Reactor.closeChannel", "Reactor is shutdown, closeChannel ignored");
                return n;
            }
            if (reactorChannel.state() == ReactorChannel.State.CLOSED) {
                int n = 0;
                return n;
            }
            reactorChannel.state(ReactorChannel.State.CLOSED);
            if (reactorChannel.warmStandByHandlerImpl == null || !reactorChannel.equals(reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl())) {
                this._reactorChannelQueue.remove(reactorChannel, ReactorChannel.REACTOR_CHANNEL_LINK);
            }
            if (reactorChannel.warmStandByHandlerImpl != null) {
                reactorChannel.warmStandByHandlerImpl.warmStandByHandlerLock().lock();
                try {
                    reactorChannel.warmStandByHandlerImpl.channelList().remove(reactorChannel);
                }
                finally {
                    reactorChannel.warmStandByHandlerImpl.warmStandByHandlerLock().unlock();
                }
            }
            if (!this.sendWorkerEvent(WorkerEventTypes.CHANNEL_CLOSE, reactorChannel)) {
                reactorChannel.state(ReactorChannel.State.DOWN);
                this.sendAndHandleChannelEventCallback("Reactor.closeChannel", 2, reactorChannel, errorInfo);
                int n = this.populateErrorInfo(errorInfo, -1, "Reactor.closeChannel", "sendWorkerEvent() failed");
                return n;
            }
            reactorChannel.tunnelStreamManager().close();
            if (reactorChannel.watchlist() != null) {
                reactorChannel.watchlist().close();
                reactorChannel.watchlist(null);
            }
        }
        finally {
            this._reactorLock.unlock();
        }
        return 0;
    }

    private int encodedMsgSize(Msg msg) {
        int msgSize = 128;
        MsgKey key = msg.msgKey();
        msgSize += msg.encodedDataBody().length();
        if (key != null) {
            if (key.checkHasName()) {
                msgSize += key.name().length();
            }
            if (key.checkHasAttrib()) {
                msgSize += key.encodedAttrib().length();
            }
        }
        return msgSize;
    }

    private void printTunnelStreamStateInfo(TunnelStream tunnelStream) {
        int ret = tunnelStream.getStateInfo(this._tunnelStreamStateInfo);
        if (ret != 0) {
            System.out.println("TunnelStreamInt.getInfo() failed: " + CodecReturnCodes.toString((int)ret));
            return;
        }
        System.out.println("TunnelStreamStateInfo:\n                  Stream State: " + this._tunnelStreamStateInfo.streamState().toString() + "\n   Outbound Untransmitted Msgs: " + this._tunnelStreamStateInfo.outboundMsgsQueued() + "\n         Outbound Unacked Msgs: " + this._tunnelStreamStateInfo.outboundMsgsWaitingForAck() + "\n   Outbound/Inbound Bytes Open: " + this._tunnelStreamStateInfo.outboundBytesOpen() + "/" + this._tunnelStreamStateInfo.inboundBytesOpen() + "\n");
    }

    private int sendTunnelStreamLogin(TunnelStream tunnelStream, ReactorErrorInfo errorInfo) {
        LoginRequest loginRequest = tunnelStream.authLoginRequest();
        TransportBuffer msgBuf = tunnelStream.getBuffer(this.getMaxFragmentSize(tunnelStream), errorInfo);
        if (msgBuf == null) {
            this.populateErrorInfo(errorInfo, -1, "Reactor.sendTunnelStreamLogin", "Failed to obtain a TransportBuffer, reason=" + errorInfo.error().text());
            return -1;
        }
        this._eIter.clear();
        this._eIter.setBufferAndRWFVersion(msgBuf, tunnelStream.reactorChannel().majorVersion(), tunnelStream.reactorChannel().minorVersion());
        int retval = loginRequest.encode(this._eIter);
        if (retval != 0) {
            this.populateErrorInfo(errorInfo, retval, "Reactor.sendTunnelStreamLogin", "Encoding of login request failed: <" + TransportReturnCodes.toString((int)retval) + ">");
            return -1;
        }
        this._tunnelStreamSubmitOptions.clear();
        this._tunnelStreamSubmitOptions.containerType(141);
        tunnelStream.startRequestTimer();
        retval = tunnelStream.submit(msgBuf, this._tunnelStreamSubmitOptions, errorInfo);
        if (retval != 0) {
            this.populateErrorInfo(errorInfo, retval, "Reactor.sendTunnelStreamLogin", "Submit of login request failed: <" + TransportReturnCodes.toString((int)retval) + ">");
            return -1;
        }
        return 0;
    }

    int getMaxFragmentSize(ReactorChannel reactorChannel, ReactorErrorInfo errorInfo) {
        this._reactorChannelInfo.clear();
        int ret = reactorChannel.info(this._reactorChannelInfo, errorInfo);
        if (ret < 0) {
            return ret;
        }
        return this._reactorChannelInfo.channelInfo().maxFragmentSize();
    }

    int getMaxFragmentSize(TunnelStream tunnelStream) {
        return tunnelStream.classOfService().common().maxFragmentSize();
    }

    private int handleTunnelStreamMsg(ReactorChannel reactorChannel, TunnelStream tunnelStream, TransportBuffer msgBuf, Msg msg, ReactorErrorInfo errorInfo) {
        int retval;
        while ((retval = reactorChannel.tunnelStreamManager().dispatch(errorInfo.error())) > 0) {
        }
        if (retval < 0) {
            if (retval == -7) {
                if (reactorChannel.state() != ReactorChannel.State.DOWN && reactorChannel.state() != ReactorChannel.State.DOWN_RECONNECTING) {
                    if (reactorChannel.server() == null && !reactorChannel.recoveryAttemptLimitReached()) {
                        reactorChannel.state(ReactorChannel.State.DOWN_RECONNECTING);
                        this.sendAndHandleChannelEventCallback("Reactor.performChannelRead", 3, reactorChannel, errorInfo);
                    } else {
                        reactorChannel.state(ReactorChannel.State.DOWN);
                        this.sendAndHandleChannelEventCallback("Reactor.performChannelRead", 2, reactorChannel, errorInfo);
                    }
                }
                retval = 0;
            } else {
                return this.populateErrorInfo(errorInfo, retval, "Reactor.performChannelRead", "TunnelStream dispatch failed - " + errorInfo.error().text());
            }
        }
        if (msg.msgClass() == 5) {
            this._tmpState.clear();
            this._tmpState.streamState(4);
            this._tmpState.dataState(2);
            this.sendAndHandleTunnelStreamStatusEventCallback("Reactor.performChannelRead", reactorChannel, tunnelStream, msgBuf, msg, this._tmpState, errorInfo);
        } else if (msg.msgClass() != 3) {
            retval = reactorChannel.tunnelStreamManager().readMsg(tunnelStream, this._msg, errorInfo.error());
            if (retval < 0) {
                if (retval == -7) {
                    if (reactorChannel.state() != ReactorChannel.State.DOWN && reactorChannel.state() != ReactorChannel.State.DOWN_RECONNECTING) {
                        if (reactorChannel.server() == null && !reactorChannel.recoveryAttemptLimitReached()) {
                            reactorChannel.state(ReactorChannel.State.DOWN_RECONNECTING);
                            this.sendAndHandleChannelEventCallback("Reactor.performChannelRead", 3, reactorChannel, errorInfo);
                        } else {
                            reactorChannel.state(ReactorChannel.State.DOWN);
                            this.sendAndHandleChannelEventCallback("Reactor.performChannelRead", 2, reactorChannel, errorInfo);
                        }
                    }
                    retval = 0;
                } else {
                    return this.populateErrorInfo(errorInfo, retval, "Reactor.performChannelRead", "TunnelStream readMsg failed - " + errorInfo.error().text());
                }
            }
            if (msg.msgClass() == 2) {
                RefreshMsg refreshMsg = (RefreshMsg)msg;
                if (reactorChannel.watchlist() != null) {
                    this._tempWlInteger.value(refreshMsg.streamId());
                    WlRequest wlRequest = reactorChannel.watchlist().streamIdtoWlRequestTable().get(this._tempWlInteger);
                    if (wlRequest == null) {
                        return this.populateErrorInfo(errorInfo, retval, "Reactor.performChannelRead", "Internal Error: TunnelStream watchlist request entry not found.");
                    }
                    if (wlRequest.stream() == null) {
                        return this.populateErrorInfo(errorInfo, retval, "Reactor.performChannelRead", "Internal Error: TunnelStream watchlist stream entry not found.");
                    }
                    tunnelStream.channelStreamId(wlRequest.stream().streamId());
                } else {
                    tunnelStream.channelStreamId(refreshMsg.streamId());
                }
                if (refreshMsg.containerType() == 135 && refreshMsg.msgKey().checkHasFilter()) {
                    int ret = tunnelStream.classOfService().decode(this._reactorChannel, refreshMsg.encodedDataBody(), errorInfo);
                    if (ret != 0) {
                        this._tmpState.clear();
                        this._tmpState.streamState(4);
                        this._tmpState.dataState(2);
                        this._tmpState.text().data("Class of service decode failed with return code: " + ret + " <" + errorInfo.error().text() + ">");
                        this.sendAndHandleTunnelStreamStatusEventCallback("Reactor.performChannelRead", reactorChannel, tunnelStream, msgBuf, msg, this._tmpState, errorInfo);
                    }
                    if (tunnelStream.classOfService().flowControl().recvWindowSize() == -1) {
                        tunnelStream.classOfService().flowControl().recvWindowSize(12288);
                    }
                    if (tunnelStream.classOfService().flowControl().recvWindowSize() < tunnelStream.classOfService().common().maxFragmentSize()) {
                        tunnelStream.classOfService().flowControl().recvWindowSize(tunnelStream.classOfService().common().maxFragmentSize());
                    }
                    if (tunnelStream.classOfService().flowControl().sendWindowSize() == -1) {
                        tunnelStream.classOfService().flowControl().sendWindowSize(12288);
                    }
                    if (tunnelStream.classOfService().flowControl().sendWindowSize() < tunnelStream.classOfService().common().maxFragmentSize()) {
                        tunnelStream.classOfService().flowControl().sendWindowSize(tunnelStream.classOfService().common().maxFragmentSize());
                    }
                    if (!tunnelStream.isProvider()) {
                        tunnelStream.setupBufferPool();
                    }
                } else {
                    this._tmpState.clear();
                    this._tmpState.streamState(4);
                    this._tmpState.dataState(2);
                    this._tmpState.text().data("TunnelStream refresh must contain FILTER_LIST and have filter in message key");
                    this.sendAndHandleTunnelStreamStatusEventCallback("Reactor.performChannelRead", reactorChannel, tunnelStream, msgBuf, msg, this._tmpState, errorInfo);
                }
                CosCommon commonProperties = tunnelStream.classOfService().common();
                if (commonProperties.streamVersion() <= 2) {
                    if (tunnelStream.classOfService().authentication().type() != 1) {
                        refreshMsg.state().copy(tunnelStream.state());
                        this.sendAndHandleTunnelStreamStatusEventCallback("Reactor.performChannelRead", reactorChannel, tunnelStream, msgBuf, (Msg)refreshMsg, refreshMsg.state(), errorInfo);
                    } else if (this.sendTunnelStreamLogin(tunnelStream, errorInfo) < 0) {
                        this._tmpState.clear();
                        this._tmpState.streamState(4);
                        this._tmpState.dataState(2);
                        this._tmpState.text().data("sendTunnelStreamLogin() failed <" + errorInfo.error().text() + ">");
                        this.sendAndHandleTunnelStreamStatusEventCallback("Reactor.performChannelRead", reactorChannel, tunnelStream, msgBuf, msg, this._tmpState, errorInfo);
                    }
                } else {
                    this._tmpState.clear();
                    this._tmpState.streamState(4);
                    this._tmpState.dataState(2);
                    this._tmpState.text().data("Unsupported class of service stream version: " + commonProperties.streamVersion());
                    this.sendAndHandleTunnelStreamStatusEventCallback("Reactor.performChannelRead", reactorChannel, tunnelStream, msgBuf, msg, this._tmpState, errorInfo);
                }
            }
            if (tunnelStream.traceFlags() > 0) {
                this.printTunnelStreamStateInfo(tunnelStream);
            }
        } else if (!tunnelStream.handleRequestRetry()) {
            StatusMsg statusMsg = (StatusMsg)msg;
            if (statusMsg.checkHasState()) {
                statusMsg.state().copy(tunnelStream.state());
            }
            this.sendAndHandleTunnelStreamStatusEventCallback("Reactor.performChannelRead", reactorChannel, tunnelStream, msgBuf, (Msg)statusMsg, statusMsg.state(), errorInfo);
            if (statusMsg.state().streamState() == 4 || statusMsg.state().streamState() == 3) {
                tunnelStream.close(this._finalStatusEvent, errorInfo.error());
            }
        }
        retval = reactorChannel.checkTunnelManagerEvents(errorInfo);
        if (retval != 0) {
            return retval;
        }
        return 0;
    }

    private int sendFlushRequest(ReactorChannel reactorChannel, String location, ReactorErrorInfo errorInfo) {
        if (reactorChannel.flushRequested()) {
            reactorChannel.flushAgain(true);
        } else {
            if (!this.sendWorkerEvent(WorkerEventTypes.FLUSH, reactorChannel)) {
                reactorChannel.state(ReactorChannel.State.DOWN);
                this.sendAndHandleChannelEventCallback(location, 2, reactorChannel, errorInfo);
                return this.populateErrorInfo(errorInfo, -1, location, "sendWorkerEvent() failed while requesting flush");
            }
            reactorChannel.flushAgain(false);
            reactorChannel.flushRequested(true);
        }
        return 0;
    }

    boolean isReactorChannelReady(ReactorChannel reactorChannel) {
        return reactorChannel.state() == ReactorChannel.State.UP || reactorChannel.state() == ReactorChannel.State.READY;
    }

    int overflowSafeAggregate(int a, int b) {
        long sum = (long)a + (long)b;
        if (sum < Integer.MAX_VALUE) {
            return (int)sum;
        }
        return Integer.MAX_VALUE;
    }

    static boolean isWarmStandbyChannelClosed(ReactorWarmStandbyHandler wsbHandler, ReactorChannel reactorChannel) {
        ReactorChannel tmp = null;
        for (int i = 0; i < wsbHandler.channelList().size(); ++i) {
            tmp = wsbHandler.channelList().get(i);
            if (reactorChannel != null && tmp == reactorChannel && reactorChannel.channel() != null && reactorChannel.channel().state() == 2 || tmp.channel() == null || tmp.channel().state() != 2) continue;
            return false;
        }
        return true;
    }

    boolean reactorHandlesWarmStandby(ReactorChannel reactorChannel) {
        return reactorChannel.warmStandByHandlerImpl != null && (reactorChannel.warmStandByHandlerImpl.warmStandbyHandlerState() & 0x10) == 0;
    }

    boolean warmStandbySendCallback(Msg msg, WlRequest wlRequest, ReactorChannel reactorChannel) {
        if (wlRequest != null && this.reactorHandlesWarmStandby(reactorChannel)) {
            if ((wlRequest.statusFlags() & WlStreamStatusFlags.SEND_STATUS) == 0 && Reactor.isWarmStandbyChannelClosed(reactorChannel.warmStandByHandlerImpl, null)) {
                wlRequest.statusFlags(WlStreamStatusFlags.NONE);
                return true;
            }
            if (reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl().warmStandbyMode() == 1) {
                return reactorChannel.isActiveServer;
            }
            ReactorWarmStandbyGroupImpl wsbGroup = reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl();
            if (msg.msgKey() != null && msg.msgKey().checkHasServiceId()) {
                this._tempWlInteger.value(msg.msgKey().serviceId());
                ReactorWSBService service = wsbGroup._perServiceById.get(this._tempWlInteger);
                if (service != null) {
                    return service.activeChannel == reactorChannel;
                }
                return false;
            }
            if (wlRequest.hasServiceId()) {
                this._tempWlInteger.value((int)wlRequest.serviceId());
                ReactorWSBService service = wsbGroup._perServiceById.get(this._tempWlInteger);
                if (service != null) {
                    return service.activeChannel == reactorChannel;
                }
                return false;
            }
            WlService wlService = reactorChannel.watchlist().directoryHandler()._serviceCache._servicesByNameTable.get(wlRequest.streamInfo().serviceName());
            if (wlService != null) {
                ReactorWSBService service = reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl()._perServiceById.get(wlService.tableKey());
                if (service != null) {
                    return service.activeChannel == reactorChannel;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    private int reactorWSBFanoutStatusMsg(ReactorChannel reactorChannel, ReactorErrorInfo errorInfo) {
        while (reactorChannel._watchlistRecoveryMsgList.size() != 0) {
            ReactorWSRecoveryMsgInfo msgInfo = reactorChannel._watchlistRecoveryMsgList.poll();
            StatusMsg statusMsg = (StatusMsg)CodecFactory.createMsg();
            statusMsg.msgClass(3);
            statusMsg.containerType(msgInfo._containerType);
            statusMsg.domainType(msgInfo._domainType);
            statusMsg.streamId(msgInfo._streamId);
            statusMsg.flags(msgInfo._flags);
            msgInfo._msgKey.copy(statusMsg.msgKey());
            msgInfo._msgState.copy(statusMsg.state());
            ReactorMsgEvent reactorMsgEvent = ReactorFactory.createReactorMsgEvent();
            reactorMsgEvent.msg((Msg)statusMsg);
            ReactorChannel callbackChannel = reactorChannel;
            if (this.reactorHandlesWarmStandby(reactorChannel)) {
                callbackChannel = reactorChannel.warmStandByHandlerImpl.mainReactorChannelImpl();
                callbackChannel.selectableChannelFromChannel(reactorChannel.channel());
                callbackChannel.userSpecObj(reactorChannel.userSpecObj());
                callbackChannel.reactorChannelType(reactorChannel.reactorChannelType());
            }
            reactorMsgEvent.reactorChannel(callbackChannel);
            reactorMsgEvent.streamInfo().serviceName(msgInfo._serviceName.toString());
            reactorMsgEvent.streamInfo().userSpecObject(msgInfo._userSpecObject);
            reactorChannel.role().defaultMsgCallback().defaultMsgCallback(reactorMsgEvent);
            reactorMsgEvent.returnToPool();
            CloseMsg closeMsg = (CloseMsg)CodecFactory.createMsg();
            closeMsg.msgClass(5);
            closeMsg.streamId(msgInfo._streamId);
            for (int i = 0; i < reactorChannel.warmStandByHandlerImpl.channelList().size(); ++i) {
                ReactorChannel channel = reactorChannel.warmStandByHandlerImpl.channelList().get(i);
                this.reactorSubmitOptions.clear();
                channel.watchlist().submitMsg((Msg)closeMsg, this.reactorSubmitOptions, errorInfo);
            }
        }
        return 0;
    }

    int submitWSBMsg(ReactorChannel reactorChannel, Msg msg, ReactorSubmitOptions submitOptions, ReactorErrorInfo errorInfo) {
        boolean stopSubmitLoop = false;
        boolean addMsgToQueue = false;
        int ret = 0;
        ReactorWarmStandbyHandler wsbHandler = reactorChannel.warmStandByHandlerImpl;
        ReactorWarmStandbyGroupImpl wsbGroup = wsbHandler.currentWarmStandbyGroupImpl();
        ReactorWLSubmitMsgOptions submitOpts = null;
        ReactorChannel submitChannel = null;
        ReactorWSBService wsbService = null;
        if (wsbHandler.channelList().size() == 0) {
            return this.populateErrorInfo(errorInfo, -1, "reactor.submitWSBMsg", "Warm Standby channel is not active.");
        }
        if (!(wsbGroup.sendQueueReqForAll || msg.domainType() == 1 && msg.msgClass() == 1)) {
            submitOpts = wsbHandler.freeSubmitMsgQueue().size() > 0 ? wsbHandler.freeSubmitMsgQueue().remove(0) : new ReactorWLSubmitMsgOptions();
            if (msg.copy(submitOpts.msg, 4095) == -1) {
                return this.populateErrorInfo(errorInfo, -1, "reactor.submitWSBMsg", "Cannot copy submit message options");
            }
            submitOpts.submitOptions.serviceName(submitOptions.serviceName());
            submitOpts.submitOptions.requestMsgOptions().userSpecObj(submitOptions.requestMsgOptions().userSpecObj());
            addMsgToQueue = true;
            if ((wsbHandler.warmStandbyHandlerState() & 2) == 0) {
                submitOpts.submitTime = System.nanoTime();
                wsbHandler.submitMsgQueue().add(submitOpts);
                return 0;
            }
        }
        block5: for (int i = 0; i < wsbHandler.channelList().size(); ++i) {
            submitChannel = wsbHandler.channelList().get(i);
            if (!submitChannel.watchlist().directoryHandler()._serviceCache.initDirectory) {
                if (msg.domainType() != 1 && msg.msgClass() == 1) {
                    if (wsbGroup.sendQueueReqForAll) {
                        if (!submitChannel.sendReqFromQueue) continue;
                        wsbGroup.sendQueueReqForAll = false;
                        --wsbGroup.sendReqQueueCount;
                        submitChannel.sendReqFromQueue = false;
                        submitOpts = wsbHandler.freeSubmitMsgQueue().size() > 0 ? wsbHandler.freeSubmitMsgQueue().remove(0) : new ReactorWLSubmitMsgOptions();
                        if (msg.copy(submitOpts.msg, 4095) == -1) {
                            return this.populateErrorInfo(errorInfo, -1, "reactor.submitWSBMsg", "Cannot copy submit message options");
                        }
                        submitOpts.submitOptions.serviceName(submitOptions.serviceName());
                        submitOpts.submitOptions.requestMsgOptions().userSpecObj(submitOptions.requestMsgOptions().userSpecObj());
                        addMsgToQueue = true;
                        continue;
                    }
                    if (!submitChannel.sendReqFromQueue) continue;
                    --wsbGroup.sendReqQueueCount;
                    submitChannel.sendReqFromQueue = false;
                    continue;
                }
                if (msg.msgClass() != 5) continue;
            }
            switch (msg.msgClass()) {
                case 1: {
                    WlService service;
                    if ((msg.flags() & 0x100) != 0) {
                        if (wsbGroup.warmStandbyMode() == 1) {
                            if (!submitChannel.isActiveServer) {
                                continue block5;
                            }
                        } else {
                            wsbService = null;
                            if (submitOptions.serviceName() != null && !submitOptions.serviceName().isEmpty()) {
                                service = submitChannel.watchlist().directoryHandler()._serviceCache._servicesByNameTable.get(submitOptions.serviceName());
                                if (service == null || (wsbService = submitChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl()._perServiceById.get(service._tableKey)) == null || wsbService.activeChannel != submitChannel) {
                                    continue block5;
                                }
                            } else if ((msg.msgKey().flags() & 1) != 0) {
                                submitChannel.watchlist()._tempWlInteger.value(msg.msgKey().serviceId());
                                wsbService = submitChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl()._perServiceById.get(submitChannel.watchlist()._tempWlInteger);
                                if (wsbService != null && wsbService.activeChannel != submitChannel) continue block5;
                            }
                        }
                        ret = submitChannel.watchlist().submitMsg(msg, submitOptions, errorInfo);
                        stopSubmitLoop = true;
                        break;
                    }
                    if ((msg.flags() & 0x200) != 0) {
                        return this.populateErrorInfo(errorInfo, -1, "reactor.submitWSBMsg", "Pause not supported with Warm Standby.");
                    }
                    ret = submitChannel.watchlist().submitMsg(msg, submitOptions, errorInfo);
                    break;
                }
                case 7: {
                    WlService service;
                    if (!this.isReactorChannelActive(submitChannel)) continue block5;
                    if (wsbGroup.warmStandbyMode() == 1) {
                        if (!submitChannel.isActiveServer) {
                            continue block5;
                        }
                    } else {
                        wsbService = null;
                        if (submitOptions.serviceName() != null && !submitOptions.serviceName().isEmpty()) {
                            service = submitChannel.watchlist().directoryHandler()._serviceCache._servicesByNameTable.get(submitOptions.serviceName());
                            if (service == null || (wsbService = submitChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl()._perServiceById.get(service._tableKey)) == null || wsbService.activeChannel != submitChannel) {
                                continue block5;
                            }
                        } else if ((msg.msgKey().flags() & 1) != 0) {
                            submitChannel.watchlist()._tempWlInteger.value(msg.msgKey().serviceId());
                            wsbService = submitChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl()._perServiceById.get(submitChannel.watchlist()._tempWlInteger);
                            if (wsbService != null && wsbService.activeChannel != submitChannel) continue block5;
                        }
                    }
                    ret = submitChannel.watchlist().submitMsg(msg, submitOptions, errorInfo);
                    break;
                }
                case 8: {
                    WlService service;
                    if (!this.isReactorChannelActive(submitChannel)) continue block5;
                    wsbService = null;
                    if (submitOptions.serviceName() != null && !submitOptions.serviceName().isEmpty()) {
                        service = submitChannel.watchlist().directoryHandler()._serviceCache._servicesByNameTable.get(submitOptions.serviceName());
                        if (service == null || (wsbService = submitChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl()._perServiceById.get(service._tableKey)) == null) {
                            continue block5;
                        }
                    } else if ((msg.msgKey().flags() & 1) != 0) {
                        submitChannel.watchlist()._tempWlInteger.value(msg.msgKey().serviceId());
                        wsbService = submitChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl()._perServiceById.get(submitChannel.watchlist()._tempWlInteger);
                        if (wsbService == null) continue block5;
                    }
                    ret = submitChannel.watchlist().submitMsg(msg, submitOptions, errorInfo);
                    break;
                }
                default: {
                    ret = submitChannel.watchlist().submitMsg(msg, submitOptions, errorInfo);
                }
            }
            if (ret != 0) break;
            submitChannel.lastSubmitOptionsTime = System.nanoTime();
            if (stopSubmitLoop) break;
        }
        if (addMsgToQueue) {
            if (ret == 0) {
                submitOpts.submitTime = System.nanoTime();
                wsbHandler.submitMsgQueue().add(submitOpts);
            } else {
                submitOpts.clear();
                wsbHandler.freeSubmitMsgQueue().add(submitOpts);
            }
        }
        return ret;
    }

    int submitWSBRDMMsg(ReactorChannel reactorChannel, MsgBase msg, ReactorSubmitOptions submitOptions, ReactorErrorInfo errorInfo) {
        boolean stopSubmitLoop = false;
        boolean addMsgToQueue = false;
        int ret = 0;
        ReactorWarmStandbyHandler wsbHandler = reactorChannel.warmStandByHandlerImpl;
        ReactorWarmStandbyGroupImpl wsbGroup = wsbHandler.currentWarmStandbyGroupImpl();
        ReactorWLSubmitMsgOptions submitOpts = null;
        ReactorChannel submitChannel = null;
        if (wsbHandler.channelList().size() == 0) {
            return this.populateErrorInfo(errorInfo, -1, "reactor.submitWSBMsg", "Warm Standby channel is not active.");
        }
        reactorChannel.watchlist().convertRDMToCodecMsg(msg, this._msg);
        if (!(wsbGroup.sendQueueReqForAll || this._msg.domainType() == 1 && this._msg.msgClass() == 1)) {
            submitOpts = wsbHandler.freeSubmitMsgQueue().size() > 0 ? wsbHandler.freeSubmitMsgQueue().remove(0) : new ReactorWLSubmitMsgOptions();
            if (this._msg.copy(submitOpts.msg, 4095) == -1) {
                return this.populateErrorInfo(errorInfo, -1, "reactor.submitWSBMsg", "Cannot copy submit message options");
            }
            submitOpts.submitOptions.serviceName(submitOptions.serviceName());
            submitOpts.submitOptions.requestMsgOptions().userSpecObj(submitOptions.requestMsgOptions().userSpecObj());
            addMsgToQueue = true;
            if ((wsbHandler.warmStandbyHandlerState() & 2) == 0) {
                submitOpts.submitTime = System.nanoTime();
                wsbHandler.submitMsgQueue().add(submitOpts);
                return 0;
            }
        }
        block4: for (int i = 0; i < wsbHandler.channelList().size(); ++i) {
            submitChannel = wsbHandler.channelList().get(i);
            if (!submitChannel.watchlist().directoryHandler()._serviceCache.initDirectory) continue;
            switch (this._msg.msgClass()) {
                case 1: {
                    WlService service;
                    ReactorWSBService wsbService;
                    if ((this._msg.flags() & 0x100) != 0) {
                        if (wsbGroup.warmStandbyMode() == 1) {
                            if (!submitChannel.isActiveServer) {
                                continue block4;
                            }
                        } else {
                            wsbService = null;
                            if (submitOptions.serviceName() != null && !submitOptions.serviceName().isEmpty()) {
                                service = submitChannel.watchlist().directoryHandler()._serviceCache._servicesByNameTable.get(submitOptions.serviceName());
                                if (service == null || (wsbService = submitChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl()._perServiceById.get(service._tableKey)) == null || wsbService.activeChannel != submitChannel) {
                                    continue block4;
                                }
                            } else if ((this._msg.msgKey().flags() & 1) != 0) {
                                submitChannel.watchlist()._tempWlInteger.value(this._msg.msgKey().serviceId());
                                wsbService = submitChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl()._perServiceById.get(submitChannel.watchlist()._tempWlInteger);
                                if (wsbService != null && wsbService.activeChannel != submitChannel) continue block4;
                            }
                        }
                        ret = submitChannel.watchlist().submitMsg(this._msg, submitOptions, errorInfo);
                        stopSubmitLoop = true;
                        break;
                    }
                    if ((this._msg.flags() & 0x200) != 0) {
                        return this.populateErrorInfo(errorInfo, -1, "reactor.submitWSBMsg", "Pause not supported with Warm Standby.");
                    }
                    ret = submitChannel.watchlist().submitMsg(this._msg, submitOptions, errorInfo);
                    break;
                }
                case 7: 
                case 8: {
                    WlService service;
                    ReactorWSBService wsbService;
                    if (!this.isReactorChannelActive(submitChannel)) continue block4;
                    if (wsbGroup.warmStandbyMode() == 1) {
                        if (!submitChannel.isActiveServer) {
                            continue block4;
                        }
                    } else {
                        wsbService = null;
                        if (submitOptions.serviceName() != null && !submitOptions.serviceName().isEmpty()) {
                            service = submitChannel.watchlist().directoryHandler()._serviceCache._servicesByNameTable.get(submitOptions.serviceName());
                            if (service == null || (wsbService = submitChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl()._perServiceById.get(service._tableKey)) == null || wsbService.activeChannel != submitChannel) {
                                continue block4;
                            }
                        } else if ((this._msg.msgKey().flags() & 1) != 0) {
                            submitChannel.watchlist()._tempWlInteger.value(this._msg.msgKey().serviceId());
                            wsbService = submitChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl()._perServiceById.get(submitChannel.watchlist()._tempWlInteger);
                            if (wsbService != null && wsbService.activeChannel != submitChannel) continue block4;
                        }
                    }
                    ret = submitChannel.watchlist().submitMsg(this._msg, submitOptions, errorInfo);
                    break;
                }
                default: {
                    ret = submitChannel.watchlist().submitMsg(this._msg, submitOptions, errorInfo);
                }
            }
            if (ret != 0 || stopSubmitLoop) break;
        }
        this._reactorChannel.lastSubmitOptionsTime = System.nanoTime();
        if (addMsgToQueue) {
            if (ret == 0) {
                submitOpts.submitTime = System.nanoTime();
                wsbHandler.submitMsgQueue().add(submitOpts);
            } else {
                submitOpts.clear();
                wsbHandler.freeSubmitMsgQueue().add(submitOpts);
            }
        }
        return 0;
    }

    void cleanUpWSBRequestQueue(ReactorWarmStandbyHandler wsbHandler, ReactorWarmStandbyGroupImpl wsbGroup) {
        if (wsbGroup.sendReqQueueCount < wsbGroup.standbyServerList().size()) {
            if (wsbGroup.sendReqQueueCount + 1 == wsbGroup.standbyServerList().size()) {
                wsbGroup.sendQueueReqForAll = true;
                wsbGroup.sendReqQueueCount = wsbGroup.standbyServerList().size() + 1;
            } else {
                ++wsbGroup.sendReqQueueCount;
            }
        }
        if (wsbGroup.sendQueueReqForAll) {
            Reactor.clearPreviousQueuedRecoveryMessage(wsbHandler);
            wsbHandler.queuedRecoveryMessage(false);
        }
    }

    int submitWSBRequestQueue(ReactorWarmStandbyHandler wsbHandler, ReactorWarmStandbyGroupImpl wsbGroup, ReactorChannel reactorChannel, ReactorErrorInfo errorInfo) {
        int retVal = 0;
        if (reactorChannel.sendReqFromQueue) {
            return retVal;
        }
        if (wsbGroup.sendReqQueueCount < wsbGroup.standbyServerList().size() + 1) {
            if (wsbGroup.sendReqQueueCount + 1 == wsbGroup.standbyServerList().size() + 1) {
                wsbGroup.sendQueueReqForAll = true;
                wsbGroup.sendReqQueueCount = wsbGroup.standbyServerList().size() + 1;
            } else {
                ++wsbGroup.sendReqQueueCount;
            }
        }
        for (int i = 0; i < wsbHandler.submitMsgQueue().size(); ++i) {
            if (wsbHandler.submitMsgQueue().get((int)i).submitTime <= reactorChannel.lastSubmitOptionsTime) continue;
            RequestMsg msg = (RequestMsg)wsbHandler.submitMsgQueue().get((int)i).msg;
            if (msg.checkPrivateStream()) {
                WlService wlService;
                ReactorWSBService wsbService;
                if (wsbGroup.warmStandbyMode() == 1) {
                    if (!reactorChannel.isActiveServer) {
                        continue;
                    }
                } else if (msg.msgKey().checkHasServiceId()) {
                    this._tempWlInteger.value(msg.msgKey().serviceId());
                    wsbService = wsbGroup._perServiceById.get(this._tempWlInteger);
                    if (wsbService != null && reactorChannel != wsbService.activeChannel) {
                        continue;
                    }
                } else if (wsbHandler.submitMsgQueue().get((int)i).submitOptions._serviceName != null && (wlService = reactorChannel.watchlist().directoryHandler()._serviceCache._servicesByNameTable.get(wsbHandler.submitMsgQueue().get((int)i).submitOptions._serviceName)) != null && (wsbService = wsbGroup._perServiceById.get(wlService._tableKey)) != null && reactorChannel != wsbService.activeChannel) continue;
            }
            if (reactorChannel.watchlist().submitMsg(wsbHandler.submitMsgQueue().get((int)i).msg, wsbHandler.submitMsgQueue().get((int)i).submitOptions, errorInfo) == 0) continue;
            retVal = -1;
        }
        if (wsbGroup.sendQueueReqForAll) {
            ReactorWLSubmitMsgOptions submitOpts = null;
            while (wsbHandler.submitMsgQueue().size() != 0) {
                submitOpts = wsbHandler.submitMsgQueue().remove(0);
                submitOpts.clear();
                wsbHandler.freeSubmitMsgQueue().add(submitOpts);
            }
            wsbHandler.queuedRecoveryMessage(false);
        }
        reactorChannel.lastSubmitOptionsTime = System.nanoTime();
        reactorChannel.sendReqFromQueue = true;
        return retVal;
    }

    static void clearPreviousQueuedRecoveryMessage(ReactorWarmStandbyHandler wsbHandler) {
        ReactorWLSubmitMsgOptions submitOpts = null;
        while (wsbHandler.submitMsgQueue().size() != 0) {
            submitOpts = wsbHandler.submitMsgQueue().remove(0);
            submitOpts.clear();
            wsbHandler.freeSubmitMsgQueue().add(submitOpts);
        }
    }

    long getLatestMsgQueueTime(ReactorWarmStandbyHandler wsbHandler) {
        int msgQueueSize = wsbHandler.submitMsgQueue().size();
        return msgQueueSize > 0 ? wsbHandler.submitMsgQueue().get((int)(msgQueueSize - 1)).submitTime : 0L;
    }

    int queueRequestsForWSBGroupRecovery(ReactorWarmStandbyHandler wsbHandler, ReactorErrorInfo errorInfo) {
        if (wsbHandler.startingReactorChannel() != null) {
            ReactorWLSubmitMsgOptions submitOpts;
            boolean addMsgToRecoveryQueue;
            ReactorChannel reactorChannel = wsbHandler.startingReactorChannel();
            Watchlist watchlist = reactorChannel.watchlist();
            long lastSubmitionTime = -1L;
            LinkedList<ReactorWLSubmitMsgOptions> unsubmittedMsgList = null;
            boolean bl = addMsgToRecoveryQueue = wsbHandler.latestMsgSubmissionTime > wsbHandler.lastMsgRecoveryCheckTime;
            if (addMsgToRecoveryQueue) {
                long lastMsgQueueTime = this.getLatestMsgQueueTime(wsbHandler);
                if (lastMsgQueueTime > reactorChannel.lastSubmitOptionsTime) {
                    unsubmittedMsgList = new LinkedList<ReactorWLSubmitMsgOptions>();
                    submitOpts = null;
                    while (wsbHandler.submitMsgQueue().size() != 0) {
                        submitOpts = wsbHandler.submitMsgQueue().remove(0);
                        if (submitOpts.submitTime > reactorChannel.lastSubmitOptionsTime) {
                            unsubmittedMsgList.add(submitOpts);
                            continue;
                        }
                        submitOpts.clear();
                        wsbHandler.freeSubmitMsgQueue().add(submitOpts);
                    }
                } else {
                    Reactor.clearPreviousQueuedRecoveryMessage(wsbHandler);
                }
            }
            if (!wsbHandler.queuedRecoveryMessage() || addMsgToRecoveryQueue) {
                for (Map.Entry<WlInteger, WlRequest> request : watchlist._streamIdtoWlRequestTable.entrySet()) {
                    submitOpts = wsbHandler.freeSubmitMsgQueue().size() != 0 ? wsbHandler.freeSubmitMsgQueue().remove(0) : new ReactorWLSubmitMsgOptions();
                    RequestMsg tmpMsg = request.getValue().requestMsg();
                    if (tmpMsg.domainType() == 1 || tmpMsg.domainType() == 4 || tmpMsg.domainType() == 5) continue;
                    tmpMsg.copy(submitOpts.msg, 4095);
                    submitOpts.submitOptions.serviceName(request.getValue().streamInfo()._serviceName);
                    submitOpts.submitOptions.requestMsgOptions().userSpecObj(request.getValue().streamInfo().userSpecObject());
                    submitOpts.submitTime = lastSubmitionTime = System.nanoTime();
                    wsbHandler.submitMsgQueue().add(submitOpts);
                }
                if (reactorChannel.lastSubmitOptionsTime != 0L) {
                    long l = reactorChannel.lastSubmitOptionsTime = lastSubmitionTime != -1L ? lastSubmitionTime : System.nanoTime();
                }
                if (unsubmittedMsgList != null) {
                    ReactorWLSubmitMsgOptions submitOpts2 = null;
                    while (unsubmittedMsgList.size() != 0) {
                        submitOpts2 = (ReactorWLSubmitMsgOptions)unsubmittedMsgList.remove(0);
                        submitOpts2.submitTime = System.nanoTime();
                        wsbHandler.submitMsgQueue().add(submitOpts2);
                    }
                }
                wsbHandler.queuedRecoveryMessage(true);
            }
            wsbHandler.lastMsgRecoveryCheckTime = System.nanoTime();
        }
        return 0;
    }

    boolean wsbServiceInStartupList(ReactorWarmStandbyGroupImpl wsbGroup, WlService service, ReactorChannel reactorChannel) {
        ReactorWSBService startupService = wsbGroup._startupServiceNameList.get(service._rdmService.info().serviceName());
        if (startupService != null) {
            if (startupService.standbyListIndex != reactorChannel.standByServerListIndex) {
                return false;
            }
            wsbGroup._startupServiceNameList.remove(service._rdmService.info().serviceName(), startupService);
            startupService.returnToPool();
        }
        return true;
    }

    boolean isReactorChannelActive(ReactorChannel reactorChannel) {
        return reactorChannel.channel() != null && reactorChannel.channel().state() == 2;
    }

    public void enableDebuggingLevel(int level) {
        this._reactorOptions.debuggerOptions().enableLevel(level);
    }

    public void disableDebuggingLevel(int level) {
        this._reactorOptions.debuggerOptions().disableLevel(level);
    }

    public int debuggingLevels() {
        return this._reactorOptions.debuggerOptions().debuggingLevels();
    }

    boolean debugConnectionLevel() {
        return this._reactorOptions.debuggerOptions().debugConnectionLevel();
    }

    boolean debugEventQueueLevel() {
        return this._reactorOptions.debuggerOptions().debugEventQueueLevel();
    }

    boolean debugTunnelStreamLevel() {
        return this._reactorOptions.debuggerOptions().debugTunnelStreamLevel();
    }

    boolean debugEnabled() {
        return this._reactorOptions.debuggerOptions().debugEnabled();
    }

    public byte[] getDebuggingInfo() {
        return this.debugger.toByteArray();
    }

    private int getMajorDictionaryVersion(Buffer version) {
        String versionString = version.toString();
        int majorVersion = 0;
        String[] versionList = versionString.split(".");
        if (versionList.length != 0) {
            majorVersion = Integer.parseInt(versionList[0]);
        }
        return majorVersion;
    }

    private /* synthetic */ boolean lambda$dispatchAll$4(VaNode node) {
        return ((WorkerEvent)node).reactorChannel() != this._reactorChannel && ((WorkerEvent)node).reactorChannel() != null;
    }

    private /* synthetic */ boolean lambda$dispatchAll$3(VaNode node) {
        return ((WorkerEvent)node).reactorChannel() == null || ((WorkerEvent)node).reactorChannel() == this._reactorChannel;
    }
}

