/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.State;
import com.refinitiv.eta.valueadd.domainrep.rdm.MsgBaseImpl;
import com.refinitiv.eta.valueadd.domainrep.rdm.queue.QueueMsg;
import com.refinitiv.eta.valueadd.domainrep.rdm.queue.QueueMsgType;
import com.refinitiv.eta.valueadd.reactor.QueueAckImpl;
import com.refinitiv.eta.valueadd.reactor.QueueDataExpiredImpl;
import com.refinitiv.eta.valueadd.reactor.QueueDataImpl;
import com.refinitiv.eta.valueadd.reactor.QueueRefreshImpl;
import com.refinitiv.eta.valueadd.reactor.QueueRequestImpl;

abstract class QueueMsgImpl
extends MsgBaseImpl
implements QueueMsg {
    int _domainType;
    int _opCode;
    int _serviceId;
    int _lastInSeqNum;
    int _lastOutSeqNum;
    int _seqNum;
    int _secondarySeqNum;
    long _timeout;
    int _containerType;
    long _identifier;
    int _undeliverableCode;
    int _type;
    State _state = CodecFactory.createState();
    static final int QMSG_MAX_NAME_LENGTH = 200;

    QueueMsgImpl() {
    }

    String opCodeToString(int opCode) {
        switch (opCode) {
            case 0: {
                return "INIT";
            }
            case 1: {
                return "DATA";
            }
            case 2: {
                return "ACK";
            }
            case 3: {
                return "REQUEST";
            }
            case 4: {
                return "DEAD_LETTER";
            }
            case -1: {
                return "REFRESH";
            }
        }
        return "Unknown";
    }

    @Override
    public QueueMsgType rdmMsgType() {
        return QueueMsgType.UNKNOWN;
    }

    @Override
    public int domainType() {
        return this._domainType;
    }

    @Override
    public void domainType(int domainType) {
        this._domainType = domainType;
    }

    @Override
    public int serviceId() {
        return this._serviceId;
    }

    @Override
    public void serviceId(int serviceId) {
        this._serviceId = serviceId;
    }

    int lastInSeqNum() {
        return this._lastInSeqNum;
    }

    int lastOutSeqNum() {
        return this._lastOutSeqNum;
    }

    int secondarySeqNum() {
        return this._secondarySeqNum;
    }

    void lastOutSeqNum(int lastOutSeqNum) {
        this._lastOutSeqNum = lastOutSeqNum;
    }

    void lastInSeqNum(int lastInSeqNum) {
        this._lastInSeqNum = lastInSeqNum;
    }

    void secondarySeqNum(int secondarySeqNum) {
        this._secondarySeqNum = secondarySeqNum;
    }

    int seqNum() {
        return this._seqNum;
    }

    void seqNum(int seqNum) {
        this._seqNum = seqNum;
    }

    int opCode() {
        return this._opCode;
    }

    void opCode(int opCode) {
        this._opCode = opCode;
    }

    State state() {
        return this._state;
    }

    void state(State state) {
        this._state = state;
    }

    String xmlDump() {
        switch (this._opCode) {
            case 2: {
                return "<QueueAck streamId=\"" + this.streamId() + "\" sourceName=\"" + ((QueueAckImpl)this).sourceName() + "\" destName=\"" + ((QueueAckImpl)this).destName() + "\" seqNum=\"" + this._seqNum + "\" identifier=\"" + this._identifier + "\" />\n";
            }
            case 1: {
                return "<QueueData streamId=\"" + this.streamId() + "\" sourceName=\"" + ((QueueDataImpl)this).sourceName() + "\" destName=\"" + ((QueueDataImpl)this).destName() + "\" seqNum=\"" + this._seqNum + "\" timeout=\"" + this._timeout + "\" identifier=\"" + this._identifier + "\" />\n";
            }
            case 4: {
                return "<QueueDataExpired streamId=\"" + this.streamId() + "\" sourceName=\"" + ((QueueDataExpiredImpl)this).sourceName() + "\" destName=\"" + ((QueueDataExpiredImpl)this).destName() + "\" seqNum=\"" + this._seqNum + "\" timeout=\"" + this._timeout + "\" identifier=\"" + this._identifier + "\" undeliverableCode=\"" + this._undeliverableCode + "\" />\n";
            }
            case 3: {
                return "<QueueRequest streamId=\"" + this.streamId() + "\" sourceName=\"" + ((QueueRequestImpl)this).sourceName() + "\" lastOutSeqNum=\"" + this._lastOutSeqNum + "\" lastInSeqNum=\"" + this._lastInSeqNum + "\" />\n";
            }
            case -1: {
                return "<QueueRefresh streamId=\"" + this.streamId() + "\" sourceName=\"" + ((QueueRefreshImpl)this).sourceName() + "\" lastOutSeqNum=\"" + this._lastOutSeqNum + "\" lastInSeqNum=\"" + this._lastInSeqNum + "\" />\n";
            }
            case -2: {
                return "<QueueClose>\n";
            }
        }
        return "<UnknownQueueMsg />\n";
    }

    class OpCodes {
        static final int INIT = 0;
        static final int DATA = 1;
        static final int ACK = 2;
        static final int REQUEST = 3;
        static final int DEAD_LETTER = 4;
        static final int REFRESH = -1;
        static final int CLOSE = -2;
        static final int STATUS = -3;

        OpCodes() {
        }
    }
}

