/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;

public class FileDumper {
    private final String xmlTraceFileName;
    private final boolean xmlTraceToMultipleFiles;
    private final long xmlTraceMaxFileSize;
    private OutputStream out;
    private boolean fileSizeReached = false;
    private long currentFileSize = 0L;

    public FileDumper(String xmlTraceFileName, boolean xmlTraceToMultipleFiles, long xmlTraceMaxFileSize) {
        this.xmlTraceFileName = xmlTraceFileName;
        this.xmlTraceToMultipleFiles = xmlTraceToMultipleFiles;
        this.xmlTraceMaxFileSize = xmlTraceMaxFileSize;
    }

    private void createNewFile() {
        String[] Ids = ManagementFactory.getRuntimeMXBean().getName().split("@");
        String processId = Ids.length > 0 ? "_" + Ids[0] + "_" : "_";
        String fileName = this.xmlTraceFileName + processId + Instant.now().toEpochMilli() + ".xml";
        Path filePath = Paths.get(fileName, new String[0]);
        try {
            Files.createFile(filePath, new FileAttribute[0]);
            this.out = Files.newOutputStream(filePath, StandardOpenOption.APPEND);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean isCurrentFileOverSize() {
        return this.currentFileSize >= this.xmlTraceMaxFileSize;
    }

    public void dump(String content) {
        if (this.fileSizeReached) {
            return;
        }
        if (this.isCurrentFileOverSize()) {
            if (this.xmlTraceToMultipleFiles) {
                this.close();
                this.createNewFile();
                try {
                    this.out.write(content.getBytes());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.currentFileSize += (long)content.getBytes().length;
            } else {
                this.fileSizeReached = true;
                this.close();
            }
        } else {
            try {
                if (this.out == null) {
                    this.createNewFile();
                }
                this.out.write(content.getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.currentFileSize += (long)content.getBytes().length;
        }
    }

    public void close() {
        if (this.out != null) {
            try {
                this.out.close();
                this.out = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.currentFileSize = 0L;
    }
}

