/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import java.nio.ByteBuffer;

class TunnelStreamUtil {
    static final long NANO_PER_MILLI = 1000000L;
    static final long NANO_PER_SEC = 1000000000L;

    TunnelStreamUtil() {
    }

    static int seqNumCompare(int seqNum1, int seqNum2) {
        return seqNum1 - seqNum2;
    }

    static int replaceQueueDataTimeout(ByteBuffer substreamBuffer, long timeout) {
        int tmpPos = substreamBuffer.position();
        int tmpLimit = substreamBuffer.limit();
        int position = substreamBuffer.position() + 8;
        position += 2;
        int tmpLength = substreamBuffer.getShort(position += 4);
        assert ((tmpLength & 0x8000) > 0);
        position += 2 + (tmpLength &= 0x7F);
        assert (substreamBuffer.get(++position) == 1);
        position = (substreamBuffer.get(++position) & 0x80) == 0 ? ++position : (position += 2);
        position += 1 + substreamBuffer.get(position);
        tmpLength = substreamBuffer.get(position);
        substreamBuffer.position(++position);
        substreamBuffer.limit(substreamBuffer.position() + tmpLength);
        TunnelStreamUtil.writeLong64ls(timeout, substreamBuffer);
        for (int i = substreamBuffer.position(); i < position + tmpLength; ++i) {
            substreamBuffer.put(i, (byte)0);
        }
        substreamBuffer.limit(tmpLimit);
        substreamBuffer.position(tmpPos);
        return 0;
    }

    static int replaceQueueDataFlags(ByteBuffer substreamBuffer, int flags) {
        int tmpPos = substreamBuffer.position();
        int position = substreamBuffer.position() + 8;
        position += 2;
        int tmpLength = substreamBuffer.getShort(position += 4);
        assert ((tmpLength & 0x8000) > 0);
        position += 2 + (tmpLength &= 0x7F);
        assert (substreamBuffer.get(++position) == 1);
        substreamBuffer.position(++position);
        TunnelStreamUtil.writeResBit15(flags, substreamBuffer);
        substreamBuffer.position(tmpPos);
        return 0;
    }

    static int writeLong64ls(long v, ByteBuffer byteBuf) {
        if (v >= -128L && v < 128L) {
            if (byteBuf.remaining() >= 1) {
                byteBuf.put((byte)(v & 0xFFL));
                return 0;
            }
            return -21;
        }
        if (v >= -32768L && v < 32768L) {
            if (byteBuf.remaining() >= 2) {
                byteBuf.putShort((short)(v & 0xFFFFL));
                return 0;
            }
            return -21;
        }
        if (v >= -8388608L && v < 0x800000L) {
            if (byteBuf.remaining() >= 3) {
                byteBuf.put((byte)(v >> 16 & 0xFFL));
                byteBuf.putShort((short)(v & 0xFFFFL));
                return 0;
            }
            return -21;
        }
        if (v >= Integer.MIN_VALUE && v < 0x80000000L) {
            if (byteBuf.remaining() >= 4) {
                byteBuf.putInt((int)v & 0xFFFFFFFF);
                return 0;
            }
            return -21;
        }
        if (v >= -549755813888L && v < 0x8000000000L) {
            if (byteBuf.remaining() >= 5) {
                byteBuf.put((byte)(v >> 32 & 0xFFL));
                byteBuf.putInt((int)(v & 0xFFFFFFFFL));
                return 0;
            }
            return -21;
        }
        if (v >= -140737488355328L && v < 0x800000000000L) {
            if (byteBuf.remaining() >= 6) {
                byteBuf.putShort((short)(v >> 32 & 0xFFFFL));
                byteBuf.putInt((int)(v & 0xFFFFFFFFL));
                return 0;
            }
            return -21;
        }
        if (v >= -36028797018963968L && v < 0x80000000000000L) {
            if (byteBuf.remaining() >= 7) {
                byteBuf.put((byte)(v >> 48 & 0xFFL));
                byteBuf.putShort((short)(v >> 32 & 0xFFFFL));
                byteBuf.putInt((int)(v & 0xFFFFFFFFL));
                return 0;
            }
            return -21;
        }
        if (byteBuf.remaining() >= 8) {
            byteBuf.putLong(v);
            return 0;
        }
        return -21;
    }

    static long readLong64ls(int size, ByteBuffer byteBuf) throws Exception {
        switch (size) {
            case 0: {
                return 0L;
            }
            case 1: {
                return byteBuf.get();
            }
            case 2: {
                return byteBuf.getShort();
            }
            case 3: {
                return (byteBuf.get() << 16) + TunnelStreamUtil.readUnsignedShort(byteBuf);
            }
            case 4: {
                return byteBuf.getInt();
            }
            case 5: {
                return ((long)byteBuf.get() << 32) + TunnelStreamUtil.readUnsignedInt(byteBuf);
            }
            case 6: {
                return ((long)byteBuf.getShort() << 32) + TunnelStreamUtil.readUnsignedInt(byteBuf);
            }
            case 7: {
                return ((long)byteBuf.get() << 48) + ((long)TunnelStreamUtil.readUnsignedShort(byteBuf) << 32) + TunnelStreamUtil.readUnsignedInt(byteBuf);
            }
            case 8: {
                return byteBuf.getLong();
            }
        }
        assert (false);
        return 0L;
    }

    static int readUnsignedShort(ByteBuffer byteBuf) throws Exception {
        int val = byteBuf.getShort();
        if (val < 0) {
            val &= 0xFFFF;
        }
        return val;
    }

    static long readUnsignedInt(ByteBuffer byteBuf) throws Exception {
        long val = byteBuf.getInt();
        if (val < 0L) {
            val &= 0xFFFFFFFFL;
        }
        return val;
    }

    static void writeResBit15(int value, ByteBuffer toBuffer) {
        if (value < 128) {
            toBuffer.put((byte)value);
        } else {
            toBuffer.putShort((short)(value | 0x8000));
        }
    }

    static int readResBit15(ByteBuffer fromBuffer) {
        int b = TunnelStreamUtil.readUnsignedByte(fromBuffer);
        if ((b & 0x80) != 0) {
            return (short)(((b & 0x7F) << 8) + TunnelStreamUtil.readUnsignedByte(fromBuffer));
        }
        return (short)b;
    }

    static int readUnsignedByte(ByteBuffer fromBuffer) {
        short val = fromBuffer.get();
        if (val < 0) {
            val = (short)(val & 0xFF);
        }
        return val;
    }
}

