/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.transport.Error;
import com.refinitiv.eta.valueadd.common.VaDoubleLinkList;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamBuffer;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamPersistenceBuffer;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamPersistenceFile;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamUtil;
import com.refinitiv.eta.valueadd.reactor.TunnelSubstream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

class TunnelStreamPersistenceFileV2
extends TunnelStreamPersistenceFile {
    private int _maxMsgs;
    private int _maxMsgLength;
    private VaDoubleLinkList<TunnelStreamPersistenceBuffer> _savedMsgList = new VaDoubleLinkList();

    TunnelStreamPersistenceFileV2(TunnelSubstream tunnelSubstream, RandomAccessFile file, FileChannel fileChannel, FileLock fileLock, Msg tmpMsg, EncodeIterator tmpEncodeIter, DecodeIterator tmpDecodeIter, boolean reset, Error error) {
        super(tunnelSubstream, file, fileChannel, fileLock);
        try {
            long fileSize = reset ? (long)(36 + (32 + this._tunnelSubstream._tunnelStream._classOfService.common().maxMsgSize() + 128) * 1024) : fileChannel.size();
            this._fileByteBuf = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, fileSize);
            this._fileByteBuf.order(ByteOrder.LITTLE_ENDIAN);
        }
        catch (IOException e) {
            error.errorId(-1);
            error.text("Failed to map persistence file to ByteBuffer");
        }
        if (!reset) {
            TunnelStreamPersistenceBuffer persistBuffer;
            int transmittedMsgCount = 0;
            this._maxMsgs = this._fileByteBuf.getInt(4);
            this._maxMsgLength = this._fileByteBuf.getInt(8);
            this._tunnelSubstream._lastOutSeqNum = this._fileByteBuf.getInt(16);
            this._tunnelSubstream._lastInSeqNum = this._fileByteBuf.getInt(20);
            int position = this._fileByteBuf.getInt(24);
            while (position != 0) {
                persistBuffer = new TunnelStreamPersistenceBuffer();
                persistBuffer.tunnelStreamHeaderLen(0);
                persistBuffer.filePosition(position);
                this._persistentBufferPool.push(persistBuffer, TunnelStreamPersistenceBuffer.SUBSTREAM_LINK);
                position = this._fileByteBuf.getInt(position + 0);
            }
            position = this._fileByteBuf.getInt(28);
            while (position != 0) {
                int entryPosition = position;
                position = this._fileByteBuf.getInt(position + 0);
                persistBuffer = new TunnelStreamPersistenceBuffer();
                int length = this._fileByteBuf.getInt(entryPosition + 8);
                persistBuffer.length(length);
                persistBuffer.tunnelStreamHeaderLen(0);
                persistBuffer.filePosition(entryPosition);
                persistBuffer.isTransmitted((this._fileByteBuf.getInt(entryPosition + 4) & 1) != 0);
                if (persistBuffer.isTransmitted()) {
                    ++transmittedMsgCount;
                }
                this._savedMsgList.push(persistBuffer, TunnelStreamPersistenceBuffer.SUBSTREAM_LINK);
            }
            int seqNum = this._tunnelSubstream._lastOutSeqNum - transmittedMsgCount;
            persistBuffer = this._savedMsgList.start(TunnelStreamPersistenceBuffer.SUBSTREAM_LINK);
            while (persistBuffer != null && persistBuffer.isTransmitted()) {
                persistBuffer.seqNum(++seqNum);
                persistBuffer = this._savedMsgList.forth(TunnelStreamPersistenceBuffer.SUBSTREAM_LINK);
            }
        } else {
            this._maxMsgs = 1024;
            this._maxMsgLength = this._tunnelSubstream._tunnelStream.classOfService().common().maxMsgSize();
            this._tunnelSubstream._lastOutSeqNum = 0;
            this._tunnelSubstream._lastInSeqNum = 0;
            this._fileByteBuf.putInt(0, 2);
            this._fileByteBuf.putInt(4, this._maxMsgs);
            this._fileByteBuf.putInt(8, this._maxMsgLength);
            this._fileByteBuf.putInt(12, 0);
            this._fileByteBuf.putInt(16, 0);
            this._fileByteBuf.putInt(20, 0);
            this._fileByteBuf.putInt(32, 0);
            TunnelStreamPersistenceBuffer prevPersistBuffer = null;
            TunnelStreamPersistenceBuffer persistBuffer = null;
            for (int i = 0; i < 1024; ++i) {
                persistBuffer = new TunnelStreamPersistenceBuffer();
                persistBuffer.filePosition(36 + i * (32 + this._maxMsgLength + 128));
                this._persistentBufferPool.push(persistBuffer, TunnelStreamPersistenceBuffer.SUBSTREAM_LINK);
                if (prevPersistBuffer != null) {
                    this._fileByteBuf.putInt(prevPersistBuffer.filePosition() + 0, persistBuffer.filePosition());
                }
                prevPersistBuffer = persistBuffer;
            }
            this._fileByteBuf.putInt(persistBuffer.filePosition() + 0, 0);
            this._fileByteBuf.putInt(24, ((TunnelStreamPersistenceBuffer)this._persistentBufferPool.peek()).filePosition());
            this._fileByteBuf.putInt(28, 0);
        }
        error.errorId(0);
    }

    @Override
    void lastOutSeqNum(int lastOutSeqNum) {
        this._fileByteBuf.putInt(16, lastOutSeqNum);
    }

    @Override
    void lastInSeqNum(int lastInSeqNum) {
        this._fileByteBuf.putInt(20, lastInSeqNum);
    }

    @Override
    int saveMsg(TunnelStreamBuffer buffer, Error error) {
        assert (buffer.length() <= this._tunnelSubstream._tunnelStream._classOfService.common().maxMsgSize());
        TunnelStreamPersistenceBuffer persistenceBuffer = (TunnelStreamPersistenceBuffer)this._persistentBufferPool.peek();
        if (persistenceBuffer == null) {
            error.errorId(-9);
            error.text("Local persistence file is full. Space may become available later as delivered messages are acknowledged.");
            return -9;
        }
        int entryPosition = persistenceBuffer.filePosition();
        buffer.setToInnerWriteBuffer();
        this._fileByteBuf.putInt(persistenceBuffer.filePosition() + 4, 0);
        this._fileByteBuf.putInt(entryPosition + 8, buffer.length());
        if (!buffer.timeoutIsCode()) {
            assert (buffer.timeoutNsec() - buffer.timeQueuedNsec() > 0L);
            this._fileByteBuf.putLong(entryPosition + 20, (buffer.timeoutNsec() - buffer.timeQueuedNsec()) / 1000000L);
            this._fileByteBuf.putLong(entryPosition + 12, buffer.timeQueuedNsec());
        } else {
            this._fileByteBuf.putLong(entryPosition + 20, buffer.timeoutNsec());
        }
        this._fileByteBuf.position(entryPosition + 32);
        buffer.copy(this._fileByteBuf);
        this.persistenceBufferListMove(this._persistentBufferPool, 24, this._savedMsgList, 28, persistenceBuffer);
        buffer.persistenceBuffer(this._tunnelSubstream, persistenceBuffer);
        return 0;
    }

    @Override
    void releasePersistenceBuffers(int seqNum) {
        TunnelStreamPersistenceBuffer persistBuffer;
        while ((persistBuffer = this._savedMsgList.peek()) != null && TunnelStreamUtil.seqNumCompare(persistBuffer.seqNum(), seqNum) <= 0) {
            this.releasePersistenceBuffer(persistBuffer);
        }
    }

    @Override
    void releasePersistenceBuffer(TunnelStreamPersistenceBuffer persistBuffer) {
        this.persistenceBufferListMove(this._savedMsgList, 28, this._persistentBufferPool, 24, persistBuffer);
        persistBuffer.reset();
    }

    @Override
    void setBufferAsTransmitted(TunnelStreamPersistenceBuffer persistenceBuffer) {
        if (persistenceBuffer.isTransmitted()) {
            return;
        }
        int seqNum = this._tunnelSubstream._lastOutSeqNum + 1;
        this._fileByteBuf.putInt(persistenceBuffer.filePosition() + 4, 1);
        persistenceBuffer.isTransmitted(true);
        persistenceBuffer.seqNum(seqNum);
        this.lastOutSeqNum(seqNum);
        this._fileByteBuf.force();
    }

    @Override
    int retransmitBuffers(int seqNum, Msg tmpMsg, EncodeIterator tmpEncodeIter, DecodeIterator tmpDecodeIter, Error error) {
        long currentTime = System.nanoTime();
        TunnelStreamPersistenceBuffer persistBuffer = this._savedMsgList.start(TunnelStreamPersistenceBuffer.SUBSTREAM_LINK);
        while (persistBuffer != null) {
            int ret = this.retransmitBuffer(persistBuffer, seqNum, currentTime, tmpMsg, tmpEncodeIter, tmpDecodeIter, error);
            if (ret != 0) {
                return ret;
            }
            persistBuffer = this._savedMsgList.forth(TunnelStreamPersistenceBuffer.SUBSTREAM_LINK);
        }
        return 0;
    }

    private void persistenceBufferListMove(VaDoubleLinkList<TunnelStreamPersistenceBuffer> oldList, int oldListHeadPosition, VaDoubleLinkList<TunnelStreamPersistenceBuffer> newList, int newListHeadPosition, TunnelStreamPersistenceBuffer persistBuffer) {
        super.peristenceBufferListMove(oldList, oldListHeadPosition, newList, newListHeadPosition, 0, persistBuffer);
        this._fileByteBuf.putInt(12, this._savedMsgList.count());
        this._fileByteBuf.force();
    }

    @Override
    void clear(Error tmpError) {
        super.clear(tmpError);
        while (this._savedMsgList.pop(TunnelStreamPersistenceBuffer.SUBSTREAM_LINK) != null) {
        }
        this._maxMsgs = 0;
    }

    @Override
    int persistBufferMsgOffset() {
        return 32;
    }

    @Override
    long persistBufferTimeoutNsec(TunnelStreamPersistenceBuffer persistBuffer) {
        return this._fileByteBuf.getLong(persistBuffer.filePosition() + 20) * 1000000L;
    }

    private class MsgHeaderFlags {
        private static final int NONE = 0;
        private static final int TRANSMITTED = 1;

        private MsgHeaderFlags() {
        }
    }

    private class MsgHeader {
        private static final int LENGTH = 32;
        static final int NEXT_MSG_POS = 0;
        static final int FLAGS_POS = 4;
        static final int MSG_LENGTH_POS = 8;
        static final int TIME_QUEUED_POS = 12;
        static final int TIME_TO_LIVE_POS = 20;

        private MsgHeader() {
        }
    }

    private class Header {
        private static final int LENGTH = 36;
        private static final int FILE_VERSION_POS = 0;
        private static final int MAX_MSGS_POS = 4;
        private static final int MAX_MSG_LENGTH_POS = 8;
        private static final int CURRENT_MSG_COUNT_POS = 12;
        private static final int LAST_OUT_SEQ_NUM_POS = 16;
        private static final int LAST_IN_SEQ_NUM_POS = 20;
        private static final int POOL_HEAD_POS = 24;
        private static final int SAVED_HEAD_POS = 28;
        private static final int FLAGS_POS = 32;
        private static final int MAX_MSGS = 1024;

        private Header() {
        }
    }
}

