/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.valueadd.common.LimitedVaPool;
import com.refinitiv.eta.valueadd.common.VaPool;
import com.refinitiv.eta.valueadd.reactor.ClassOfService;
import com.refinitiv.eta.valueadd.reactor.ConsumerRole;
import com.refinitiv.eta.valueadd.reactor.NIProviderRole;
import com.refinitiv.eta.valueadd.reactor.ProviderRole;
import com.refinitiv.eta.valueadd.reactor.RDMDictionaryMsgEvent;
import com.refinitiv.eta.valueadd.reactor.RDMDirectoryMsgEvent;
import com.refinitiv.eta.valueadd.reactor.RDMLoginMsgEvent;
import com.refinitiv.eta.valueadd.reactor.Reactor;
import com.refinitiv.eta.valueadd.reactor.ReactorAcceptOptions;
import com.refinitiv.eta.valueadd.reactor.ReactorAuthTokenEvent;
import com.refinitiv.eta.valueadd.reactor.ReactorChannel;
import com.refinitiv.eta.valueadd.reactor.ReactorChannelEvent;
import com.refinitiv.eta.valueadd.reactor.ReactorChannelInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorChannelStats;
import com.refinitiv.eta.valueadd.reactor.ReactorChannelStatsImpl;
import com.refinitiv.eta.valueadd.reactor.ReactorConnectInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorConnectOptions;
import com.refinitiv.eta.valueadd.reactor.ReactorDebugger;
import com.refinitiv.eta.valueadd.reactor.ReactorDebuggerImpl;
import com.refinitiv.eta.valueadd.reactor.ReactorDispatchOptions;
import com.refinitiv.eta.valueadd.reactor.ReactorErrorInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorJsonConverterOptions;
import com.refinitiv.eta.valueadd.reactor.ReactorMsgEvent;
import com.refinitiv.eta.valueadd.reactor.ReactorOAuthCredential;
import com.refinitiv.eta.valueadd.reactor.ReactorOAuthCredentialEvent;
import com.refinitiv.eta.valueadd.reactor.ReactorOAuthCredentialRenewal;
import com.refinitiv.eta.valueadd.reactor.ReactorOAuthCredentialRenewalOptions;
import com.refinitiv.eta.valueadd.reactor.ReactorOptions;
import com.refinitiv.eta.valueadd.reactor.ReactorPackedBuffer;
import com.refinitiv.eta.valueadd.reactor.ReactorRestProxyOptions;
import com.refinitiv.eta.valueadd.reactor.ReactorServiceDiscoveryOptions;
import com.refinitiv.eta.valueadd.reactor.ReactorServiceEndpointEvent;
import com.refinitiv.eta.valueadd.reactor.ReactorSubmitOptions;
import com.refinitiv.eta.valueadd.reactor.ReactorWSBService;
import com.refinitiv.eta.valueadd.reactor.ReactorWarmStandbyGroup;
import com.refinitiv.eta.valueadd.reactor.ReactorWarmStandbyGroupImpl;
import com.refinitiv.eta.valueadd.reactor.ReactorWarmStandbyServerInfo;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamAcceptOptions;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamAuthInfo;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamInfo;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamInfoImpl;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamMsgEvent;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamOpenOptions;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamQueueMsgEvent;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamRejectOptions;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamStatusEvent;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamSubmitOptions;
import com.refinitiv.eta.valueadd.reactor.Watchlist;
import com.refinitiv.eta.valueadd.reactor.WlInteger;
import com.refinitiv.eta.valueadd.reactor.WlItemAggregationKey;
import com.refinitiv.eta.valueadd.reactor.WlItemGroup;
import com.refinitiv.eta.valueadd.reactor.WlPostTimeoutInfo;
import com.refinitiv.eta.valueadd.reactor.WlRequest;
import com.refinitiv.eta.valueadd.reactor.WlService;
import com.refinitiv.eta.valueadd.reactor.WlStream;
import com.refinitiv.eta.valueadd.reactor.WlView;
import com.refinitiv.eta.valueadd.reactor.WorkerEvent;
import java.io.OutputStream;

public class ReactorFactory {
    static VaPool _reactorChannelPool = new VaPool(true);
    static VaPool _rdmLoginMsgEventPool = new VaPool(true);
    static VaPool _rdmDirectoryMsgEventPool = new VaPool(true);
    static VaPool _rdmDictionaryMsgEventPool = new VaPool(true);
    static LimitedVaPool _reactorMsgEventPool = new LimitedVaPool(true);
    static LimitedVaPool _reactorChannelEventPool = new LimitedVaPool(true);
    static VaPool _reactorAuthTokenEventPool = new VaPool(true);
    static VaPool _reactorServiceEndpointEventPool = new VaPool(true);
    static VaPool _reactorOAuthCredentialEventPool = new VaPool(true);
    static VaPool _queueMsgEventPool = new VaPool(true);
    static LimitedVaPool _tunnelStreamMsgEventPool = new LimitedVaPool(true);
    static LimitedVaPool _tunnelStreamStatusEventPool = new LimitedVaPool(true);
    static LimitedVaPool _workerEventPool = new LimitedVaPool(true);
    static VaPool _watchlistPool = new VaPool(true);
    static VaPool _postTimeoutInfoPool = new VaPool(true);
    static VaPool _itemAggregationKeyPool = new VaPool(true);
    static VaPool _wlStreamPool = new VaPool(true);
    static VaPool _wlRequestPool = new VaPool(true);
    static VaPool _wlServicePool = new VaPool(true);
    static VaPool _wlItemGroupPool = new VaPool(true);
    static VaPool _wlIntegerPool = new VaPool(true);
    static VaPool _wlViewPool = new VaPool(true);
    static VaPool _packedBufferPool = new VaPool(true);
    static VaPool _wsbServicePool = new VaPool(true);
    private static final int DEFAULT_POOL_LIMIT = -1;

    private ReactorFactory() {
        throw new AssertionError();
    }

    public static void setReactorMsgEventPoolLimit(int reactorMsgEventPoolLimit) {
        _reactorMsgEventPool.setLimit(reactorMsgEventPoolLimit > 0 ? reactorMsgEventPoolLimit : -1);
    }

    public static void setReactorChannelEventPoolLimit(int reactorChannelEventPoolLimit) {
        _reactorChannelEventPool.setLimit(reactorChannelEventPoolLimit > 0 ? reactorChannelEventPoolLimit : -1);
    }

    public static void setWorkerEventPoolLimit(int workerEventPoolLimit) {
        _workerEventPool.setLimit(workerEventPoolLimit > 0 ? workerEventPoolLimit : -1);
    }

    public static void setTunnelStreamMsgEventPoolLimit(int tunnelStreamMsgEventPoolLimit) {
        _tunnelStreamMsgEventPool.setLimit(tunnelStreamMsgEventPoolLimit > 0 ? tunnelStreamMsgEventPoolLimit : -1);
    }

    public static void setTunnelStreamStatusEventPoolLimit(int tunnelStreamStatusEventPoolLimit) {
        _tunnelStreamStatusEventPool.setLimit(tunnelStreamStatusEventPoolLimit > 0 ? tunnelStreamStatusEventPoolLimit : -1);
    }

    public static Reactor createReactor(ReactorOptions options, ReactorErrorInfo errorInfo) {
        if (errorInfo == null) {
            System.out.println("ReactorFactory.createReactor: ReactorErrorInfo cannot be null, reactor not created.");
            return null;
        }
        Reactor reactor = new Reactor(options, errorInfo);
        if (!reactor.isShutdown()) {
            return reactor;
        }
        return null;
    }

    public static ReactorErrorInfo createReactorErrorInfo() {
        return new ReactorErrorInfo();
    }

    public static ReactorOptions createReactorOptions() {
        return new ReactorOptions();
    }

    public static ReactorChannelStats createReactorChannelStats() {
        return new ReactorChannelStatsImpl();
    }

    public static ReactorConnectOptions createReactorConnectOptions() {
        return new ReactorConnectOptions();
    }

    public static ReactorAcceptOptions createReactorAcceptOptions() {
        return new ReactorAcceptOptions();
    }

    public static ReactorDispatchOptions createReactorDispatchOptions() {
        return new ReactorDispatchOptions();
    }

    public static ReactorSubmitOptions createReactorSubmitOptions() {
        return new ReactorSubmitOptions();
    }

    public static TunnelStreamOpenOptions createTunnelStreamOpenOptions() {
        return new TunnelStreamOpenOptions();
    }

    public static ConsumerRole createConsumerRole() {
        return new ConsumerRole();
    }

    public static ProviderRole createProviderRole() {
        return new ProviderRole();
    }

    public static NIProviderRole createNIProviderRole() {
        return new NIProviderRole();
    }

    public static ReactorChannelInfo createReactorChannelInfo() {
        return new ReactorChannelInfo();
    }

    public static ReactorConnectInfo createReactorConnectInfo() {
        return new ReactorConnectInfo();
    }

    public static ReactorWarmStandbyServerInfo createReactorWarmStandbyServerInfo() {
        return new ReactorWarmStandbyServerInfo();
    }

    public static TunnelStreamAcceptOptions createTunnelStreamAcceptOptions() {
        return new TunnelStreamAcceptOptions();
    }

    public static TunnelStreamRejectOptions createTunnelStreamRejectOptions() {
        return new TunnelStreamRejectOptions();
    }

    public static TunnelStreamSubmitOptions createTunnelStreamSubmitOptions() {
        return new TunnelStreamSubmitOptions();
    }

    public static ClassOfService createClassOfService() {
        return new ClassOfService();
    }

    public static ReactorServiceDiscoveryOptions createReactorServiceDiscoveryOptions() {
        return new ReactorServiceDiscoveryOptions();
    }

    public static TunnelStreamInfo createTunnelStreamInfo() {
        return new TunnelStreamInfoImpl();
    }

    public static ReactorOAuthCredential createReactorOAuthCredential() {
        return new ReactorOAuthCredential();
    }

    public static ReactorOAuthCredentialRenewal createReactorOAuthCredentialRenewal() {
        return new ReactorOAuthCredentialRenewal();
    }

    public static ReactorOAuthCredentialRenewalOptions createReactorOAuthCredentialRenewalOptions() {
        return new ReactorOAuthCredentialRenewalOptions();
    }

    public static ReactorJsonConverterOptions createReactorJsonConverterOptions() {
        return new ReactorJsonConverterOptions();
    }

    static TunnelStreamAuthInfo createTunnelStreamAuthInfo() {
        return new TunnelStreamAuthInfo();
    }

    static ReactorChannel createReactorChannel() {
        ReactorChannel reactorChannel = (ReactorChannel)_reactorChannelPool.poll();
        if (reactorChannel == null) {
            reactorChannel = new ReactorChannel();
            reactorChannel.clear();
            _reactorChannelPool.updatePool(reactorChannel);
        } else {
            reactorChannel.clear();
        }
        return reactorChannel;
    }

    static RDMLoginMsgEvent createRDMLoginMsgEvent() {
        RDMLoginMsgEvent rdmLoginMsgEvent = (RDMLoginMsgEvent)_rdmLoginMsgEventPool.poll();
        if (rdmLoginMsgEvent == null) {
            rdmLoginMsgEvent = new RDMLoginMsgEvent();
            _rdmLoginMsgEventPool.updatePool(rdmLoginMsgEvent);
        } else {
            rdmLoginMsgEvent.clear();
        }
        return rdmLoginMsgEvent;
    }

    static RDMDirectoryMsgEvent createRDMDirectoryMsgEvent() {
        RDMDirectoryMsgEvent rdmDirectoryMsgEvent = (RDMDirectoryMsgEvent)_rdmDirectoryMsgEventPool.poll();
        if (rdmDirectoryMsgEvent == null) {
            rdmDirectoryMsgEvent = new RDMDirectoryMsgEvent();
            _rdmDirectoryMsgEventPool.updatePool(rdmDirectoryMsgEvent);
        } else {
            rdmDirectoryMsgEvent.clear();
        }
        return rdmDirectoryMsgEvent;
    }

    static RDMDictionaryMsgEvent createRDMDictionaryMsgEvent() {
        RDMDictionaryMsgEvent rdmDictionaryMsgEvent = (RDMDictionaryMsgEvent)_rdmDictionaryMsgEventPool.poll();
        if (rdmDictionaryMsgEvent == null) {
            rdmDictionaryMsgEvent = new RDMDictionaryMsgEvent();
            _rdmDictionaryMsgEventPool.updatePool(rdmDictionaryMsgEvent);
        } else {
            rdmDictionaryMsgEvent.clear();
        }
        return rdmDictionaryMsgEvent;
    }

    static ReactorMsgEvent createReactorMsgEvent() {
        ReactorMsgEvent reactorMsgEvent = (ReactorMsgEvent)_reactorMsgEventPool.poll();
        if (reactorMsgEvent == null) {
            reactorMsgEvent = new ReactorMsgEvent();
            _reactorMsgEventPool.updatePool(reactorMsgEvent);
        } else {
            reactorMsgEvent.clear();
        }
        return reactorMsgEvent;
    }

    static ReactorChannelEvent createReactorChannelEvent() {
        ReactorChannelEvent reactorChannelEvent = (ReactorChannelEvent)_reactorChannelEventPool.poll();
        if (reactorChannelEvent == null) {
            reactorChannelEvent = new ReactorChannelEvent();
            _reactorChannelEventPool.updatePool(reactorChannelEvent);
        } else {
            reactorChannelEvent.clear();
        }
        return reactorChannelEvent;
    }

    static ReactorAuthTokenEvent createReactorAuthTokenEvent() {
        ReactorAuthTokenEvent reactorAuthTokenEvent = (ReactorAuthTokenEvent)_reactorAuthTokenEventPool.poll();
        if (reactorAuthTokenEvent == null) {
            reactorAuthTokenEvent = new ReactorAuthTokenEvent();
            _reactorAuthTokenEventPool.updatePool(reactorAuthTokenEvent);
        } else {
            reactorAuthTokenEvent.clear();
        }
        return reactorAuthTokenEvent;
    }

    static ReactorServiceEndpointEvent createReactorServiceEndpointEvent() {
        ReactorServiceEndpointEvent reactorServiceEndpointEvent = (ReactorServiceEndpointEvent)_reactorServiceEndpointEventPool.poll();
        if (reactorServiceEndpointEvent == null) {
            reactorServiceEndpointEvent = new ReactorServiceEndpointEvent();
            _reactorServiceEndpointEventPool.updatePool(reactorServiceEndpointEvent);
        } else {
            reactorServiceEndpointEvent.clear();
        }
        return reactorServiceEndpointEvent;
    }

    static ReactorOAuthCredentialEvent createReactorOAuthCredentialEvent() {
        ReactorOAuthCredentialEvent reactorOAuthCredentialEvent = (ReactorOAuthCredentialEvent)_reactorOAuthCredentialEventPool.poll();
        if (reactorOAuthCredentialEvent == null) {
            reactorOAuthCredentialEvent = new ReactorOAuthCredentialEvent();
            _reactorOAuthCredentialEventPool.updatePool(reactorOAuthCredentialEvent);
        } else {
            reactorOAuthCredentialEvent.clear();
        }
        return reactorOAuthCredentialEvent;
    }

    public static TunnelStreamStatusEvent createTunnelStreamStatusEvent() {
        TunnelStreamStatusEvent tunnelStreamStatusEvent = (TunnelStreamStatusEvent)_tunnelStreamStatusEventPool.poll();
        if (tunnelStreamStatusEvent == null) {
            tunnelStreamStatusEvent = new TunnelStreamStatusEvent();
            _tunnelStreamStatusEventPool.updatePool(tunnelStreamStatusEvent);
        } else {
            tunnelStreamStatusEvent.clear();
        }
        return tunnelStreamStatusEvent;
    }

    static TunnelStreamMsgEvent createTunnelStreamMsgEvent() {
        TunnelStreamMsgEvent tunnelStreamMsgEvent = (TunnelStreamMsgEvent)_tunnelStreamMsgEventPool.poll();
        if (tunnelStreamMsgEvent == null) {
            tunnelStreamMsgEvent = new TunnelStreamMsgEvent();
            _tunnelStreamMsgEventPool.updatePool(tunnelStreamMsgEvent);
        } else {
            tunnelStreamMsgEvent.clear();
        }
        return tunnelStreamMsgEvent;
    }

    static TunnelStreamQueueMsgEvent createQueueMsgEvent() {
        TunnelStreamQueueMsgEvent queueMsgEvent = (TunnelStreamQueueMsgEvent)_queueMsgEventPool.poll();
        if (queueMsgEvent == null) {
            queueMsgEvent = new TunnelStreamQueueMsgEvent();
            _queueMsgEventPool.updatePool(queueMsgEvent);
        } else {
            queueMsgEvent.clear();
        }
        return queueMsgEvent;
    }

    static WorkerEvent createWorkerEvent() {
        WorkerEvent workerEvent = (WorkerEvent)_workerEventPool.poll();
        if (workerEvent == null) {
            workerEvent = new WorkerEvent();
            _workerEventPool.updatePool(workerEvent);
        } else {
            workerEvent.clear();
        }
        return workerEvent;
    }

    static Watchlist createWatchlist(ReactorChannel reactorChannel, ConsumerRole consumerRole) {
        Watchlist watchlist = (Watchlist)_watchlistPool.poll();
        if (watchlist == null) {
            watchlist = new Watchlist(reactorChannel, consumerRole);
            _watchlistPool.updatePool(watchlist);
        } else {
            watchlist.clear();
            watchlist.reactorChannel(reactorChannel);
            watchlist.role(consumerRole);
        }
        return watchlist;
    }

    static WlPostTimeoutInfo createWlPostTimeoutInfo() {
        WlPostTimeoutInfo postTimeoutInfo = (WlPostTimeoutInfo)_postTimeoutInfoPool.poll();
        if (postTimeoutInfo == null) {
            postTimeoutInfo = new WlPostTimeoutInfo();
            _postTimeoutInfoPool.updatePool(postTimeoutInfo);
        } else {
            postTimeoutInfo.clear();
        }
        return postTimeoutInfo;
    }

    static WlItemAggregationKey createWlItemAggregationKey() {
        WlItemAggregationKey itemAggregationKey = (WlItemAggregationKey)_itemAggregationKeyPool.poll();
        if (itemAggregationKey == null) {
            itemAggregationKey = new WlItemAggregationKey();
            _itemAggregationKeyPool.updatePool(itemAggregationKey);
        } else {
            itemAggregationKey.clear();
        }
        return itemAggregationKey;
    }

    static WlStream createWlStream() {
        WlStream wlStream = (WlStream)_wlStreamPool.poll();
        if (wlStream == null) {
            wlStream = new WlStream();
            _wlStreamPool.updatePool(wlStream);
        } else {
            wlStream.clear();
        }
        return wlStream;
    }

    static WlRequest createWlRequest() {
        WlRequest wlRequest = (WlRequest)_wlRequestPool.poll();
        if (wlRequest == null) {
            wlRequest = new WlRequest();
            _wlRequestPool.updatePool(wlRequest);
        } else {
            wlRequest.clear();
        }
        return wlRequest;
    }

    static WlService createWlService() {
        WlService wlService = (WlService)_wlServicePool.poll();
        if (wlService == null) {
            wlService = new WlService();
            _wlServicePool.updatePool(wlService);
        } else {
            wlService.clear();
        }
        return wlService;
    }

    static WlItemGroup createWlItemGroup() {
        WlItemGroup wlItemGroup = (WlItemGroup)_wlItemGroupPool.poll();
        if (wlItemGroup == null) {
            wlItemGroup = new WlItemGroup();
            _wlItemGroupPool.updatePool(wlItemGroup);
        } else {
            wlItemGroup.clear();
        }
        return wlItemGroup;
    }

    static WlInteger createWlInteger() {
        WlInteger wlInteger = (WlInteger)_wlIntegerPool.poll();
        if (wlInteger == null) {
            wlInteger = new WlInteger();
            _wlIntegerPool.updatePool(wlInteger);
        } else {
            wlInteger.clear();
        }
        return wlInteger;
    }

    static WlView createWlView() {
        WlView wlView = (WlView)_wlViewPool.poll();
        if (wlView == null) {
            wlView = new WlView();
            _wlViewPool.updatePool(wlView);
        } else {
            wlView.clear();
        }
        return wlView;
    }

    static ReactorWSBService createWsbService() {
        ReactorWSBService wsbService = (ReactorWSBService)_wsbServicePool.poll();
        if (wsbService == null) {
            wsbService = new ReactorWSBService();
            _wsbServicePool.updatePool(wsbService);
        } else {
            wsbService.clear();
        }
        return wsbService;
    }

    static ReactorPackedBuffer createPackedBuffer() {
        ReactorPackedBuffer packedBuffer = (ReactorPackedBuffer)_packedBufferPool.poll();
        if (packedBuffer == null) {
            packedBuffer = new ReactorPackedBuffer();
            _packedBufferPool.updatePool(packedBuffer);
        } else {
            packedBuffer.clear();
        }
        return packedBuffer;
    }

    static ReactorDebugger createReactorDebugger(OutputStream stream) {
        return new ReactorDebuggerImpl(stream);
    }

    static ReactorDebugger createReactorDebugger(OutputStream stream, int capacity) {
        return new ReactorDebuggerImpl(stream, capacity);
    }

    static ReactorDebugger createReactorDebugger(int capacity) {
        return new ReactorDebuggerImpl(capacity);
    }

    public static ReactorWarmStandbyGroup createReactorWarmStandbyGroup() {
        return new ReactorWarmStandbyGroupImpl();
    }

    public static ReactorRestProxyOptions createReactorRestProxyOptions() {
        return new ReactorRestProxyOptions();
    }
}

