/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.cache;

import com.refinitiv.eta.valueadd.cache.PayloadCursor;
import com.refinitiv.eta.valueadd.common.VaIteratableQueue;
import com.refinitiv.eta.valueadd.common.VaNode;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class PayloadCursorImpl
extends VaNode
implements PayloadCursor {
    private boolean _isCursorDestroyed = true;
    boolean _isComplete = false;
    long _etaCursorRef = this.etaCreateCursor();
    private static VaIteratableQueue _activeCacheCursorPool = new VaIteratableQueue();
    private static VaIteratableQueue _freeCacheCursorPool = new VaIteratableQueue();
    private static Lock _globalCursorLock = new ReentrantLock();

    public PayloadCursorImpl() {
        if (this._etaCursorRef == 0L) {
            throw new UnsupportedOperationException("PayloadCursorImpl constructor: cannot create eta cursor, PayloadCursor not created.");
        }
        this._isCursorDestroyed = false;
    }

    public static PayloadCursor create() {
        _globalCursorLock.lock();
        PayloadCursorImpl cursor = (PayloadCursorImpl)_freeCacheCursorPool.poll();
        if (cursor == null) {
            cursor = new PayloadCursorImpl();
        } else {
            cursor._isCursorDestroyed = false;
            cursor.clear();
        }
        _activeCacheCursorPool.add((VaNode)cursor);
        _globalCursorLock.unlock();
        return cursor;
    }

    @Override
    public void destroy() {
        if (this._isCursorDestroyed) {
            return;
        }
        this._isCursorDestroyed = true;
        _globalCursorLock.lock();
        _activeCacheCursorPool.remove((VaNode)this);
        _freeCacheCursorPool.add((VaNode)this);
        _globalCursorLock.unlock();
    }

    @Override
    public void clear() {
        if (this._isCursorDestroyed) {
            return;
        }
        this._isComplete = false;
        this.etaClearCursor(this._etaCursorRef);
    }

    @Override
    public boolean isComplete() {
        if (this._isCursorDestroyed) {
            return false;
        }
        return this._isComplete;
    }

    public boolean isDestroyed() {
        return this._isCursorDestroyed;
    }

    public long getETACursorRef() {
        return this._etaCursorRef;
    }

    public void setComplete(boolean isComplete) {
        this._isComplete = isComplete;
    }

    public static void destroyAll() {
        PayloadCursorImpl cursor = null;
        _globalCursorLock.lock();
        while ((cursor = (PayloadCursorImpl)_freeCacheCursorPool.poll()) != null) {
            cursor.etaDestroyCursor(cursor._etaCursorRef);
        }
        while ((cursor = (PayloadCursorImpl)_activeCacheCursorPool.poll()) != null) {
            cursor.etaDestroyCursor(cursor._etaCursorRef);
        }
        _globalCursorLock.unlock();
    }

    public native long etaCreateCursor();

    public native void etaDestroyCursor(long var1);

    public native void etaClearCursor(long var1);
}

