/*
 * Decompiled with CFR 0.152.
 */
package com.redmadrobot.inputmask.helper;

import com.redmadrobot.inputmask.helper.AffinityCalculationStrategy$WhenMappings;
import com.redmadrobot.inputmask.helper.Mask;
import com.redmadrobot.inputmask.model.CaretString;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u000b\u001a\u00020\f*\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002j\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006\u0012"}, d2={"Lcom/redmadrobot/inputmask/helper/AffinityCalculationStrategy;", "", "(Ljava/lang/String;I)V", "calculateAffinityOfMask", "", "mask", "Lcom/redmadrobot/inputmask/helper/Mask;", "text", "Lcom/redmadrobot/inputmask/model/CaretString;", "autocomplete", "", "prefixIntersection", "", "another", "WHOLE_STRING", "PREFIX", "CAPACITY", "EXTRACTED_VALUE_CAPACITY", "input-mask-android_release"})
public final class AffinityCalculationStrategy
extends Enum<AffinityCalculationStrategy> {
    public static final /* enum */ AffinityCalculationStrategy WHOLE_STRING;
    public static final /* enum */ AffinityCalculationStrategy PREFIX;
    public static final /* enum */ AffinityCalculationStrategy CAPACITY;
    public static final /* enum */ AffinityCalculationStrategy EXTRACTED_VALUE_CAPACITY;
    private static final /* synthetic */ AffinityCalculationStrategy[] $VALUES;

    static {
        AffinityCalculationStrategy[] affinityCalculationStrategyArray = new AffinityCalculationStrategy[4];
        AffinityCalculationStrategy[] affinityCalculationStrategyArray2 = affinityCalculationStrategyArray;
        affinityCalculationStrategyArray[0] = WHOLE_STRING = new AffinityCalculationStrategy();
        affinityCalculationStrategyArray[1] = PREFIX = new AffinityCalculationStrategy();
        affinityCalculationStrategyArray[2] = CAPACITY = new AffinityCalculationStrategy();
        affinityCalculationStrategyArray[3] = EXTRACTED_VALUE_CAPACITY = new AffinityCalculationStrategy();
        $VALUES = affinityCalculationStrategyArray;
    }

    public final int calculateAffinityOfMask(@NotNull Mask mask, @NotNull CaretString text, boolean autocomplete) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)mask, (String)"mask");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        switch (AffinityCalculationStrategy$WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                n = mask.apply(text, autocomplete).getAffinity();
                break;
            }
            case 2: {
                n = this.prefixIntersection(mask.apply(text, autocomplete).getFormattedText().getString(), text.getString()).length();
                break;
            }
            case 3: {
                if (text.getString().length() > mask.totalTextLength()) {
                    n = Integer.MIN_VALUE;
                    break;
                }
                n = text.getString().length() - mask.totalTextLength();
                break;
            }
            case 4: {
                int extractedValueLength = mask.apply(text, autocomplete).getExtractedValue().length();
                if (extractedValueLength > mask.totalValueLength()) {
                    n = Integer.MIN_VALUE;
                    break;
                }
                n = extractedValueLength - mask.totalValueLength();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    private final String prefixIntersection(@NotNull String $receiver, String another) {
        int endIndex;
        CharSequence charSequence = $receiver;
        if (charSequence.length() == 0 || (charSequence = (CharSequence)another).length() == 0) {
            return "";
        }
        for (endIndex = 0; endIndex < $receiver.length() && endIndex < another.length(); ++endIndex) {
            if ($receiver.charAt(endIndex) == another.charAt(endIndex)) {
                continue;
            }
            String string = $receiver;
            int n = 0;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, endIndex);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            return string3;
        }
        String string = $receiver;
        int n = 0;
        String string4 = string;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(n, endIndex);
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string5;
    }

    public static AffinityCalculationStrategy[] values() {
        return (AffinityCalculationStrategy[])$VALUES.clone();
    }

    public static AffinityCalculationStrategy valueOf(String string) {
        return Enum.valueOf(AffinityCalculationStrategy.class, string);
    }
}

