/*
 * Decompiled with CFR 0.152.
 */
package io.redisearch.aggregation.reducers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class Reducer {
    private String alias;
    private final String field;

    protected Reducer(String field) {
        this.field = field;
        this.alias = null;
    }

    protected Reducer() {
        this(null);
    }

    protected List<String> getOwnArgs() {
        if (this.field == null) {
            return Collections.emptyList();
        }
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(this.field);
        return ret;
    }

    public abstract String getName();

    public final String getAlias() {
        return this.alias;
    }

    public final Reducer setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public final Reducer as(String alias) {
        return this.setAlias(alias);
    }

    public final Reducer setAliasAsField() {
        if (this.field == null || this.field.isEmpty()) {
            throw new IllegalArgumentException("Cannot set to field name since no field exists");
        }
        return this.setAlias(this.field);
    }

    public void addArgs(List<String> args) {
        List<String> ownArgs = this.getOwnArgs();
        args.add(Integer.toString(ownArgs.size()));
        args.addAll(ownArgs);
    }

    public final List<String> getArgs() {
        ArrayList<String> args = new ArrayList<String>();
        this.addArgs(args);
        return args;
    }
}

