/*
 * Decompiled with CFR 0.152.
 */
package tcms.API;

import com.redhat.qe.xmlrpc.BaseObject;
import com.redhat.qe.xmlrpc.Session;
import java.util.HashMap;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import tcms.API.TestopiaException;

public class TestPlan
extends BaseObject {
    protected static final String LIST_METHOD = "TestPlan.filter";
    private static final String PLAN_ID = "plan";
    private BaseObject.IntegerAttribute productId = this.newIntegerAttribute("product", null);
    private BaseObject.IntegerAttribute type = this.newIntegerAttribute("type", null);
    private BaseObject.BooleanAttribute isactive = this.newBooleanAttribute("isactive", null);
    private BaseObject.StringAttribute name = this.newStringAttribute("name", null);
    private BaseObject.StringAttribute defaultProductVersion = this.newStringAttribute("default_product_version", null);
    private BaseObject.StringAttribute version = this.newStringAttribute("version", null);

    public TestPlan(Session session, Integer planID) {
        this.session = session;
        this.id = this.newIntegerAttribute(PLAN_ID, planID);
        this.listMethod = LIST_METHOD;
    }

    public TestPlan(Session session, String plan) throws XmlRpcException {
        this.session = session;
        this.listMethod = LIST_METHOD;
        this.id = this.newIntegerAttribute(PLAN_ID, null);
        this.getPlanIDByName(plan);
    }

    public TestPlan(Session session, Integer product, String plan, String version) throws XmlRpcException {
        this.session = session;
        this.listMethod = LIST_METHOD;
        this.id = this.newIntegerAttribute(PLAN_ID, null);
        this.productId.set(product);
        this.defaultProductVersion.set(version);
        this.name.set(plan);
        this.getPlanIdByCurrentAttributes();
    }

    public int getPlanIdByCurrentAttributes() throws XmlRpcException {
        Object[] results = this.getList(this.getAttributesMap());
        if (results.length > 1) {
            throw new RuntimeException("Multiple matches on testplan name='" + this.name + "'.  Please use a more specific query.");
        }
        if (results.length == 0) {
            throw new RuntimeException("No matches on testplan with attributes " + this.getAttributesMap());
        }
        this.syncAttributes((Map)results[0]);
        return this.getId();
    }

    public int getPlanIDByName(String name) throws XmlRpcException {
        Object[] results = this.getList("name", name);
        if (results.length > 1) {
            throw new RuntimeException("Multiple matches on testplan name='" + name + "'.  Please use a more specific query.");
        }
        this.syncAttributes((Map)results[0]);
        return this.getId();
    }

    public void setDefaultProductVersion(String defaultProductVersion) {
        this.defaultProductVersion.set(defaultProductVersion);
    }

    public String getDefaultProductVersion() {
        return this.defaultProductVersion.get();
    }

    public void setIsActive(boolean isActive) {
        this.isactive.set(Boolean.valueOf(isActive));
    }

    public void setName(String name) {
        this.name.set(name);
    }

    public void setProductID(int productID) {
        this.productId.set(Integer.valueOf(productID));
    }

    public void setTypeID(int typeID) {
        this.type.set(Integer.valueOf(typeID));
    }

    public HashMap<String, Object> getCategories() throws TestopiaException, XmlRpcException {
        if (this.id.get() == null) {
            throw new TestopiaException("planID is null.");
        }
        return (HashMap)this.callXmlrpcMethod("TestPlan.get", new Object[]{this.id.get()});
    }

    public Object[] getBuilds() throws TestopiaException, XmlRpcException {
        if (this.id.get() == null) {
            throw new TestopiaException("planID is null.");
        }
        return (Object[])this.callXmlrpcMethod("TestPlan.get_builds", new Object[]{this.id.get()});
    }

    public Object[] getComponents() throws TestopiaException, XmlRpcException {
        if (this.id.get() == null) {
            throw new TestopiaException("planID is null.");
        }
        return (Object[])this.callXmlrpcMethod("TestPlan.get_components", new Object[]{this.id.get()});
    }

    public Object[] getTestCases() throws TestopiaException, XmlRpcException {
        if (this.id.get() == null) {
            throw new TestopiaException("planID is null.");
        }
        return (Object[])this.callXmlrpcMethod("TestPlan.get_test_cases", new Object[]{this.id.get()});
    }

    public Object[] getTestRuns() throws TestopiaException, XmlRpcException {
        if (this.id.get() == null) {
            throw new TestopiaException("planID is null.");
        }
        return (Object[])this.callXmlrpcMethod("TestPlan.get_test_runs", new Object[]{this.id.get()});
    }
}

