/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.qe.tools.compare;

import java.util.Comparator;

public class RangeComparator<T>
implements Comparator<T> {
    protected double maxDifference = 0.0;

    public RangeComparator(double maxDifference) {
        this.maxDifference = maxDifference;
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (!(o1 instanceof Number) || !(o2 instanceof Number)) {
            throw new IllegalArgumentException("Can't compare non-Number objects " + o1.toString() + " and " + o2.toString());
        }
        if (o1 == null && o2 == null) {
            return 0;
        }
        Double n1 = o1 instanceof Integer ? Double.valueOf(((Integer)o1).doubleValue()) : (Double)o1;
        Double n2 = o1 instanceof Integer ? Double.valueOf(((Integer)o2).doubleValue()) : (Double)o2;
        if (Math.abs(n1 - n2) <= this.maxDifference) {
            return 0;
        }
        if (n1 > n2) {
            return 1;
        }
        return -1;
    }

    public String toString() {
        return " within " + this.maxDifference + " of ";
    }
}

