/*
 * Decompiled with CFR 0.152.
 */
package redgatesqlci;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.tasks.Builder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import redgatesqlci.SqlChangeAutomationVersionOption;

abstract class SqlContinuousIntegrationBuilder
extends Builder {
    SqlContinuousIntegrationBuilder() {
    }

    void addProductVersionParameter(Collection<String> params, SqlChangeAutomationVersionOption sqlChangeAutomationVersionOption) {
        params.add("-RequiredProductVersion");
        String productVersion = Optional.ofNullable(sqlChangeAutomationVersionOption).map(x -> x.getOption() == SqlChangeAutomationVersionOption.ProductVersionOption.Specific).orElse(false) != false ? sqlChangeAutomationVersionOption.getSpecificVersion() : SqlChangeAutomationVersionOption.ProductVersionOption.Latest.name();
        params.add(productVersion);
    }

    boolean runSqlContinuousIntegrationCmdlet(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener, Iterable<String> params) {
        try {
            FilePath scaRunnerLocation = this.CopyResourceToWorkspace(build, "PowerShell/SqlChangeAutomationRunner.ps1");
            this.CopyResourceToWorkspace(build, "PowerShell/PowershellGallery.ps1");
            this.CopyResourceToWorkspace(build, "PowerShell/SqlCi.ps1");
            Launcher.ProcStarter procStarter = this.defineProcess(build, launcher, listener, params, scaRunnerLocation);
            return this.executeProcess(launcher, listener, procStarter);
        }
        catch (IOException e) {
            listener.error("Unexpected I/O exception executing cmdlet: " + e.getMessage());
            return false;
        }
        catch (InterruptedException e) {
            listener.error("Unexpected thread interruption executing cmdlet");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FilePath CopyResourceToWorkspace(AbstractBuild<?, ?> build, String relativeFilePath) throws IOException, InterruptedException {
        FilePath filePath = new FilePath(build.getWorkspace(), relativeFilePath);
        InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream('/' + relativeFilePath);
        try {
            filePath.copyFrom(stream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
        return filePath;
    }

    private Launcher.ProcStarter defineProcess(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener, Iterable<String> params, FilePath scaRunnerLocation) {
        String longString = this.generateCmdString(params, scaRunnerLocation.getRemote());
        Map<String, String> vars = this.getEnvironmentVariables(build, listener);
        Launcher.ProcStarter procStarter = new Launcher.ProcStarter(launcher);
        procStarter.envs(vars);
        procStarter.cmdAsSingleString(longString).stdout((OutputStream)listener.getLogger()).stderr((OutputStream)listener.getLogger()).pwd(build.getWorkspace());
        return procStarter;
    }

    private String generateCmdString(Iterable<String> params, String sqlCiLocation) {
        StringBuilder longStringBuilder = new StringBuilder();
        longStringBuilder.append("\"").append(SqlContinuousIntegrationBuilder.getPowerShellExeLocation()).append("\" -NonInteractive -ExecutionPolicy Bypass -File \"").append(sqlCiLocation).append("\"").append(" -Verbose");
        for (String param : params) {
            String fixedParam = param.trim();
            if (fixedParam.contains("\"")) {
                fixedParam = fixedParam.replace("\"", "\\\\\\\"");
            }
            if (fixedParam.contains(" ")) {
                fixedParam = "\"" + fixedParam + "\"";
            }
            longStringBuilder.append(" ").append(fixedParam);
        }
        return longStringBuilder.toString();
    }

    private Map<String, String> getEnvironmentVariables(AbstractBuild<?, ?> build, TaskListener listener) {
        HashMap<String, String> vars = new HashMap<String, String>(build.getBuildVariables());
        try {
            EnvVars envVars = build.getEnvironment(listener);
            vars.putAll((Map<String, String>)envVars);
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
        vars.put("REDGATE_FUR_ENVIRONMENT", "Jenkins Plugin");
        return vars;
    }

    private boolean executeProcess(Launcher launcher, TaskListener listener, Launcher.ProcStarter procStarter) throws IOException, InterruptedException {
        Proc proc = launcher.launch(procStarter);
        int exitCode = proc.join();
        return exitCode == 0;
    }

    static String constructPackageFileName(String packageName, String buildNumber) {
        return packageName + "." + buildNumber + ".nupkg";
    }

    private static String getPowerShellExeLocation() {
        String psHome = System.getenv("PS_HOME");
        if (psHome != null) {
            return psHome;
        }
        return "C:\\Windows\\System32\\WindowsPowerShell\\v1.0\\powershell.exe";
    }
}

