/*
 * Decompiled with CFR 0.152.
 */
package redgatesqlci;

import hudson.EnvVars;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jenkins.security.MasterToSlaveCallable;

public class Utils {
    public static boolean runSQLCIWithParams(AbstractBuild build, Launcher launcher, BuildListener listener, ArrayList<String> params) {
        String[] possibleSqlCiLocations;
        VirtualChannel channel = launcher.getChannel();
        String sqlCiLocation = "";
        String allLocations = "";
        for (String possibleLocation : possibleSqlCiLocations = new String[]{Utils.getEnvironmentVariable("DLMAS_HOME", channel) + "\\sqlci.ps1", Utils.getEnvironmentVariable("ProgramFiles", channel) + "\\Red Gate\\DLM Automation 2\\sqlci.ps1", Utils.getEnvironmentVariable("ProgramFiles(X86)", channel) + "\\Red Gate\\DLM Automation 2\\sqlci.ps1"}) {
            if (Utils.ciExists(possibleLocation, channel)) {
                sqlCiLocation = possibleLocation;
                break;
            }
            allLocations = allLocations.concat(possibleLocation + "  ");
        }
        if (sqlCiLocation.isEmpty()) {
            listener.error("SQLCI.ps1 cannot be found. Checked " + allLocations + ". Please install Redgate DLM Automation 2 on this agent.");
            return false;
        }
        ArrayList<String> procParams = new ArrayList<String>();
        procParams.add(0, "\"" + Utils.getPowerShellExeLocation() + "\"");
        procParams.add(1, "-NonInteractive");
        procParams.add(2, "-ExecutionPolicy");
        procParams.add(3, "Bypass");
        procParams.add(4, "-File");
        procParams.add(5, "\"" + sqlCiLocation + "\"");
        procParams.add(6, "-Verbose");
        StringBuffer longStringBuffer = new StringBuffer();
        longStringBuffer.append("\"" + Utils.getPowerShellExeLocation() + "\" -NonInteractive -ExecutionPolicy Bypass -File \"" + sqlCiLocation + "\"" + " -Verbose");
        for (String param : params) {
            String fixedParam = param.trim();
            if (fixedParam.contains("\"")) {
                fixedParam = fixedParam.replace("\"", "\\\\\\\"");
            }
            if (fixedParam.contains(" ")) {
                fixedParam = "\"" + fixedParam + "\"";
            }
            procParams.add(param);
            longStringBuffer.append(" " + fixedParam);
        }
        String longString = longStringBuffer.toString();
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.putAll(build.getBuildVariables());
        Proc proc = null;
        Launcher.ProcStarter procStarter = new Launcher.ProcStarter(launcher);
        try {
            EnvVars envVars = build.getEnvironment((TaskListener)listener);
            vars.putAll((Map<String, String>)envVars);
        }
        catch (IOException e) {
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        vars.put("REDGATE_FUR_ENVIRONMENT", "Jenkins Plugin");
        procStarter.envs(vars);
        procStarter.cmdAsSingleString(longString).stdout((OutputStream)listener.getLogger()).stderr((OutputStream)listener.getLogger()).pwd(build.getWorkspace());
        try {
            proc = launcher.launch(procStarter);
            int exitCode = proc.join();
            return exitCode == 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            listener.getLogger().println("IOException");
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            listener.getLogger().println("InterruptedException");
            return false;
        }
    }

    public static String constructPackageFileName(String packageName, String buildNumber) {
        return packageName + "." + buildNumber + ".nupkg";
    }

    private static String getEnvironmentVariable(final String variableName, VirtualChannel channel) {
        try {
            return (String)channel.call((Callable)new MasterToSlaveCallable<String, RuntimeException>(){

                public String call() {
                    return System.getenv(variableName);
                }
            });
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean ciExists(final String possibleLocation, VirtualChannel channel) {
        try {
            return (Boolean)channel.call((Callable)new MasterToSlaveCallable<Boolean, RuntimeException>(){

                public Boolean call() {
                    return new File(possibleLocation).isFile();
                }
            });
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String getPowerShellExeLocation() {
        String psHome = System.getenv("PS_HOME");
        if (psHome == null) {
            psHome = "C:\\Windows\\System32\\WindowsPowerShell\\v1.0\\powershell.exe";
        }
        return psHome;
    }

    public static String getEscapedOptions(String options) {
        if (options.trim().startsWith("-")) {
            StringBuilder sb = new StringBuilder(options);
            return sb.insert(0, ',').toString();
        }
        return options;
    }
}

