/*
 * Decompiled with CFR 0.152.
 */
package redgatesqlci;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import redgatesqlci.GenerateTestData;
import redgatesqlci.RunTestSet;
import redgatesqlci.Server;
import redgatesqlci.Utils;

public class TestBuilder
extends Builder {
    private final String packageid;
    private final String tempServer;
    private final String serverName;
    private final String dbName;
    private final String serverAuth;
    private final String username;
    private final String password;
    private final String options;
    private final String filter;
    private final String runOnlyParams;
    private final String runTestSet;
    private final String generateTestData;
    private final String sqlgenPath;
    private final String packageVersion;

    public String getPackageid() {
        return this.packageid;
    }

    public String getTempServer() {
        return this.tempServer;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getServerAuth() {
        return this.serverAuth;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getOptions() {
        return this.options;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getRunOnlyParams() {
        return this.runOnlyParams;
    }

    public String getRunTestSet() {
        return this.runTestSet;
    }

    public String getGenerateTestData() {
        return this.generateTestData;
    }

    public String getSqlgenPath() {
        return this.sqlgenPath;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    @DataBoundConstructor
    public TestBuilder(String packageid, Server tempServer, RunTestSet runTestSet, GenerateTestData generateTestData, String options, String filter, String packageVersion) {
        this.packageid = packageid;
        this.tempServer = tempServer.getvalue();
        this.runTestSet = runTestSet.getvalue();
        String string = this.generateTestData = generateTestData == null ? null : "true";
        if (this.tempServer.equals("sqlServer")) {
            this.dbName = tempServer.getDbName();
            this.serverName = tempServer.getServerName();
            this.serverAuth = tempServer.getServerAuth().getvalue();
            this.username = tempServer.getServerAuth().getUsername();
            this.password = tempServer.getServerAuth().getPassword();
        } else {
            this.dbName = "";
            this.serverName = "";
            this.serverAuth = "";
            this.username = "";
            this.password = "";
        }
        this.runOnlyParams = this.runTestSet.equals("runOnlyTest") ? runTestSet.getRunOnlyParams() : "";
        this.sqlgenPath = this.generateTestData != null ? generateTestData.getSqlgenPath() : "";
        this.options = options;
        this.filter = filter;
        this.packageVersion = packageVersion;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        ArrayList<String> params = new ArrayList<String>();
        String buildNumber = "1.0." + Integer.toString(build.getNumber());
        if (this.getPackageVersion() != null && !this.getPackageVersion().isEmpty()) {
            buildNumber = this.getPackageVersion();
        }
        String packageFileName = Utils.constructPackageFileName(this.getPackageid(), buildNumber);
        params.add("Test");
        params.add("-package");
        params.add(packageFileName);
        if (this.getTempServer().equals("sqlServer")) {
            params.add("-temporaryDatabaseServer");
            params.add(this.getServerName());
            if (!this.getDbName().isEmpty()) {
                params.add("-temporaryDatabaseName");
                params.add(this.getDbName());
            }
            if (this.getServerAuth().equals("sqlServerAuth")) {
                params.add("-temporaryDatabaseUserName");
                params.add(this.getUsername());
                params.add("-temporaryDatabasePassword");
                params.add(this.getPassword());
            }
        }
        if (this.getRunTestSet().equals("runOnlyTest")) {
            params.add("-runOnly");
            params.add(this.getRunOnlyParams());
        }
        if (this.getGenerateTestData() != null) {
            params.add("-sqlDataGenerator");
            params.add(this.getSqlgenPath());
        }
        if (!this.getOptions().isEmpty()) {
            params.add("-Options");
            params.add(this.getOptions());
        }
        if (!this.getFilter().isEmpty()) {
            params.add("-filter");
            params.add(this.getFilter());
        }
        return Utils.runSQLCIWithParams(build, launcher, listener, params);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckPackageid(@QueryParameter String packageid) throws IOException, ServletException {
            if (packageid.length() == 0) {
                return FormValidation.error((String)"Enter a package ID");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Redgate DLM Automation: Test a database package";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }
}

