/*
 * Decompiled with CFR 0.152.
 */
package redgatesqlci;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import redgatesqlci.ServerAuth;
import redgatesqlci.Utils;

public class SyncBuilder
extends Builder {
    private final String packageid;
    private final String serverName;
    private final String dbName;
    private final String serverAuth;
    private final String username;
    private final String password;
    private final String options;
    private final String filter;
    private final String packageVersion;
    private final String isolationLevel;
    private final boolean updateScript;

    public String getPackageid() {
        return this.packageid;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getServerAuth() {
        return this.serverAuth;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getOptions() {
        return this.options;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public String getIsolationLevel() {
        return this.isolationLevel;
    }

    public boolean getUpdateScript() {
        return this.updateScript;
    }

    @DataBoundConstructor
    public SyncBuilder(String packageid, String serverName, String dbName, ServerAuth serverAuth, String options, String filter, String packageVersion, String isolationLevel, boolean updateScript) {
        this.packageid = packageid;
        this.serverName = serverName;
        this.dbName = dbName;
        this.serverAuth = serverAuth.getvalue();
        this.username = serverAuth.getUsername();
        this.password = serverAuth.getPassword();
        this.options = options;
        this.filter = filter;
        this.packageVersion = packageVersion;
        this.isolationLevel = isolationLevel;
        this.updateScript = updateScript;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        ArrayList<String> params = new ArrayList<String>();
        String buildNumber = "1.0." + Integer.toString(build.getNumber());
        if (this.getPackageVersion() != null && !this.getPackageVersion().isEmpty()) {
            buildNumber = this.getPackageVersion();
        }
        String packageFileName = Utils.constructPackageFileName(this.getPackageid(), buildNumber);
        params.add("Sync");
        params.add("-package");
        params.add(packageFileName);
        params.add("-databaseServer");
        params.add(this.getServerName());
        params.add("-databaseName");
        params.add(this.getDbName());
        if (this.getServerAuth().equals("sqlServerAuth")) {
            params.add("-databaseUserName");
            params.add(this.getUsername());
            params.add("-databasePassword");
            params.add(this.getPassword());
        }
        if (!this.getOptions().isEmpty()) {
            params.add("-Options");
            params.add(this.getOptions());
        }
        if (!this.getFilter().isEmpty()) {
            params.add("-filter");
            params.add(this.getFilter());
        }
        if (!this.getIsolationLevel().isEmpty()) {
            params.add("-transactionIsolationLevel");
            params.add(this.getIsolationLevel());
        }
        if (this.getUpdateScript()) {
            params.add("-scriptFile");
            params.add(this.getPackageid() + "." + buildNumber + ".sql");
        }
        return Utils.runSQLCIWithParams(build, launcher, listener, params);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckPackageid(@QueryParameter String packageid) throws IOException, ServletException {
            if (packageid.length() == 0) {
                return FormValidation.error((String)"Enter a package ID");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckDbName(@QueryParameter String dbName) throws IOException, ServletException {
            if (dbName.length() == 0) {
                return FormValidation.error((String)"Enter a database name");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckServerName(@QueryParameter String serverName) throws IOException, ServletException {
            if (serverName.length() == 0) {
                return FormValidation.error((String)"Enter a server name");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Redgate DLM Automation: Sync a database package";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }
}

