/*
 * Decompiled with CFR 0.152.
 */
package redgatesqlci;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import redgatesqlci.DbFolder;
import redgatesqlci.DlmDashboard;
import redgatesqlci.Server;
import redgatesqlci.Utils;

public class BuildBuilder
extends Builder {
    private String dbFolder;
    private String subfolder;
    private final String packageid;
    private final String tempServer;
    private final String serverName;
    private final String dbName;
    private final String serverAuth;
    private final String username;
    private final String password;
    private final String options;
    private final String filter;
    private final String packageVersion;
    private final boolean sendToDlmDashboard;
    private final String dlmDashboardHost;
    private final String dlmDashboardPort;

    public String getDbFolder() {
        return this.dbFolder;
    }

    public String getSubfolder() {
        return this.subfolder;
    }

    public String getPackageid() {
        return this.packageid;
    }

    public String getTempServer() {
        return this.tempServer;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getServerAuth() {
        return this.serverAuth;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getOptions() {
        return this.options;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    public boolean getSendToDlmDashboard() {
        return this.sendToDlmDashboard;
    }

    public String getDlmDashboardHost() {
        return this.dlmDashboardHost;
    }

    public String getDlmDashboardPort() {
        return this.dlmDashboardPort;
    }

    @DataBoundConstructor
    public BuildBuilder(DbFolder dbFolder, String packageid, Server tempServer, String options, String filter, String packageVersion, DlmDashboard dlmDashboard) {
        this.dbFolder = dbFolder.getvalue();
        this.subfolder = dbFolder.getsubfolder();
        this.packageid = packageid;
        this.tempServer = tempServer.getvalue();
        if (this.tempServer.equals("sqlServer")) {
            this.dbName = tempServer.getDbName();
            this.serverName = tempServer.getServerName();
            this.serverAuth = tempServer.getServerAuth().getvalue();
            this.username = tempServer.getServerAuth().getUsername();
            this.password = tempServer.getServerAuth().getPassword();
        } else {
            this.dbName = "";
            this.serverName = "";
            this.serverAuth = "";
            this.username = "";
            this.password = "";
        }
        this.options = options;
        this.filter = filter;
        this.packageVersion = packageVersion;
        boolean bl = this.sendToDlmDashboard = dlmDashboard != null;
        if (this.getSendToDlmDashboard()) {
            this.dlmDashboardHost = dlmDashboard.getDlmDashboardHost();
            this.dlmDashboardPort = dlmDashboard.getDlmDashboardPort();
        } else {
            this.dlmDashboardHost = null;
            this.dlmDashboardPort = null;
        }
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        ArrayList<String> params = new ArrayList<String>();
        FilePath checkOutPath = build.getWorkspace();
        if (checkOutPath == null) {
            return false;
        }
        params.add("Build");
        if (this.getDbFolder().equals("subfolder")) {
            params.add("-scriptsFolder");
            Path path = Paths.get(checkOutPath.getRemote(), this.getSubfolder());
            params.add(path.toString());
        } else {
            params.add("-scriptsFolder");
            params.add(checkOutPath.getRemote());
        }
        params.add("-packageId");
        params.add(this.getPackageid());
        if (this.getPackageVersion() == null || this.getPackageVersion().isEmpty()) {
            params.add("-packageVersion");
            params.add("1.0." + build.getNumber());
        } else {
            params.add("-packageVersion");
            params.add(this.getPackageVersion());
        }
        if (!this.options.isEmpty()) {
            params.add("-Options");
            params.add(Utils.getEscapedOptions(this.getOptions()));
        }
        if (!this.filter.isEmpty()) {
            params.add("-filter");
            params.add(this.getFilter());
        }
        if (this.getTempServer().equals("sqlServer")) {
            params.add("-temporaryDatabaseServer");
            params.add(this.getServerName());
            if (!this.getDbName().isEmpty()) {
                params.add("-temporaryDatabaseName");
                params.add(this.getDbName());
            }
            if (this.getServerAuth().equals("sqlServerAuth")) {
                params.add("-temporaryDatabaseUserName");
                params.add(this.getUsername());
                params.add("-temporaryDatabasePassword");
                params.add(this.getPassword());
            }
        }
        if (this.getSendToDlmDashboard()) {
            params.add("-dlmDashboardHost");
            params.add(this.getDlmDashboardHost());
            params.add("-dlmDashboardPort");
            params.add(this.getDlmDashboardPort());
        }
        return Utils.runSQLCIWithParams(build, launcher, listener, params);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckPackageid(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Enter a package ID.");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Redgate DLM Automation: Build a database package";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }
}

