/*
 * Decompiled with CFR 0.152.
 */
package redgatesqlci;

import hudson.EnvVars;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class Utils {
    public static boolean runSQLCIWithParams(AbstractBuild build, Launcher launcher, BuildListener listener, Collection<String> params) {
        String[] possibleSqlCiLocations;
        String sqlCiLocation = "";
        String allLocations = "";
        for (String possibleLocation : possibleSqlCiLocations = new String[]{System.getenv("DLMAS_HOME") + "sqlCI\\sqlci.exe", System.getenv("ProgramFiles") + "\\Red Gate\\DLM Automation Suite 1\\sqlCI\\sqlci.exe", System.getenv("ProgramFiles") + "\\Red Gate\\SQL Automation Pack 1\\sqlCI\\sqlci.exe", System.getenv("ProgramFiles") + "\\Red Gate\\sqlCI\\sqlci.exe", System.getenv("ProgramFiles(X86)") + "\\Red Gate\\DLM Automation Suite 1\\sqlCI\\sqlci.exe", System.getenv("ProgramFiles(X86)") + "\\Red Gate\\SQL Automation Pack 1\\sqlCI\\sqlci.exe", System.getenv("ProgramFiles(X86)") + "\\Red Gate\\sqlCI\\sqlci.exe"}) {
            if (new File(possibleLocation).isFile()) {
                sqlCiLocation = possibleLocation;
                break;
            }
            allLocations = allLocations.concat(possibleLocation + "  ");
        }
        if (sqlCiLocation == "") {
            listener.error("SQL CI executable cannot be found. Checked " + allLocations + ".Please install Redgate SQL CI on this agent.");
            return false;
        }
        ArrayList<String> procParams = new ArrayList<String>();
        procParams.add(sqlCiLocation);
        String longString = sqlCiLocation;
        for (String param : params) {
            String fixedParam = param.trim();
            if (fixedParam.contains("\"")) {
                fixedParam = fixedParam.replace("\"", "\\\\\\\"");
            }
            if (fixedParam.contains(" ")) {
                int equalsPlace = fixedParam.indexOf("=");
                fixedParam = fixedParam.substring(0, equalsPlace + 1) + "\\\"" + fixedParam.substring(equalsPlace + 1, fixedParam.length()) + "\\\"";
            }
            procParams.add(param);
            longString = longString + " " + fixedParam;
        }
        HashMap vars = new HashMap();
        vars.putAll(build.getBuildVariables());
        Proc proc = null;
        Launcher.ProcStarter procStarter = new Launcher.ProcStarter(launcher);
        EnvVars envVars = new EnvVars();
        try {
            envVars = build.getEnvironment((TaskListener)listener);
            vars.putAll(envVars);
        }
        catch (IOException e) {
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        procStarter.envs(vars);
        procStarter.cmdAsSingleString(longString).stdout((OutputStream)listener.getLogger()).stderr((OutputStream)listener.getLogger()).pwd(build.getWorkspace());
        try {
            proc = launcher.launch(procStarter);
            int exitCode = proc.join();
            return exitCode == 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            listener.getLogger().println("IOException");
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            listener.getLogger().println("InterruptedException");
            return false;
        }
    }

    public static String constructPackageFileName(String packageName, String buildNumber) {
        return packageName + "." + buildNumber + ".nupkg";
    }
}

