/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.app.ActivityManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsUtil;
import com.razorpay.CheckoutPresenter;
import com.razorpay.Logger;
import com.razorpay.PerformanceUtil;
import java.util.HashMap;
import org.json.JSONObject;

class SecondaryWebViewClient
extends WebViewClient {
    CheckoutPresenter presenter;

    public SecondaryWebViewClient(CheckoutPresenter checkoutPresenter) {
        this.presenter = checkoutPresenter;
    }

    public boolean shouldOverrideUrlLoading(WebView webView, String string) {
        return false;
    }

    public void onReceivedError(WebView webView, int n, String string, String string2) {
        this.presenter.destroyActivity(2, string);
    }

    public void onPageStarted(WebView webView, String string, Bitmap bitmap) {
        webView.setTag((Object)string);
        this.presenter.onPageStarted(2, webView, string);
    }

    public void onPageFinished(WebView webView, String string) {
        this.presenter.onPageFinished(2, webView, string);
    }

    public boolean onRenderProcessGone(WebView webView, RenderProcessGoneDetail renderProcessGoneDetail) {
        try {
            this.trackRendererCrash(webView, renderProcessGoneDetail, "secondary_webview");
        }
        catch (Exception exception) {
            Logger.e((String)("Error in onRenderProcessGone: " + exception.getMessage()));
        }
        return true;
    }

    private void trackRendererCrash(WebView webView, RenderProcessGoneDetail renderProcessGoneDetail, String string) {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            if (Build.VERSION.SDK_INT >= 26 && renderProcessGoneDetail != null) {
                hashMap.put("did_crash", renderProcessGoneDetail.didCrash());
                hashMap.put("renderer_priority_at_exit", renderProcessGoneDetail.rendererPriorityAtExit());
            } else {
                hashMap.put("did_crash", "unknown");
                hashMap.put("renderer_priority_at_exit", "unknown");
            }
            hashMap.put("manufacturer", Build.MANUFACTURER);
            hashMap.put("model", Build.MODEL);
            hashMap.put("os_version", Build.VERSION.RELEASE);
            if (webView != null && webView.getContext() != null) {
                int n = PerformanceUtil.getPerformanceClass((Context)webView.getContext());
                boolean bl = PerformanceUtil.isLowEndDevice((Context)webView.getContext());
                hashMap.put("performance_class", n);
                hashMap.put("is_low_end_device", bl);
                webView = (ActivityManager)webView.getContext().getSystemService("activity");
                if (webView != null) {
                    ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
                    webView.getMemoryInfo(memoryInfo);
                    long l = memoryInfo.totalMem / 0x100000L;
                    hashMap.put("total_ram_mb", l);
                }
            }
            hashMap.put("cpu_cores", Runtime.getRuntime().availableProcessors());
            hashMap.put("webview_type", string);
            AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.WEBVIEW_RENDERER_CRASHED, (JSONObject)AnalyticsUtil.getJSONResponse(hashMap));
            Logger.d((String)"Renderer crash analytics tracked");
            return;
        }
        catch (Exception exception) {
            Logger.e((String)("Error tracking renderer crash: " + exception.getMessage()));
            return;
        }
    }
}

