/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.app.Activity;
import android.content.Context;
import android.webkit.WebView;
import com.razorpay.ConfigCheckout;
import com.razorpay.Logger;
import com.razorpay.MagicData;
import com.razorpay.SmsAgent;
import com.razorpay.SmsAgentInterface;
import org.json.JSONObject;

class MagicBase
implements SmsAgentInterface {
    Context context = this.context;
    WebView webView;
    String lastSms;
    SmsAgent smsAgent;
    boolean hasOtpPermission = false;
    boolean isMagicEnabled = false;
    MagicData magicData;
    String merchantKey;
    boolean jsInsertedInCurrentPage = false;

    MagicBase(Activity activity, WebView webView) {
        this.webView = webView;
        this.smsAgent = SmsAgent.getSmsAgentInstance();
        this.smsAgent.registerForCallbacks((SmsAgentInterface)this);
        this.magicData = new MagicData(activity);
        this.magicData.checkForUpdates();
    }

    public void onPageFinished(WebView webView, String string) {
        if (!this.jsInsertedInCurrentPage) {
            try {
                webView = ConfigCheckout.getInstance().getMagicSettings();
                webView.put("merchant_key", (Object)this.merchantKey);
                webView.put("otp_permission", this.hasOtpPermission);
                string = new JSONObject();
                string.put("type", (Object)ConfigCheckout.SDK_TYPE);
                string.put("version_code", ConfigCheckout.SDK_VERSION_CODE);
                webView.put("sdk", (Object)string);
                this.injectJs("window.__rzp_options = " + webView.toString());
            }
            catch (Exception exception) {
                Logger.e((String)"Unable to load magic settings", (Throwable)exception);
            }
            MagicBase magicBase = this;
            magicBase.injectJs(magicBase.magicData.getMagicJs());
            if (this.lastSms != null) {
                this.injectJs(String.format("Magic.elfBridge.setSms(%s)", this.lastSms));
                this.lastSms = null;
            }
            this.jsInsertedInCurrentPage = true;
        }
    }

    public void onProgressChanged(int n) {
    }

    public void onPageStarted(WebView webView, String string) {
        this.jsInsertedInCurrentPage = false;
    }

    public void paymentFlowEnd() {
        this.smsAgent.deregisterForCallbacks((SmsAgentInterface)this);
        this.smsAgent.removeSMSBroadcastReceiver((Activity)this.context);
    }

    private void injectJs(String string) {
        this.webView.loadUrl(String.format("javascript: %s", string));
    }

    public void postSms(String string, String string2) {
        if (!this.isMagicEnabled) {
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("sender", (Object)string);
            jSONObject.put("message", (Object)string2);
            this.lastSms = jSONObject.toString();
            this.injectJs(String.format("Magic.elfBridge.setSms(%s)", jSONObject.toString()));
            return;
        }
        catch (Exception exception) {
            Logger.e((String)"Exception", (Throwable)exception);
            return;
        }
    }

    void setMagicEnabled(boolean bl) {
        this.isMagicEnabled = bl;
    }

    public void setSmsPermission(boolean bl) {
        this.hasOtpPermission = bl;
    }
}

