/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Parcelable;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsProperty;
import com.razorpay.AnalyticsUtil;
import com.razorpay.BaseUtils;
import com.razorpay.ConfigCheckout;
import com.razorpay.Logger;
import com.razorpay.SharedPreferenceUtil;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

class CardSaving {
    CardSaving() {
    }

    static void sendBroadcastForFetchingDeviceToken(Context context) {
        Intent intent = new Intent();
        intent.setAction("rzp.device_token.share");
        List list = context.getPackageManager().queryBroadcastReceivers(intent, 0);
        for (int i = 0; i < list.size(); ++i) {
            ResolveInfo resolveInfo = (ResolveInfo)list.get(i);
            intent.setComponent(new ComponentName(resolveInfo.activityInfo.packageName, resolveInfo.activityInfo.name));
            resolveInfo = new Intent();
            resolveInfo.setComponent(new ComponentName("com.razorpay", "com.razorpay.CheckoutActivity"));
            intent.putExtra("forward", (Parcelable)resolveInfo);
            context.sendOrderedBroadcast(intent, null, new BroadcastReceiver(){

                public void onReceive(Context context, Intent object) {
                    object = this.getResultExtras(false);
                    if (object != null && (object = object.getString("device_token_info_list")) != null) {
                        try {
                            object = new JSONArray((String)object);
                            CardSaving.getCorrectDeviceTokenFromInfoListAndSave(context, (JSONArray)object);
                            return;
                        }
                        catch (Exception exception) {}
                    }
                }
            }, null, -1, null, null);
        }
    }

    static String getCorrectDeviceTokenFromInfoListAndSave(Context context, JSONArray jSONArray) {
        String string;
        JSONObject jSONObject = null;
        if (jSONArray == null || jSONArray.length() == 0) {
            return null;
        }
        if (jSONArray.length() == 1) {
            try {
                jSONObject = jSONArray.getJSONObject(0);
            }
            catch (Exception exception) {}
        } else if (jSONArray.length() != 1) {
            string = null;
            boolean bl = false;
            String string2 = "{";
            boolean bl2 = true;
            for (int i = 0; i < jSONArray.length(); ++i) {
                try {
                    JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                    if (!bl2) {
                        string2 = string2 + ",";
                    } else {
                        bl2 = false;
                    }
                    string2 = string2 + "'" + jSONObject2.getString("card_saving_token_source") + "': '" + jSONObject2.getString("rzp_device_token") + "'";
                    if (string == null) {
                        string = jSONObject2.getString("rzp_device_token");
                        continue;
                    }
                    if (string.equals(jSONObject2.getString("rzp_device_token"))) continue;
                    bl = true;
                    continue;
                }
                catch (Throwable throwable) {}
            }
            string2 = string2 + "}";
            if (bl) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("packages", string2);
                AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.MULTIPLE_TOKEN_EVENT, (JSONObject)AnalyticsUtil.getJSONResponse(hashMap));
                return null;
            }
            try {
                jSONObject = jSONArray.getJSONObject(0);
            }
            catch (Exception exception) {}
        }
        if (jSONObject != null) {
            string = "";
            String string3 = "";
            try {
                string = jSONObject.getString("rzp_device_token");
                string3 = jSONObject.getString("card_saving_token_source");
            }
            catch (Exception exception) {}
            CardSaving.setDeviceToken(context, string);
            AnalyticsUtil.addProperty((String)"device_token_source_single", (AnalyticsProperty)new AnalyticsProperty(string3, AnalyticsProperty.Scope.ORDER));
            return string;
        }
        return null;
    }

    static void fetchDeviceTokenFromOtherAppsIfRequired(Context context) throws IllegalStateException {
        String string;
        if (ConfigCheckout.getInstance().isCardSavingLocalEnabled() && (string = CardSaving.getDeviceToken(context)) != null) {
            AnalyticsUtil.addProperty((String)"device_token_source_single", (AnalyticsProperty)new AnalyticsProperty(context.getPackageName(), AnalyticsProperty.Scope.ORDER));
            return;
        }
        if (Build.VERSION.SDK_INT >= 24 && ConfigCheckout.getInstance().isCardSavingBroadcastReceiverFlowEnabled()) {
            CardSaving.sendBroadcastForFetchingDeviceToken(context);
            return;
        }
        if (ConfigCheckout.getInstance().isCardSavingSharedPreferencesFlowEnabled()) {
            string = CardSaving.getListOfRazorpayPackages(context);
            CardSaving.getCorrectDeviceTokenFromInfoListAndSave(context, (JSONArray)string);
        }
    }

    private static JSONArray getListOfRazorpayPackages(Context context) {
        JSONArray jSONArray = new JSONArray();
        Object object = BaseUtils.getListOfAppsWhichHandleDeepLink((Context)context, (String)"io.rzp://rzp.io");
        int n = 0;
        object = object.iterator();
        while (object.hasNext()) {
            Object object2;
            Object object3 = (ResolveInfo)object.next();
            object3 = object3.activityInfo.taskAffinity;
            ++n;
            try {
                object2 = context.createPackageContext((String)object3, 2);
                if ((object2 = CardSaving.getDeviceToken((Context)object2)) == null) continue;
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("rzp_device_token", object2);
                jSONObject.put("card_saving_token_source", object3);
                jSONArray.put((Object)jSONObject);
            }
            catch (Exception exception) {
                object2 = exception;
                if (exception instanceof SecurityException && Build.VERSION.SDK_INT >= 24) {
                    AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.SHARE_PREFERENCES_SECURITY_EXCEPTION);
                } else {
                    AnalyticsUtil.reportError((String)((Throwable)object2).getMessage(), (String)"S0", (String)((Throwable)object2).getMessage());
                }
                Logger.e((String)"Error fetching global device token", (Throwable)object2);
            }
        }
        AnalyticsUtil.addProperty((String)"sdk_count", (AnalyticsProperty)new AnalyticsProperty(n, AnalyticsProperty.Scope.ORDER));
        AnalyticsUtil.addProperty((String)"sdk_count_with_token", (AnalyticsProperty)new AnalyticsProperty(jSONArray.length(), AnalyticsProperty.Scope.ORDER));
        return jSONArray;
    }

    static String getAppToken(Context context) {
        context = SharedPreferenceUtil.getPrivatePrefs((Context)context);
        return context.getString("rzp_app_token", null);
    }

    static void setAppToken(Context context, String string) {
        context = SharedPreferenceUtil.getPrivateEditor((Context)context);
        context.putString("rzp_app_token", string).apply();
    }

    static String getDeviceToken(Context context) {
        context = SharedPreferenceUtil.getPublicPrefs((Context)context);
        return context.getString("rzp_device_token", null);
    }

    static void setDeviceToken(Context context, String string) {
        context = SharedPreferenceUtil.getPublicEditor((Context)context);
        context.putString("rzp_device_token", string).apply();
    }

    static void clearDeviceToken(Context context) {
        SharedPreferenceUtil.getPublicEditor((Context)context).remove("rzp_device_token").apply();
    }
}

