/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.RelativeLayout;
import android.widget.Toast;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowCompat;
import androidx.core.view.WindowInsetsCompat;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsUtil;
import com.razorpay.AndroidBug5497Workaround;
import com.razorpay.BaseUtils;
import com.razorpay.CheckoutBridge;
import com.razorpay.CheckoutCacheManager;
import com.razorpay.CheckoutInteractor;
import com.razorpay.CheckoutPresenter;
import com.razorpay.CheckoutPresenterImpl;
import com.razorpay.CheckoutUtils;
import com.razorpay.ConfigCheckout;
import com.razorpay.LifecycleContext;
import com.razorpay.Logger;
import com.razorpay.MagicBridge;
import com.razorpay.PrimaryWebChromeClient;
import com.razorpay.PrimaryWebViewClient;
import com.razorpay.RZPProgressBar;
import com.razorpay.ResourceUtils;
import com.razorpay.SecondaryWebChromeClient;
import com.razorpay.SecondaryWebViewClient;
import com.razorpay.SharedPreferenceUtil;
import com.razorpay.SmsAgent;
import com.razorpay.SmsAgentInterface;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

class BaseCheckoutActivity
extends Activity
implements CheckoutPresenterImpl.CheckoutView,
SmsAgentInterface {
    private ViewGroup parent;
    private WebView primaryWebView;
    private WebView secondaryWebView;
    private RelativeLayout container;
    protected CheckoutPresenter presenter;
    protected Object checkoutBridgeObject;
    private WebViewClient primaryWebViewClient;
    private WebViewClient secondaryWebViewClient;
    private WebChromeClient primaryWebChromeClient;
    private WebChromeClient secondaryWebChromeClient;
    private static int UPI_REQUEST_CODE = 99;
    private RZPProgressBar rzpbar;
    private SmsAgent smsAgent;
    private String lifecycleContext = "";

    BaseCheckoutActivity() {
    }

    protected void setLifecycleContext(LifecycleContext lifecycleContext, String string) {
        this.lifecycleContext = lifecycleContext.format(string);
    }

    private void setWebViewClient(int n, WebViewClient webViewClient) {
        switch (n) {
            case 1: {
                this.primaryWebViewClient = webViewClient;
                return;
            }
            case 2: {
                this.secondaryWebViewClient = webViewClient;
            }
        }
    }

    private void setWebChromeClient(int n, WebChromeClient webChromeClient) {
        switch (n) {
            case 1: {
                this.primaryWebChromeClient = webChromeClient;
                return;
            }
            case 2: {
                this.secondaryWebChromeClient = webChromeClient;
            }
        }
    }

    @SuppressLint(value={"SourceLockedOrientationActivity"})
    public void onCreate(Bundle bundle) {
        try {
            AnalyticsUtil.logFunctionEntry((String)"BaseCheckoutActivity", (String)"onCreate", (boolean)ConfigCheckout.getInstance().isVerboseLoggingEnabled());
            Bundle bundle2 = new HashMap();
            if (!this.lifecycleContext.isEmpty()) {
                bundle2.put("reason", this.lifecycleContext);
            }
            AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.ACTIVITY_ONCREATE_CALLED, bundle2);
            this.lifecycleContext = "";
            SharedPreferenceUtil.handleSdkUpdate((Context)this, (String)ConfigCheckout.SDK_VERSION);
            ConfigCheckout.getInstance().init((Context)this);
            BaseUtils.checkForLatestVersion((Context)this, (int)ConfigCheckout.SDK_VERSION_CODE);
            this.presenter.setCheckoutLoadStartAt();
            AnalyticsUtil.libraryType = "CHECKOUTJS";
            this.setWebViewClient(1, new PrimaryWebViewClient(this.presenter));
            this.setWebViewClient(2, new SecondaryWebViewClient(this.presenter));
            this.setWebChromeClient(1, new PrimaryWebChromeClient(this.presenter));
            this.setWebChromeClient(2, new SecondaryWebChromeClient(this.presenter));
            BaseUtils.setup();
            AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CHECKOUT_INIT);
            this.requestWindowFeature(1);
            super.onCreate(bundle);
            Logger.d((String)"CheckoutActivity onCreate called");
            bundle2 = bundle;
            int n = 1;
            if (bundle == null) {
                bundle2 = this.getIntent().getExtras();
                n = 0;
            }
            if (bundle2 == null) {
                bundle2 = CheckoutUtils.getCheckoutActivityStateBundle(this);
            }
            if (!this.presenter.setOptions(bundle2, n != 0)) {
                return;
            }
            this.parent = (ViewGroup)this.findViewById(0x1020002);
            WindowCompat.setDecorFitsSystemWindows((Window)this.getWindow(), (boolean)true);
            ViewCompat.setOnApplyWindowInsetsListener((View)this.parent, (view, windowInsetsCompat) -> {
                Insets insets = windowInsetsCompat.getInsets(WindowInsetsCompat.Type.systemBars());
                view.setPadding(insets.left, insets.top, insets.right, insets.bottom);
                return windowInsetsCompat;
            });
            BaseCheckoutActivity baseCheckoutActivity = this;
            baseCheckoutActivity.createPrimaryWebView(baseCheckoutActivity.checkoutBridgeObject);
            this.createSecondaryWebView();
            this.createContainer();
            if (!CheckoutUtils.isDynamicUrlConfigUsed(bundle2)) {
                if (CheckoutCacheManager.getInstance().publicPageResponse != null) {
                    CheckoutCacheManager.getInstance().isFetchedPublicPageUsed = true;
                    this.presenter.loadFetchedForm(CheckoutCacheManager.getInstance().checkoutPublicUrl, CheckoutCacheManager.getInstance().publicPageResponse);
                } else {
                    this.presenter.loadForm("");
                }
            } else {
                this.presenter.setOptionsWithDynamicUrl((Context)this, bundle2, n != 0, new SetOptionsCallback(){

                    @Override
                    public void onOptionsSet() {
                        SharedPreferenceUtil.setValue((Context)BaseCheckoutActivity.this, (String)"optimizer_hosted", (String)"true");
                        if (CheckoutCacheManager.getInstance().publicPageResponse != null) {
                            CheckoutCacheManager.getInstance().isFetchedPublicPageUsed = true;
                            BaseCheckoutActivity.this.presenter.loadFetchedForm(CheckoutCacheManager.getInstance().checkoutPublicUrl, CheckoutCacheManager.getInstance().publicPageResponse);
                            return;
                        }
                        BaseCheckoutActivity.this.presenter.loadForm("");
                    }

                    @Override
                    public void onFeatureDisabled() {
                        BaseCheckoutActivity.this.destroy(3, "Dynamic URL Config is disabled. Please contact the administrator if you believe this is wrong.");
                    }

                    @Override
                    public void onError() {
                        BaseCheckoutActivity.this.destroy(3, "Dynamic URL Config is disabled. Please contact the administrator if you believe this is wrong.");
                    }
                });
            }
            this.presenter.passPrefillToSegment();
            boolean bl = (this.getWindow().getAttributes().flags & 0x400) != 0;
            if (bl) {
                AndroidBug5497Workaround.assistActivity(this);
                Logger.d((String)"FULLSCREEN");
            } else {
                Logger.d((String)"NOT FULLSCREEN");
            }
            if (this.presenter.isAllowRotation()) {
                return;
            }
            if (ResourceUtils.isTablet((Context)this)) {
                Logger.d((String)"is tablet");
                this.setFinishOnTouchOutside(false);
                WindowManager.LayoutParams layoutParams = this.getWindow().getAttributes();
                int n2 = ResourceUtils.dpToPx((Context)this, (int)375);
                n = ResourceUtils.getViewHeight((Activity)this);
                if (n > 600) {
                    n = ResourceUtils.dpToPx((Context)this, (int)600);
                }
                layoutParams.height = n;
                layoutParams.width = n2;
                this.getWindow().setAttributes(layoutParams);
            } else if (Build.VERSION.SDK_INT != 26) {
                this.setRequestedOrientation(1);
            }
            this.presenter.fetchCondfig();
            this.presenter.handleCardSaving();
            if (!BaseUtils.isDeviceHaveCorrectTlsVersion()) {
                AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CHECKOUT_TLS_ERROR);
                this.destroy(6, "TLSv1  is not supported for security reasons");
                return;
            }
            AnalyticsUtil.logFunctionExit((String)"BaseCheckoutActivity", (String)"onCreate", (boolean)ConfigCheckout.getInstance().isVerboseLoggingEnabled());
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            AnalyticsUtil.reportCaughtException((Throwable)exception);
            return;
        }
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        this.presenter.saveInstanceState(bundle);
    }

    public void onBackPressed() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        this.presenter.backPressed(hashMap);
    }

    protected void onDestroy() {
        try {
            AnalyticsUtil.logFunctionEntry((String)"BaseCheckoutActivity", (String)"onDestroy", (boolean)ConfigCheckout.getInstance().isVerboseLoggingEnabled());
            AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.ACTIVITY_ONDESTROY_CALLED);
            Logger.d((String)"CheckoutActivity onDestroy called");
            try {
                this.presenter.cleanUpOnDestroy();
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                AnalyticsUtil.reportError((String)this.getClass().getName(), (String)"S0", (String)concurrentModificationException.getLocalizedMessage());
                concurrentModificationException.printStackTrace();
            }
            super.onDestroy();
            AnalyticsUtil.logFunctionExit((String)"BaseCheckoutActivity", (String)"onDestroy", (boolean)ConfigCheckout.getInstance().isVerboseLoggingEnabled());
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            AnalyticsUtil.reportCaughtException((Throwable)exception);
            return;
        }
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
    }

    @SuppressLint(value={"JavascriptInterface"})
    private void createPrimaryWebView(Object object) {
        this.primaryWebView = new WebView((Context)this);
        this.primaryWebView.setBackgroundColor(Color.parseColor((String)"#99000000"));
        this.primaryWebView.setContentDescription((CharSequence)"primary_webview");
        BaseCheckoutActivity baseCheckoutActivity = this;
        if (CheckoutUtils.shouldDisableHardwareAcceleration((Context)baseCheckoutActivity, baseCheckoutActivity.presenter.getCheckoutOptions())) {
            this.primaryWebView.setLayerType(1, null);
        }
        BaseCheckoutActivity baseCheckoutActivity2 = this;
        BaseUtils.setWebViewSettings((Context)baseCheckoutActivity2, (WebView)baseCheckoutActivity2.primaryWebView, (boolean)false);
        this.primaryWebView.clearFormData();
        this.primaryWebView.addJavascriptInterface(object, "CheckoutBridge");
        this.primaryWebView.setWebChromeClient(this.primaryWebChromeClient);
        this.primaryWebView.setWebViewClient(this.primaryWebViewClient);
    }

    private void createSecondaryWebView() {
        this.secondaryWebView = new WebView((Context)this);
        this.secondaryWebView.setBackgroundColor(Color.parseColor((String)"#99000000"));
        BaseCheckoutActivity baseCheckoutActivity = this;
        if (CheckoutUtils.shouldDisableHardwareAcceleration((Context)baseCheckoutActivity, baseCheckoutActivity.presenter.getCheckoutOptions())) {
            this.secondaryWebView.setLayerType(1, null);
        }
        BaseCheckoutActivity baseCheckoutActivity2 = this;
        BaseUtils.setWebViewSettings((Context)baseCheckoutActivity2, (WebView)baseCheckoutActivity2.secondaryWebView, (boolean)false);
        this.secondaryWebView.clearFormData();
        this.secondaryWebView.addJavascriptInterface((Object)new MagicBridge((CheckoutInteractor)((Object)this.presenter)), "MagicBridge");
        this.secondaryWebView.addJavascriptInterface((Object)new CheckoutBridge((CheckoutInteractor)((Object)this.presenter), 2), "CheckoutBridge");
        this.secondaryWebView.setVisibility(8);
        this.secondaryWebView.setWebChromeClient(this.secondaryWebChromeClient);
        this.secondaryWebView.setWebViewClient(this.secondaryWebViewClient);
    }

    private void createContainer() {
        this.container = new RelativeLayout((Context)this);
        this.container.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.container.setBackgroundColor(0);
        this.parent.addView((View)this.container);
        this.primaryWebView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.secondaryWebView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.primaryWebView.setContentDescription((CharSequence)"primary_webview");
        this.secondaryWebView.setContentDescription((CharSequence)"secondary_webview");
        this.container.addView((View)this.primaryWebView);
        this.container.addView((View)this.secondaryWebView);
        String string = this.presenter.getProgressBarColor();
        if (string != null) {
            BaseCheckoutActivity baseCheckoutActivity = this;
            this.rzpbar = new RZPProgressBar((Context)baseCheckoutActivity, (ViewGroup)baseCheckoutActivity.container, string);
        } else {
            BaseCheckoutActivity baseCheckoutActivity = this;
            this.rzpbar = new RZPProgressBar((Context)baseCheckoutActivity, (ViewGroup)baseCheckoutActivity.container);
        }
        this.presenter.setUpAddOn();
    }

    protected void onActivityResult(int n, int n2, Intent intent) {
        try {
            AnalyticsUtil.logFunctionEntry((String)"BaseCheckoutActivity", (String)"onActivityResult", (boolean)ConfigCheckout.getInstance().isVerboseLoggingEnabled());
            super.onActivityResult(n, n2, intent);
            if (n == 1001) {
                this.presenter.sendOtpPermissionCallback(true);
            }
            this.presenter.onActivityResultReceived(n, n2, intent);
            AnalyticsUtil.logFunctionExit((String)"BaseCheckoutActivity", (String)"onActivityResult", (boolean)ConfigCheckout.getInstance().isVerboseLoggingEnabled());
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            AnalyticsUtil.reportCaughtException((Throwable)exception);
            return;
        }
    }

    public void onRequestPermissionsResult(int n, String[] stringArray, int[] nArray) {
        this.presenter.onRequestPermissionsResult(n, stringArray, nArray);
    }

    public void postSms(String string, String string2) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("sender", (Object)string);
            jSONObject.put("message", (Object)string2);
            string = String.format("OTPElf.showOTP('%s','%s')", string2, string);
            this.loadUrl(1, string);
            return;
        }
        catch (JSONException jSONException) {
            AnalyticsUtil.reportError((String)this.getClass().getName(), (String)"S1", (String)jSONException.getMessage());
            jSONException.printStackTrace();
            return;
        }
    }

    public void setSmsPermission(boolean bl) {
        this.presenter.sendOtpPermissionCallback(bl);
        if (this.smsAgent != null) {
            this.smsAgent.deregisterForCallbacks((SmsAgentInterface)this);
        }
    }

    @Override
    public void loadUrl(int n, String string) {
        switch (n) {
            case 1: {
                if (this.primaryWebView == null) break;
                this.primaryWebView.loadUrl(string);
                return;
            }
            case 2: {
                this.secondaryWebView.loadUrl(string);
            }
        }
    }

    @Override
    public void checkSmsPermission() {
    }

    @Override
    @SuppressLint(value={"JavascriptInterface"})
    public void addJavascriptInterfaceToPrimaryWebview(Object object, String string) {
        this.primaryWebView.addJavascriptInterface(object, string);
    }

    @Override
    public void loadData(int n, String string, String string2, String string3) {
        switch (n) {
            case 1: {
                this.primaryWebView.loadData(string, string2, string3);
                return;
            }
            case 2: {
                this.secondaryWebView.loadData(string, string2, string3);
            }
        }
    }

    @Override
    public void loadDataWithBaseURL(int n, String string, String string2, String string3, String string4, String string5) {
        switch (n) {
            case 1: {
                this.primaryWebView.loadDataWithBaseURL(string, string2, string3, string4, string5);
                return;
            }
            case 2: {
                this.secondaryWebView.loadDataWithBaseURL(string, string2, string3, string4, string5);
            }
        }
    }

    @Override
    public void makeWebViewVisible(int n) {
        switch (n) {
            case 1: {
                if (this.primaryWebView.getVisibility() != 8) break;
                this.primaryWebView.setVisibility(0);
                this.secondaryWebView.setVisibility(8);
                CheckoutUtils.dismissLoader();
                AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.WEB_VIEW_SECONDARY_TO_PRIMARY_SWITCH);
                return;
            }
            case 2: {
                if (this.secondaryWebView.getVisibility() != 8) break;
                this.primaryWebView.setVisibility(8);
                this.secondaryWebView.setVisibility(0);
                CheckoutUtils.dismissLoader();
                AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.WEB_VIEW_PRIMARY_TO_SECONDARY_SWITCH);
            }
        }
    }

    @Override
    public boolean isWebViewVisible(int n) {
        boolean bl = false;
        switch (n) {
            case 1: {
                if (this.primaryWebView == null || this.primaryWebView.getVisibility() != 0) break;
                bl = true;
                break;
            }
            case 2: {
                if (this.secondaryWebView == null || this.secondaryWebView.getVisibility() != 0) break;
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public void showToast(String string, int n) {
        Toast.makeText((Context)this, (CharSequence)string, (int)n).show();
    }

    @Override
    public void destroy(int n, String string) {
        Intent intent = new Intent();
        intent.putExtra("RESULT", string);
        if (string == null || TextUtils.isEmpty((CharSequence)string)) {
            n = 5;
        }
        this.setResult(n, intent);
        BaseUtils.getInstance().clearMetadata();
        this.finish();
    }

    @Override
    public void showProgressBar(int n) {
        if (this.rzpbar != null) {
            this.rzpbar.show(n);
        }
    }

    @Override
    public void hideProgressBar() {
        if (this.rzpbar != null) {
            this.rzpbar.hide();
        }
    }

    @Override
    public void clearWebViewHistory(int n) {
        switch (n) {
            case 1: {
                this.primaryWebView.clearHistory();
                return;
            }
            case 2: {
                this.secondaryWebView.clearHistory();
            }
        }
    }

    @Override
    public WebView getWebView(int n) {
        WebView webView = null;
        switch (n) {
            case 1: {
                webView = this.primaryWebView;
                break;
            }
            case 2: {
                webView = this.secondaryWebView;
            }
        }
        return webView;
    }

    public void onPause() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (!this.lifecycleContext.isEmpty()) {
            hashMap.put("reason", this.lifecycleContext);
            Logger.d((String)("CheckoutActivity onPause called with reason: " + this.lifecycleContext));
        } else {
            Logger.d((String)"CheckoutActivity onPause called");
        }
        AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.ACTIVITY_ONPAUSE_CALLED, hashMap);
        this.lifecycleContext = "";
        super.onPause();
    }

    public void onResume() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (!this.lifecycleContext.isEmpty()) {
            hashMap.put("reason", this.lifecycleContext);
            Logger.d((String)("CheckoutActivity onResume called with reason: " + this.lifecycleContext));
        } else {
            Logger.d((String)"CheckoutActivity onResume called");
        }
        AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.ACTIVITY_ONRESUME_CALLED, hashMap);
        this.lifecycleContext = "";
        super.onResume();
        this.presenter.onResumeTriggered();
    }

    static interface SetOptionsCallback {
        public void onOptionsSet();

        public void onFeatureDisabled();

        public void onError();
    }
}

