/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.app.ActivityManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.Nullable;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsUtil;
import com.razorpay.CheckoutCacheManager;
import com.razorpay.CheckoutPresenter;
import com.razorpay.CheckoutUtils;
import com.razorpay.GlobalUrlConfig;
import com.razorpay.Logger;
import com.razorpay.PerformanceUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

class PrimaryWebViewClient
extends WebViewClient {
    CheckoutPresenter presenter;
    int maxRetryCount = 2;

    public PrimaryWebViewClient(CheckoutPresenter checkoutPresenter) {
        this.presenter = checkoutPresenter;
    }

    public boolean shouldOverrideUrlLoading(WebView webView, String string) {
        return this.presenter.shouldOverrideUrlLoading(webView, string);
    }

    @Nullable
    public WebResourceResponse shouldInterceptRequest(WebView object, WebResourceRequest object2) {
        String string;
        String string2;
        if (Build.VERSION.SDK_INT >= 21) {
            Logger.d((String)("shouldInterceptRequest: " + object2.getUrl().toString()));
            string2 = object2.getUrl().toString().substring(object2.getUrl().toString().lastIndexOf("/") + 1);
        } else {
            Logger.d((String)("shouldInterceptRequest: " + object.getUrl()));
            string2 = object.getUrl() != null ? object.getUrl().substring(object.getUrl().lastIndexOf("/") + 1) : "";
        }
        if (!CheckoutCacheManager.getInstance().isFetchedPublicPageUsed && string2.equalsIgnoreCase("v2-entry.modern.js")) {
            return super.shouldInterceptRequest(object, object2);
        }
        if (!string2.isEmpty() && !(string = CheckoutCacheManager.getInstance().getFileIfBuildExists(string2)).isEmpty()) {
            object = "text/javascript";
            if (string2.endsWith("css")) {
                object = "text/css";
            }
            object2 = new HashMap<String, String>();
            object2.put("Access-Control-Allow-Origin", "*");
            if (Build.VERSION.SDK_INT >= 21) {
                return new WebResourceResponse((String)object, "UTF-8", 200, "OK", (Map)object2, (InputStream)new ByteArrayInputStream(string.getBytes()));
            }
            return new WebResourceResponse((String)object, "UTF-8", (InputStream)new ByteArrayInputStream(string.getBytes()));
        }
        return super.shouldInterceptRequest(object, object2);
    }

    public void onReceivedError(WebView webView, int n, String string, String string2) {
        if (string.contains("NAME_NOT_RESOLVED")) {
            if (this.maxRetryCount > 0) {
                this.presenter.loadForm("");
                --this.maxRetryCount;
                return;
            }
            this.presenter.showLoaderDialog(2, string);
            return;
        }
        this.presenter.destroyActivity(2, string);
    }

    public void onPageStarted(WebView webView, String string, Bitmap bitmap) {
        Logger.d((String)("onPageStarted: " + string));
        Logger.d((String)("LOAD_TIME onPageStarted:" + System.currentTimeMillis()));
        webView.setTag((Object)string);
        this.presenter.onPageStarted(1, webView, string);
        CheckoutUtils.toggleWebviewBackground(webView, string.contains(GlobalUrlConfig.instance().getBaseUrl()));
    }

    public void onPageFinished(WebView webView, String string) {
        Logger.d((String)("onPageFinished: " + string));
        Logger.d((String)("LOAD_TIME onPageFinished:" + System.currentTimeMillis()));
        this.presenter.onPageFinished(1, webView, string);
        CheckoutUtils.toggleWebviewBackground(webView, string.contains(GlobalUrlConfig.instance().getBaseUrl()));
    }

    public boolean onRenderProcessGone(WebView webView, RenderProcessGoneDetail renderProcessGoneDetail) {
        try {
            this.trackRendererCrash(webView, renderProcessGoneDetail, "primary_webview");
        }
        catch (Exception exception) {
            Logger.e((String)("Error in onRenderProcessGone: " + exception.getMessage()));
        }
        return true;
    }

    private void trackRendererCrash(WebView webView, RenderProcessGoneDetail renderProcessGoneDetail, String string) {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            if (Build.VERSION.SDK_INT >= 26 && renderProcessGoneDetail != null) {
                hashMap.put("did_crash", renderProcessGoneDetail.didCrash());
                hashMap.put("renderer_priority_at_exit", renderProcessGoneDetail.rendererPriorityAtExit());
            } else {
                hashMap.put("did_crash", "unknown");
                hashMap.put("renderer_priority_at_exit", "unknown");
            }
            hashMap.put("manufacturer", Build.MANUFACTURER);
            hashMap.put("model", Build.MODEL);
            hashMap.put("os_version", Build.VERSION.RELEASE);
            if (webView != null && webView.getContext() != null) {
                int n = PerformanceUtil.getPerformanceClass((Context)webView.getContext());
                boolean bl = PerformanceUtil.isLowEndDevice((Context)webView.getContext());
                hashMap.put("performance_class", n);
                hashMap.put("is_low_end_device", bl);
                webView = (ActivityManager)webView.getContext().getSystemService("activity");
                if (webView != null) {
                    ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
                    webView.getMemoryInfo(memoryInfo);
                    long l = memoryInfo.totalMem / 0x100000L;
                    hashMap.put("total_ram_mb", l);
                }
            }
            hashMap.put("cpu_cores", Runtime.getRuntime().availableProcessors());
            hashMap.put("webview_type", string);
            AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.WEBVIEW_RENDERER_CRASHED, (JSONObject)AnalyticsUtil.getJSONResponse(hashMap));
            Logger.d((String)"Renderer crash analytics tracked");
            return;
        }
        catch (Exception exception) {
            Logger.e((String)("Error tracking renderer crash: " + exception.getMessage()));
            return;
        }
    }
}

