/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.app.Activity;
import android.content.Intent;
import androidx.annotation.NonNull;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsUtil;
import com.razorpay.CheckoutPresenterImpl;
import com.razorpay.GenericPluginCallback;
import com.razorpay.OtpElfCheckoutPresenterImpl;
import com.razorpay.PluginCheckoutInteractor;
import com.razorpay.RzpInternalCallback;
import com.razorpay.RzpPlugin;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PluginOtpElfCheckoutPresenterImpl
extends OtpElfCheckoutPresenterImpl
implements PluginCheckoutInteractor {
    private HashMap<String, String> pluginsMap;
    private boolean isExtRzpPluginActive = false;
    private boolean isExtPluginFuncTriggered = false;
    private RzpPlugin extActiveRzpPluginInstance;
    private final RzpInternalCallback rzpInternalCallback = new RzpInternalCallback(){

        public void onPaymentSuccess(String string) {
            try {
                JSONObject jSONObject = new JSONObject(string);
                if (jSONObject.has("provider")) {
                    switch (jSONObject.getString("provider")) {
                        case "GOOGLE_PAY": 
                        case "UPI_TURBO": 
                        case "GPAY_IN_A_BOX": {
                            PluginOtpElfCheckoutPresenterImpl.this.sendExternalSdkResponse(jSONObject.toString());
                            break;
                        }
                        default: {
                            PluginOtpElfCheckoutPresenterImpl.this.onComplete(jSONObject.toString());
                        }
                    }
                }
                AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CHECKOUT_PLUGIN_INTERNAL_CALLBACK_SUCCESS, (JSONObject)AnalyticsUtil.getJSONResponse((String)string));
                return;
            }
            catch (JSONException jSONException) {
                AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CHECKOUT_PLUGIN_INTERNAL_CALLBACK_ERROR);
                return;
            }
        }

        public void onPaymentError(int n, String string) {
            block11: {
                Object object = new HashMap<String, Object>();
                object.put("response", string);
                object.put("code", n);
                AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CHECKOUT_PLUGIN_INTERNAL_CALLBACK_ERROR, (JSONObject)AnalyticsUtil.getJSONResponse(object));
                try {
                    JSONObject jSONObject = new JSONObject(string);
                    if (jSONObject.has("provider")) {
                        switch (jSONObject.getString("provider")) {
                            case "GOOGLE_PAY": 
                            case "UPI_TURBO": 
                            case "GPAY_IN_A_BOX": {
                                PluginOtpElfCheckoutPresenterImpl.this.sendExternalSdkResponse(jSONObject.toString());
                                break block11;
                            }
                            default: {
                                PluginOtpElfCheckoutPresenterImpl.this.onComplete(jSONObject.toString());
                            }
                        }
                    }
                    return;
                }
                catch (Exception exception) {
                    AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CHECKOUT_PLUGIN_INTERNAL_CALLBACK_ERROR_EXCEPTION);
                    PluginOtpElfCheckoutPresenterImpl.this.onComplete(string);
                }
            }
        }
    };

    public PluginOtpElfCheckoutPresenterImpl(Activity activity, CheckoutPresenterImpl.CheckoutView checkoutView, HashMap<String, String> hashMap) {
        super(activity, checkoutView, hashMap);
        this.pluginsMap = hashMap;
    }

    @Override
    public void triggerExternalSdkFunc(String string) {
        if (this.pluginsMap == null || this.pluginsMap.size() == 0) {
            return;
        }
        try {
            string = new JSONObject(string);
            switch (string.getString("provider")) {
                case "UPI_TURBO": {
                    if (!string.getString("action").equalsIgnoreCase("LINK_NEW_ACCOUNT")) break;
                    AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.TRIGGER_EXTERNAL_SDK_FUNC_LINK_CALLED);
                    this.upiTurbo.linkNewUpiAccountCheckout(string.getJSONObject("data").optString("color"), string.getJSONObject("data").optString("amountInDisplayFormat"), new GenericPluginCallback(){
                        final /* synthetic */ JSONObject val$jsonData;
                        {
                            this.val$jsonData = jSONObject;
                        }

                        public void onSuccess(@NonNull Object object) {
                            try {
                                JSONObject jSONObject = new JSONObject();
                                jSONObject.put("payload", object);
                                this.val$jsonData.put("data", (Object)jSONObject);
                                PluginOtpElfCheckoutPresenterImpl.this.sendExternalSdkResponse(this.val$jsonData.toString());
                                return;
                            }
                            catch (JSONException jSONException) {
                                return;
                            }
                        }

                        public void onError(@NonNull JSONObject jSONObject) {
                            try {
                                JSONObject jSONObject2 = new JSONObject();
                                jSONObject2.put("error", (Object)jSONObject);
                                this.val$jsonData.put("data", (Object)jSONObject2);
                                PluginOtpElfCheckoutPresenterImpl.this.sendExternalSdkResponse(this.val$jsonData.toString());
                                return;
                            }
                            catch (JSONException jSONException) {
                                return;
                            }
                        }
                    });
                }
            }
            return;
        }
        catch (JSONException jSONException) {
            return;
        }
    }

    @Override
    public void processPayment(String object) {
        JSONObject jSONObject;
        if (this.pluginsMap == null || this.pluginsMap.size() == 0) {
            return;
        }
        try {
            jSONObject = new JSONObject((String)object);
        }
        catch (JSONException jSONException) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("data", (String)object);
            AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CHECKOUT_PLUGIN_CALLING_PROCESS_PAYMENT_EXCEPTION, (JSONObject)AnalyticsUtil.getJSONResponse(hashMap));
            return;
        }
        RzpPlugin rzpPlugin = new HashMap();
        rzpPlugin.put("data", object);
        AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CHECKOUT_PLUGIN_CALLING_PROCESS_PAYMENT, (JSONObject)AnalyticsUtil.getJSONResponse(rzpPlugin));
        if (this.pluginsMap.containsKey("com.razorpay.plugin.googlepay_all") && this.pluginsMap.containsValue("com.razorpay.plugin.googlepay")) {
            this.pluginsMap.remove("com.razorpay.plugin.googlepay");
        }
        for (String string : this.pluginsMap.values()) {
            try {
                rzpPlugin = (RzpPlugin)RzpPlugin.class.getClassLoader().loadClass(string).newInstance();
                if (!rzpPlugin.doesHandlePayload(this.merchantKey, jSONObject, this.activity)) continue;
                this.isExtRzpPluginActive = true;
                this.extActiveRzpPluginInstance = rzpPlugin;
                if (string.equalsIgnoreCase("com.razorpay.RazorpayTurbo")) {
                    string = this.checkoutOptions.getAsJson();
                    string.put("apiResponse", (Object)jSONObject.getJSONObject("data").getJSONObject("apiResponse"));
                    string.put("upiAccount", (Object)jSONObject.getJSONObject("data").getJSONObject("upiAccount"));
                    string.put("apiPayload", (Object)jSONObject.getJSONObject("data").getJSONObject("apiPayload"));
                    rzpPlugin.processPayment(this.merchantKey, (JSONObject)string, this.activity, this.rzpInternalCallback);
                    return;
                }
                rzpPlugin.processPayment(this.merchantKey, jSONObject, this.activity, this.rzpInternalCallback);
                return;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | JSONException throwable) {
                AnalyticsUtil.reportError((String)this.getClass().getName(), (String)"S0", (String)throwable.getLocalizedMessage());
            }
        }
    }

    @Override
    public void sendExternalSdkResponse(String string) {
        AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.SEND_EXTERNAL_SDK_RESPONSE);
        super.sendExternalSdkResponse(string);
    }

    @Override
    protected JSONObject getOptionsForHandleMessage() {
        JSONObject jSONObject = super.getOptionsForHandleMessage();
        final JSONObject jSONObject2 = new JSONObject();
        boolean bl = false;
        boolean bl2 = false;
        try {
            block14: for (final String string : this.pluginsMap.keySet()) {
                final int n = 20;
                final int n2 = string.length();
                switch (string.substring(n, n2)) {
                    case "googlepay_all": {
                        Object object;
                        try {
                            object = Class.forName("com.google.android.apps.nbu.paisa.inapp.client.api.PaymentsClient");
                            if ((object = ((Class)object).newInstance()) == null) continue block14;
                            jSONObject2.put("googlepay", true);
                            bl = true;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            AnalyticsUtil.reportError((String)this.getClass().getName(), (String)"S2", (String)"GooglePay SDK is not included");
                        }
                        continue block14;
                    }
                    case "googlepay": {
                        bl2 = true;
                        jSONObject2.put(string.substring(n, n2), true);
                        continue block14;
                    }
                    case "upi_turbo": {
                        if (this.isExtPluginFuncTriggered) continue block14;
                        this.isExtPluginFuncTriggered = true;
                        Object object = this.integratedPluginsData;
                        if (object.has("upiTurboData")) {
                            this.isExtPluginFuncTriggered = false;
                            if ((object = object.get("upiTurboData")) instanceof JSONArray) {
                                jSONObject2.put(string.substring(n, n2), object);
                                continue block14;
                            }
                            jSONObject2.put(string.substring(n, n2), (Object)new JSONArray());
                            continue block14;
                        }
                        this.upiTurbo.getLinkedUpiAccounts(new GenericPluginCallback(){

                            public void onSuccess(@NonNull Object object) {
                                try {
                                    PluginOtpElfCheckoutPresenterImpl.this.isExtPluginFuncTriggered = false;
                                    JSONArray jSONArray = (JSONArray)object;
                                    if (jSONArray.length() != 0) {
                                        jSONObject2.put(string.substring(n, n2), object);
                                        return;
                                    }
                                    jSONObject2.put(string.substring(n, n2), (Object)new JSONArray());
                                }
                                catch (JSONException jSONException) {}
                            }

                            public void onError(@NonNull JSONObject jSONObject) {
                                try {
                                    PluginOtpElfCheckoutPresenterImpl.this.isExtPluginFuncTriggered = false;
                                    jSONObject2.put(string.substring(n, n2), (Object)new JSONArray());
                                    return;
                                }
                                catch (JSONException jSONException) {
                                    return;
                                }
                            }
                        }, null);
                        continue block14;
                    }
                }
                jSONObject2.put(string.substring(n, n2), true);
            }
            if (bl2 && bl) {
                jSONObject.put("googlepay_wrapper_version", (Object)"both");
            } else if (bl) {
                jSONObject.put("googlepay_wrapper_version", (Object)"2");
            }
            jSONObject.put("external_sdks", (Object)jSONObject2);
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError((String)this.getClass().getName(), (String)"S1", (String)exception.getLocalizedMessage());
        }
        return jSONObject;
    }

    @Override
    protected void onError(JSONObject object) {
        AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CHECKOUT_PLUGIN_ON_ERROR_CALLED, (JSONObject)object);
        if (this.isExtRzpPluginActive) {
            object = String.format("javascript: window.onComplete(%s)", object.toString());
            this.view.loadUrl(1, (String)object);
            this.isExtRzpPluginActive = false;
            return;
        }
        super.onError((JSONObject)object);
    }

    @Override
    public void onActivityResultReceived(int n, int n2, Intent intent) {
        if (this.isExtRzpPluginActive) {
            this.extActiveRzpPluginInstance.onActivityResult(this.merchantKey, n, n2, intent);
            return;
        }
        super.onActivityResultReceived(n, n2, intent);
    }
}

