/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.app.Activity;
import android.content.Context;
import android.webkit.WebView;
import com.razorpay.CheckoutPresenterImpl;
import com.razorpay.CheckoutUtils;
import com.razorpay.ConfigCheckout;
import com.razorpay.RzpAssist;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class OtpElfCheckoutPresenterImpl
extends CheckoutPresenterImpl {
    private RzpAssist primaryRzpAssist;
    private RzpAssist secondaryRzpAssist;
    private boolean isSecondaryRzpAssistEnabled = true;

    public OtpElfCheckoutPresenterImpl(Activity activity, CheckoutPresenterImpl.CheckoutView checkoutView) {
        super(activity, checkoutView);
    }

    public OtpElfCheckoutPresenterImpl(Activity activity, CheckoutPresenterImpl.CheckoutView checkoutView, HashMap<String, String> hashMap) {
        super(activity, checkoutView, hashMap);
    }

    @Override
    public void setUpAddOn() {
        this.primaryRzpAssist = new RzpAssist(this.merchantKey, this.activity, this.view.getWebView(1), ConfigCheckout.SDK_TYPE, ConfigCheckout.SDK_VERSION_CODE, ConfigCheckout.SDK_VERSION);
        this.primaryRzpAssist.setRzpAssistEnabled(true);
        this.secondaryRzpAssist = new RzpAssist(this.merchantKey, this.activity, this.view.getWebView(2), ConfigCheckout.SDK_TYPE, ConfigCheckout.SDK_VERSION_CODE, ConfigCheckout.SDK_VERSION);
        this.secondaryRzpAssist.setRzpAssistEnabled(true);
        if (this.checkoutOptions.getOtpElfPreferences() != null && this.primaryRzpAssist != null) {
            this.primaryRzpAssist.setOtpElfPreferences(this.checkoutOptions.getOtpElfPreferences());
        }
        super.setUpAddOn();
    }

    @Override
    protected void enableAddon(JSONObject jSONObject) {
        super.enableAddon(jSONObject);
        try {
            if (jSONObject.has("otpelf")) {
                this.isSecondaryRzpAssistEnabled = jSONObject.getBoolean("otpelf");
                if (this.secondaryRzpAssist != null) {
                    this.secondaryRzpAssist.setRzpAssistEnabled(this.isSecondaryRzpAssistEnabled);
                }
            }
            return;
        }
        catch (JSONException jSONException) {
            return;
        }
    }

    @Override
    public void onProgressChanges(int n, int n2) {
        switch (n) {
            case 1: {
                if (this.primaryRzpAssist == null) break;
                this.primaryRzpAssist.onProgressChanged(n2);
                break;
            }
            case 2: {
                if (this.secondaryRzpAssist == null || !this.isSecondaryRzpAssistEnabled) break;
                this.secondaryRzpAssist.onProgressChanged(n2);
            }
        }
        super.onProgressChanges(n, n2);
    }

    @Override
    public void onPageStarted(int n, WebView webView, String string) {
        super.onPageStarted(n, webView, string);
        switch (n) {
            case 1: {
                if (this.primaryRzpAssist == null) break;
                this.primaryRzpAssist.onPageStarted(webView, string);
                return;
            }
            case 2: {
                if (this.secondaryRzpAssist != null && this.isSecondaryRzpAssistEnabled) {
                    this.secondaryRzpAssist.onPageStarted(webView, string);
                }
                if (!this.view.isWebViewVisible(2)) break;
                CheckoutUtils.showLoader((Context)this.activity);
            }
        }
    }

    @Override
    public void onPageFinished(int n, WebView webView, String string) {
        super.onPageFinished(n, webView, string);
        switch (n) {
            case 2: {
                if (this.secondaryRzpAssist != null && this.isSecondaryRzpAssistEnabled) {
                    this.secondaryRzpAssist.onPageFinished(webView, string);
                }
                if (!this.view.isWebViewVisible(2)) break;
                CheckoutUtils.dismissLoader();
            }
        }
    }

    @Override
    protected void primaryWebviewPageFinished(String string, WebView webView) {
        super.primaryWebviewPageFinished(string, webView);
        if (this.primaryRzpAssist != null) {
            this.primaryRzpAssist.onPageFinished(webView, string);
        }
    }

    @Override
    public void onRequestPermissionsResult(int n, String[] stringArray, int[] nArray) {
        super.onRequestPermissionsResult(n, stringArray, nArray);
        if (this.primaryRzpAssist != null) {
            this.primaryRzpAssist.onRequestPermissionsResult(n, stringArray, nArray);
        }
    }

    @Override
    protected void addOnFlowEnd() {
        if (this.primaryRzpAssist != null) {
            this.primaryRzpAssist.paymentFlowEnd();
        }
        if (this.secondaryRzpAssist != null) {
            this.secondaryRzpAssist.paymentFlowEnd();
        }
        super.addOnFlowEnd();
    }

    @Override
    public void backPressed(Map<String, Object> map) {
        if (this.primaryRzpAssist != null) {
            map.put("current_loading_url_primary_webview", this.primaryRzpAssist.getCurrentLoadingUrl());
            map.put("last_loaded_url_primary_webview", this.primaryRzpAssist.getLastLoadedUrl());
        }
        if (this.secondaryRzpAssist != null) {
            map.put("current_loading_url_secondary_webview", this.secondaryRzpAssist.getCurrentLoadingUrl());
            map.put("last_loaded_url_secondary_webview", this.secondaryRzpAssist.getLastLoadedUrl());
        }
        super.backPressed(map);
    }

    @Override
    public void setPaymentID(String string) {
        if (this.primaryRzpAssist != null) {
            this.primaryRzpAssist.setPaymentId(string);
        }
        super.setPaymentID(string);
    }

    @Override
    protected void addAnalyticsData(JSONObject jSONObject) {
        try {
            if (this.primaryRzpAssist != null) {
                this.primaryRzpAssist.setPaymentData(jSONObject);
                jSONObject.put("razorpay_otp", this.primaryRzpAssist.isRazorpayOtpReceived());
            }
        }
        catch (JSONException jSONException) {}
        super.addAnalyticsData(jSONObject);
    }

    @Override
    protected void helpersReset() {
        super.helpersReset();
        if (this.primaryRzpAssist != null) {
            this.primaryRzpAssist.reset();
        }
        if (this.secondaryRzpAssist != null && this.isSecondaryRzpAssistEnabled) {
            this.secondaryRzpAssist.reset();
        }
    }
}

