/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Color;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Base64;
import android.view.WindowManager;
import android.webkit.WebView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import com.google.android.gms.auth.api.phone.SmsRetriever;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.tasks.Task;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsProperty;
import com.razorpay.AnalyticsUtil;
import com.razorpay.AppSignatureHelper;
import com.razorpay.AutoReadOtpHelper;
import com.razorpay.BaseCheckoutActivity;
import com.razorpay.BaseUtils;
import com.razorpay.Callback;
import com.razorpay.CardSaving;
import com.razorpay.CheckoutBridge;
import com.razorpay.CheckoutInteractor;
import com.razorpay.CheckoutOptions;
import com.razorpay.CheckoutPresenter;
import com.razorpay.CheckoutUtils;
import com.razorpay.ConfigCheckout;
import com.razorpay.GenericPluginCallback;
import com.razorpay.LifecycleContext;
import com.razorpay.Logger;
import com.razorpay.MagicBase;
import com.razorpay.Owl;
import com.razorpay.RazorpayExceptionHandler;
import com.razorpay.ResourceUtils;
import com.razorpay.ResponseObject;
import com.razorpay.RzpGPayInABoxExternalPlugin;
import com.razorpay.RzpPlugin;
import com.razorpay.SharedPreferenceUtil;
import com.razorpay.UpiTurboCheckout;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

class CheckoutPresenterImpl
implements CheckoutInteractor,
CheckoutPresenter {
    protected Activity activity;
    protected CheckoutView view;
    protected HashMap<String, String> pluginsMap;
    String merchantKey;
    CheckoutOptions checkoutOptions;
    private String dashOptions;
    private JSONObject dashOptionsJSON;
    private boolean isOnLoadTriggered = false;
    private String checkoutUrl;
    private String checkoutContent = "{}";
    private int paymentAttempts = 0;
    private boolean clearHistory;
    private boolean isPaymentSuccessful = false;
    private boolean isSmsReceiverRegistered = false;
    private long preloadCompleteDuration;
    private long preloadAbortDuration;
    private long checkoutLoadStartAt;
    private boolean isTwoWebViewFlow = false;
    private boolean isMagic = false;
    private int merchantLogoResourceId = 0;
    private boolean isActivityCreated = false;
    private Task<Void> loginOtpSmsTask;
    private AutoReadOtpHelper autoReadOtpHelper;
    private boolean sendSmsHash = false;
    private boolean allowRotation = false;
    private String sanitizedChallanEncodedString = "";
    private boolean isDynamicUrlLoaded = false;
    private String payment_id = null;
    private MagicBase magicBase = null;
    UpiTurboCheckout upiTurbo;
    private boolean nameNotFound_retryStatus = false;
    private Task<Void> automaticRetrievalTask;
    private Task<Void> userConsentTask;
    private Boolean internalUpiApp = Boolean.FALSE;
    private Boolean hideCircularLoader = Boolean.FALSE;
    private Boolean isTouchNGoPayment = Boolean.FALSE;
    private ArrayList<String> walletsWithAppToAppRedirection;
    BroadcastReceiver otpAutoReadBroadcast = new BroadcastReceiver(){

        public void onReceive(Context object, Intent intent) {
            if ("com.google.android.gms.auth.api.phone.SMS_RETRIEVED".equals(intent.getAction())) {
                object = intent.getExtras();
                intent = (Status)object.get("com.google.android.gms.auth.api.phone.EXTRA_STATUS");
                AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.AUTO_READ_OTP_SMS_RETRIEVER_API_RECEIVED_SMS);
                switch (intent.getStatusCode()) {
                    case 0: {
                        intent = (Intent)object.get("com.google.android.gms.auth.api.phone.EXTRA_CONSENT_INTENT");
                        if (intent == null) {
                            object = (String)object.get("com.google.android.gms.auth.api.phone.EXTRA_SMS_MESSAGE");
                            intent = new Intent();
                            intent.putExtra("com.google.android.gms.auth.api.phone.EXTRA_SMS_MESSAGE", (String)object);
                            CheckoutPresenterImpl.this.onActivityResultReceived(1001, -1, intent);
                            return;
                        }
                        object = CheckoutPresenterImpl.this.activity.getCallingActivity();
                        if (object == null || !object.getPackageName().equals(CheckoutPresenterImpl.this.activity.getPackageName()) || !CheckoutPresenterImpl.this.activity.getLocalClassName().contains("CheckoutActivity")) break;
                        try {
                            CheckoutPresenterImpl.this.activity.startActivityForResult(intent, 1001);
                            AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.AUTO_READ_OTP_SMS_RETRIEVER_API_SHOWED_ONE_TIME_CONSENT);
                            return;
                        }
                        catch (ActivityNotFoundException activityNotFoundException) {
                            AnalyticsUtil.reportError((String)"AutoReadOtpHelper", (String)"S0", (String)activityNotFoundException.getLocalizedMessage());
                            return;
                        }
                    }
                    case 15: {
                        AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.AUTO_READ_OTP_SMS_RETRIEVER_API_TIMEOUT);
                    }
                }
            }
        }
    };
    Queue<String> checkoutMessageQueue = new LinkedList<String>();
    private boolean isCheckoutLoaded = false;
    JSONObject integratedPluginsData = new JSONObject();
    private boolean truecallerLoginAttempt = false;

    void enableCheckoutLoaded() {
        this.isCheckoutLoaded = true;
    }

    void enableTwoViewFlow() {
        this.isTwoWebViewFlow = true;
    }

    public CheckoutPresenterImpl(Activity activity, CheckoutView checkoutView) {
        this.activity = activity;
        this.view = checkoutView;
    }

    public CheckoutPresenterImpl(Activity activity, CheckoutView checkoutView, HashMap<String, String> hashMap) {
        this.activity = activity;
        this.view = checkoutView;
        this.pluginsMap = hashMap;
    }

    @Override
    public void setOptionsWithDynamicUrl(Context context, Bundle bundle, boolean bl, final BaseCheckoutActivity.SetOptionsCallback setOptionsCallback) {
        if (SharedPreferenceUtil.getValue((Context)context, (String)"optimizer_hosted") != null) {
            this.checkoutUrl = CheckoutUtils.getCheckoutUrlWithOptions(this.checkoutOptions, null);
            this.isDynamicUrlLoaded = true;
            setOptionsCallback.onOptionsSet();
            return;
        }
        CheckoutUtils.isFeatureEnabled(this.checkoutOptions.getMerchantKey(), "optimizer_hosted", new Callback(){

            public void run(ResponseObject responseObject) {
                if (responseObject.getResponseResult().equalsIgnoreCase("true")) {
                    CheckoutPresenterImpl.this.checkoutUrl = CheckoutUtils.getCheckoutUrlWithOptions(CheckoutPresenterImpl.this.checkoutOptions, null);
                    CheckoutPresenterImpl.this.isDynamicUrlLoaded = true;
                    setOptionsCallback.onOptionsSet();
                    return;
                }
                setOptionsCallback.onFeatureDisabled();
            }
        });
    }

    @Override
    public boolean setOptions(Bundle bundle, boolean bl) {
        this.isActivityCreated = bl;
        if (bundle == null) {
            AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CALLING_ON_INVALID_PARAMETER);
            this.destroyActivity(0, "Invalid parameters passed");
            return false;
        }
        this.checkoutOptions = new CheckoutOptions(bundle.getString("OPTIONS"));
        CheckoutPresenterImpl checkoutPresenterImpl = this;
        checkoutPresenterImpl.setupExternalPlugins(checkoutPresenterImpl.pluginsMap);
        JSONObject jSONObject = this.checkoutOptions.getAsJson();
        if (jSONObject.has("retry")) {
            ConfigCheckout.getInstance().setRetryConfigFromOptions(jSONObject);
        }
        if (jSONObject.has("hideNativeLoader")) {
            this.hideCircularLoader = Boolean.TRUE;
        }
        this.merchantKey = this.checkoutOptions.getMerchantKey();
        this.sendSmsHash = this.checkoutOptions.shouldSendHashForSms();
        this.allowRotation = this.checkoutOptions.allowRotation();
        this.merchantLogoResourceId = bundle.getInt("IMAGE", 0);
        this.checkoutOptions.modifyMerchantOptions(this.activity, this.merchantLogoResourceId);
        CheckoutUtils.addAddons((Context)this.activity, this.merchantKey);
        jSONObject.has("ep");
        this.checkoutUrl = CheckoutUtils.getCheckoutUrlWithOptions(this.checkoutOptions);
        if (this.checkoutUrl == null) {
            AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CALLING_ON_INVALID_URL);
            this.destroyActivity(3, "Invalid URL. Please make sure you've set public key");
        }
        if (!bl) {
            String string;
            this.checkoutOptions.logMerchantOptions();
            this.dashOptions = CheckoutUtils.getMerchantOptions((Context)this.activity, this.merchantKey);
            if (this.dashOptions != null) {
                try {
                    this.dashOptionsJSON = new JSONObject(this.dashOptions);
                }
                catch (Exception exception) {
                    AnalyticsUtil.reportError((String)"CxPsntrImpl", (String)"S0", (String)exception.getLocalizedMessage());
                }
            }
            if ((string = bundle.getString("FRAMEWORK")) != null) {
                AnalyticsUtil.addProperty((String)"framework", (AnalyticsProperty)new AnalyticsProperty(string, AnalyticsProperty.Scope.ORDER));
            }
            AnalyticsUtil.setFramework((String)string);
            string = bundle.getString("FRAMEWORK_VERSION");
            if (string != null) {
                AnalyticsUtil.addProperty((String)"frameworkVersion", (AnalyticsProperty)new AnalyticsProperty(string, AnalyticsProperty.Scope.ORDER));
            }
            if (bundle.getBoolean("DISABLE_FULL_SCREEN", false)) {
                CheckoutUtils.disableFullScreenMode(this.activity);
            }
            if (bundle.containsKey("PRELOAD_COMPLETE_DURATION")) {
                this.preloadCompleteDuration = bundle.getLong("PRELOAD_COMPLETE_DURATION");
            }
            if (bundle.containsKey("PRELOAD_ABORT_DURATION")) {
                this.preloadAbortDuration = bundle.getLong("PRELOAD_ABORT_DURATION");
            }
        } else {
            this.dashOptions = bundle.getString("DASH_OPTIONS");
            if (bundle.getBoolean("DISABLE_FULL_SCREEN", false)) {
                CheckoutUtils.disableFullScreenMode(this.activity);
            }
        }
        Object object = ConfigCheckout.getInstance();
        this.walletsWithAppToAppRedirection = BaseUtils.getAppsWithPackageNames((Context)this.activity, (ArrayList)object.getWalletsWithAppToAppRedirection());
        object = new HashMap<String, ArrayList<String>>();
        object.put("app:list", this.walletsWithAppToAppRedirection);
        AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CHECKOUT_SUPPORTED_WALLETS_IDENTIFIED, (JSONObject)AnalyticsUtil.getJSONResponse((Map)object));
        return true;
    }

    void injectJs(String string) {
        this.view.loadUrl(1, String.format("javascript: %s", string));
    }

    @Override
    public void onActivityResultReceived(int n, int n2, Intent object) {
        block38: {
            if (n == 77 && n2 == -1) {
                if (object != null && object.getData() != null) {
                    Uri uri = object.getData();
                    Object object2 = this.sanitizedChallanEncodedString;
                    try {
                        object = this.activity.getContentResolver().openOutputStream(uri);
                        try {
                            if (object != null) {
                                object2 = Base64.decode((String)object2, (int)0);
                                ((OutputStream)object).write((byte[])object2);
                                ((OutputStream)object).flush();
                                BaseUtils.openPdfFile((Activity)this.activity, (Uri)uri);
                            }
                        }
                        finally {
                            if (object != null) {
                                ((OutputStream)object).close();
                            }
                            break block38;
                        }
                    }
                    catch (IOException iOException) {
                        object = iOException;
                        iOException.printStackTrace();
                    }
                    return;
                }
            } else if (n == 78 && n2 == -1) {
                if (object != null && object.getData() != null) {
                    Uri uri = object.getData();
                    Object object3 = this.sanitizedChallanEncodedString;
                    try {
                        object = this.activity.getContentResolver().openOutputStream(uri);
                        try {
                            if (object != null) {
                                object3 = Base64.decode((String)object3, (int)0);
                                ((OutputStream)object).write((byte[])object3);
                                ((OutputStream)object).flush();
                                BaseUtils.openFile((Activity)this.activity, (Uri)uri);
                            }
                        }
                        finally {
                            if (object != null) {
                                ((OutputStream)object).close();
                            }
                            break block38;
                        }
                    }
                    catch (IOException iOException) {
                        object = iOException;
                        iOException.printStackTrace();
                    }
                    return;
                }
            } else if (n == 1001) {
                if (n2 == -1) {
                    AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.AUTO_READ_OTP_SMS_RETRIEVER_API_RECEIVED_SMS);
                    String string = object.getStringExtra("com.google.android.gms.auth.api.phone.EXTRA_SMS_MESSAGE");
                    if (this.isCheckoutLoaded) {
                        try {
                            JSONObject jSONObject = new JSONObject();
                            jSONObject.put("sender", (Object)"razorpay");
                            jSONObject.put("message", (Object)string);
                            this.injectJs(String.format("OTPElf.showOTP('%s','%s')", string, "razorpay"));
                            AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.AUTO_READ_OTP_SMS_RETRIEVER_API_OTP_POPULATION_JS);
                        }
                        catch (JSONException jSONException) {
                            AnalyticsUtil.reportError((String)"CxPsntrImpl", (String)"S0", (String)jSONException.getLocalizedMessage());
                            jSONException.printStackTrace();
                        }
                    }
                } else {
                    AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.AUTO_READ_OTP_SMS_RETRIEVER_API_CONSENT_DECLINED);
                }
                if (this.userConsentTask != null && !this.userConsentTask.isSuccessful()) {
                    this.startSmsRetrievers();
                    return;
                }
            } else {
                if (n == 99) {
                    JSONObject jSONObject = BaseUtils.getJSONFromIntentData((Intent)object);
                    if (jSONObject.toString().contains("\"from\":\"razorpay\"") && AnalyticsUtil.getKeyType().equalsIgnoreCase("test") && this.internalUpiApp.booleanValue()) {
                        this.destroyActivity(0, "");
                        return;
                    }
                    String string = String.format("javascript: upiIntentResponse(%s)", jSONObject.toString());
                    this.loadResultToWebView(jSONObject, string);
                    return;
                }
                if (n == 20) {
                    try {
                        JSONObject jSONObject = new JSONObject("{'data':" + n2 + "}");
                        jSONObject.put("provider", (Object)"CRED");
                        String string = String.format("javascript:externalAppResponse(%s)", jSONObject.toString());
                        this.loadResultToWebView(jSONObject, string);
                        return;
                    }
                    catch (JSONException jSONException) {
                        AnalyticsUtil.reportError((String)"CxPsntrImpl", (String)"S0", (String)jSONException.getMessage());
                    }
                }
            }
        }
    }

    private void loadResultToWebView(JSONObject jSONObject, String string) {
        HashMap<String, JSONObject> hashMap = new HashMap<String, JSONObject>();
        hashMap.put("result", jSONObject);
        AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.NATIVE_INTENT_ONACTIVITY_RESULT, (JSONObject)AnalyticsUtil.getJSONResponse(hashMap));
        if (this.isCheckoutLoaded) {
            this.view.loadUrl(1, string);
            return;
        }
        if (this.checkoutMessageQueue == null) {
            this.checkoutMessageQueue = new LinkedList<String>();
        }
        this.checkoutMessageQueue.add(string);
    }

    private void setupExternalPlugins(HashMap<String, String> jSONObject) {
        this.integratedPluginsData = new JSONObject();
        if (jSONObject != null && jSONObject.containsKey("com.razorpay.plugin.upi_turbo")) {
            try {
                jSONObject = this.checkoutOptions.getAsJson();
                if (!jSONObject.has("prefill") || !jSONObject.getJSONObject("prefill").has("contact")) {
                    return;
                }
                this.integratedPluginsData.put("upi_turbo", true);
                CheckoutUtils.showLoader((Context)this.activity);
                this.upiTurbo = !jSONObject.has("order_id") ? new UpiTurboCheckout(this.activity, jSONObject.getJSONObject("prefill").getString("contact"), this.checkoutOptions.getColor(), null) : new UpiTurboCheckout(this.activity, jSONObject.getJSONObject("prefill").getString("contact"), this.checkoutOptions.getColor(), jSONObject.getString("order_id"));
                this.upiTurbo.getLinkedUpiAccounts(new GenericPluginCallback(){

                    public void onSuccess(@NonNull Object object) {
                        try {
                            CheckoutPresenterImpl.this.integratedPluginsData.remove("upi_turbo");
                            CheckoutPresenterImpl.this.integratedPluginsData.put("upiTurboData", object);
                            CheckoutPresenterImpl.this.onLoad();
                            return;
                        }
                        catch (JSONException jSONException) {
                            return;
                        }
                    }

                    public void onError(@NonNull JSONObject jSONObject) {
                        try {
                            CheckoutPresenterImpl.this.integratedPluginsData.remove("upi_turbo");
                            CheckoutPresenterImpl.this.integratedPluginsData.put("upiTurboData", (Object)jSONObject);
                            CheckoutPresenterImpl.this.onLoad();
                            return;
                        }
                        catch (JSONException jSONException) {
                            return;
                        }
                    }
                }, null);
                return;
            }
            catch (JSONException jSONException) {
                this.integratedPluginsData.remove("upi_turbo");
                this.onLoad();
            }
        }
    }

    @Override
    public void sendExternalSdkResponse(String string) {
        string = String.format("javascript: window.externalSDKResponse(%s)", string);
        if (this.isCheckoutLoaded) {
            this.view.loadUrl(1, string);
            return;
        }
        if (this.checkoutMessageQueue == null) {
            this.checkoutMessageQueue = new LinkedList<String>();
        }
        this.checkoutMessageQueue.add(string);
    }

    @Override
    public void unregisterReceivers() {
        try {
            if (this.otpAutoReadBroadcast != null) {
                this.activity.unregisterReceiver(this.otpAutoReadBroadcast);
                this.isSmsReceiverRegistered = false;
            }
            return;
        }
        catch (Exception exception) {
            this.isSmsReceiverRegistered = false;
            AnalyticsUtil.reportError((String)"CxPrntrImpl", (String)"S2", (String)exception.getMessage());
            return;
        }
    }

    @Override
    public String getSdkPlugins() {
        HashMap hashMap = BaseUtils.getAllPluginsFromManifest((Context)this.activity);
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("isAmazonPluginIntegrated", false);
            jSONObject.put("isGooglePayPluginIntegrated", false);
            if (hashMap == null || hashMap.size() == 0) {
                return jSONObject.toString();
            }
            for (String string : hashMap.values()) {
                if (hashMap.size() > 0 && string.equalsIgnoreCase("com.razorpay.RazorpayAmazon")) {
                    jSONObject.put("isAmazonPluginIntegrated", true);
                }
                if (hashMap.size() > 0 && string.equalsIgnoreCase("com.razorpay.RzpGpayMerged")) {
                    jSONObject.put("isGooglePayPluginIntegrated", true);
                }
                if (hashMap.size() <= 0 || !string.equalsIgnoreCase("com.razorpay.RazorpayTurbo")) continue;
                jSONObject.put("isTurboPluginIntegrated", true);
            }
        }
        catch (JSONException jSONException) {
            AnalyticsUtil.reportError((String)"CxPsntrImpl", (String)"S0", (String)jSONException.getLocalizedMessage());
        }
        return jSONObject.toString();
    }

    @Override
    public void onCheckoutRendered() {
        Logger.d((String)("LOAD_TIME onCheckoutRendered " + System.currentTimeMillis()));
        AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CHECKOUT_RENDERED_COMPLETE);
    }

    @Override
    public void getPdfString(String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2) && string2.contains("base64,")) {
            this.sanitizedChallanEncodedString = string2.split("base64,")[1];
            try {
                string2 = new Intent("android.intent.action.CREATE_DOCUMENT");
                string2.addCategory("android.intent.category.OPENABLE");
                string2.setType("application/pdf");
                string2.putExtra("android.intent.extra.TITLE", string);
                this.activity.startActivityForResult((Intent)string2, 77);
                return;
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                Logger.d((String)"No app found to handle PDF saving");
            }
        }
    }

    @Override
    public void getDownloadFileString(String string, String string2, String string3) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            if (string2.contains("base64,")) {
                try {
                    this.sanitizedChallanEncodedString = string2.split("base64,")[1];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    AnalyticsUtil.reportError((String)CheckoutPresenterImpl.class.getSimpleName(), (String)"S0", (String)("getDownloadFileString: " + arrayIndexOutOfBoundsException.getMessage()));
                    return;
                }
            } else {
                this.sanitizedChallanEncodedString = string2;
            }
            string2 = BaseUtils.getType((String)string3);
            if (string2.startsWith("image/")) {
                this.saveImageToGallery(string, this.sanitizedChallanEncodedString, string3);
                return;
            }
            try {
                string3 = new Intent("android.intent.action.CREATE_DOCUMENT");
                string3.addCategory("android.intent.category.OPENABLE");
                string3.setType(string2);
                string3.putExtra("android.intent.extra.TITLE", string);
                this.activity.startActivityForResult((Intent)string3, 78);
                return;
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                Logger.d((String)"No app found to handle file saving");
            }
        }
    }

    private void saveImageToGallery(String string, String object, String object2) {
        try {
            object = Base64.decode((String)object, (int)0);
            ContentValues contentValues = new ContentValues();
            contentValues.put("_display_name", string + "." + (String)object2);
            contentValues.put("mime_type", BaseUtils.getType((String)object2));
            if (Build.VERSION.SDK_INT >= 29) {
                contentValues.put("is_pending", Integer.valueOf(1));
                contentValues.put("relative_path", "DCIM");
            }
            if ((string = this.activity.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues)) != null) {
                object2 = this.activity.getContentResolver().openOutputStream((Uri)string);
                try {
                    if (object2 != null) {
                        ((OutputStream)object2).write((byte[])object);
                        ((OutputStream)object2).flush();
                    }
                }
                finally {
                    if (object2 != null) {
                        ((OutputStream)object2).close();
                    }
                }
                if (Build.VERSION.SDK_INT >= 29) {
                    contentValues.clear();
                    contentValues.put("is_pending", Integer.valueOf(0));
                    this.activity.getContentResolver().update((Uri)string, contentValues, null, null);
                }
                this.activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        Toast.makeText((Context)CheckoutPresenterImpl.this.activity, (CharSequence)"Image saved to gallery", (int)0).show();
                    }
                });
            }
            return;
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError((String)"CxPsntrImpl", (String)"S2", (String)("Failed to save image: " + exception.getMessage()));
            Logger.d((String)("Failed to save image to gallery: " + exception.getMessage()));
            return;
        }
    }

    @Override
    @SuppressLint(value={"UnspecifiedRegisterReceiverFlag"})
    public void registerSmsListener() {
        try {
            IntentFilter intentFilter = new IntentFilter("com.google.android.gms.auth.api.phone.SMS_RETRIEVED");
            if (Build.VERSION.SDK_INT >= 33) {
                this.activity.registerReceiver(this.otpAutoReadBroadcast, intentFilter, "com.google.android.gms.auth.api.phone.permission.SEND", null, 2);
            } else {
                this.activity.registerReceiver(this.otpAutoReadBroadcast, intentFilter, "com.google.android.gms.auth.api.phone.permission.SEND", null);
            }
            this.isSmsReceiverRegistered = true;
            return;
        }
        catch (Exception exception) {
            this.isSmsReceiverRegistered = false;
            return;
        }
    }

    @Override
    public void unregisterSmsListener() {
        this.unregisterReceivers();
    }

    @Override
    public CheckoutOptions getCheckoutOptions() {
        return this.checkoutOptions;
    }

    @Override
    public void setUpAddOn() {
    }

    @Override
    public void loadForm(String string) {
        if (this.paymentAttempts != 0) {
            AnalyticsUtil.postData();
        }
        ++this.paymentAttempts;
        AnalyticsUtil.addProperty((String)"payment_attempt", (AnalyticsProperty)new AnalyticsProperty(this.paymentAttempts, AnalyticsProperty.Scope.ORDER));
        this.clearHistory = true;
        string = this.checkoutUrl + string;
        string = string.replace(" ", "%20");
        this.view.loadUrl(1, string);
    }

    @Override
    public void loadFetchedForm(String string, String string2) {
        if (this.paymentAttempts != 0) {
            AnalyticsUtil.postData();
        }
        ++this.paymentAttempts;
        AnalyticsUtil.addProperty((String)"payment_attempt", (AnalyticsProperty)new AnalyticsProperty(this.paymentAttempts, AnalyticsProperty.Scope.ORDER));
        this.clearHistory = true;
        this.view.loadDataWithBaseURL(1, string, string2, "text/html", "UTF-8", null);
    }

    @Override
    public void showRetryDialog(final int n, final String string) {
        this.view.loadUrl(1, "about:blank");
        final AlertDialog alertDialog = new AlertDialog.Builder((Context)this.activity).create();
        alertDialog.setTitle((CharSequence)"Trouble Connecting");
        alertDialog.setMessage((CharSequence)"Please check your internet connection & restart the payment process.\n\nRetrying in 5 seconds");
        alertDialog.setButton(-2, (CharSequence)"Cancel Payment", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n2) {
                alertDialog.dismiss();
                CheckoutPresenterImpl.this.destroyActivity(n, string);
            }
        });
        alertDialog.show();
        new CountDownTimer(5000L, 1000L){

            public void onTick(long l) {
                if (l > 0L) {
                    alertDialog.setMessage((CharSequence)String.format("Please reset network settings & restart the payment process.\n\nRetrying in %s second(s)", l / 1000L));
                }
            }

            public void onFinish() {
                alertDialog.dismiss();
                CheckoutPresenterImpl.this.loadForm("");
            }
        }.start();
    }

    @Override
    public void onResumeTriggered() {
        if (this.truecallerLoginAttempt && this.view.isWebViewVisible(1)) {
            try {
                String string = String.format("javascript: window.externalSDKResponse(%s)", new JSONObject().put("provider", (Object)"truecaller"));
                this.view.loadUrl(1, string);
                this.truecallerLoginAttempt = false;
                return;
            }
            catch (JSONException jSONException) {
                throw new RuntimeException(jSONException);
            }
        }
    }

    @Override
    public List<String> getWalletsWithAppToAppRedirection() {
        return this.walletsWithAppToAppRedirection;
    }

    @Override
    public boolean shouldOverrideUrlLoading(WebView webView, String string) {
        Object object;
        List<String> list = this.getWalletsWithAppToAppRedirection();
        if (string.startsWith("razorpay://")) {
            try {
                object = Uri.parse((String)string);
                object = object.getQueryParameter("fallback");
                if (object != null) {
                    webView.loadUrl((String)object);
                    return true;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (!ConfigCheckout.getInstance().isTNGRedirectionEnabled() || !this.isTouchNGoPayment.booleanValue()) {
            return false;
        }
        if (string.contains("tngdigital")) {
            if (!list.contains("my.com.tngdigital.ewallet")) {
                AnalyticsUtil.addProperty((String)"url", (AnalyticsProperty)new AnalyticsProperty(string, AnalyticsProperty.Scope.PAYMENT));
                AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CHECKOUT_TNG_WALLET_WEB_FLOW_START);
                return false;
            }
            object = "my.com.tngdigital.ewallet";
            this.callNativeIntent(string, (String)object);
            AnalyticsUtil.addProperty((String)"url", (AnalyticsProperty)new AnalyticsProperty(string, AnalyticsProperty.Scope.PAYMENT));
            AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CHECKOUT_WEBVIEW_URL_OVERRIDE);
            return true;
        }
        return false;
    }

    @Override
    public void showLoaderDialog(final int n, final String string) {
        this.view.loadUrl(1, "about:blank");
        if (!this.activity.isFinishing()) {
            final AlertDialog alertDialog = new AlertDialog.Builder((Context)this.activity).create();
            alertDialog.setCancelable(false);
            alertDialog.setTitle((CharSequence)"Trouble Connecting");
            alertDialog.setMessage((CharSequence)"Unable to connect to Razorpay.\n\nPlease check your internet connection and/or disconnect from VPN if connected and hit Try Again");
            alertDialog.setButton(-1, (CharSequence)"Try again", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n) {
                    CheckoutPresenterImpl.this.loadForm("");
                }
            });
            alertDialog.setButton(-2, (CharSequence)"Cancel Payment", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n2) {
                    alertDialog.dismiss();
                    CheckoutPresenterImpl.this.destroyActivity(n, string);
                }
            });
            alertDialog.show();
        }
    }

    @Override
    public void passPrefillToSegment() {
        String string = this.checkoutOptions.getPrefilledEmail();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            AnalyticsUtil.addProperty((String)"email", (AnalyticsProperty)new AnalyticsProperty(string, AnalyticsProperty.Scope.ORDER));
        }
        if (!TextUtils.isEmpty((CharSequence)(string = this.checkoutOptions.getPrefilledContact()))) {
            AnalyticsUtil.addProperty((String)"contact", (AnalyticsProperty)new AnalyticsProperty(string, AnalyticsProperty.Scope.ORDER));
        }
    }

    @Override
    public void handleCardSaving() {
        AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CARD_SAVING_START);
        CardSaving.fetchDeviceTokenFromOtherAppsIfRequired(this.activity.getApplicationContext());
    }

    @Override
    public void saveInstanceState(Bundle bundle) {
        if (this.merchantLogoResourceId != 0) {
            bundle.putString("OPTIONS", this.checkoutOptions.getOptionsWithoutImage());
            bundle.putInt("IMAGE", this.merchantLogoResourceId);
        } else {
            bundle.putString("OPTIONS", this.checkoutOptions.getAsString());
        }
        bundle.putString("DASH_OPTIONS", this.dashOptions);
        if (this.activity.getIntent() != null) {
            bundle.putBoolean("DISABLE_FULL_SCREEN", this.activity.getIntent().getBooleanExtra("DISABLE_FULL_SCREEN", false));
        }
        if ((bundle = CheckoutUtils.checkoutActivityStateBundleToJSONObject(bundle)) != null) {
            SharedPreferenceUtil.setValue((Context)this.activity, (String)"SAVED_STATE_BUNDLE_MAP", (String)bundle.toString());
        }
    }

    @Override
    public void setCheckoutLoadStartAt() {
        this.checkoutLoadStartAt = System.nanoTime();
    }

    @Override
    public void destroyActivity(int n, String string) {
        AnalyticsUtil.addProperty((String)"destroy_resultCode", (AnalyticsProperty)new AnalyticsProperty(String.valueOf(n), AnalyticsProperty.Scope.ORDER));
        AnalyticsUtil.addProperty((String)"destroy_result", (AnalyticsProperty)new AnalyticsProperty(string, AnalyticsProperty.Scope.ORDER));
        AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.INTERNAL_DESTROY_METHOD_CALLED);
        this.cleanUpOnDestroy();
        this.view.destroy(n, string);
    }

    @Override
    public void onCheckoutBackPress() {
        AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CHECKOUT_SOFT_BACK_PRESSED);
        this.destroyActivity(0, BaseUtils.getPaymentCancelledResponse((String)BaseUtils.getInstance().getMetadata()));
    }

    protected void enableAddon(JSONObject jSONObject) {
        try {
            if (jSONObject.has("magic")) {
                this.isMagic = jSONObject.getBoolean("magic");
                if (this.magicBase != null) {
                    this.magicBase.setMagicEnabled(this.isMagic);
                }
                AnalyticsUtil.addProperty((String)"is_magic", (AnalyticsProperty)new AnalyticsProperty(this.isMagic, AnalyticsProperty.Scope.PAYMENT));
            }
            return;
        }
        catch (JSONException jSONException) {
            AnalyticsUtil.reportError((String)"CxPsntrImpl", (String)"S0", (String)jSONException.getLocalizedMessage());
            return;
        }
    }

    @Override
    public void invokePopup(final String string) {
        this.isTwoWebViewFlow = true;
        try {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String string2;
                        JSONObject jSONObject = new JSONObject(string);
                        CheckoutPresenterImpl.this.enableAddon(jSONObject);
                        if (jSONObject.has("content")) {
                            string2 = jSONObject.getString("content");
                            CheckoutPresenterImpl.this.view.loadDataWithBaseURL(2, "about:blank", string2, "text/html", "UTF-8", null);
                        }
                        if (jSONObject.has("url")) {
                            string2 = jSONObject.getString("url");
                            CheckoutPresenterImpl.this.view.loadUrl(2, string2);
                        }
                        if (jSONObject.has("focus") && !jSONObject.getBoolean("focus")) {
                            CheckoutPresenterImpl.this.view.makeWebViewVisible(1);
                        } else {
                            CheckoutPresenterImpl.this.view.makeWebViewVisible(2);
                        }
                    }
                    catch (Exception exception) {
                        AnalyticsUtil.reportError((String)"CxPsntrImpl", (String)"S0", (String)exception.getLocalizedMessage());
                    }
                    AnalyticsUtil.addProperty((String)"two_webview_flow", (AnalyticsProperty)new AnalyticsProperty(true, AnalyticsProperty.Scope.PAYMENT));
                }
            });
            return;
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError((String)"CxPsntrImpl", (String)"S0", (String)exception.getLocalizedMessage());
            return;
        }
    }

    @Override
    public void fetchCondfig() {
        ConfigCheckout.IS_MAGIC_ENABLED = this.isMagicPresent();
        ConfigCheckout.fetchConfig((Context)this.activity, this.merchantKey);
    }

    @Override
    public boolean isMagicPresent() {
        return false;
    }

    @Override
    public void onProgressChanges(int n, int n2) {
        switch (n) {
            case 1: {
                this.view.showProgressBar(n2);
                return;
            }
            case 2: {
                if (this.magicBase == null || !this.isMagic) break;
                this.magicBase.onProgressChanged(n2);
            }
        }
    }

    @Override
    public void onPageStarted(int n, WebView webView, String string) {
        switch (n) {
            case 1: {
                return;
            }
            case 2: {
                if (this.magicBase == null || !this.isMagic) break;
                this.magicBase.onPageStarted(webView, string);
            }
        }
    }

    @Override
    public void onPageFinished(int n, WebView webView, String string) {
        switch (n) {
            case 1: {
                this.primaryWebviewPageFinished(string, webView);
                if (string.contains(this.checkoutUrl)) break;
                CheckoutUtils.dismissLoader();
                return;
            }
            case 2: {
                if (this.magicBase == null || !this.isMagic) break;
                this.magicBase.onPageFinished(webView, string);
            }
        }
    }

    private void sendQueuedMessagesToCheckout() {
        if (this.checkoutMessageQueue != null && !this.checkoutMessageQueue.isEmpty()) {
            for (String string : this.checkoutMessageQueue) {
                this.view.loadUrl(1, string);
            }
            this.checkoutMessageQueue.clear();
        }
    }

    protected void primaryWebviewPageFinished(String object, WebView webView) {
        long l = System.nanoTime();
        this.view.hideProgressBar();
        if (((String)object).contains("https://api.razorpay.com") && ((String)object).contains("android") && ((String)object).contains("1.7.2")) {
            if (this.paymentAttempts == 1) {
                this.isCheckoutLoaded = true;
                this.sendQueuedMessagesToCheckout();
                object = new HashMap();
                long l2 = l - this.checkoutLoadStartAt;
                object.put("checkout_load_duration", l2);
                Logger.d((String)("preload ; checkout loaded in " + BaseUtils.nanoTimeToSecondsString((long)l2, (int)2) + " sec."));
                Logger.d((String)("LOAD_TIME : checkout loaded in " + BaseUtils.nanoTimeToSecondsString((long)l2, (int)2) + " sec."));
                Logger.d((String)("Checkout loaded in " + BaseUtils.nanoTimeToSecondsString((long)l2, (int)2) + " sec."));
                if (this.preloadCompleteDuration > 0L) {
                    object.put("preload_finish_duration", this.preloadCompleteDuration);
                    Logger.d((String)("Preload was completed in " + BaseUtils.nanoTimeToSecondsString((long)this.preloadCompleteDuration, (int)2) + " sec."));
                } else if (this.preloadAbortDuration > 0L) {
                    object.put("preload_abort_duration", this.preloadAbortDuration);
                    Logger.d((String)("Preload was aborted in " + BaseUtils.nanoTimeToSecondsString((long)this.preloadAbortDuration, (int)2) + " sec."));
                }
                long l3 = this.preloadCompleteDuration - l2;
                if (l3 > 0L) {
                    object.put("time_shaved_off", l3);
                    Logger.d((String)("Load time shaved is " + BaseUtils.nanoTimeToSecondsString((long)l3, (int)2) + " sec."));
                }
                AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CHECKOUT_LOADED, (JSONObject)AnalyticsUtil.getJSONResponse((Map)object));
            }
            if (this.clearHistory) {
                this.view.clearWebViewHistory(1);
                this.clearHistory = false;
            }
        }
    }

    @Override
    public String getProgressBarColor() {
        String string = null;
        try {
            if (this.checkoutOptions.getAsJson() == null) {
                throw new Exception("No options defined");
            }
            JSONObject jSONObject = this.checkoutOptions.getAsJson();
            JSONObject jSONObject2 = jSONObject.getJSONObject("theme");
            string = jSONObject2.getString("color");
            Color.parseColor((String)string);
        }
        catch (Exception exception) {
            try {
                if (this.dashOptionsJSON == null) {
                    throw new Exception("No dash options defined");
                }
                JSONObject jSONObject = this.dashOptionsJSON.getJSONObject("theme");
                string = jSONObject.getString("color");
                Color.parseColor((String)string);
            }
            catch (Exception exception2) {
                AnalyticsUtil.reportError((String)"CxPsntrImpl", (String)"S2", (String)exception2.getMessage());
            }
            AnalyticsUtil.reportError((String)"CxPsntrImpl", (String)"S2", (String)exception.getMessage());
        }
        return string;
    }

    @Override
    public void onRequestPermissionsResult(int n, String[] stringArray, int[] nArray) {
    }

    @Override
    public void sendOtpPermissionCallback(final boolean bl) {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("granted", bl);
                    CheckoutPresenterImpl.this.view.loadUrl(1, String.format("javascript: otpPermissionCallback(%s)", jSONObject.toString()));
                    return;
                }
                catch (Exception exception) {
                    AnalyticsUtil.reportError((String)"CxPsntrImpl", (String)"S2", (String)exception.getLocalizedMessage());
                    return;
                }
            }
        });
    }

    protected void addOnFlowEnd() {
        if (this.magicBase != null) {
            this.magicBase.paymentFlowEnd();
        }
    }

    @Override
    public void cleanUpOnDestroy() {
        try {
            this.markPaymentCancelled();
            this.clearAllPlugins();
            this.unregisterReceivers();
            RazorpayExceptionHandler.unregister();
            return;
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError((String)"CxPsntrImpl", (String)"S2", (String)exception.getLocalizedMessage());
            return;
        }
    }

    private void clearAllPlugins() {
        if (this.pluginsMap != null && this.upiTurbo != null && this.pluginsMap.containsKey("com.razorpay.plugin.upi_turbo")) {
            this.upiTurbo.destroy();
        }
    }

    private void markPaymentCancelled() {
        if (this.payment_id == null || this.isPaymentSuccessful) {
            return;
        }
        try {
            String string = BaseUtils.constructBasicAuth((String)this.merchantKey);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("Authorization", "Basic " + string);
            string = "https://api.razorpay.com/v1/payments/" + this.payment_id + "/cancel?platform=android_sdk";
            Logger.d((String)"Sending cancel request");
            Owl.get((String)string, hashMap, (Callback)new Callback(){

                public void run(ResponseObject responseObject) {
                    Logger.d((String)("API Cancel hit: " + responseObject.getResponseResult()));
                }
            });
            this.payment_id = null;
            return;
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError((String)"CxPsntrImpl", (String)"S0", (String)exception.getLocalizedMessage());
            Logger.d((String)"Exception in cancel req", (Throwable)exception);
            return;
        }
    }

    @Override
    public void backPressed(final Map<String, Object> map) {
        AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CHECKOUT_HARD_BACK_PRESSED, (JSONObject)AnalyticsUtil.getJSONResponse(map));
        if (CheckoutUtils.isCheckoutUrl(this.view.getWebView(1)) && !this.view.isWebViewVisible(2)) {
            this.view.loadUrl(1, "javascript: window.backPressed ? window.backPressed('onCheckoutBackPress') : CheckoutBridge.onCheckoutBackPress();");
            map.put("in_checkout", "true");
            return;
        }
        if (!ConfigCheckout.getInstance().isBackButtonAlertEnabled()) {
            this.destroyActivity(0, "BackPressed");
            return;
        }
        CheckoutUtils.showDialog((Context)this.activity, ConfigCheckout.getInstance().getBackButtonAlertMessage(), ConfigCheckout.getInstance().getBackButtonPositiveText(), ConfigCheckout.getInstance().getBackButtonNegativeText(), new CheckoutUtils.BackButtonDialogCallback(){

            @Override
            public void onPositiveButtonClick() {
                Logger.d((String)"ALERT Don't cancel");
                AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.ALERT_PAYMENT_CONTINUE, (JSONObject)AnalyticsUtil.getJSONResponse((Map)map));
            }

            @Override
            public void onNegativeButtonClick() {
                Logger.d((String)"ALERT Cancel");
                AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.ALERT_PAYMENT_CANCELLED, (JSONObject)AnalyticsUtil.getJSONResponse((Map)map));
                if (CheckoutPresenterImpl.this.isTwoWebViewFlow) {
                    CheckoutPresenterImpl.this.view.makeWebViewVisible(1);
                    CheckoutPresenterImpl.this.view.loadUrl(2, "about:blank");
                    CheckoutPresenterImpl.this.view.loadUrl(1, "javascript: window.onpaymentcancel()");
                } else {
                    CheckoutPresenterImpl.this.handleRetry(null);
                    CheckoutPresenterImpl.this.markPaymentCancelled();
                }
                CheckoutPresenterImpl.this.clearAllPlugins();
                CheckoutPresenterImpl.this.isTwoWebViewFlow = false;
            }
        });
    }

    @Override
    public void onLoad() {
        if (this.integratedPluginsData.has("upi_turbo")) {
            return;
        }
        CheckoutUtils.dismissLoader();
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                String string = CheckoutPresenterImpl.this.getHandleMessageFormattedString();
                CheckoutPresenterImpl.this.view.loadUrl(1, string);
                CheckoutPresenterImpl.this.view.loadUrl(1, String.format("javascript: CheckoutBridge.sendAnalyticsData({data: %s})", AnalyticsUtil.getAnalyticsDataForCheckout((Context)CheckoutPresenterImpl.this.activity).toString()));
                CheckoutPresenterImpl.this.isCheckoutLoaded = true;
            }
        });
        this.startSmsRetrievers();
    }

    private void startSmsRetrievers() {
        this.automaticRetrievalTask = SmsRetriever.getClient((Activity)this.activity).startSmsRetriever();
        this.userConsentTask = SmsRetriever.getClient((Activity)this.activity).startSmsUserConsent(null);
    }

    protected JSONObject getOptionsForHandleMessage() {
        JSONObject jSONObject = new JSONObject();
        try {
            Object object;
            jSONObject.put("options", (Object)this.checkoutOptions.getAsJson());
            jSONObject.put("data", (Object)this.checkoutContent);
            jSONObject.put("id", (Object)AnalyticsUtil.getLocalOrderId());
            jSONObject.put("pdf_download_supported", true);
            jSONObject.put("file_download_supported", true);
            jSONObject.put("key_id", (Object)this.merchantKey);
            jSONObject.put("externalSDKs", (Object)new JSONObject());
            if (this.checkoutOptions.shouldSendHashForSms()) {
                object = new AppSignatureHelper((Context)this.activity);
                jSONObject.put("sms_hash", object.getAppSignatures().get(0));
            }
            jSONObject.put("upi_intents_data", (Object)CheckoutUtils.getUpiIntentsDataInJsonArray((Context)this.activity));
            jSONObject.put("uri_data", (Object)CheckoutUtils.getAppIntentDataInJsonArray((Context)this.activity));
            object = new JSONObject();
            object.put("openedAt", System.currentTimeMillis());
            jSONObject.put("metadata", object);
            object = this.getSdkObject();
            jSONObject.put("sdk", object);
            object = CardSaving.getDeviceToken(this.activity.getApplicationContext());
            if (!TextUtils.isEmpty((CharSequence)object)) {
                jSONObject.put("device_token", object);
            }
            jSONObject.put("sdk_popup", true);
            jSONObject.put("magic", true);
            jSONObject.put("network_type", BaseUtils.getNetworkType((Context)this.activity));
            jSONObject.put("activity_recreated", this.isActivityCreated);
        }
        catch (JSONException jSONException) {
            AnalyticsUtil.reportError((String)"CxPsntrImpl", (String)"S2", (String)jSONException.getLocalizedMessage());
        }
        return jSONObject;
    }

    @NotNull
    private JSONObject getSdkObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("framework", (Object)AnalyticsUtil.getFramework());
        jSONObject.put("type", (Object)ConfigCheckout.SDK_TYPE);
        jSONObject.put("name", (Object)(ConfigCheckout.SDK_TYPE + "_android_" + AnalyticsUtil.getFramework()));
        jSONObject.put("version", (Object)"1.7.2");
        jSONObject.put("platform", (Object)"android");
        String string = "getCallingPackage";
        String string2 = this.activity.getCallingPackage();
        if (string2 == null) {
            string2 = this.activity.getPackageName();
            string = "getPackageName";
        }
        if (string2 == null) {
            string2 = this.activity.getApplicationContext().getPackageName();
            string = "getApplicationContext.getPackageName";
        }
        if (string2 == null) {
            string2 = this.activity.getApplication().getPackageName();
            string = "getApplication.getPackageName";
        }
        if (string2 == null) {
            string = "null";
        }
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("function_name", (Object)string);
        AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CHECKOUT_PACKAGE_NAME_FUNC_USED, (JSONObject)jSONObject2);
        jSONObject.put("package_name", (Object)string2);
        return jSONObject;
    }

    private String getHandleMessageFormattedString() {
        return String.format("javascript: handleMessage(%s)", this.getOptionsForHandleMessage().toString());
    }

    @Override
    public void setAppToken(String string) {
        CardSaving.setAppToken((Context)this.activity, string);
    }

    @Override
    public void setDeviceToken(String string) {
        CardSaving.setDeviceToken((Context)this.activity, string);
    }

    @Override
    public void callNativeIntent(String string, String string2) {
        Object object;
        if (string.contains("truecallersdk://truesdk")) {
            this.truecallerLoginAttempt = true;
        }
        BaseUtils.startActivityForResult((String)string, (String)string2, (Activity)this.activity);
        if (string2 != null) {
            ((BaseCheckoutActivity)this.activity).setLifecycleContext(LifecycleContext.REDIRECTING_TO_APP, string2);
        } else {
            try {
                object = string.split(":")[0];
                ((BaseCheckoutActivity)this.activity).setLifecycleContext(LifecycleContext.REDIRECTING_USING_SCHEME, (String)object);
            }
            catch (Exception exception) {}
        }
        object = new HashMap<String, String>();
        object.put("url", string == null ? "null" : string);
        object.put("package_name", string2 == null ? "null" : string2);
        AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.NATIVE_INTENT_CALLED, (JSONObject)AnalyticsUtil.getJSONResponse((Map)object));
    }

    @Override
    public void setPaymentID(String string) {
        Logger.d((String)("setPaymentID called: " + string));
        this.payment_id = string;
        BaseUtils.getInstance().setPaymentId(string);
        if (this.checkoutOptions.getOrderId() != null) {
            BaseUtils.getInstance().setOrderId(this.checkoutOptions.getOrderId());
        }
        AnalyticsUtil.addProperty((String)"payment_id", (AnalyticsProperty)new AnalyticsProperty(string, AnalyticsProperty.Scope.PAYMENT));
        AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.PAYMENT_ID_ATTACHED);
    }

    @Override
    public void setMerchantOptions(String string) {
        this.dashOptions = string;
        try {
            this.dashOptionsJSON = this.dashOptions == null || this.dashOptions.equalsIgnoreCase("undefined") ? null : new JSONObject(this.dashOptions);
        }
        catch (Exception exception) {
            Logger.e((String)"Error parsing merchant dash options JSON", (Throwable)exception);
            this.dashOptionsJSON = null;
            AnalyticsUtil.reportError((String)"CxPsntrImpl", (String)"S0", (String)exception.getMessage());
        }
        if (this.dashOptionsJSON == null) {
            CheckoutUtils.setMerchantOptions((Context)this.activity, this.merchantKey, null);
            return;
        }
        CheckoutUtils.setMerchantOptions((Context)this.activity, this.merchantKey, string);
    }

    protected void addAnalyticsData(JSONObject jSONObject) {
        AnalyticsUtil.addFilteredPropertiesFromPayload((JSONObject)jSONObject);
    }

    @Override
    public void onSubmit(String string) {
        CheckoutUtils.dismissLoader();
        this.isTouchNGoPayment = Boolean.FALSE;
        if (this.paymentAttempts > 1) {
            AnalyticsUtil.refreshPaymentSession();
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            this.checkoutContent = string;
            this.addAnalyticsData(jSONObject);
            this.savePrefillData(jSONObject);
            if (jSONObject.has("method")) {
                string = jSONObject.getString("method");
                if (string.equalsIgnoreCase("netbanking") || string.equalsIgnoreCase("card")) {
                    if (!this.isSmsReceiverRegistered) {
                        this.registerSmsListener();
                    }
                } else {
                    this.unregisterSmsListener();
                }
                if (string.equals("wallet")) {
                    if (jSONObject.has("wallet")) {
                        string = jSONObject.getString("wallet");
                        this.isTouchNGoPayment = "touchngo".equalsIgnoreCase(string);
                        if (this.checkoutOptions.hasExternalWallet(string)) {
                            jSONObject = new JSONObject();
                            jSONObject.put("external_wallet", (Object)string);
                            AnalyticsUtil.addProperty((String)"external_wallet", (AnalyticsProperty)new AnalyticsProperty(string, AnalyticsProperty.Scope.ORDER));
                            AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.EXTERNAL_WALLET_SELECTED);
                            this.onComplete(jSONObject);
                        }
                    }
                } else {
                    this.unregisterReceivers();
                }
            }
            BaseUtils.getInstance().setDeeplinkEnabled((Context)this.activity, this.isTouchNGoPayment.booleanValue());
            AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CHECKOUT_SUBMIT);
            AnalyticsUtil.postData();
            return;
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError((String)"CxPsntrImpl", (String)"S0", (String)exception.getMessage());
            Logger.e((String)"Error in submit", (Throwable)exception);
            return;
        }
    }

    protected void onComplete(JSONObject jSONObject) {
        try {
            if (jSONObject.has("error")) {
                AnalyticsUtil.addProperty((String)"payment_status", (AnalyticsProperty)new AnalyticsProperty("fail", AnalyticsProperty.Scope.PAYMENT));
                AnalyticsUtil.addProperty((String)"payload", (AnalyticsProperty)new AnalyticsProperty(jSONObject.toString(), AnalyticsProperty.Scope.PAYMENT));
                AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CHECKOUT_PAYMENT_COMPLETE);
                if (this.isTwoWebViewFlow) {
                    this.view.makeWebViewVisible(1);
                }
                this.onError(jSONObject);
            } else if (jSONObject.has("razorpay_fund_account_id")) {
                this.destroyActivity(1, jSONObject.toString());
            } else if (jSONObject.has("razorpay_payment_id")) {
                String string;
                this.payment_id = string = jSONObject.getString("razorpay_payment_id");
                AnalyticsUtil.addProperty((String)"payment_id", (AnalyticsProperty)new AnalyticsProperty(string, AnalyticsProperty.Scope.PAYMENT));
                AnalyticsUtil.addProperty((String)"payment_status", (AnalyticsProperty)new AnalyticsProperty("success", AnalyticsProperty.Scope.PAYMENT));
                AnalyticsUtil.addProperty((String)"payload", (AnalyticsProperty)new AnalyticsProperty(jSONObject.toString(), AnalyticsProperty.Scope.PAYMENT));
                AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CHECKOUT_PAYMENT_COMPLETE);
                this.isPaymentSuccessful = true;
                this.destroyActivity(1, jSONObject.toString());
            } else if (jSONObject.has("external_wallet")) {
                this.destroyActivity(4, jSONObject.toString());
            } else {
                this.destroyActivity(0, "Post payment parsing error");
            }
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError((String)"CxPsntrImpl", (String)"S0", (String)exception.getMessage());
            this.destroyActivity(0, exception.getMessage());
        }
        this.isTwoWebViewFlow = false;
    }

    protected void onError(JSONObject object) {
        if (this.isTwoWebViewFlow) {
            object = String.format("javascript: window.onComplete(%s)", object.toString());
            this.view.loadUrl(1, (String)object);
            return;
        }
        this.activity.runOnUiThread(new Runnable(){
            final /* synthetic */ JSONObject val$o;
            {
                this.val$o = jSONObject;
            }

            @Override
            public void run() {
                CheckoutPresenterImpl.this.handleRetry(this.val$o.toString());
            }
        });
    }

    private void handleRetry(String string) {
        if (CheckoutUtils.shouldRetryPayment(this.paymentAttempts)) {
            try {
                if (string != null) {
                    JSONObject jSONObject = new JSONObject(string);
                    if (jSONObject.has("error")) {
                        string = string + (this.checkoutUrl.contains("?") ? "&" : "?");
                        if (jSONObject.get("error") instanceof JSONObject) {
                            jSONObject = (JSONObject)jSONObject.get("error");
                            string = string + "error=" + jSONObject.toString();
                        }
                    }
                } else {
                    this.destroyActivity(0, "");
                    return;
                }
                this.helpersReset();
                this.loadForm(string);
            }
            catch (Exception exception) {
                this.destroyActivity(0, "");
                AnalyticsUtil.reportError((String)"CxPsntrImpl", (String)"S0", (String)exception.getMessage());
                return;
            }
        } else {
            this.destroyActivity(0, string);
        }
    }

    protected void helpersReset() {
        Logger.d((String)"helpersReset called");
    }

    private void savePrefillData(JSONObject jSONObject) {
        try {
            if (jSONObject.has("contact")) {
                CheckoutUtils.setUserContact((Context)this.activity, jSONObject.getString("contact"));
                this.checkoutOptions.putPrefill("contact", jSONObject.getString("contact"));
            }
            if (jSONObject.has("email")) {
                CheckoutUtils.setUserEmail((Context)this.activity, jSONObject.getString("email"));
                this.checkoutOptions.putPrefill("email", jSONObject.getString("email"));
            }
            return;
        }
        catch (JSONException jSONException) {
            Logger.e((String)"Error parsing JSON", (Throwable)jSONException);
            return;
        }
    }

    @Override
    public void onFault(String string) {
        try {
            string = new JSONObject(string);
            Logger.d((String)string.toString());
            return;
        }
        catch (JSONException jSONException) {
            return;
        }
    }

    @Override
    public void onComplete(final String string) {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    JSONObject jSONObject = new JSONObject(string);
                    Logger.d((String)"oncomplete JavascriptInterface");
                    CheckoutPresenterImpl.this.onComplete(jSONObject);
                    return;
                }
                catch (Exception exception) {
                    AnalyticsUtil.reportError((String)"CxPsntrImpl", (String)"S0", (String)exception.getMessage());
                    CheckoutPresenterImpl.this.destroyActivity(0, BaseUtils.getPaymentCancelledResponse((String)BaseUtils.getInstance().getMetadata()));
                    return;
                }
            }
        });
    }

    @Override
    public void setDimensions(final int n, final int n2) {
        if (ResourceUtils.isTablet((Context)this.activity)) {
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    WindowManager.LayoutParams layoutParams = CheckoutPresenterImpl.this.activity.getWindow().getAttributes();
                    Logger.d((String)"SetDimensions called");
                    Logger.d((String)("Height:" + n2));
                    Logger.d((String)("Width:" + n));
                    layoutParams.height = ResourceUtils.dpToPx((Context)CheckoutPresenterImpl.this.activity, (int)n2);
                    layoutParams.width = ResourceUtils.dpToPx((Context)CheckoutPresenterImpl.this.activity, (int)n);
                    CheckoutPresenterImpl.this.activity.getWindow().setAttributes(layoutParams);
                }
            });
        }
    }

    @Override
    public void onDismiss() {
        this.destroyActivity(0, BaseUtils.getPaymentCancelledResponse((String)BaseUtils.getInstance().getMetadata()));
    }

    @Override
    public void onDismiss(String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            this.destroyActivity(0, jSONObject.toString());
            return;
        }
        catch (JSONException jSONException) {
            this.destroyActivity(0, BaseUtils.getGenericPaymentErrorResponse((String)string, (String)BaseUtils.getInstance().getMetadata()));
            return;
        }
    }

    @Override
    public void requestExtraAnalyticsData() {
        final JSONObject jSONObject = AnalyticsUtil.getExtraAnalyticsPayload();
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    CheckoutPresenterImpl.this.view.loadUrl(1, String.format("javascript: CheckoutBridge.sendExtraAnalyticsData(%s)", jSONObject.toString()));
                    return;
                }
                catch (Exception exception) {
                    AnalyticsUtil.reportError((String)"CxPsntrImpl", (String)"S2", (String)exception.getLocalizedMessage());
                    return;
                }
            }
        });
    }

    @Override
    public void onError(String string) {
        try {
            this.onError(new JSONObject(string));
            return;
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError((String)"CxPsntrImpl", (String)"S0", (String)exception.getMessage());
            this.activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    CheckoutPresenterImpl.this.helpersReset();
                    CheckoutPresenterImpl.this.loadForm("");
                }
            });
            return;
        }
    }

    @Override
    public void relay(String string) {
    }

    @Override
    public void requestOtpPermission() {
    }

    @Override
    public void toast(final String string, final int n) {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                CheckoutPresenterImpl.this.view.showToast(string, n);
            }
        });
    }

    @Override
    public void showAlertDialog(final String string, final String string2, final String string3) {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                CheckoutUtils.showDialog((Context)CheckoutPresenterImpl.this.activity, string, string3, string2, new CheckoutUtils.BackButtonDialogCallback(){

                    @Override
                    public void onPositiveButtonClick() {
                        CheckoutPresenterImpl.this.view.loadUrl(1, String.format("javascript: CheckoutBridge.isPositiveButtonClicked({isClicked: %s})", Boolean.TRUE));
                    }

                    @Override
                    public void onNegativeButtonClick() {
                        CheckoutPresenterImpl.this.view.loadUrl(1, String.format("javascript: CheckoutBridge.isPositiveButtonClicked({isClicked: %s})", Boolean.FALSE));
                    }
                });
            }
        });
    }

    @Override
    public void sendDataToWebView(final int n, final String string) {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                switch (n) {
                    case 1: {
                        CheckoutPresenterImpl.this.view.loadUrl(1, String.format("javascript: handleRelay(%s)", string));
                        return;
                    }
                    case 2: {
                        String string2 = String.format("javascript: Magic.handleRelay(%s)", string);
                        CheckoutPresenterImpl.this.view.loadUrl(2, string2);
                    }
                }
            }
        });
    }

    @Override
    public void checkSmsPermission() {
        this.view.checkSmsPermission();
    }

    @Override
    public void isWebViewSafeOnUI(final int n, final CheckoutBridge.WebViewSafeCheckCallback webViewSafeCheckCallback) {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                CheckoutPresenterImpl.this.executeWebViewCallback(n, webViewSafeCheckCallback);
            }
        });
    }

    private void executeWebViewCallback(int n, CheckoutBridge.WebViewSafeCheckCallback webViewSafeCheckCallback) {
        Object object = n == 1 ? this.view.getWebView(1) : this.view.getWebView(2);
        object = object.getTag().toString();
        try {
            object = new URL((String)object);
            object = ((URL)object).getHost();
            if (object == null || !((String)object).endsWith("razorpay.com") && !((String)object).endsWith("razorpay.in") && !this.isDynamicUrlLoaded) {
                webViewSafeCheckCallback.unSecure();
                return;
            }
            webViewSafeCheckCallback.secure();
        }
        catch (Exception exception) {
            AnalyticsUtil.reportError((String)"CxPsntrImpl", (String)"S0", (String)exception.getLocalizedMessage());
            webViewSafeCheckCallback.unSecure();
        }
    }

    @Override
    public void isWebViewSafe(int n, CheckoutBridge.WebViewSafeCheckCallback webViewSafeCheckCallback) {
        this.executeWebViewCallback(n, webViewSafeCheckCallback);
    }

    @Override
    public boolean isUserRegisteredOnUPI(String string) {
        return BaseUtils.checkUpiRegisteredApp((Context)this.activity, (String)string);
    }

    @Override
    public boolean isUserRegistered(String string) {
        return BaseUtils.checkGpayCardsUpiRegistered((Activity)this.activity, (String)string);
    }

    @Override
    public boolean isAllowRotation() {
        return this.allowRotation;
    }

    @Override
    public String getGPayFOPs(Double d) {
        String string = null;
        RzpPlugin rzpPlugin = this.pluginsMap.entrySet().iterator();
        while (rzpPlugin.hasNext()) {
            Map.Entry<String, String> entry = rzpPlugin.next();
            String string2 = entry.getKey();
            if (string2 == null || !string2.toLowerCase().contains("gpay_in_a_box")) continue;
            try {
                rzpPlugin = (RzpPlugin)RzpPlugin.class.getClassLoader().loadClass(entry.getValue()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (!(rzpPlugin instanceof RzpGPayInABoxExternalPlugin)) break;
                string = ((RzpGPayInABoxExternalPlugin)rzpPlugin).getPaymentMethods((Context)this.activity, d.doubleValue());
            }
            catch (Exception exception) {}
            break;
        }
        return string;
    }

    static interface CheckoutView {
        public void loadUrl(int var1, String var2);

        public void loadData(int var1, String var2, String var3, String var4);

        public void loadDataWithBaseURL(int var1, String var2, String var3, String var4, String var5, String var6);

        public void makeWebViewVisible(int var1);

        public boolean isWebViewVisible(int var1);

        public void showToast(String var1, int var2);

        public void destroy(int var1, String var2);

        public void showProgressBar(int var1);

        public void hideProgressBar();

        public void clearWebViewHistory(int var1);

        public WebView getWebView(int var1);

        public void checkSmsPermission();

        public void addJavascriptInterfaceToPrimaryWebview(Object var1, String var2);
    }
}

