/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Fragment;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.text.TextUtils;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsProperty;
import com.razorpay.AnalyticsUtil;
import com.razorpay.BaseUtils;
import com.razorpay.CheckoutCacheManager;
import com.razorpay.CheckoutUtils;
import com.razorpay.ConfigCheckout;
import com.razorpay.ExternalWalletListener;
import com.razorpay.GlobalUrlConfig;
import com.razorpay.Logger;
import com.razorpay.OpinionatedSoln;
import com.razorpay.PaymentData;
import com.razorpay.PaymentResultListener;
import com.razorpay.PaymentResultWithDataListener;
import com.razorpay.StorageBridge;
import com.razorpay.UpiTurboCheckout;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class Checkout
extends Fragment {
    public static final int NETWORK_ERROR = 2;
    public static final int INVALID_OPTIONS = 3;
    public static final int PAYMENT_CANCELED = 0;
    public static final int TLS_ERROR = 6;
    public static final int INCOMPATIBLE_PLUGIN = 7;
    public static final int MAGICX_REQUEST_CODE = 98001;
    public static final int MAGICX_RESPONSE_CODE = 99002;
    public static final int RZP_REQUEST_CODE = 62442;
    static final int PAYMENT_SUCCESS = 1;
    static final int EXTERNAL_WALLET = 4;
    static final int INTEGRATION_ONE = 1;
    static final int INTEGRATION_TWO = 2;
    static final int INTEGRATION_THREE = 3;
    static final String EVENT_CALLBACK_DNE = "dne";
    static final String EVENT_CALLBACK_THREW_ERROR = "threw_error";
    boolean isGlobalConfigLoaded = false;
    @SuppressLint(value={"StaticFieldLeak"})
    private static WebView sPreloadView;
    private static long sPreloadCompleteDuration;
    private static long sPreloadAbortDuration;
    private static boolean sPreloadFailed;
    private String key;
    private JSONObject options;
    private Activity merchantActivity;
    private String merchantClassName;
    private boolean disableFullScreen;
    private int checkoutImage;
    private static PaymentData paymentData;
    private boolean isMethodOverridden;
    private PaymentResultListener paymentResultListenerFromClass = null;
    private PaymentResultWithDataListener paymentResultWithDataListenerFromClass = null;
    private ExternalWalletListener externalWalletListenerFromClass = null;
    public UpiTurboCheckout upiTurbo;

    public Checkout() {
        Checkout.trackEvent(AnalyticsEvent.CHECKOUT_INITIALIZED, "timestamp", System.currentTimeMillis());
    }

    public static Checkout getInstance(Context context) {
        if (ConfigCheckout.getInstance().getPrefetchEnabled().booleanValue()) {
            CheckoutCacheManager.getInstance().startPrefetch(context);
        }
        if (ConfigCheckout.getInstance().getPreloadEnabled().booleanValue()) {
            Checkout.preload(context);
        }
        Checkout.trackEvent(AnalyticsEvent.CHECKOUT_INITIALIZED_GET_INSTANCE, "timestamp", System.currentTimeMillis());
        return new Checkout();
    }

    @Deprecated
    public final void setPublicKey(String string) {
        this.key = string;
    }

    public final Checkout upiTurbo(Activity activity) {
        this.upiTurbo = new UpiTurboCheckout(activity, "", null, null);
        return this;
    }

    public final void setHostedOptimizerConfig(JSONObject jSONObject) {
        this.isGlobalConfigLoaded = true;
        GlobalUrlConfig.initiate((JSONObject)jSONObject);
    }

    public final void setImage(int n) {
        this.checkoutImage = n;
    }

    public final void setUpiTurbo(Activity activity) {
        this.upiTurbo = new UpiTurboCheckout(activity, "", null, null);
    }

    public final void setUpiTurbo(Activity activity, String string) {
        this.upiTurbo = new UpiTurboCheckout(activity, "", string, null);
    }

    public final void setKeyID(String string) {
        this.setPublicKey(string);
        BaseUtils.apiKey = string;
    }

    public final void setFullScreenDisable(boolean bl) {
        this.disableFullScreen = bl;
    }

    public final void open(final Activity activity, final JSONObject jSONObject) {
        if (OpinionatedSoln.INSTANCE.getBuildConfigValue((Context)activity, "DEBUG") != null) {
            if (!OpinionatedSoln.INSTANCE.getAlertShownForStatus() && !this.isGlobalConfigLoaded) {
                this.sdkCheckIntegrationInternal(activity, new OpinionatedSoln.DismissCallback(){

                    @Override
                    public void alertDismissed() {
                        Checkout.this.openInternal(activity, jSONObject);
                    }
                });
                return;
            }
            this.openInternal(activity, jSONObject);
            return;
        }
        this.openInternal(activity, jSONObject);
    }

    private void openInternal(Activity activity, JSONObject jSONObject) {
        if (TextUtils.isEmpty((CharSequence)this.key)) {
            this.key = BaseUtils.getKeyId((Context)activity);
        } else {
            BaseUtils.apiKey = this.key;
        }
        ConfigCheckout.getAdvertisingIdFromUtil((Context)activity);
        if (TextUtils.isEmpty((CharSequence)this.key)) {
            throw new RuntimeException("Please set your Razorpay API key in AndroidManifest.xml");
        }
        if (jSONObject == null || jSONObject.length() == 0) {
            throw new RuntimeException("Checkout options cannot be null or empty");
        }
        try {
            jSONObject.put("key", (Object)this.key);
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            AnalyticsUtil.reportError((String)jSONException.getMessage(), (String)"S2", (String)jSONException2.getMessage());
        }
        Checkout checkout = this;
        checkout.abortPreloadIfRequired(checkout.merchantActivity);
        this.options = jSONObject;
        this.merchantClassName = activity.getClass().getName();
        this.merchantActivity = activity;
        try {
            activity.getFragmentManager().beginTransaction().add((Fragment)this, null).commitAllowingStateLoss();
            return;
        }
        catch (IllegalStateException illegalStateException) {
            AnalyticsUtil.reportError((String)"Checkout", (String)"S2", (String)illegalStateException.getMessage());
            return;
        }
    }

    static void trackEvent(AnalyticsEvent analyticsEvent, String string, Object object) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(string, object);
        AnalyticsUtil.trackEvent((AnalyticsEvent)analyticsEvent, hashMap);
    }

    public static void preload(Context context) {
        Checkout.trackEvent(AnalyticsEvent.CHECKOUT_PRELOAD_STARTED, "timestamp", System.currentTimeMillis());
        sPreloadCompleteDuration = 0L;
        sPreloadAbortDuration = 0L;
        sPreloadFailed = false;
        context = context.getApplicationContext();
        sPreloadView = new WebView(context);
        BaseUtils.setWebViewSettings((Context)context, (WebView)sPreloadView, (boolean)false);
        sPreloadView.setWebViewClient(new WebViewClient(){
            long pageStartAt;

            public void onPageStarted(WebView webView, String string, Bitmap bitmap) {
                this.pageStartAt = System.nanoTime();
                if (sPreloadView == null) {
                    Checkout.trackEvent(AnalyticsEvent.WEB_VIEW_UNEXPECTED_NULL, "error_location", "Checkout->Preload()->onPageStarted");
                    return;
                }
                sPreloadView.setTag((Object)this.pageStartAt);
                Logger.d((String)"Preload started!");
            }

            public void onReceivedError(WebView webView, int n, String string, String string2) {
                Logger.d((String)"onReceivedError OLD while pre-loading!");
                Checkout.failPreload();
            }

            public void onReceivedError(WebView webView, WebResourceRequest webResourceRequest, WebResourceError webResourceError) {
                super.onReceivedError(webView, webResourceRequest, webResourceError);
                Logger.d((String)"onReceivedError NEW while pre-loading!");
                Checkout.failPreload();
            }

            public void onPageFinished(WebView object, String string) {
                long l = System.nanoTime();
                if (!sPreloadFailed) {
                    sPreloadCompleteDuration = l - this.pageStartAt;
                    Checkout.trackEvent(AnalyticsEvent.CHECKOUT_PRELOAD_COMPLETED, "timestamp", System.currentTimeMillis());
                    object = "Preload finished in " + BaseUtils.nanoTimeToSecondsString((long)sPreloadCompleteDuration, (int)2) + " sec.";
                    Logger.d((String)object);
                }
                Checkout.destroyPreloadView();
            }
        });
        sPreloadView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView webView, int n) {
                Logger.d((String)("Preload progress: " + n));
            }
        });
        sPreloadView.loadUrl("https://api.razorpay.com/v1/checkout/public");
    }

    private static void failPreload() {
        Checkout.trackEvent(AnalyticsEvent.CHECKOUT_PRELOAD_FAILED, "timestamp", System.currentTimeMillis());
        sPreloadFailed = true;
    }

    private static void destroyPreloadView() {
        try {
            sPreloadView.stopLoading();
        }
        catch (Exception exception) {}
        sPreloadView = null;
    }

    private void abortPreloadIfRequired(Activity object) {
        long l = System.nanoTime();
        try {
            if (sPreloadView != null) {
                long l2 = (Long)sPreloadView.getTag();
                sPreloadAbortDuration = l - l2;
                if ((object = new StorageBridge((Context)object)).getString("prefetchedUpiAccounts") == null) {
                    object.setString("usePrefetchedUpiAccounts", "false");
                }
                object = "Preload aborted in " + BaseUtils.nanoTimeToSecondsString((long)sPreloadAbortDuration, (int)2) + " sec.";
                Logger.d((String)object);
                Checkout.trackEvent(AnalyticsEvent.CHECKOUT_PRELOAD_ABORTED, "timestamp", System.currentTimeMillis());
            }
        }
        catch (Exception exception) {}
        Checkout.destroyPreloadView();
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        if (this.options != null) {
            bundle = new Intent();
            bundle.setComponent(new ComponentName(this.getActivity().getPackageName(), "com.razorpay.CheckoutActivity"));
            if (sPreloadCompleteDuration > 0L) {
                bundle.putExtra("PRELOAD_COMPLETE_DURATION", sPreloadCompleteDuration);
            } else if (sPreloadAbortDuration > 0L) {
                bundle.putExtra("PRELOAD_ABORT_DURATION", sPreloadAbortDuration);
            }
            bundle.putExtra("OPTIONS", this.options.toString());
            bundle.putExtra("IMAGE", this.checkoutImage);
            bundle.putExtra("DISABLE_FULL_SCREEN", this.disableFullScreen);
            this.options = null;
            this.startActivityForResult((Intent)bundle, 62442);
        }
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        if (n != 62442) {
            return;
        }
        if (this.merchantActivity == null) {
            this.merchantActivity = this.getActivity();
        }
        this.merchantClassName = this.merchantActivity.getClass().getName();
        Object object = Checkout.getPaymentResult(intent);
        if (object == null || TextUtils.isEmpty((CharSequence)object)) {
            object = BaseUtils.getGenericPaymentErrorResponse((String)"Payment Error", (String)BaseUtils.getInstance().getMetadata());
        } else if (((String)object).contains("cancelled") && !((String)object).contains("error")) {
            object = BaseUtils.getPaymentCancelledResponse((String)BaseUtils.getInstance().getMetadata());
        }
        Checkout.trackOnActivityResultEvent(n2, (String)object);
        Checkout.createPaymentData(this.merchantActivity, (String)object);
        if (n2 == 1) {
            this.handleOnSuccess();
        } else if (n2 == 4) {
            this.handleExternalWalletSelected();
        } else {
            this.handleOnError(n2, (String)object);
        }
        try {
            this.getActivity().getFragmentManager().beginTransaction().remove((Fragment)this).commit();
            return;
        }
        catch (Exception exception) {
            object = exception;
            AnalyticsUtil.reportError((String)exception.getMessage(), (String)"S1", (String)((Throwable)object).getMessage());
            return;
        }
    }

    private void handleExternalWalletSelected() {
        if (this.externalWalletListenerFromClass != null) {
            this.externalWalletListenerFromClass.onExternalWalletSelected(paymentData.getExternalWallet(), paymentData);
            return;
        }
        if (this.getActivity() instanceof ExternalWalletListener) {
            try {
                ExternalWalletListener externalWalletListener = (ExternalWalletListener)this.getActivity();
                String string = paymentData.getExternalWallet();
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    externalWalletListener.onExternalWalletSelected(string, paymentData);
                    AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.MERCHANT_EXTERNAL_WALLET_SELECTED_CALLED);
                    AnalyticsUtil.postData();
                }
                return;
            }
            catch (Exception exception) {
                Checkout.handleMerchantCallbackError(this.merchantActivity, 4, EVENT_CALLBACK_THREW_ERROR, exception);
                return;
            }
        }
        Checkout.handleMerchantCallbackError(this.merchantActivity, 4, EVENT_CALLBACK_DNE, new Exception());
    }

    private void handleOnError(int n, String string) {
        this.isMethodOverridden = true;
        this.onError(n, string);
        if (this.isMethodOverridden) {
            Checkout.trackIntegrationType(n, 1);
        }
    }

    private void handleOnSuccess() {
        String string = paymentData.getPaymentId();
        if (string != null) {
            this.isMethodOverridden = true;
            this.onSuccess(string);
        }
        if (this.isMethodOverridden) {
            Checkout.trackIntegrationType(1, 1);
        }
    }

    public void onSuccess(String string) {
        this.isMethodOverridden = false;
        boolean bl = this.handleOnSuccessViaInterface(string);
        if (!bl) {
            this.handleOnSuccessViaReflection(string);
        }
    }

    public void onError(int n, String string) {
        this.isMethodOverridden = false;
        boolean bl = this.handleOnErrorViaInterface(n, string);
        if (!bl) {
            this.handleOnErrorViaReflection(n, string);
        }
    }

    private void handleOnErrorViaReflection(int n, String string) {
        Method method = null;
        try {
            method = this.getMerchantClassMethod("onPaymentError", Integer.TYPE, String.class);
        }
        catch (Exception exception) {
            Checkout.handleMerchantCallbackError(this.merchantActivity, n, EVENT_CALLBACK_DNE, exception);
        }
        try {
            this.invokeMethod(method, n, string);
            Checkout.trackIntegrationType(n, 2);
            return;
        }
        catch (Exception exception) {
            Checkout.handleMerchantCallbackError(this.merchantActivity, n, EVENT_CALLBACK_THREW_ERROR, exception);
            return;
        }
    }

    private boolean handleOnErrorViaInterface(int n, String string) {
        if (this.paymentResultListenerFromClass != null) {
            this.paymentResultListenerFromClass.onPaymentError(n, string);
            return true;
        }
        if (this.getActivity() instanceof PaymentResultListener) {
            try {
                PaymentResultListener paymentResultListener = (PaymentResultListener)this.getActivity();
                paymentResultListener.onPaymentError(n, string);
                Checkout.trackIntegrationType(n, 3);
            }
            catch (Exception exception) {
                Checkout.handleMerchantCallbackError(this.merchantActivity, n, EVENT_CALLBACK_THREW_ERROR, exception);
            }
            return true;
        }
        if (this.paymentResultWithDataListenerFromClass != null) {
            this.paymentResultWithDataListenerFromClass.onPaymentError(n, string, paymentData);
            return true;
        }
        if (this.getActivity() instanceof PaymentResultWithDataListener) {
            try {
                PaymentResultWithDataListener paymentResultWithDataListener = (PaymentResultWithDataListener)this.getActivity();
                paymentResultWithDataListener.onPaymentError(n, string, paymentData);
                Checkout.trackIntegrationType(n, 3);
            }
            catch (Exception exception) {
                Checkout.handleMerchantCallbackError(this.merchantActivity, n, EVENT_CALLBACK_THREW_ERROR, exception);
            }
            return true;
        }
        return false;
    }

    private boolean handleOnSuccessViaInterface(String string) {
        if (this.paymentResultListenerFromClass != null) {
            this.paymentResultListenerFromClass.onPaymentSuccess(string);
            return true;
        }
        if (this.getActivity() instanceof PaymentResultListener) {
            try {
                PaymentResultListener paymentResultListener = (PaymentResultListener)this.getActivity();
                paymentResultListener.onPaymentSuccess(string);
                Checkout.trackIntegrationType(1, 3);
            }
            catch (Exception exception) {
                Checkout.handleMerchantCallbackError(this.merchantActivity, 1, EVENT_CALLBACK_THREW_ERROR, exception);
            }
            return true;
        }
        if (this.paymentResultWithDataListenerFromClass != null) {
            this.paymentResultWithDataListenerFromClass.onPaymentSuccess(string, paymentData);
            return true;
        }
        if (this.getActivity() instanceof PaymentResultWithDataListener) {
            try {
                PaymentResultWithDataListener paymentResultWithDataListener = (PaymentResultWithDataListener)this.getActivity();
                paymentResultWithDataListener.onPaymentSuccess(string, paymentData);
                Checkout.trackIntegrationType(1, 3);
            }
            catch (Exception exception) {
                Checkout.handleMerchantCallbackError(this.merchantActivity, 1, EVENT_CALLBACK_THREW_ERROR, exception);
            }
            return true;
        }
        return false;
    }

    private void handleOnSuccessViaReflection(String string) {
        Method method = null;
        try {
            method = this.getMerchantClassMethod("onPaymentSuccess", String.class);
        }
        catch (Exception exception) {
            Checkout.handleMerchantCallbackError(this.merchantActivity, 1, EVENT_CALLBACK_DNE, exception);
        }
        try {
            this.invokeMethod(method, string);
            Checkout.trackIntegrationType(1, 2);
            return;
        }
        catch (Exception exception) {
            Checkout.handleMerchantCallbackError(this.merchantActivity, 1, EVENT_CALLBACK_THREW_ERROR, exception);
            return;
        }
    }

    private void invokeMethod(Method method, Object ... objectArray) throws Exception {
        if (method == null) {
            return;
        }
        method.invoke((Object)this.merchantActivity, objectArray);
    }

    private Method getMerchantClassMethod(String object, Class ... classArray) throws Exception {
        Class<?> clazz = Class.forName(this.merchantClassName);
        object = clazz.getMethod((String)object, classArray);
        return object;
    }

    private static void trackIntegrationType(int n, int n2) {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("integration_type", Integer.toString(n2));
            if (n == 1) {
                AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.MERCHANT_ON_SUCCESS_CALLED, (JSONObject)AnalyticsUtil.getJSONResponse(hashMap));
            } else {
                AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.MERCHANT_ON_ERROR_CALLED, (JSONObject)AnalyticsUtil.getJSONResponse(hashMap));
            }
            AnalyticsUtil.postData();
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            AnalyticsUtil.reportError((String)exception.getMessage(), (String)"S2", (String)exception2.getMessage());
            return;
        }
    }

    private static void trackOnActivityResultEvent(int n, String string) {
        try {
            AnalyticsUtil.addProperty((String)"onActivityResult result", (AnalyticsProperty)new AnalyticsProperty(string, AnalyticsProperty.Scope.ORDER));
            AnalyticsUtil.addProperty((String)"onActivityResult resultCode", (AnalyticsProperty)new AnalyticsProperty(String.valueOf(n), AnalyticsProperty.Scope.ORDER));
            if (n == 1) {
                AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CALLING_ON_SUCCESS);
            } else if (n == 4) {
                AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CALLING_EXTERNAL_WALLET_SELECTED);
            } else {
                AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.CALLING_ON_ERROR);
            }
            AnalyticsUtil.postData();
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            AnalyticsUtil.reportError((String)exception.getMessage(), (String)"S2", (String)exception2.getMessage());
            return;
        }
    }

    private static void handleMerchantCallbackError(Activity activity, int n, String string, Exception exception) {
        String string2;
        String string3;
        if (n == 1) {
            string3 = "onPaymentSuccess";
            string2 = "success";
        } else if (n == 4) {
            string3 = "onExternalWalletSelected";
            string2 = "redirected";
        } else {
            string3 = "onPaymentError";
            string2 = "error";
        }
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("event_details", exception.getMessage());
            hashMap.put("event_type", exception.getMessage());
            hashMap.put("payment_status", string2);
            AnalyticsUtil.trackEvent((AnalyticsEvent)AnalyticsEvent.HANDOVER_ERROR, (JSONObject)AnalyticsUtil.getJSONResponse(hashMap));
            AnalyticsUtil.postData();
        }
        catch (Exception exception2) {
            Exception exception3 = exception2;
            AnalyticsUtil.reportError((String)exception2.getMessage(), (String)"S0", (String)exception3.getMessage());
        }
        if (string.equals(EVENT_CALLBACK_DNE)) {
            if (n == 4) {
                Toast.makeText((Context)activity, (CharSequence)"Error: ExternalWalletListener probably not implemented in your activity", (int)0).show();
                return;
            }
            Toast.makeText((Context)activity, (CharSequence)("Error: " + string3 + " probably not implemented in your activity"), (int)0).show();
            return;
        }
        if (string.equals(EVENT_CALLBACK_THREW_ERROR)) {
            Toast.makeText((Context)activity, (CharSequence)("Your " + string3 + " method is throwing an error. Wrap the entire code of the method inside a try catch."), (int)0).show();
        }
    }

    private static void createPaymentData(Activity activity, String string) {
        paymentData = new PaymentData();
        paymentData.setUserContact(CheckoutUtils.getUserContact((Context)activity));
        paymentData.setUserEmail(CheckoutUtils.getUserEmail((Context)activity));
        try {
            activity = new JSONObject(string);
            if (activity.optJSONObject("error") != null) {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("error", (Object)activity.getJSONObject("error"));
                JSONObject jSONObject2 = activity.getJSONObject("error").getJSONObject("metadata");
                if (jSONObject2.has("payment_id")) {
                    paymentData.setPaymentId(jSONObject2.getString("payment_id"));
                }
                if (jSONObject2.has("order_id")) {
                    paymentData.setOrderId(jSONObject2.getString("order_id"));
                }
                paymentData.setData(jSONObject);
            } else {
                paymentData.setData((JSONObject)activity);
            }
            if (activity.has("razorpay_payment_id")) {
                paymentData.setPaymentId(activity.getString("razorpay_payment_id"));
            }
            if (activity.has("razorpay_order_id")) {
                paymentData.setOrderId(activity.getString("razorpay_order_id"));
            }
            if (activity.has("razorpay_signature")) {
                paymentData.setSignature(activity.getString("razorpay_signature"));
            }
            if (activity.has("external_wallet")) {
                paymentData.setExternalWallet(activity.getString("external_wallet"));
            }
            return;
        }
        catch (JSONException jSONException) {
            JSONObject jSONObject = new JSONObject();
            JSONObject jSONObject3 = new JSONObject();
            try {
                jSONObject3.put("code", (Object)"RESPONSE");
                jSONObject3.put("description", (Object)string);
                jSONObject.put("error", (Object)jSONObject3);
            }
            catch (JSONException jSONException2) {}
            AnalyticsUtil.reportError((String)jSONException.getMessage(), (String)"S2", (String)jSONException.getMessage());
            return;
        }
    }

    @Deprecated
    public static void handleActivityResult(Activity activity, int n, int n2, Intent intent, PaymentResultWithDataListener paymentResultWithDataListener, ExternalWalletListener externalWalletListener) {
        if (n != 62442) {
            return;
        }
        String string = Checkout.getPaymentResult(intent);
        if (string == null || TextUtils.isEmpty((CharSequence)string)) {
            string = BaseUtils.getGenericPaymentErrorResponse((String)"Payment Error", (String)BaseUtils.getInstance().getMetadata());
        } else if (string.contains("cancelled") && !string.contains("error")) {
            string = BaseUtils.getPaymentCancelledResponse((String)BaseUtils.getInstance().getMetadata());
        }
        Checkout.trackOnActivityResultEvent(n2, string);
        Checkout.createPaymentData(activity, string);
        if (n2 == 1) {
            try {
                string = paymentData.getPaymentId();
                paymentResultWithDataListener.onPaymentSuccess(string, paymentData);
                return;
            }
            catch (Exception exception) {
                Checkout.handleMerchantCallbackError(activity, n2, EVENT_CALLBACK_THREW_ERROR, exception);
                return;
            }
        }
        if (n2 == 4) {
            if (externalWalletListener != null) {
                try {
                    externalWalletListener.onExternalWalletSelected(paymentData.getExternalWallet(), paymentData);
                    return;
                }
                catch (Exception exception) {
                    Checkout.handleMerchantCallbackError(activity, n2, EVENT_CALLBACK_THREW_ERROR, exception);
                    return;
                }
            }
        } else {
            try {
                paymentResultWithDataListener.onPaymentError(n2, string, paymentData);
                return;
            }
            catch (Exception exception) {
                Checkout.handleMerchantCallbackError(activity, n2, EVENT_CALLBACK_THREW_ERROR, exception);
            }
        }
    }

    public void merchantActivityResult(Activity activity, int n, int n2, Intent intent, PaymentResultWithDataListener paymentResultWithDataListener, ExternalWalletListener externalWalletListener) {
        this.merchantActivity = activity;
        this.paymentResultWithDataListenerFromClass = paymentResultWithDataListener;
        this.externalWalletListenerFromClass = externalWalletListener;
        this.onActivityResult(n, n2, intent);
    }

    public void merchantActivityResult(Activity activity, int n, int n2, Intent intent, PaymentResultListener paymentResultListener, ExternalWalletListener externalWalletListener) {
        this.merchantActivity = activity;
        this.paymentResultListenerFromClass = paymentResultListener;
        this.externalWalletListenerFromClass = externalWalletListener;
        this.onActivityResult(n, n2, intent);
    }

    public static void clearUserData(Context context) {
        CheckoutUtils.clearUserData(context);
    }

    private static String getPaymentResult(Intent intent) {
        if (intent != null && (intent = intent.getExtras()) != null) {
            return intent.getString("RESULT");
        }
        return null;
    }

    public static void sdkCheckIntegration(Activity activity) {
        OpinionatedSoln.INSTANCE.integrationStatusCheck(activity);
    }

    private void sdkCheckIntegrationInternal(Activity activity, OpinionatedSoln.DismissCallback dismissCallback) {
        OpinionatedSoln.INSTANCE.integrationStatusCheck(activity, dismissCallback);
    }

    public String builderTest() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("key", (Object)this.key);
            jSONObject.put("image", this.checkoutImage);
            jSONObject.put("disableFullScreen", this.disableFullScreen);
        }
        catch (JSONException jSONException) {}
        return jSONObject.toString();
    }

    public static class Builder {
        private String builderKey;
        private int builderCheckoutImage;
        private boolean builderDisableFullScreen;
        private Activity activity;
        private String color;

        public Builder(Activity activity) {
            this.activity = activity;
        }

        public Builder() {
        }

        public Builder setKeyId(String string) {
            this.builderKey = string;
            return this;
        }

        public Builder setImage(int n) {
            this.builderCheckoutImage = n;
            return this;
        }

        public Builder disableFullscreen(boolean bl) {
            this.builderDisableFullScreen = bl;
            return this;
        }

        public Builder setColor(String string) {
            this.color = string;
            return this;
        }

        public Checkout build() {
            Checkout checkout = new Checkout();
            checkout.setFullScreenDisable(this.builderDisableFullScreen);
            checkout.setImage(this.builderCheckoutImage);
            if (this.color != null) {
                checkout.setUpiTurbo(this.activity, this.color);
            } else {
                checkout.setUpiTurbo(this.activity);
            }
            if (this.builderKey != null) {
                checkout.setKeyID(this.builderKey);
            }
            return checkout;
        }
    }
}

