/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import com.razorpay.F_$o_;
import com.razorpay.M$$8$;
import com.razorpay.M$_J_;
import com.razorpay.P$_S_;
import com.razorpay.S__Z$;
import com.razorpay.V$$3$;
import com.razorpay.p$$q_;
import com.razorpay.w_$E$;

class CircularProgressView
extends View {
    private static final float INDETERMINANT_MIN_SWEEP = 15.0f;
    private Context context;
    private Paint paint;
    private int size = 0;
    private RectF bounds;
    private boolean isIndeterminate;
    private boolean autostartAnimation;
    private float currentProgress;
    private float maxProgress;
    private float indeterminateSweep;
    private float indeterminateRotateOffset;
    private int thickness;
    private int color;
    private int animDuration;
    private int animSwoopDuration;
    private int animSyncDuration;
    private int animSteps;
    private float startAngle;
    private float actualProgress;
    private ValueAnimator startAngleRotate;
    private ValueAnimator progressAnimator;
    private AnimatorSet indeterminateAnimator;
    private float initialStartAngle;

    public CircularProgressView(Context context) {
        super(context);
        this.init(null, 0, context);
    }

    public CircularProgressView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(attributeSet, 0, context);
    }

    public CircularProgressView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.init(attributeSet, n2, context);
    }

    protected void init(AttributeSet attributeSet, int n2, Context context) {
        this.initAttributes(attributeSet, n2, context);
        this.paint = new Paint(1);
        this.updatePaint();
        this.bounds = new RectF();
    }

    private void initAttributes(AttributeSet attributeSet, int n2, Context context) {
        this.getResources();
        this.currentProgress = 0.0f;
        this.maxProgress = 100.0f;
        this.thickness = this.convertDPtoInt(context, 3);
        this.isIndeterminate = true;
        this.autostartAnimation = true;
        this.startAngle = this.initialStartAngle = -90.0f;
        this.color = Color.parseColor((String)"#4aa3df");
        this.animDuration = 4000;
        this.animSwoopDuration = 5000;
        this.animSyncDuration = 500;
        this.animSteps = 3;
    }

    protected void onMeasure(int n2, int n3) {
        super.onMeasure(n2, n3);
        n2 = this.getPaddingLeft() + this.getPaddingRight();
        n3 = this.getPaddingTop() + this.getPaddingBottom();
        int n4 = this.getMeasuredWidth() - n2;
        int n5 = this.getMeasuredHeight() - n3;
        this.size = n4 < n5 ? n4 : n5;
        CircularProgressView circularProgressView = this;
        circularProgressView.setMeasuredDimension(circularProgressView.size + n2, this.size + n3);
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        super.onSizeChanged(n2, n3, n4, n5);
        this.size = n2 < n3 ? n2 : n3;
        this.updateBounds();
    }

    private void updateBounds() {
        int n2 = this.getPaddingLeft();
        int n3 = this.getPaddingTop();
        this.bounds.set((float)(n2 + this.thickness), (float)(n3 + this.thickness), (float)(this.size - n2 - this.thickness), (float)(this.size - n3 - this.thickness));
    }

    private void updatePaint() {
        this.paint.setColor(this.color);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth((float)this.thickness);
        this.paint.setStrokeCap(Paint.Cap.BUTT);
    }

    protected void onDraw(Canvas canvas) {
        float f2;
        super.onDraw(canvas);
        float f3 = f2 = this.isInEditMode() ? this.currentProgress / this.maxProgress * 360.0f : this.actualProgress / this.maxProgress * 360.0f;
        if (!this.isIndeterminate) {
            canvas.drawArc(this.bounds, this.startAngle, f2, false, this.paint);
            return;
        }
        canvas.drawArc(this.bounds, this.startAngle + this.indeterminateRotateOffset, this.indeterminateSweep, false, this.paint);
    }

    public boolean isIndeterminate() {
        return this.isIndeterminate;
    }

    public void setIndeterminate(boolean bl) {
        boolean bl2 = this.isIndeterminate == bl;
        this.isIndeterminate = bl;
        if (bl2) {
            this.resetAnimation();
        }
    }

    public int getThickness() {
        return this.thickness;
    }

    public void setThickness(int n2) {
        this.thickness = n2;
        this.updatePaint();
        this.updateBounds();
        this.invalidate();
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int n2) {
        this.color = n2;
        this.updatePaint();
        this.invalidate();
    }

    public float getMaxProgress() {
        return this.maxProgress;
    }

    public void setMaxProgress(float f2) {
        this.maxProgress = f2;
        this.invalidate();
    }

    public float getProgress() {
        return this.currentProgress;
    }

    public void setProgress(float f2) {
        this.currentProgress = f2;
        if (!this.isIndeterminate) {
            if (this.progressAnimator != null && this.progressAnimator.isRunning()) {
                this.progressAnimator.cancel();
            }
            this.progressAnimator = ValueAnimator.ofFloat((float[])new float[]{this.actualProgress, f2});
            this.progressAnimator.setDuration((long)this.animSyncDuration);
            this.progressAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            this.progressAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new M$$8$(this));
            this.progressAnimator.start();
        }
        this.invalidate();
    }

    public void startAnimation() {
        this.resetAnimation();
    }

    public void resetAnimation() {
        if (this.startAngleRotate != null && this.startAngleRotate.isRunning()) {
            this.startAngleRotate.cancel();
        }
        if (this.progressAnimator != null && this.progressAnimator.isRunning()) {
            this.progressAnimator.cancel();
        }
        if (this.indeterminateAnimator != null && this.indeterminateAnimator.isRunning()) {
            this.indeterminateAnimator.cancel();
        }
        if (!this.isIndeterminate) {
            this.startAngle = this.initialStartAngle;
            this.startAngleRotate = ValueAnimator.ofFloat((float[])new float[]{this.startAngle, this.startAngle + 360.0f});
            this.startAngleRotate.setDuration((long)this.animSwoopDuration);
            this.startAngleRotate.setInterpolator((TimeInterpolator)new DecelerateInterpolator(2.0f));
            this.startAngleRotate.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new M$_J_(this));
            this.startAngleRotate.start();
            this.actualProgress = 0.0f;
            this.progressAnimator = ValueAnimator.ofFloat((float[])new float[]{this.actualProgress, this.currentProgress});
            this.progressAnimator.setDuration((long)this.animSyncDuration);
            this.progressAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            this.progressAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new F_$o_(this));
            this.progressAnimator.start();
            return;
        }
        this.indeterminateSweep = 15.0f;
        this.indeterminateAnimator = new AnimatorSet();
        AnimatorSet animatorSet = null;
        for (int i2 = 0; i2 < this.animSteps; ++i2) {
            AnimatorSet animatorSet2 = this.createIndeterminateAnimator(i2);
            AnimatorSet.Builder builder = this.indeterminateAnimator.play((Animator)animatorSet2);
            if (animatorSet != null) {
                builder.after((Animator)animatorSet);
            }
            animatorSet = animatorSet2;
        }
        this.indeterminateAnimator.addListener((Animator.AnimatorListener)new P$_S_(this));
        this.indeterminateAnimator.start();
    }

    public void stopAnimation() {
        if (this.startAngleRotate != null) {
            this.startAngleRotate.cancel();
            this.startAngleRotate = null;
        }
        if (this.progressAnimator != null) {
            this.progressAnimator.cancel();
            this.progressAnimator = null;
        }
        if (this.indeterminateAnimator != null) {
            this.indeterminateAnimator.cancel();
            this.indeterminateAnimator = null;
        }
    }

    private AnimatorSet createIndeterminateAnimator(float f2) {
        float f3 = 360.0f * (float)(this.animSteps - 1) / (float)this.animSteps + 15.0f;
        float f4 = -90.0f + f2 * (f3 - 15.0f);
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{15.0f, f3});
        valueAnimator.setDuration((long)(this.animDuration / this.animSteps / 2));
        valueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator(1.0f));
        valueAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new p$$q_(this));
        ValueAnimator valueAnimator2 = ValueAnimator.ofFloat((float[])new float[]{f2 * 720.0f / (float)this.animSteps, (f2 + 0.5f) * 720.0f / (float)this.animSteps});
        valueAnimator2.setDuration((long)(this.animDuration / this.animSteps / 2));
        valueAnimator2.setInterpolator((TimeInterpolator)new LinearInterpolator());
        valueAnimator2.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new S__Z$(this));
        ValueAnimator valueAnimator3 = ValueAnimator.ofFloat((float[])new float[]{f4, f4 + f3 - 15.0f});
        valueAnimator3.setDuration((long)(this.animDuration / this.animSteps / 2));
        valueAnimator3.setInterpolator((TimeInterpolator)new DecelerateInterpolator(1.0f));
        valueAnimator3.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new w_$E$(this, f3, f4));
        ValueAnimator valueAnimator4 = ValueAnimator.ofFloat((float[])new float[]{(f2 + 0.5f) * 720.0f / (float)this.animSteps, (f2 + 1.0f) * 720.0f / (float)this.animSteps});
        valueAnimator4.setDuration((long)(this.animDuration / this.animSteps / 2));
        valueAnimator4.setInterpolator((TimeInterpolator)new LinearInterpolator());
        valueAnimator4.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new V$$3$(this));
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.play((Animator)valueAnimator).with((Animator)valueAnimator2);
        animatorSet.play((Animator)valueAnimator3).with((Animator)valueAnimator4).after((Animator)valueAnimator2);
        return animatorSet;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.autostartAnimation) {
            this.startAnimation();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stopAnimation();
    }

    public void setVisibility(int n2) {
        int n3 = this.getVisibility();
        super.setVisibility(n2);
        if (n2 != n3) {
            if (n2 == 0) {
                this.resetAnimation();
                return;
            }
            if (n2 == 8 || n2 == 4) {
                this.stopAnimation();
            }
        }
    }

    private int convertDPtoInt(Context context, int n2) {
        return (int)TypedValue.applyDimension((int)1, (float)n2, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    static /* synthetic */ float access$002(CircularProgressView circularProgressView, float f2) {
        circularProgressView.actualProgress = f2;
        return circularProgressView.actualProgress;
    }

    static /* synthetic */ float access$102(CircularProgressView circularProgressView, float f2) {
        circularProgressView.startAngle = f2;
        return circularProgressView.startAngle;
    }

    static /* synthetic */ float access$202(CircularProgressView circularProgressView, float f2) {
        circularProgressView.indeterminateSweep = f2;
        return circularProgressView.indeterminateSweep;
    }

    static /* synthetic */ float access$302(CircularProgressView circularProgressView, float f2) {
        circularProgressView.indeterminateRotateOffset = f2;
        return circularProgressView.indeterminateRotateOffset;
    }

    static /* synthetic */ float access$100(CircularProgressView circularProgressView) {
        return circularProgressView.startAngle;
    }
}

