/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.app.Activity;
import android.content.Context;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.razorpay.ConfigDroid;
import com.razorpay.R;

class ResourceUtils {
    ResourceUtils() {
    }

    static int getMagicVersionCode() {
        return ConfigDroid.MAGIC_VERSION_CODE;
    }

    static boolean isTablet(Context context) {
        return context.getResources().getBoolean(R.bool.isTablet);
    }

    static int dpToPx(Context context, int n) {
        context = context.getResources().getDisplayMetrics();
        return (int)TypedValue.applyDimension((int)1, (float)n, (DisplayMetrics)context);
    }

    static int getStatusBarHeight(Context context) {
        int n = 0;
        int n2 = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (n2 > 0) {
            n = context.getResources().getDimensionPixelSize(n2);
        }
        return n;
    }

    static int getViewHeight(Activity activity) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.heightPixels - ResourceUtils.getStatusBarHeight((Context)activity);
    }

    static int getRzpAssistVersionCode() {
        return ConfigDroid.RZP_ASSIST_VERSION_CODE;
    }
}

