/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import com.razorpay.CoreConfig;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0010\u001a\u00020\u0006J\u0006\u0010\u0011\u001a\u00020\u0006J\u0006\u0010\u0012\u001a\u00020\u0006J\u0006\u0010\u0013\u001a\u00020\u0006J\u0006\u0010\u0014\u001a\u00020\u0006J\u0006\u0010\u0015\u001a\u00020\u0006R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0011\u0010\r\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/razorpay/GlobalUrlConfig;", "", "urlConfig", "Lorg/json/JSONObject;", "(Lorg/json/JSONObject;)V", "baseCdn", "", "getBaseCdn", "()Ljava/lang/String;", "baseUrl", "getBaseUrl", "cdnUrl", "getCdnUrl", "staticCdn", "getStaticCdn", "trackUrl", "getButlerUrl", "getCheckoutUrl", "getOtpelfJsUrl", "getOtpelfVersionUrl", "getPaymentsEndpoint", "getTrackUrl", "Companion", "core_release"})
public final class GlobalUrlConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String baseUrl;
    @NotNull
    private final String baseCdn;
    @NotNull
    private final String staticCdn;
    @NotNull
    private final String trackUrl;
    @NotNull
    private final String cdnUrl;
    private static GlobalUrlConfig globalUrlConfig;

    private GlobalUrlConfig(JSONObject jSONObject) {
        String string = jSONObject.optString("frame", "https://api.razorpay.com");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"urlConfig.optString(\"fra\u2026\", BaseConstants.RZP_URL)");
        this.baseUrl = string;
        String string2 = jSONObject.optString("baseCdn", "");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"urlConfig.optString(\"baseCdn\", \"\")");
        this.baseCdn = string2;
        String string3 = jSONObject.optString("staticCdn", "");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"urlConfig.optString(\"staticCdn\", \"\")");
        this.staticCdn = string3;
        String string4 = CoreConfig.getInstance().getLumberjackEndpoint();
        if (string4 == null) {
            string4 = "https://lumberjack.razorpay.com/v1/track";
        }
        String string5 = jSONObject.optString("trackUrl", string4);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"urlConfig.optString(\n   \u2026LUMBERJACK_ENDPOINT\n    )");
        this.trackUrl = string5;
        String string6 = jSONObject.optString("cdnUrl");
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"urlConfig.optString(\"cdnUrl\")");
        this.cdnUrl = string6;
    }

    @NotNull
    public final String getBaseUrl() {
        return this.baseUrl;
    }

    @NotNull
    public final String getBaseCdn() {
        return this.baseCdn;
    }

    @NotNull
    public final String getStaticCdn() {
        return this.staticCdn;
    }

    @NotNull
    public final String getCdnUrl() {
        return this.cdnUrl;
    }

    @NotNull
    public final String getOtpelfVersionUrl() {
        if (((CharSequence)this.cdnUrl).length() == 0) {
            String string = CoreConfig.getInstance().getOtpElfVersionUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n            CoreConfig\u2026tpElfVersionUrl\n        }");
            return string;
        }
        return this.cdnUrl + "static/otpelf2/version.json";
    }

    @NotNull
    public final String getOtpelfJsUrl() {
        if (((CharSequence)this.cdnUrl).length() == 0) {
            String string = CoreConfig.getInstance().getOtpElfJsUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n            CoreConfig\u2026e().otpElfJsUrl\n        }");
            return string;
        }
        return this.cdnUrl + "static/otpelf2/otpelf.js";
    }

    @NotNull
    public final String getCheckoutUrl() {
        if (Intrinsics.areEqual((Object)this.baseUrl, (Object)"https://api.razorpay.com")) {
            return this.baseUrl + "/v1/checkout/public";
        }
        return this.baseUrl + "?baseCdn=" + this.baseCdn + "&staticCdn=" + this.staticCdn + "&trackUrl=" + this.trackUrl + "&cdn=" + this.cdnUrl;
    }

    @NotNull
    public final String getTrackUrl() {
        if (Intrinsics.areEqual((Object)this.trackUrl, (Object)CoreConfig.getInstance().getLumberjackEndpoint())) {
            return this.trackUrl;
        }
        return this.trackUrl + "v1/track";
    }

    @NotNull
    public final String getButlerUrl() {
        if (Intrinsics.areEqual((Object)this.baseUrl, (Object)"https://api.razorpay.com")) {
            String string = CoreConfig.getInstance().getConfigEndpoint();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInstance().configEndpoint");
            return string;
        }
        URI uRI = new URI(this.baseUrl);
        return uRI.getScheme() + "://" + uRI.getHost() + "/butler/v1/settings";
    }

    @NotNull
    public final String getPaymentsEndpoint() {
        if (Intrinsics.areEqual((Object)this.baseUrl, (Object)"https://api.razorpay.com")) {
            return "https://api.razorpay.com/v1/payments/";
        }
        URI uRI = new URI(this.baseUrl);
        return uRI.getScheme() + "://" + uRI.getHost() + "/v1/payments/";
    }

    @JvmStatic
    @NotNull
    public static final GlobalUrlConfig instance() {
        return Companion.instance();
    }

    @JvmStatic
    public static final void initiate(@Nullable JSONObject jSONObject) {
        Companion.initiate(jSONObject);
    }

    public /* synthetic */ GlobalUrlConfig(JSONObject jSONObject, DefaultConstructorMarker defaultConstructorMarker) {
        this(jSONObject);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J\b\u0010\t\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/razorpay/GlobalUrlConfig$Companion;", "", "()V", "globalUrlConfig", "Lcom/razorpay/GlobalUrlConfig;", "initiate", "", "urlConfig", "Lorg/json/JSONObject;", "instance", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final GlobalUrlConfig instance() {
            if (globalUrlConfig != null) {
                GlobalUrlConfig globalUrlConfig = globalUrlConfig;
                if (globalUrlConfig == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"globalUrlConfig");
                    globalUrlConfig = null;
                }
                return globalUrlConfig;
            }
            GlobalUrlConfig.globalUrlConfig = new GlobalUrlConfig(new JSONObject(), null);
            GlobalUrlConfig globalUrlConfig = globalUrlConfig;
            if (globalUrlConfig == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"globalUrlConfig");
                globalUrlConfig = null;
            }
            return globalUrlConfig;
        }

        @JvmStatic
        public final void initiate(@Nullable JSONObject jSONObject) {
            GlobalUrlConfig.globalUrlConfig = jSONObject == null ? new GlobalUrlConfig(new JSONObject(), null) : new GlobalUrlConfig(jSONObject, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

