/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.AsyncTask;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.razorpay.AnalyticsUtil;
import java.util.concurrent.LinkedBlockingQueue;

public class AdvertisingIdUtil {
    static void getId(Context context, AdvertisingIdCallback advertisingIdCallback) {
        new AdvertisingIdAsyncTask(context, advertisingIdCallback).execute(new Void[0]);
    }

    private static class AdvertisingIdAsyncTask
    extends AsyncTask<Void, Void, String> {
        private AdvertisingIdCallback callback;
        @SuppressLint(value={"StaticFieldLeak"})
        private Context context;

        AdvertisingIdAsyncTask(Context context, AdvertisingIdCallback advertisingIdCallback) {
            this.context = context;
            this.callback = advertisingIdCallback;
        }

        protected String doInBackground(Void ... object) {
            object = new AdvertisingConnection();
            Object object2 = new Intent("com.google.android.gms.ads.identifier.service.START");
            object2.setPackage("com.google.android.gms");
            if (this.context.bindService(object2, (ServiceConnection)object, 1)) {
                try {
                    object2 = new AdvertisingInterface(((AdvertisingConnection)object).getBinder());
                    object2 = object2.getId();
                    return object2;
                }
                catch (Exception exception) {
                    object2 = exception;
                    object2 = exception.getMessage();
                    return object2;
                }
                finally {
                    try {
                        this.context.unbindService((ServiceConnection)object);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        AnalyticsUtil.reportError(((Object)((Object)this)).getClass().getName(), "S1", illegalArgumentException.getLocalizedMessage());
                    }
                }
            }
            return "permission disabled";
        }

        protected void onPostExecute(String string) {
            super.onPostExecute((Object)string);
            this.callback.onResult(string);
        }
    }

    static interface AdvertisingIdCallback {
        public void onResult(String var1);
    }

    private static final class AdvertisingInterface
    implements IInterface {
        private IBinder binder;

        AdvertisingInterface(IBinder iBinder) {
            this.binder = iBinder;
        }

        public final IBinder asBinder() {
            return this.binder;
        }

        public final String getId() throws RemoteException {
            String string;
            Parcel parcel = Parcel.obtain();
            Parcel parcel2 = Parcel.obtain();
            try {
                parcel.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                this.binder.transact(1, parcel, parcel2, 0);
                parcel2.readException();
                string = parcel2.readString();
            }
            finally {
                parcel2.recycle();
                parcel.recycle();
            }
            return string;
        }
    }

    private static final class AdvertisingConnection
    implements ServiceConnection {
        boolean retrieved = false;
        private final LinkedBlockingQueue<IBinder> queue = new LinkedBlockingQueue(1);

        private AdvertisingConnection() {
        }

        public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            try {
                this.queue.put(iBinder);
                return;
            }
            catch (Exception exception) {
                AnalyticsUtil.reportError(this.getClass().getName(), "S1", exception.getMessage());
                return;
            }
        }

        public final void onServiceDisconnected(ComponentName componentName) {
        }

        final IBinder getBinder() throws InterruptedException {
            if (!this.retrieved) {
                this.retrieved = true;
            }
            return this.queue.take();
        }
    }
}

