/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.text.TextUtils;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsProperty;
import com.razorpay.BaseUtils;
import com.razorpay.CoreConfig;
import com.razorpay.Logger;
import com.razorpay.Lumberjack;
import com.razorpay.RazorpayExceptionHandler;
import com.razorpay.ResourceUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;
import proguard.annotation.Keep;
import proguard.annotation.KeepClassMembers;

@Keep
@KeepClassMembers
class AnalyticsUtil {
    private static boolean isAnalyticsInitialized = false;
    static CharSequence MERCHANT_APP_NAME;
    static int MERCHANT_APP_BUILD;
    static CharSequence MERCHANT_APP_VERSION;
    static CharSequence MERCHANT_APP_NAMESPACE;
    static String KEY_TYPE;
    static String BUILD_TYPE;
    private static String localPaymentId;
    private static String localOrderId;
    private static String sdkType;
    private static int sdkVersionCode;
    private static String sdkVersion;
    static String libraryType;

    AnalyticsUtil() {
    }

    static void setup(Context context, String merchantKey, String sdkType, int sdkVersionCode, String sdkVersion) {
        AnalyticsUtil.sdkType = sdkType;
        AnalyticsUtil.sdkVersionCode = sdkVersionCode;
        AnalyticsUtil.sdkVersion = sdkVersion;
        AnalyticsUtil.setAppDetails(context, merchantKey);
        AnalyticsUtil.init(context, merchantKey);
    }

    private static void init(Context context, String merchantKey) {
        if (context == null) {
            throw new RuntimeException("Context not set");
        }
        if (merchantKey == null) {
            throw new RuntimeException("Merchant key not set");
        }
        Lumberjack.init(context, sdkType, sdkVersion);
        Lumberjack.addOrderProperty("merchant_key", merchantKey);
        Lumberjack.addOrderProperty("merchant_package", context.getPackageName());
        RazorpayExceptionHandler.register(context);
        isAnalyticsInitialized = true;
    }

    static String getBuildType() {
        return BUILD_TYPE;
    }

    static String getKeyType() {
        return KEY_TYPE;
    }

    static void trackEvent(AnalyticsEvent event) {
        Lumberjack.trackEvent(event.getEventName());
    }

    static void postData() {
        if (isAnalyticsInitialized) {
            Lumberjack.postData();
        }
    }

    static void trackEvent(AnalyticsEvent event, Map<String, Object> properties) {
        Lumberjack.trackEvent(event.getEventName(), properties);
    }

    static void trackEvent(AnalyticsEvent event, JSONObject properties) {
        Lumberjack.trackEvent(event.getEventName(), properties);
    }

    static void addProperty(String key, AnalyticsProperty property) {
        if (property.scope == AnalyticsProperty.Scope.PAYMENT) {
            Lumberjack.addPaymentProperty(key, property.value);
        } else if (property.scope == AnalyticsProperty.Scope.ORDER) {
            Lumberjack.addOrderProperty(key, property.value);
        }
    }

    static void addFilteredPropertiesFromPayload(JSONObject jsonData) {
        Lumberjack.addFilteredPropertiesFromPayload(jsonData);
    }

    static String getAppDetail() {
        if (isAnalyticsInitialized) {
            return MERCHANT_APP_NAME + "-" + MERCHANT_APP_VERSION + "-" + MERCHANT_APP_BUILD;
        }
        return null;
    }

    static void trackPage(String page, String url) {
        Lumberjack.trackPage(page, url);
    }

    static void reportError(Exception e, String level, String message) {
        AnalyticsUtil.trackEvent(AnalyticsEvent.ERROR_LOGGED, AnalyticsUtil.getErrorProperties(level, message));
        e.printStackTrace();
    }

    static void reportError(AbstractMethodError e, String level, String message) {
        AnalyticsUtil.trackEvent(AnalyticsEvent.ERROR_LOGGED, AnalyticsUtil.getErrorProperties(level, message));
        e.printStackTrace();
    }

    static Map<String, Object> getErrorProperties(String level, String message) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("error_level", level);
        properties.put("error_message", message);
        return properties;
    }

    static JSONObject getAnalyticsDataForCheckout(Context context) {
        JSONObject data = new JSONObject();
        try {
            data.put("platform", (Object)"mobile_sdk");
            data.put("platform_version", (Object)sdkVersion);
            data.put("os", (Object)"android");
            data.put("os_version", (Object)Build.VERSION.RELEASE);
            if (ResourceUtils.isTablet(context)) {
                data.put("device", (Object)"tablet");
            } else {
                data.put("device", (Object)"mobile");
            }
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "critical", e.getMessage());
        }
        return data;
    }

    static void trackPageLoadStart(String url) {
        AnalyticsEvent event = AnalyticsUtil.isCheckoutUrl(url) ? AnalyticsEvent.CHECKOUT_PAGE_LOAD_START : AnalyticsEvent.PAGE_LOAD_START;
        AnalyticsUtil.trackEvent(event, AnalyticsUtil.getPageLoadStartProperties(url));
    }

    static Map<String, Object> getPageLoadStartProperties(String url) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("url", url);
        return properties;
    }

    static void trackPageLoadEnd(String url, long pageLoadTime) {
        AnalyticsEvent event = AnalyticsUtil.isCheckoutUrl(url) ? AnalyticsEvent.CHECKOUT_PAGE_LOAD_FINISH : AnalyticsEvent.PAGE_LOAD_FINISH;
        AnalyticsUtil.trackEvent(event, AnalyticsUtil.getPageLoadEndProperties(url, pageLoadTime));
    }

    static boolean isCheckoutUrl(String url) {
        return url.indexOf(CoreConfig.getInstance().getCheckoutEndpoint()) == 0;
    }

    static Map<String, Object> getPageLoadEndProperties(String url, long pageLoadTime) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("url", url);
        properties.put("page_load_time", (double)pageLoadTime / 1.0E9);
        return properties;
    }

    static void reset() {
        isAnalyticsInitialized = false;
        localPaymentId = null;
        localOrderId = null;
        Lumberjack.destroy();
    }

    static void setAppDetails(Context context, String merchantKey) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            MERCHANT_APP_NAME = AnalyticsUtil.returnUndefinedIfNull(packageInfo.applicationInfo.loadLabel(packageManager));
            MERCHANT_APP_VERSION = AnalyticsUtil.returnUndefinedIfNull(packageInfo.versionName);
            MERCHANT_APP_NAMESPACE = AnalyticsUtil.returnUndefinedIfNull(packageInfo.packageName);
            MERCHANT_APP_BUILD = packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            AnalyticsUtil.reportError((Exception)((Object)e), "critical", e.getMessage());
        }
        BUILD_TYPE = BaseUtils.getAppBuildType(context);
        KEY_TYPE = AnalyticsUtil.getKeyType(merchantKey);
    }

    static String getKeyType(String merchantKey) {
        if (AnalyticsUtil.isNullOrEmpty(merchantKey)) {
            return null;
        }
        String prefix = merchantKey.substring(0, 8);
        if (prefix.equals("rzp_live")) {
            return "live";
        }
        if (prefix.equals("rzp_test")) {
            return "test";
        }
        return null;
    }

    static boolean isNullOrEmpty(CharSequence text) {
        return TextUtils.isEmpty((CharSequence)text) || TextUtils.getTrimmedLength((CharSequence)text) == 0;
    }

    static CharSequence returnUndefinedIfNull(CharSequence value) {
        if (AnalyticsUtil.isNullOrEmpty(value)) {
            return "undefined";
        }
        return value;
    }

    static String getLocalPaymentId() {
        if (localPaymentId == null) {
            localPaymentId = AnalyticsUtil.getUniqueId();
        }
        return localPaymentId;
    }

    static String getLocalOrderId() {
        if (localOrderId == null) {
            localOrderId = AnalyticsUtil.getUniqueId();
        }
        return localOrderId;
    }

    static void refreshPaymentSession() {
        localPaymentId = AnalyticsUtil.getUniqueId();
        Lumberjack.clearPaymentProperties();
    }

    static void refreshOrderSession() {
        localOrderId = AnalyticsUtil.getUniqueId();
        localPaymentId = AnalyticsUtil.getUniqueId();
        Lumberjack.clearOrderProperties();
        Lumberjack.clearPaymentProperties();
    }

    static void setLocalOrderId(String localOrderId) {
        AnalyticsUtil.localOrderId = localOrderId;
    }

    static String getUniqueId() {
        long unixTime = (System.currentTimeMillis() - 1388534400000L) * 1000000L;
        long part2 = (long)Math.floor(1.4776336E7 * Math.random());
        return AnalyticsUtil.tobase62(unixTime) + AnalyticsUtil.tobase62(part2);
    }

    static String tobase62(long number) {
        String[] base62Chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".split("");
        String result = "";
        while (number > 0L) {
            int rixit = (int)(number % 62L);
            result = String.valueOf(base62Chars[rixit]) + result;
            number = (long)Math.floor(number / 62L);
        }
        return result;
    }

    static void reportUncaughtException(Throwable throwable) {
        String stackTrace = AnalyticsUtil.getStackTrace(throwable);
        Logger.d(stackTrace);
        AnalyticsUtil.trackEvent(AnalyticsEvent.ERROR_LOGGED, AnalyticsUtil.getErrorProperties("uncaught", stackTrace));
    }

    static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        throwable.printStackTrace(printWriter);
        return stringWriter.getBuffer().toString();
    }

    public static void saveEventsToPreferences(Context context) {
        Lumberjack.saveEventsToPreferences(context);
    }

    public static JSONObject getExtraAnalyticsPayload() {
        return Lumberjack.getContextPayload();
    }

    static {
        sdkType = "standealone";
    }
}

