/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.app.Activity;
import android.content.Intent;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsUtil;
import com.razorpay.CheckoutPresenterImpl;
import com.razorpay.OtpElfCheckoutPresenterImpl;
import com.razorpay.PluginCheckoutInteractor;
import com.razorpay.RzpInternalCallback;
import com.razorpay.RzpPlugin;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class PluginOtpElfCheckoutPresenterImpl
extends OtpElfCheckoutPresenterImpl
implements PluginCheckoutInteractor {
    private HashMap<String, String> pluginsMap;
    private boolean isExtRzpPluginActive = false;
    private RzpPlugin extActiveRzpPluginInstance;
    private final RzpInternalCallback rzpInternalCallback = new RzpInternalCallback(){

        @Override
        public void onPaymentSuccess(String response) {
            try {
                JSONObject responseJson = new JSONObject(response);
                if (responseJson.has("provider") && responseJson.getString("provider").equals("GOOGLE_PAY")) {
                    PluginOtpElfCheckoutPresenterImpl.this.verifyGPayResponse(response);
                    return;
                }
                HashMap<String, Object> props = new HashMap<String, Object>();
                props.put("response", response);
                AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_PLUGIN_INTERNAL_CALLBACK_SUCCESS, props);
                PluginOtpElfCheckoutPresenterImpl.this.onComplete(response);
            }
            catch (JSONException e) {
                e.printStackTrace();
                AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_PLUGIN_INTERNAL_CALLBACK_ERROR);
            }
        }

        @Override
        public void onPaymentError(int code, String response) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("response", response);
            props.put("code", code);
            AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_PLUGIN_INTERNAL_CALLBACK_ERROR, props);
            try {
                JSONObject responseJson = new JSONObject(response);
                PluginOtpElfCheckoutPresenterImpl.this.onComplete(responseJson.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_PLUGIN_INTERNAL_CALLBACK_ERROR_EXCEPTION);
                PluginOtpElfCheckoutPresenterImpl.this.onComplete(response);
            }
        }
    };

    public PluginOtpElfCheckoutPresenterImpl(Activity activity, CheckoutPresenterImpl.CheckoutView view, HashMap<String, String> pluginsMap) {
        super(activity, view);
        this.pluginsMap = pluginsMap;
    }

    @Override
    public void processPayment(String data) {
        JSONObject payload;
        if (this.pluginsMap == null || this.pluginsMap.size() == 0) {
            return;
        }
        try {
            payload = new JSONObject(data);
        }
        catch (JSONException e) {
            e.printStackTrace();
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("data", data);
            AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_PLUGIN_CALLING_PROCESS_PAYMENT_EXCEPTION, props);
            e.printStackTrace();
            return;
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("data", data);
        AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_PLUGIN_CALLING_PROCESS_PAYMENT, props);
        for (String className : this.pluginsMap.values()) {
            try {
                RzpPlugin pluginClass = (RzpPlugin)RzpPlugin.class.getClassLoader().loadClass(className).newInstance();
                if (!pluginClass.doesHandlePayload(this.merchantKey, payload, this.activity)) continue;
                this.isExtRzpPluginActive = true;
                this.extActiveRzpPluginInstance = pluginClass;
                pluginClass.processPayment(this.merchantKey, payload, this.activity, this.rzpInternalCallback);
                return;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                AnalyticsUtil.reportError(e, "critical", e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
    }

    @Override
    public void verifyGPayResponse(String response) {
        super.verifyGPaySdkResponse(response);
    }

    @Override
    protected JSONObject getOptionsForHandleMessage() {
        JSONObject jsonObject = super.getOptionsForHandleMessage();
        JSONObject extSDKs = new JSONObject();
        try {
            for (String pluginSDKsName : this.pluginsMap.keySet()) {
                int startIndex = "com.razorpay.plugin.".length();
                int endIndex = pluginSDKsName.length();
                extSDKs.put(pluginSDKsName.substring(startIndex, endIndex), true);
            }
            jsonObject.put("external_sdks", (Object)extSDKs);
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "error", e.getLocalizedMessage());
            e.printStackTrace();
        }
        return jsonObject;
    }

    @Override
    protected void onError(JSONObject o) {
        AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_PLUGIN_ON_ERROR_CALLED, o);
        if (this.isExtRzpPluginActive) {
            String str = String.format("javascript: window.onComplete(%s)", o.toString());
            this.view.loadUrl(1, str);
            this.isExtRzpPluginActive = false;
        } else {
            super.onError(o);
        }
    }

    @Override
    public void onActivityResultReceived(int requestCode, int resultCode, Intent data) {
        if (this.isExtRzpPluginActive) {
            this.extActiveRzpPluginInstance.onActivityResult(this.merchantKey, requestCode, resultCode, data);
        } else {
            super.onActivityResultReceived(requestCode, resultCode, data);
        }
    }
}

