/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import androidx.core.app.ActivityCompat;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsUtil;
import com.razorpay.Logger;
import com.razorpay.SmsAgentInterface;
import com.razorpay.SmsReceiver;
import java.util.ArrayList;

class SmsAgent {
    private SmsReceiver smsBroadcastReceiver;
    static final int READ_SMS_PERMISSION_CODE = 1;
    static SmsAgent sSmsAgent;
    ArrayList<SmsAgentInterface> interfaceArrayList = new ArrayList();

    static SmsAgent getSmsAgentInstance() {
        if (sSmsAgent == null) {
            sSmsAgent = new SmsAgent();
        }
        return sSmsAgent;
    }

    SmsAgent() {
    }

    void registerForCallbacks(SmsAgentInterface smsAgentInterface) {
        this.interfaceArrayList.add(smsAgentInterface);
    }

    void deregisterForCallbacks(SmsAgentInterface smsAgentInterface) {
        try {
            this.interfaceArrayList.remove(smsAgentInterface);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    boolean takeActionsIfPermissionsAreGranted(Activity activity) {
        if (ActivityCompat.checkSelfPermission((Context)activity, (String)"android.permission.RECEIVE_SMS") == 0) {
            this.sendSmsPermissionCallBack(true);
            this.addSMSBroadcastReceiver(activity);
            AnalyticsUtil.trackEvent(AnalyticsEvent.SMS_PERMISSION_ALREADY_GRANTED);
            return true;
        }
        Logger.d("No permission for reading SMS");
        AnalyticsUtil.trackEvent(AnalyticsEvent.SMS_PERMISSION_ALREADY_NOT_GRANTED);
        return false;
    }

    void addSMSBroadcastReceiver(Activity activity) {
        if (this.smsBroadcastReceiver != null) {
            return;
        }
        Logger.d("Adding SMS Broadcast receiver");
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.setPriority(1000);
        this.smsBroadcastReceiver = new SmsReceiver(this);
        intentFilter.addAction("android.provider.Telephony.SMS_RECEIVED");
        activity.registerReceiver((BroadcastReceiver)this.smsBroadcastReceiver, intentFilter);
        Logger.d("Added SMS Broadcast receiver");
    }

    void removeSMSBroadcastReceiver(Activity activity) {
        this.sendSmsPermissionCallBack(false);
        if (this.smsBroadcastReceiver == null) {
            Logger.d("removeSMSBroadcastReceiver called but it was not registered");
            return;
        }
        try {
            activity.unregisterReceiver((BroadcastReceiver)this.smsBroadcastReceiver);
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "critical", e.getMessage());
        }
        this.smsBroadcastReceiver = null;
        Logger.d("SMS Broadcast receiver removed");
    }

    void handleRequestPermissionsResult(Activity activity, int requestCode, String[] permissions, int[] grantResults) {
        switch (requestCode) {
            case 1: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    this.sendSmsPermissionCallBack(true);
                    this.addSMSBroadcastReceiver(activity);
                    AnalyticsUtil.trackEvent(AnalyticsEvent.SMS_PERMISSION_NOW_GRANTED);
                    break;
                }
                this.sendSmsPermissionCallBack(false);
                AnalyticsUtil.trackEvent(AnalyticsEvent.SMS_PERMISSION_NOW_DENIED);
            }
        }
    }

    void sendSmsPermissionCallBack(boolean hasSmsPermission) {
        for (SmsAgentInterface smsAgentInterface : this.interfaceArrayList) {
            smsAgentInterface.setSmsPermission(hasSmsPermission);
        }
    }

    void postSms(String sender, String message) {
        for (SmsAgentInterface smsAgentInterface : this.interfaceArrayList) {
            smsAgentInterface.postSms(sender, message);
        }
    }
}

