/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.content.Context;
import android.content.SharedPreferences;
import android.webkit.JavascriptInterface;
import com.razorpay.Logger;
import com.razorpay.SharedPreferenceUtil;

class StorageBridge {
    SharedPreferences preferences;
    SharedPreferences.Editor editor;

    StorageBridge(Context context) {
        this.preferences = SharedPreferenceUtil.getStorageBridgePrefs(context);
        this.editor = SharedPreferenceUtil.getStorageBridgeEditor(context);
    }

    @JavascriptInterface
    public void setString(String key, String value) {
        try {
            this.editor.putString(key, value);
            this.editor.commit();
        }
        catch (Exception e) {
            Logger.e("Error saving string", e);
        }
    }

    @JavascriptInterface
    public void setBoolean(String key, boolean value) {
        try {
            this.editor.putBoolean(key, value);
            this.editor.commit();
        }
        catch (Exception e) {
            Logger.e("Error saving boolean", e);
        }
    }

    @JavascriptInterface
    public void setInt(String key, int value) {
        try {
            this.editor.putInt(key, value);
            this.editor.commit();
        }
        catch (Exception e) {
            Logger.e("Error saving integer", e);
        }
    }

    @JavascriptInterface
    public void setFloat(String key, float value) {
        try {
            this.editor.putFloat(key, value);
            this.editor.commit();
        }
        catch (Exception e) {
            Logger.e("Error saving float", e);
        }
    }

    @JavascriptInterface
    public String getString(String key) {
        try {
            return this.preferences.getString(key, null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @JavascriptInterface
    public boolean getBoolean(String key) {
        try {
            return this.preferences.getBoolean(key, false);
        }
        catch (Exception e) {
            return false;
        }
    }

    @JavascriptInterface
    public float getFloat(String key) {
        try {
            return this.preferences.getFloat(key, 0.0f);
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    @JavascriptInterface
    public int getInt(String key) {
        try {
            return this.preferences.getInt(key, 0);
        }
        catch (Exception e) {
            return 0;
        }
    }
}

