/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.app.Activity;
import android.content.Context;
import android.webkit.WebView;
import com.razorpay.Config;
import com.razorpay.Logger;
import com.razorpay.MagicData;
import com.razorpay.SmsAgent;
import com.razorpay.SmsAgentInterface;
import org.json.JSONObject;

class MagicBase
implements SmsAgentInterface {
    Context context = this.context;
    WebView webView;
    String lastSms;
    SmsAgent smsAgent;
    boolean hasOtpPermission = false;
    boolean isMagicEnabled = false;
    MagicData magicData;
    String merchantKey;
    boolean jsInsertedInCurrentPage = false;

    MagicBase(Activity activity, WebView webView) {
        this.webView = webView;
        this.smsAgent = SmsAgent.getSmsAgentInstance();
        this.smsAgent.registerForCallbacks(this);
        this.magicData = new MagicData(activity);
        this.magicData.checkForUpdates();
    }

    public void onPageFinished(WebView webview, String url) {
        if (!this.jsInsertedInCurrentPage) {
            try {
                JSONObject settings = Config.getInstance().getMagicSettings();
                settings.put("merchant_key", (Object)this.merchantKey);
                settings.put("otp_permission", this.hasOtpPermission);
                JSONObject sdk = new JSONObject();
                sdk.put("type", (Object)Config.SDK_TYPE);
                sdk.put("version_code", Config.SDK_VERSION_CODE);
                settings.put("sdk", (Object)sdk);
                this.injectJs("window.__rzp_options = " + settings.toString());
            }
            catch (Exception e) {
                Logger.e("Unable to load magic settings", e);
            }
            this.injectJs(this.magicData.getMagicJs());
            if (this.lastSms != null) {
                this.injectJs(String.format("Magic.elfBridge.setSms(%s)", this.lastSms));
                this.lastSms = null;
            }
            this.jsInsertedInCurrentPage = true;
        }
    }

    public void onProgressChanged(int progress) {
    }

    public void onPageStarted(WebView view, String url) {
        this.jsInsertedInCurrentPage = false;
    }

    public void paymentFlowEnd() {
        this.smsAgent.deregisterForCallbacks(this);
        this.smsAgent.removeSMSBroadcastReceiver((Activity)this.context);
    }

    private void injectJs(String js) {
        this.webView.loadUrl(String.format("javascript: %s", js));
    }

    @Override
    public void postSms(String sender, String message) {
        if (!this.isMagicEnabled) {
            return;
        }
        try {
            JSONObject sms = new JSONObject();
            sms.put("sender", (Object)sender);
            sms.put("message", (Object)message);
            this.lastSms = sms.toString();
            this.injectJs(String.format("Magic.elfBridge.setSms(%s)", sms.toString()));
        }
        catch (Exception e) {
            Logger.e("Exception", e);
        }
    }

    void setMagicEnabled(boolean enabled) {
        this.isMagicEnabled = enabled;
    }

    @Override
    public void setSmsPermission(boolean hasSmsPermission) {
        this.hasOtpPermission = hasSmsPermission;
    }
}

