/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.webkit.CookieManager;
import android.webkit.WebView;
import android.widget.LinearLayout;
import com.razorpay.AnalyticsUtil;
import com.razorpay.BaseUtils;
import com.razorpay.CardSaving;
import com.razorpay.CheckoutOptions;
import com.razorpay.CircularProgressView;
import com.razorpay.Config;
import com.razorpay.Logger;
import com.razorpay.R;
import com.razorpay.SharedPreferenceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class CheckoutUtils {
    private static Dialog dialog;

    CheckoutUtils() {
    }

    static void addAddons(Context context, String merchantKey) {
        AnalyticsUtil.setup(context, merchantKey, Config.SDK_TYPE, Config.SDK_VERSION_CODE, Config.SDK_VERSION);
    }

    static String getCheckoutUrlWithOptions(CheckoutOptions checkoutOptions) {
        String url = "https://api.razorpay.com/v1/checkout/public";
        url = CheckoutUtils.addParamToUrl(url, "version", Config.SDK_VERSION);
        Map<String, String> urlConfigMap = Config.getInstance().getCheckoutUrlConfig();
        Set<String> urlConfigKeys = urlConfigMap.keySet();
        for (String key : urlConfigKeys) {
            url = CheckoutUtils.addParamToUrl(url, key, urlConfigMap.get(key));
        }
        ArrayList<String> keys = Config.getInstance().getCheckoutAppendKeys();
        for (String key : keys) {
            if (!checkoutOptions.has(key)) continue;
            url = CheckoutUtils.addParamToUrl(url, key, (String)checkoutOptions.get(key));
        }
        Logger.d("Modified Url: " + url);
        return url;
    }

    static boolean isCheckoutUrl(WebView webView) {
        String tag;
        String string2 = tag = webView.getTag() == null ? "" : webView.getTag().toString();
        return tag.contains(Config.getInstance().getCheckoutEndpoint());
    }

    static String addParamToUrl(String url, String key, String value) {
        if (url == null) {
            return null;
        }
        if (key == null) {
            return url;
        }
        url = url + (url.contains("?") ? "&" : "?") + key;
        if (value == null) {
            return url;
        }
        return url + "=" + value;
    }

    static void disableFullScreenMode(Activity activity) {
        activity.getWindow().addFlags(2048);
        activity.getWindow().clearFlags(1024);
    }

    static boolean shouldRetryPayment(int paymentAttempts) {
        int retryMaxCount = Config.getInstance().getRetryMaxCount();
        return Config.getInstance().isRetryEnabled() && (retryMaxCount == -1 || retryMaxCount > paymentAttempts);
    }

    static String getBase64FromCurrentAppsResource(Activity a, int resourceId) {
        Resources resources = a.getResources();
        return BaseUtils.getBase64FromResource(resources, resourceId);
    }

    static void setUserEmail(Context context, String email) {
        SharedPreferences.Editor editor = SharedPreferenceUtil.getPrivateEditor(context);
        editor.putString("rzp_user_email", email);
        editor.commit();
    }

    static void setMerchantOptions(Context context, String merchantKey, String merchantOptions) {
        SharedPreferences.Editor editor = SharedPreferenceUtil.getPrivateEditor(context);
        if (merchantOptions == null) {
            editor.remove("pref_merchant_options_" + merchantKey);
        } else {
            editor.putString("pref_merchant_options_" + merchantKey, merchantOptions);
        }
        editor.apply();
    }

    static String getMerchantOptions(Context context, String merchantKey) {
        SharedPreferences prefs = SharedPreferenceUtil.getPrivatePrefs(context);
        return prefs.getString("pref_merchant_options_" + merchantKey, null);
    }

    static void setUserContact(Context context, String contact) {
        SharedPreferences.Editor editor = SharedPreferenceUtil.getPrivateEditor(context);
        editor.putString("rzp_user_contact", contact);
        editor.commit();
    }

    static String getUserEmail(Context context) {
        SharedPreferences sharedPref = SharedPreferenceUtil.getPrivatePrefs(context);
        return sharedPref.getString("rzp_user_email", null);
    }

    static String getUserContact(Context context) {
        SharedPreferences sharedPref = SharedPreferenceUtil.getPrivatePrefs(context);
        return sharedPref.getString("rzp_user_contact", null);
    }

    static void showDialog(Context context, String message, String positiveButtonText, String negativeButtonText, final BackButtonDialogCallback backButtonDialogCallback) {
        new AlertDialog.Builder(context).setMessage((CharSequence)message).setPositiveButton((CharSequence)positiveButtonText, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface arg0, int arg1) {
                backButtonDialogCallback.onPositiveButtonClick();
            }
        }).setNegativeButton((CharSequence)negativeButtonText, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface arg0, int arg1) {
                backButtonDialogCallback.onNegativeButtonClick();
            }
        }).show();
    }

    static JSONObject isPackageInstalled(Context context, String packageName) {
        try {
            PackageManager packageManager = context.getPackageManager();
            ResolveInfo resolveInfo = new ResolveInfo();
            resolveInfo.resolvePackageName = packageManager.getPackageInfo((String)packageName, (int)0).packageName;
            return CheckoutUtils.getAppExistenceDataInJson(context, resolveInfo);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    static JSONObject getAppExistenceDataInJson(Context context, ResolveInfo resolveInfo) {
        JSONObject jsonObject = new JSONObject();
        try {
            if (resolveInfo.resolvePackageName.equalsIgnoreCase("com.dreamplug.androidapp")) {
                jsonObject.put("shortcode", (Object)"cred");
                jsonObject.put("uri", (Object)"credpay");
                jsonObject.put("package_name", (Object)resolveInfo.resolvePackageName);
            } else if (resolveInfo.resolvePackageName.equalsIgnoreCase("in.org.npci.upiapp")) {
                jsonObject.put("shortcode", (Object)"bhim");
                jsonObject.put("uri", (Object)"upi://pay");
                jsonObject.put("package_name", (Object)resolveInfo.resolvePackageName);
            }
            return jsonObject;
        }
        catch (JSONException e) {
            AnalyticsUtil.reportError((Exception)((Object)e), "warning", e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    static JSONArray getUpiIntentsDataInJsonArray(Context context) {
        List<ResolveInfo> resolveInfoList = BaseUtils.getListOfAppsWhichHandleDeepLink(context, "upi://pay");
        if (resolveInfoList != null && resolveInfoList.size() > 0) {
            JSONArray jsonArray = new JSONArray();
            for (ResolveInfo resolveInfo : resolveInfoList) {
                jsonArray.put((Object)CheckoutUtils.getIntentDataInJson(context, resolveInfo));
            }
            return jsonArray;
        }
        return null;
    }

    static JSONArray getAppIntentDataInJsonArray(Context context) {
        List<ResolveInfo> resolveInfoList = BaseUtils.getListOfAppsWhichHandleDeepLink(context, "credpay://checkout");
        if (resolveInfoList != null && resolveInfoList.size() > 0) {
            JSONArray jsonArray = new JSONArray();
            for (ResolveInfo resolveInfo : resolveInfoList) {
                jsonArray.put((Object)CheckoutUtils.getAppIntentDataInJson(context, resolveInfo));
            }
            return jsonArray;
        }
        return null;
    }

    static JSONObject getAppIntentDataInJson(Context context, ResolveInfo resolveInfo) {
        JSONObject jsonObject = new JSONObject();
        try {
            if (resolveInfo.activityInfo.packageName.contains("com.dreamplug.androidapp")) {
                jsonObject.put("package_name", (Object)"com.dreamplug.androidapp");
                jsonObject.put("shortcode", (Object)"cred");
                jsonObject.put("uri", (Object)"credpay");
                return jsonObject;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            AnalyticsUtil.reportError(e, "error", e.getMessage());
        }
        return null;
    }

    static JSONObject getIntentDataInJson(Context context, ResolveInfo resolveInfo) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("package_name", (Object)resolveInfo.activityInfo.packageName);
            String appName = BaseUtils.getAppNameOfResolveInfo(resolveInfo, context);
            jsonObject.put("app_name", (Object)appName);
            jsonObject.put("app_icon", (Object)BaseUtils.getBase64FromOtherAppsResource(context, resolveInfo.activityInfo.packageName));
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "warning", e.getMessage());
            e.printStackTrace();
        }
        return jsonObject;
    }

    static void showLoader(Context context) {
        if (!Config.getInstance().isNativeLoaderEnabled()) {
            return;
        }
        if (context == null || ((Activity)context).isFinishing()) {
            return;
        }
        if (dialog != null && dialog.isShowing()) {
            return;
        }
        dialog = new Dialog(context);
        dialog.requestWindowFeature(1);
        dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        dialog.setContentView(R.layout.rzp_loader);
        CircularProgressView circularProgressView = (CircularProgressView)dialog.findViewById(R.id.progressBar);
        circularProgressView.setColor(Color.parseColor((String)Config.getInstance().getNativeLoaderColor()));
        LinearLayout loaderLL = (LinearLayout)dialog.findViewById(R.id.ll_loader);
        loaderLL.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                CheckoutUtils.dismissLoader();
            }
        });
        try {
            dialog.show();
        }
        catch (Exception e) {
            Logger.e("Error showing loader", e);
        }
    }

    static void dismissLoader() {
        if (dialog == null) {
            return;
        }
        if (dialog.isShowing()) {
            try {
                dialog.dismiss();
            }
            catch (Exception e) {
                Logger.e("Error dismissing loader", e);
            }
        }
        dialog = null;
    }

    static void clearUserData(Context context) {
        CheckoutUtils.setUserContact(context, null);
        CheckoutUtils.setUserEmail(context, null);
        CardSaving.setDeviceToken(context, null);
        CheckoutUtils.clearUserRelatedCookies();
    }

    static void clearUserRelatedCookies() {
        CookieManager cookieManager = CookieManager.getInstance();
        cookieManager.setCookie("https://api.razorpay.com", "razorpay_api_session=");
    }

    static interface BackButtonDialogCallback {
        public void onPositiveButtonClick();

        public void onNegativeButtonClick();
    }
}

