/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.RelativeLayout;
import android.widget.Toast;
import com.razorpay.AnalyticsEvent;
import com.razorpay.AnalyticsUtil;
import com.razorpay.AndroidBug5497Workaround;
import com.razorpay.BaseUtils;
import com.razorpay.CheckoutBridge;
import com.razorpay.CheckoutInteractor;
import com.razorpay.CheckoutPresenter;
import com.razorpay.CheckoutPresenterImpl;
import com.razorpay.CheckoutUtils;
import com.razorpay.Config;
import com.razorpay.Logger;
import com.razorpay.MagicBridge;
import com.razorpay.PrimaryWebChromeClient;
import com.razorpay.PrimaryWebViewClient;
import com.razorpay.RZPProgressBar;
import com.razorpay.ResourceUtils;
import com.razorpay.SecondaryWebChromeClient;
import com.razorpay.SecondaryWebViewClient;
import com.razorpay.SharedPreferenceUtil;
import com.razorpay.SmsAgent;
import com.razorpay.SmsAgentInterface;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

class BaseCheckoutActivity
extends Activity
implements SmsAgentInterface,
CheckoutPresenterImpl.CheckoutView {
    private ViewGroup parent;
    private WebView primaryWebView;
    private WebView secondaryWebView;
    private RelativeLayout container;
    protected CheckoutPresenter presenter;
    protected Object checkoutBridgeObject;
    private WebViewClient primaryWebViewClient;
    private WebViewClient secondaryWebViewClient;
    private WebChromeClient primaryWebChromeClient;
    private WebChromeClient secondaryWebChromeClient;
    private static int UPI_REQUEST_CODE = 99;
    private RZPProgressBar rzpbar;
    private SmsAgent smsAgent;

    BaseCheckoutActivity() {
    }

    private void setWebViewClient(int webViewType, WebViewClient webViewClient) {
        switch (webViewType) {
            case 1: {
                this.primaryWebViewClient = webViewClient;
                break;
            }
            case 2: {
                this.secondaryWebViewClient = webViewClient;
            }
        }
    }

    private void setWebChromeClient(int webViewType, WebChromeClient webChromeClient) {
        switch (webViewType) {
            case 1: {
                this.primaryWebChromeClient = webChromeClient;
                break;
            }
            case 2: {
                this.secondaryWebChromeClient = webChromeClient;
            }
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        boolean fullScreen;
        SharedPreferenceUtil.handleSdkUpdate((Context)this, Config.SDK_VERSION);
        Config.getInstance().init((Context)this);
        BaseUtils.checkForLatestVersion((Context)this, Config.SDK_VERSION_CODE);
        this.presenter.setCheckoutLoadStartAt();
        this.setWebViewClient(1, new PrimaryWebViewClient(this.presenter));
        this.setWebViewClient(2, new SecondaryWebViewClient(this.presenter));
        this.setWebChromeClient(1, new PrimaryWebChromeClient(this.presenter));
        this.setWebChromeClient(2, new SecondaryWebChromeClient(this.presenter));
        this.checkSmsPermission();
        BaseUtils.setup();
        AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_INIT);
        this.requestWindowFeature(1);
        super.onCreate(savedInstanceState);
        Logger.d("CheckoutActivity onCreate called");
        Bundle extras = savedInstanceState;
        boolean acitvityRestored = true;
        if (savedInstanceState == null) {
            extras = this.getIntent().getExtras();
            acitvityRestored = false;
        }
        if (!this.presenter.setOptions(extras, acitvityRestored)) {
            return;
        }
        this.parent = (ViewGroup)this.findViewById(0x1020002);
        this.createPrimaryWebView(this.checkoutBridgeObject);
        this.createSecondaryWebView();
        this.createContainer();
        this.presenter.loadForm("");
        this.presenter.passPrefillToSegment();
        boolean bl = fullScreen = (this.getWindow().getAttributes().flags & 0x400) != 0;
        if (fullScreen) {
            AndroidBug5497Workaround.assistActivity(this);
            Logger.d("FULLSCREEN");
        } else {
            Logger.d("NOT FULLSCREEN");
        }
        if (this.presenter.isAllowRotation()) {
            return;
        }
        if (ResourceUtils.isTablet((Context)this)) {
            Logger.d("is tablet");
            this.setFinishOnTouchOutside(false);
            WindowManager.LayoutParams params = this.getWindow().getAttributes();
            int width = ResourceUtils.dpToPx((Context)this, 375);
            int height = ResourceUtils.getViewHeight(this);
            if (height > 600) {
                height = ResourceUtils.dpToPx((Context)this, 600);
            }
            params.height = height;
            params.width = width;
            this.getWindow().setAttributes(params);
        } else {
            this.setRequestedOrientation(1);
        }
        this.presenter.fetchCondfig();
        this.presenter.handleCardSaving();
        if (!BaseUtils.isDeviceHaveCorrectTlsVersion()) {
            AnalyticsUtil.trackEvent(AnalyticsEvent.CHECKOUT_TLS_ERROR);
            this.destroy(6, "TLSv1  is not supported for security reasons");
            return;
        }
    }

    public void onSaveInstanceState(Bundle savedInstanceState) {
        super.onSaveInstanceState(savedInstanceState);
        this.presenter.saveInstanceState(savedInstanceState);
    }

    public void onBackPressed() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        this.presenter.backPressed(props);
    }

    protected void onDestroy() {
        super.onDestroy();
        AnalyticsUtil.trackEvent(AnalyticsEvent.ACTIVITY_ONDESTROY_CALLED);
        Logger.d("CheckoutActivity onDestroy called");
        try {
            this.presenter.cleanUpOnDestroy();
        }
        catch (ConcurrentModificationException e) {
            AnalyticsUtil.reportError(e, "critical", e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    @SuppressLint(value={"JavascriptInterface"})
    private void createPrimaryWebView(Object jsBridge) {
        this.primaryWebView = new WebView((Context)this);
        BaseUtils.setWebViewSettings((Context)this, this.primaryWebView, false);
        this.primaryWebView.clearFormData();
        this.primaryWebView.addJavascriptInterface(jsBridge, "CheckoutBridge");
        this.primaryWebView.setWebChromeClient(this.primaryWebChromeClient);
        this.primaryWebView.setWebViewClient(this.primaryWebViewClient);
    }

    private void createSecondaryWebView() {
        this.secondaryWebView = new WebView((Context)this);
        BaseUtils.setWebViewSettings((Context)this, this.secondaryWebView, false);
        this.secondaryWebView.clearFormData();
        this.secondaryWebView.addJavascriptInterface((Object)new MagicBridge((CheckoutInteractor)((Object)this.presenter)), "MagicBridge");
        this.secondaryWebView.addJavascriptInterface((Object)new CheckoutBridge((CheckoutInteractor)((Object)this.presenter), 2), "CheckoutBridge");
        this.secondaryWebView.setVisibility(8);
        this.secondaryWebView.setWebChromeClient(this.secondaryWebChromeClient);
        this.secondaryWebView.setWebViewClient(this.secondaryWebViewClient);
    }

    private void createContainer() {
        this.container = new RelativeLayout((Context)this);
        this.container.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.container.setBackgroundColor(-1);
        this.parent.addView((View)this.container);
        this.primaryWebView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.secondaryWebView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.container.addView((View)this.primaryWebView);
        this.container.addView((View)this.secondaryWebView);
        String color = this.presenter.getProgressBarColor();
        this.rzpbar = color != null ? new RZPProgressBar((Context)this, (ViewGroup)this.container, color) : new RZPProgressBar((Context)this, (ViewGroup)this.container);
        this.presenter.setUpAddOn();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1001) {
            this.presenter.sendOtpPermissionCallback(true);
        }
        this.presenter.onActivityResultReceived(requestCode, resultCode, data);
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        this.presenter.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    @Override
    public void postSms(String sender, String message) {
        try {
            JSONObject sms = new JSONObject();
            sms.put("sender", (Object)sender);
            sms.put("message", (Object)message);
            String lastSms = sms.toString();
            String otpMessage = String.format("javascript: OTPElf.elfBridge.setSms(%s)", lastSms);
            this.loadUrl(1, otpMessage);
        }
        catch (JSONException e) {
            AnalyticsUtil.reportError((Exception)((Object)e), "error", e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void setSmsPermission(boolean hasSmsPermission) {
        this.presenter.sendOtpPermissionCallback(hasSmsPermission);
        if (this.smsAgent != null) {
            this.smsAgent.deregisterForCallbacks(this);
        }
    }

    @Override
    public void loadUrl(int webViewType, String url) {
        switch (webViewType) {
            case 1: {
                this.primaryWebView.loadUrl(url);
                break;
            }
            case 2: {
                this.secondaryWebView.loadUrl(url);
            }
        }
    }

    @Override
    public void checkSmsPermission() {
        this.smsAgent = SmsAgent.getSmsAgentInstance();
        this.smsAgent.registerForCallbacks(this);
        this.smsAgent.takeActionsIfPermissionsAreGranted(this);
    }

    @Override
    @SuppressLint(value={"JavascriptInterface"})
    public void addJavascriptInterfaceToPrimaryWebview(Object jsBridge, String bridgeName) {
        this.primaryWebView.addJavascriptInterface(jsBridge, bridgeName);
    }

    @Override
    public void loadData(int webViewType, String data, String mimeType, String encoding) {
        switch (webViewType) {
            case 1: {
                this.primaryWebView.loadData(data, mimeType, encoding);
                break;
            }
            case 2: {
                this.secondaryWebView.loadData(data, mimeType, encoding);
            }
        }
    }

    @Override
    public void loadDataWithBaseURL(int webViewType, String baseUrl, String data, String mimeType, String encoding, String historyUrl) {
        switch (webViewType) {
            case 1: {
                this.primaryWebView.loadDataWithBaseURL(baseUrl, data, mimeType, encoding, historyUrl);
                break;
            }
            case 2: {
                this.secondaryWebView.loadDataWithBaseURL(baseUrl, data, mimeType, encoding, historyUrl);
            }
        }
    }

    @Override
    public void makeWebViewVisible(int webViewType) {
        switch (webViewType) {
            case 1: {
                if (this.primaryWebView.getVisibility() != 8) break;
                this.primaryWebView.setVisibility(0);
                this.secondaryWebView.setVisibility(8);
                CheckoutUtils.dismissLoader();
                AnalyticsUtil.trackEvent(AnalyticsEvent.WEB_VIEW_SECONDARY_TO_PRIMARY_SWITCH);
                break;
            }
            case 2: {
                if (this.secondaryWebView.getVisibility() != 8) break;
                this.primaryWebView.setVisibility(8);
                this.secondaryWebView.setVisibility(0);
                CheckoutUtils.dismissLoader();
                AnalyticsUtil.trackEvent(AnalyticsEvent.WEB_VIEW_PRIMARY_TO_SECONDARY_SWITCH);
            }
        }
    }

    @Override
    public boolean isWebViewVisible(int webViewType) {
        boolean state = false;
        switch (webViewType) {
            case 1: {
                if (this.primaryWebView == null || this.primaryWebView.getVisibility() != 0) break;
                state = true;
                break;
            }
            case 2: {
                if (this.secondaryWebView == null || this.secondaryWebView.getVisibility() != 0) break;
                state = true;
            }
        }
        return state;
    }

    @Override
    public void showToast(String message, int duration) {
        Toast.makeText((Context)this, (CharSequence)message, (int)duration).show();
    }

    @Override
    public void destroy(int resultCode, String result) {
        Intent returnIntent = new Intent();
        returnIntent.putExtra("RESULT", result);
        if (result == null) {
            resultCode = 5;
        }
        this.setResult(resultCode, returnIntent);
        this.finish();
    }

    @Override
    public void showProgressBar(int progress) {
        if (this.rzpbar != null) {
            this.rzpbar.show(progress);
        }
    }

    @Override
    public void hideProgressBar() {
        if (this.rzpbar != null) {
            this.rzpbar.hide();
        }
    }

    @Override
    public void clearWebViewHistory(int webViewType) {
        switch (webViewType) {
            case 1: {
                this.primaryWebView.clearHistory();
                break;
            }
            case 2: {
                this.secondaryWebView.clearHistory();
            }
        }
    }

    @Override
    public WebView getWebView(int webViewType) {
        WebView webView = null;
        switch (webViewType) {
            case 1: {
                webView = this.primaryWebView;
                break;
            }
            case 2: {
                webView = this.secondaryWebView;
            }
        }
        return webView;
    }
}

