/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.razorpay.AnalyticsProperty;
import com.razorpay.AnalyticsUtil;
import com.razorpay.CheckoutUtils;
import com.razorpay.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class CheckoutOptions {
    private JSONObject options;

    CheckoutOptions(String optionsString) {
        try {
            this.options = new JSONObject(optionsString);
        }
        catch (JSONException e) {
            AnalyticsUtil.reportError((Exception)((Object)e), "critical", e.getMessage());
        }
    }

    String getMerchantKey() {
        try {
            return this.options.getString("key");
        }
        catch (JSONException e) {
            Logger.e("Error reading options!", e);
            AnalyticsUtil.reportError((Exception)((Object)e), "critical", e.getMessage());
            return null;
        }
    }

    boolean shouldSendHashForSms() {
        try {
            return this.options.getBoolean("send_sms_hash");
        }
        catch (JSONException e) {
            Logger.e("Error reading options!", e);
            AnalyticsUtil.reportError((Exception)((Object)e), "error:exception", e.getMessage());
            return true;
        }
    }

    JSONObject getAsJson() {
        return this.options;
    }

    String getAsString() {
        return this.options.toString();
    }

    JSONObject getPrefill() {
        return this.options.optJSONObject("prefill");
    }

    JSONObject getOtpElfPreferences() {
        return this.options.optJSONObject("otpelf_preferences");
    }

    void logMerchantOptions() {
        try {
            JSONObject jsonObject = new JSONObject(this.options.toString());
            if (jsonObject.has("prefill")) {
                JSONObject prefill = jsonObject.getJSONObject("prefill");
                prefill.remove("card");
                prefill.remove("card[number]");
                prefill.remove("card[expiry]");
                prefill.remove("card[cvv]");
                jsonObject.put("prefill", (Object)prefill);
            }
            jsonObject.remove("image");
            AnalyticsUtil.addProperty("merchant options", new AnalyticsProperty(jsonObject, AnalyticsProperty.Scope.ORDER));
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "warning", e.getMessage());
        }
    }

    void modifyMerchantOptions(Activity context, int resourceId) {
        String savedContact;
        String savedEmail;
        String imageBase64;
        this.put("redirect", true);
        if (resourceId != 0 && (imageBase64 = CheckoutUtils.getBase64FromCurrentAppsResource(context, resourceId)) != null) {
            this.put("image", imageBase64);
        }
        if (!TextUtils.isEmpty((CharSequence)(savedEmail = CheckoutUtils.getUserEmail((Context)context)))) {
            this.prefillEmail(savedEmail);
        }
        if (!TextUtils.isEmpty((CharSequence)(savedContact = CheckoutUtils.getUserContact((Context)context)))) {
            this.prefillContact(savedContact);
        }
    }

    String getOptionsWithoutImage() {
        this.put("image", null);
        return this.options.toString();
    }

    private void prefillContact(String savedContact) {
        if (this.getPrefill() != null && this.getPrefill().has("contact")) {
            return;
        }
        this.putPrefill("contact", savedContact);
    }

    private void prefillEmail(String savedEmail) {
        if (this.getPrefill() != null && this.getPrefill().has("email")) {
            return;
        }
        this.putPrefill("email", savedEmail);
    }

    void putPrefill(String key, Object value) {
        JSONObject prefillObject = new JSONObject();
        if (this.getPrefill() != null) {
            prefillObject = this.getPrefill();
        }
        try {
            prefillObject.put(key, value);
        }
        catch (JSONException e) {
            AnalyticsUtil.reportError((Exception)((Object)e), "error", e.getMessage());
        }
        try {
            this.options.put("prefill", (Object)prefillObject);
        }
        catch (JSONException e) {
            AnalyticsUtil.reportError((Exception)((Object)e), "error", e.getMessage());
        }
    }

    private void put(String key, Object value) {
        try {
            this.options.put(key, value);
        }
        catch (JSONException e) {
            AnalyticsUtil.reportError((Exception)((Object)e), "error", e.getMessage());
        }
    }

    boolean has(String key) {
        return this.options.has(key);
    }

    String getPrefilledContact() {
        if (this.getPrefill() == null) {
            return null;
        }
        return this.getPrefill().optString("contact");
    }

    String getPrefilledEmail() {
        if (this.getPrefill() == null) {
            return null;
        }
        return this.getPrefill().optString("contact");
    }

    public boolean hasExternalWallet(String walletName) {
        try {
            JSONObject external;
            JSONArray wallets;
            if (this.options.has("external") && (wallets = (external = this.options.getJSONObject("external")).getJSONArray("wallets")).toString().contains(walletName)) {
                return true;
            }
        }
        catch (Exception e) {
            AnalyticsUtil.reportError(e, "warning", e.getMessage());
        }
        return false;
    }

    <T> T get(String key) {
        Object value = this.options.opt(key);
        if (value == null) {
            return null;
        }
        return (T)value.getClass().cast(value);
    }
}

